/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.beam.coder;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.json.bind.Jsonb;
import lombok.Generated;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.util.VarInt;
import org.talend.sdk.component.runtime.beam.io.CountingOutputStream;
import org.talend.sdk.component.runtime.beam.io.NoCloseInputStream;
import org.talend.sdk.component.runtime.serialization.ContainerFinder;

public class JsonbCoder<T>
extends CustomCoder<T> {
    private Type type;
    private Jsonb jsonb;

    public void encode(T object, OutputStream outputStream) throws IOException {
        CountingOutputStream buffer = new CountingOutputStream();
        try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream(buffer);){
            this.jsonb.toJson(object, (OutputStream)gzipOutputStream);
        }
        VarInt.encode((long)buffer.getCounter(), (OutputStream)outputStream);
        outputStream.write(buffer.toByteArray());
    }

    public T decode(InputStream inputStream) throws IOException {
        long maxBytes = VarInt.decodeLong((InputStream)inputStream);
        return (T)this.jsonb.fromJson((InputStream)new GZIPInputStream(new NoCloseInputStream(inputStream, maxBytes)), this.type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        JsonbCoder that = (JsonbCoder)((Object)JsonbCoder.class.cast(o));
        return Objects.equals(this.type, that.type) && this.jsonb != null && that.jsonb != null;
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public static <T> JsonbCoder<T> of(Class<T> type, String plugin) {
        return new JsonbCoder<T>(type, (Jsonb)ContainerFinder.Instance.get().find(plugin).findService(Jsonb.class));
    }

    public static JsonbCoder of(Type type, String plugin) {
        return new JsonbCoder(type, (Jsonb)ContainerFinder.Instance.get().find(plugin).findService(Jsonb.class));
    }

    @Generated
    private JsonbCoder(Type type, Jsonb jsonb) {
        this.type = type;
        this.jsonb = jsonb;
    }

    @Generated
    protected JsonbCoder() {
    }

    @Generated
    public Type getType() {
        return this.type;
    }
}

