/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.design.extension.repository;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.talend.sdk.component.api.component.MigrationHandler;
import org.talend.sdk.component.api.component.Version;
import org.talend.sdk.component.design.extension.RepositoryModel;
import org.talend.sdk.component.design.extension.repository.Config;
import org.talend.sdk.component.design.extension.repository.ConfigKey;
import org.talend.sdk.component.design.extension.repository.Family;
import org.talend.sdk.component.runtime.manager.ComponentFamilyMeta;
import org.talend.sdk.component.runtime.manager.ComponentManager;
import org.talend.sdk.component.runtime.manager.ParameterMeta;
import org.talend.sdk.component.runtime.manager.reflect.MigrationHandlerFactory;
import org.talend.sdk.component.runtime.manager.util.IdGenerator;
import org.talend.sdk.component.runtime.manager.util.Lazy;

public class RepositoryModelBuilder {
    public RepositoryModel create(ComponentManager.AllServices services, Collection<ComponentFamilyMeta> familyMetas, MigrationHandlerFactory migrationHandlerFactory) {
        List<Family> families = familyMetas.stream().map(familyMeta -> this.createConfigForFamily(services, migrationHandlerFactory, (ComponentFamilyMeta)familyMeta)).collect(Collectors.toList());
        return new RepositoryModel(families);
    }

    private Family createConfigForFamily(ComponentManager.AllServices services, MigrationHandlerFactory migrationHandlerFactory, ComponentFamilyMeta familyMeta) {
        Family family = new Family();
        family.setId(familyMeta.getId());
        family.setMeta(familyMeta);
        family.setConfigs(Lazy.lazy(() -> this.extractConfigurations(services, migrationHandlerFactory, familyMeta).values().stream().collect(ArrayList::new, (aggregator, item) -> {
            Collection configs = aggregator.stream().filter(c -> this.toParamStream(item.getMeta().getNestedParameters()).anyMatch(p -> p.getJavaType() == c.getMeta().getJavaType())).findFirst().map(Config::getChildConfigs).orElse((List)aggregator);
            if (configs.stream().noneMatch(c -> c.getMeta().getJavaType() == item.getMeta().getJavaType())) {
                configs.add(item);
            }
        }, List::addAll)));
        return family;
    }

    private Map<Type, Config> extractConfigurations(ComponentManager.AllServices services, MigrationHandlerFactory migrationHandlerFactory, ComponentFamilyMeta familyMeta) {
        return Stream.concat(familyMeta.getPartitionMappers().values().stream(), familyMeta.getProcessors().values().stream()).flatMap(b -> ((List)b.getParameterMetas().get()).stream()).flatMap(this::flatten).filter(RepositoryModelBuilder::isConfiguration).map(p -> this.createConfig(familyMeta.getPlugin(), services, (ParameterMeta)p, familyMeta.getName(), familyMeta.getIcon(), migrationHandlerFactory)).collect(Collectors.toMap(c -> c.getMeta().getJavaType(), Function.identity(), (config1, config2) -> config1, LinkedHashMap::new));
    }

    private Stream<ParameterMeta> toParamStream(Collection<ParameterMeta> params) {
        if (params.isEmpty()) {
            return Stream.empty();
        }
        return Stream.concat(params.stream(), params.stream().flatMap(p -> this.toParamStream(p.getNestedParameters())));
    }

    private Stream<ParameterMeta> flatten(ParameterMeta meta) {
        if (meta.getNestedParameters() == null || meta.getNestedParameters().isEmpty()) {
            return Stream.of(meta);
        }
        return Stream.concat(meta.getNestedParameters().stream().flatMap(this::flatten), Stream.of(meta));
    }

    private Config createConfig(String plugin, ComponentManager.AllServices services, ParameterMeta config, String familyName, String familyIcon, MigrationHandlerFactory migrationHandlerFactory) {
        Config c = new Config();
        c.setIcon(familyIcon);
        c.setKey(this.getKey(familyName, config.getMetadata()));
        c.setMeta(this.translate(config, config.getPath().length(), "configuration"));
        c.setId(IdGenerator.get((String[])new String[]{plugin, c.getKey().getFamily(), c.getKey().getConfigType(), c.getKey().getConfigName()}));
        if (Class.class.isInstance(config.getJavaType())) {
            Class clazz = (Class)Class.class.cast(config.getJavaType());
            Version version = clazz.getAnnotation(Version.class);
            if (version != null) {
                c.setVersion(version.value());
                if (version.migrationHandler() != MigrationHandler.class) {
                    c.setMigrationHandler(migrationHandlerFactory.findMigrationHandler(() -> Collections.singletonList(c.getMeta()), clazz, services));
                }
            } else {
                c.setVersion(-1);
            }
        }
        if (c.getMigrationHandler() == null) {
            c.setMigrationHandler((v, d) -> d);
        }
        return c;
    }

    private ConfigKey getKey(String family, Map<String, String> meta) {
        String configName = meta.get("tcomp::configurationtype::name");
        String configType = meta.get("tcomp::configurationtype::type");
        return new ConfigKey(family, configName, configType);
    }

    private static boolean isConfiguration(ParameterMeta parameterMeta) {
        return parameterMeta.getMetadata().keySet().stream().anyMatch(m -> m.startsWith("tcomp::configurationtype::"));
    }

    private ParameterMeta translate(ParameterMeta config, int replacedPrefixLen, String newPrefix) {
        return new ParameterMeta(config.getSource(), config.getJavaType(), config.getType(), newPrefix + config.getPath().substring(replacedPrefixLen), config.getPath().length() == replacedPrefixLen ? newPrefix : config.getName(), config.getI18nPackages(), config.getNestedParameters().stream().map(it -> this.translate((ParameterMeta)it, replacedPrefixLen, newPrefix)).collect(Collectors.toList()), config.getProposals(), config.getMetadata(), config.isLogMissingResourceBundle());
    }
}

