/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.di.schema;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.talend.sdk.component.api.record.Schema;

public class StudioTypes {
    public static final String BIGDECIMAL = "id_BigDecimal";
    public static final String BOOLEAN = "id_Boolean";
    public static final String BYTE = "id_Byte";
    public static final String BYTE_ARRAY = "id_byte[]";
    public static final String CHARACTER = "id_Character";
    public static final String DATE = "id_Date";
    public static final String DOUBLE = "id_Double";
    public static final String DOCUMENT = "id_Document";
    public static final String DYNAMIC = "id_Dynamic";
    public static final String FLOAT = "id_Float";
    public static final String INTEGER = "id_Integer";
    public static final String LIST = "id_List";
    public static final String LONG = "id_Long";
    public static final String OBJECT = "id_Object";
    public static final String SHORT = "id_Short";
    public static final String STRING = "id_String";
    private static final Map<String, String> CLASSES_TO_STUDIO_TYPES = new HashMap<String, String>(){
        {
            this.put("[B", StudioTypes.BYTE_ARRAY);
            this.put("boolean", StudioTypes.BOOLEAN);
            this.put("byte", StudioTypes.BYTE);
            this.put("byte[]", StudioTypes.BYTE_ARRAY);
            this.put("char", StudioTypes.CHARACTER);
            this.put("double", StudioTypes.DOUBLE);
            this.put("float", StudioTypes.FLOAT);
            this.put("int", StudioTypes.INTEGER);
            this.put("java.lang.Boolean", StudioTypes.BOOLEAN);
            this.put("java.lang.Byte", StudioTypes.BYTE);
            this.put("java.lang.Character", StudioTypes.CHARACTER);
            this.put("java.lang.Double", StudioTypes.DOUBLE);
            this.put("java.lang.Float", StudioTypes.FLOAT);
            this.put("java.lang.Integer", StudioTypes.INTEGER);
            this.put("java.lang.Long", StudioTypes.LONG);
            this.put("java.lang.Object", StudioTypes.OBJECT);
            this.put("java.lang.Short", StudioTypes.SHORT);
            this.put("java.lang.String", StudioTypes.STRING);
            this.put("java.math.BigDecimal", StudioTypes.BIGDECIMAL);
            this.put("java.util.Date", StudioTypes.DATE);
            this.put("java.util.List", StudioTypes.LIST);
            this.put("long", StudioTypes.LONG);
            this.put("routines.system.Dynamic", StudioTypes.DYNAMIC);
            this.put("short", StudioTypes.SHORT);
        }
    };
    private static final Map<String, Class<?>> STUDIO_TYPES_TO_CLASSES = new HashMap<String, Class<?>>(){
        {
            this.put(StudioTypes.BIGDECIMAL, BigDecimal.class);
            this.put(StudioTypes.BOOLEAN, Boolean.class);
            this.put(StudioTypes.BYTE, Byte.class);
            this.put(StudioTypes.BYTE_ARRAY, byte[].class);
            this.put(StudioTypes.CHARACTER, Character.class);
            this.put(StudioTypes.DATE, Date.class);
            this.put(StudioTypes.DOUBLE, Double.class);
            this.put(StudioTypes.FLOAT, Float.class);
            this.put(StudioTypes.INTEGER, Integer.class);
            this.put(StudioTypes.LIST, List.class);
            this.put(StudioTypes.LONG, Long.class);
            this.put(StudioTypes.OBJECT, Object.class);
            this.put(StudioTypes.SHORT, Short.class);
            this.put(StudioTypes.STRING, String.class);
        }
    };
    private static final Map<Schema.Type, String> RECORD_TYPES_TO_STUDIOS_TYPES = new HashMap<Schema.Type, String>(){
        {
            this.put(Schema.Type.ARRAY, StudioTypes.LIST);
            this.put(Schema.Type.BOOLEAN, StudioTypes.BOOLEAN);
            this.put(Schema.Type.BYTES, StudioTypes.BYTE_ARRAY);
            this.put(Schema.Type.DATETIME, StudioTypes.DATE);
            this.put(Schema.Type.DOUBLE, StudioTypes.DOUBLE);
            this.put(Schema.Type.FLOAT, StudioTypes.FLOAT);
            this.put(Schema.Type.INT, StudioTypes.INTEGER);
            this.put(Schema.Type.LONG, StudioTypes.LONG);
            this.put(Schema.Type.RECORD, StudioTypes.OBJECT);
            this.put(Schema.Type.STRING, StudioTypes.STRING);
        }
    };

    public static String typeFromClass(String clazz) {
        return Optional.ofNullable(CLASSES_TO_STUDIO_TYPES.get(clazz)).orElseThrow(() -> new IllegalArgumentException("Unexpected class: " + clazz));
    }

    public static String typeFromRecord(Schema.Type type) {
        return Optional.ofNullable(RECORD_TYPES_TO_STUDIOS_TYPES.get(type)).orElseThrow(() -> new IllegalArgumentException("Unexpected type: " + type));
    }

    public static Class<?> classFromType(String type) {
        return STUDIO_TYPES_TO_CLASSES.get(type);
    }
}

