/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.di.studio;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.api.component.AfterVariables;
import org.talend.sdk.component.runtime.base.Delegated;
import org.talend.sdk.component.runtime.base.Lifecycle;
import org.talend.sdk.component.runtime.base.lang.exception.InvocationExceptionWrapper;
import org.talend.sdk.component.runtime.serialization.ContainerFinder;

public class AfterVariableExtracter {
    private static final Logger log = LoggerFactory.getLogger(AfterVariableExtracter.class);

    public static Map<String, Object> extractAfterVariables(Lifecycle lifecycle) {
        if (lifecycle instanceof Delegated) {
            Object delegate = ((Delegated)lifecycle).getDelegate();
            ClassLoader classloader = Optional.ofNullable(ContainerFinder.Instance.get().find(lifecycle.plugin()).classloader()).orElseGet(() -> Thread.currentThread().getContextClassLoader());
            return AfterVariableExtracter.findMethods(delegate, AfterVariables.AfterVariableContainer.class, classloader).findFirst().map(m -> AfterVariableExtracter.callInLoader(classloader, () -> (Map)m.invoke(delegate, new Object[0]))).orElse(Collections.emptyMap());
        }
        log.warn("Not supported implementation of lifecycle");
        return Collections.emptyMap();
    }

    private static Stream<Method> findMethods(Object delegate, Class<? extends Annotation> marker, ClassLoader loader) {
        return AfterVariableExtracter.callInLoader(loader, () -> Stream.of(delegate.getClass().getMethods()).filter(m -> m.isAnnotationPresent(marker)).peek(m -> {
            if (!m.isAccessible()) {
                m.setAccessible(true);
            }
        }));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T callInLoader(ClassLoader loader, Callable<T> supplier) {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(loader);
        try {
            T t = supplier.call();
            return t;
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw InvocationExceptionWrapper.toRuntimeException((InvocationTargetException)e);
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    private AfterVariableExtracter() {
    }
}

