/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.di.beam.components;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.api.record.Record;
import org.talend.sdk.component.runtime.base.Delegated;
import org.talend.sdk.component.runtime.di.JobStateAware;
import org.talend.sdk.component.runtime.di.beam.InMemoryQueueIO;
import org.talend.sdk.component.runtime.di.beam.LoopState;
import org.talend.sdk.component.runtime.di.beam.components.DIPipeline;
import org.talend.sdk.component.runtime.di.beam.components.PipelineInit;
import org.talend.sdk.component.runtime.input.Input;
import org.talend.sdk.component.runtime.input.Mapper;

public class QueueMapper
implements Mapper,
JobStateAware,
Supplier<DIPipeline>,
Delegated {
    private static final Logger log = LoggerFactory.getLogger(QueueMapper.class);
    private final LoopState state;
    private final String plugin;
    private final String family;
    private final String name;
    private final PTransform<PBegin, PCollection<Record>> transform;
    private JobStateAware.State jobState;

    public QueueMapper(String plugin, String family, String name, PTransform<PBegin, PCollection<Record>> transform) {
        this.plugin = plugin;
        this.family = family;
        this.name = name;
        this.transform = transform;
        this.state = LoopState.newTracker(plugin);
        log.debug("Associating state {} to {}#{}", new Object[]{this.state.getId(), family, name});
    }

    public String getStateId() {
        return this.state.getId();
    }

    public long assess() {
        return 1L;
    }

    public List<Mapper> split(long desiredSize) {
        return Collections.singletonList(this);
    }

    public Input create() {
        return new QueueInput(this);
    }

    public boolean isStream() {
        return false;
    }

    public String plugin() {
        return this.plugin;
    }

    public String rootName() {
        return this.family;
    }

    public String name() {
        return this.name;
    }

    public void start() {
        if (this.transform == null) {
            log.error("No transform for " + this.plugin + "#" + this.family + "#" + this.name);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Adding to beam pipeline:\n\n[{}] -> [{}]\n", (Object)this.transform.getName(), (Object)(this.family + '#' + this.name));
        }
        DIPipeline diPipeline = this.get();
        diPipeline.withState(this.getStateId(), () -> diPipeline.apply(this.transform).apply(InMemoryQueueIO.to(this.state)));
    }

    public void stop() {
    }

    @Override
    public void setState(JobStateAware.State state) {
        this.jobState = state;
        this.get().registerStateForTransform(Objects.requireNonNull(this.transform, "transform can't be null"), this.jobState);
    }

    @Override
    public DIPipeline get() {
        return PipelineInit.ensurePipeline(Objects.requireNonNull(this.jobState, "jobState must be non null"));
    }

    public Object getDelegate() {
        return this.transform;
    }

    private static class QueueInput
    implements Input {
        private final QueueMapper parent;

        public Object next() {
            PipelineInit.lazyStart(this.parent.jobState, this.parent);
            return this.parent.state.next();
        }

        public String plugin() {
            return this.parent.plugin;
        }

        public String rootName() {
            return this.parent.family;
        }

        public String name() {
            return this.parent.name;
        }

        public void start() {
            this.parent.jobState.getPipelineDone().thenAccept(done -> this.parent.state.end());
        }

        public void stop() {
        }

        public QueueInput(QueueMapper parent) {
            this.parent = parent;
        }
    }
}

