/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.di.record;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.json.bind.Jsonb;
import javax.json.bind.spi.JsonbProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.api.record.Record;
import org.talend.sdk.component.api.record.Schema;
import org.talend.sdk.component.api.service.record.RecordBuilderFactory;
import org.talend.sdk.component.runtime.di.record.DynamicWrapper;
import org.talend.sdk.component.runtime.di.schema.StudioTypes;
import org.talend.sdk.component.runtime.record.MappingUtils;

public class DiRowStructVisitor {
    private static final Logger log = LoggerFactory.getLogger(DiRowStructVisitor.class);
    private RecordBuilderFactory factory;
    private Record.Builder recordBuilder;
    private Schema rowStructSchema;
    private final Jsonb jsonb = JsonbProvider.provider().create().build();
    private Set<String> allowedFields;

    private void visit(Object data) {
        log.debug("[visit] Class: {} ==> {}.", (Object)data.getClass().getName(), data);
        Arrays.stream(data.getClass().getFields()).forEach(field -> {
            try {
                Class<?> fieldType = field.getType();
                String studioType = StudioTypes.typeFromClass(fieldType.getName());
                String name = field.getName();
                Object raw = field.get(data);
                log.debug("[visit] Field {} ({} / {}) ==> {}.", new Object[]{name, fieldType.getName(), studioType, raw});
                if (raw == null) {
                    log.debug("[visit] Skipping field {} with null value.", (Object)name);
                    return;
                }
                if (!this.allowedFields.contains(name)) {
                    log.debug("[visit] Skipping technical field {}.", (Object)name);
                    return;
                }
                switch (studioType) {
                    case "id_Object": {
                        this.onObject(name, raw);
                        break;
                    }
                    case "id_List": {
                        this.onArray(this.toCollectionEntry(name, "", raw), (Collection)Collection.class.cast(raw));
                        break;
                    }
                    case "id_byte[]": {
                        this.onBytes(name, (byte[])byte[].class.cast(raw));
                        break;
                    }
                    case "id_Character": {
                        this.onString(name, String.valueOf(raw));
                        break;
                    }
                    case "id_String": {
                        this.onString(name, raw);
                        break;
                    }
                    case "id_BigDecimal": {
                        this.onDecimal(name, (BigDecimal)BigDecimal.class.cast(raw));
                        break;
                    }
                    case "id_Byte": {
                        this.onInt(name, ((Byte)Byte.class.cast(raw)).intValue());
                        break;
                    }
                    case "id_Integer": 
                    case "id_Short": {
                        this.onInt(name, raw);
                        break;
                    }
                    case "id_Long": {
                        this.onLong(name, raw);
                        break;
                    }
                    case "id_Float": {
                        this.onFloat(name, raw);
                        break;
                    }
                    case "id_Double": {
                        this.onDouble(name, raw);
                        break;
                    }
                    case "id_Boolean": {
                        this.onBoolean(name, raw);
                        break;
                    }
                    case "id_Date": {
                        if (Timestamp.class.isInstance(raw)) {
                            this.onInstant(name, (Timestamp)raw);
                            break;
                        }
                        this.onDatetime(name, ((Date)Date.class.cast(raw)).toInstant().atZone(ZoneOffset.UTC));
                        break;
                    }
                    case "id_Dynamic": {
                        DynamicWrapper dynamic = new DynamicWrapper(raw);
                        dynamic.getDynamic().metadatas.forEach(meta -> {
                            Object value = dynamic.getDynamic().getColumnValue(meta.getName());
                            String metaName = Schema.sanitizeConnectionName((String)meta.getName());
                            String metaOriginalName = meta.getDbName();
                            log.debug("[visit] Dynamic {}\t({})\t ==> {}.", new Object[]{meta.getName(), meta.getType(), value});
                            if (value == null) {
                                return;
                            }
                            switch (meta.getType()) {
                                case "id_Object": {
                                    this.onObject(metaName, value);
                                    break;
                                }
                                case "id_List": {
                                    this.onArray(this.toCollectionEntry(metaName, metaOriginalName, value), (Collection)Collection.class.cast(value));
                                    break;
                                }
                                case "id_String": 
                                case "id_Character": {
                                    this.onString(metaName, value);
                                    break;
                                }
                                case "id_byte[]": {
                                    byte[] bytes;
                                    if (byte[].class.isInstance(value)) {
                                        bytes = (byte[])byte[].class.cast(value);
                                    } else if (ByteBuffer.class.isInstance(value)) {
                                        bytes = ((ByteBuffer)ByteBuffer.class.cast(value)).array();
                                    } else {
                                        log.warn("[visit] '{}' of type `id_byte[]` and content is contained in `{}`: This should not happen!  Wrapping `byte[]` from `String.valueOf()`: result may be inaccurate.", (Object)metaName, (Object)value.getClass().getSimpleName());
                                        bytes = ByteBuffer.wrap(String.valueOf(value).getBytes()).array();
                                    }
                                    this.onBytes(metaName, bytes);
                                    break;
                                }
                                case "id_Byte": 
                                case "id_Short": 
                                case "id_Integer": {
                                    this.onInt(metaName, value);
                                    break;
                                }
                                case "id_Long": {
                                    this.onLong(metaName, value);
                                    break;
                                }
                                case "id_Float": {
                                    this.onFloat(metaName, value);
                                    break;
                                }
                                case "id_Double": {
                                    this.onDouble(metaName, value);
                                    break;
                                }
                                case "id_BigDecimal": {
                                    this.onDecimal(metaName, (BigDecimal)BigDecimal.class.cast(value));
                                    break;
                                }
                                case "id_Boolean": {
                                    this.onBoolean(metaName, value);
                                    break;
                                }
                                case "id_Date": {
                                    ZonedDateTime dateTime = Long.class.isInstance(value) ? ZonedDateTime.ofInstant(Instant.ofEpochMilli((Long)Long.class.cast(value)), ZoneOffset.UTC) : ZonedDateTime.ofInstant(((Date)Date.class.cast(value)).toInstant(), ZoneOffset.UTC);
                                    this.onDatetime(metaName, dateTime);
                                    break;
                                }
                                default: {
                                    throw new IllegalStateException("Unexpected value: " + meta.getType());
                                }
                            }
                        });
                        break;
                    }
                    default: {
                        throw new IllegalAccessException(String.format("Invalid type: %s (%s) with value: %s. .", fieldType, studioType, raw));
                    }
                }
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        });
    }

    public Record get(Object data, RecordBuilderFactory factory) {
        if (this.rowStructSchema == null) {
            this.factory = factory;
            this.rowStructSchema = this.inferSchema(data, factory);
        }
        this.recordBuilder = factory.newRecordBuilder(this.rowStructSchema);
        this.visit(data);
        return this.recordBuilder.build();
    }

    private <T> T getMetadata(String metadata, Object data, Class<T> type) {
        try {
            Method m = data.getClass().getDeclaredMethod(metadata, new Class[0]);
            return Optional.ofNullable(m.invoke(data, new Object[0])).map(type::cast).orElse(null);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return null;
        }
    }

    private Schema inferSchema(Object data, RecordBuilderFactory factory) {
        Set fields = Arrays.stream(data.getClass().getFields()).map(f -> f.getName()).collect(Collectors.toSet());
        this.allowedFields = Arrays.stream(data.getClass().getDeclaredMethods()).map(method -> method.getName()).filter(m -> m.matches("^(get|is).*")).map(n -> n.replaceAll("^(get|is)", "")).map(n -> {
            if (fields.contains(n)) {
                return n;
            }
            return n.substring(0, 1).toLowerCase(Locale.ROOT) + n.substring(1);
        }).collect(Collectors.toSet());
        Schema.Builder schema = factory.newSchemaBuilder(Schema.Type.RECORD);
        Arrays.stream(data.getClass().getFields()).forEach(field -> {
            try {
                String studioType;
                Class<?> type = field.getType();
                if (!this.allowedFields.contains(field.getName())) {
                    log.debug("[inferSchema] Skipping technical field {}.", (Object)field.getName());
                    return;
                }
                String name = Schema.sanitizeConnectionName((String)field.getName());
                Object raw = field.get(data);
                boolean isNullable = Optional.ofNullable(this.getMetadata(name + "IsNullable", data, Boolean.class)).orElse(true);
                Boolean isKey = Optional.ofNullable(this.getMetadata(name + "IsKey", data, Boolean.class)).orElse(false);
                Integer length = Optional.ofNullable(this.getMetadata(name + "Length", data, Integer.class)).orElse(-1);
                Integer precision = Optional.ofNullable(this.getMetadata(name + "Precision", data, Integer.class)).orElse(-1);
                String defaultValue = this.getMetadata(name + "Default", data, String.class);
                String comment = this.getMetadata(name + "Comment", data, String.class);
                String pattern = this.getMetadata(name + "Pattern", data, String.class);
                String originalDbColumnName = this.getMetadata(name + "OriginalDbColumnName", data, String.class);
                switch (studioType = StudioTypes.typeFromClass(type.getName())) {
                    case "id_List": {
                        schema.withEntry(this.toCollectionEntry(name, "", raw));
                        break;
                    }
                    case "id_Object": 
                    case "id_String": 
                    case "id_Character": {
                        schema.withEntry(this.toEntry(name, Schema.Type.STRING, originalDbColumnName, isNullable, comment, isKey, length, precision, defaultValue, null, studioType));
                        break;
                    }
                    case "id_BigDecimal": {
                        schema.withEntry(this.toEntry(name, Schema.Type.DECIMAL, originalDbColumnName, isNullable, comment, isKey, length, precision, defaultValue, null, studioType));
                        break;
                    }
                    case "id_Integer": 
                    case "id_Short": 
                    case "id_Byte": {
                        schema.withEntry(this.toEntry(name, Schema.Type.INT, originalDbColumnName, isNullable, comment, isKey, null, null, defaultValue, null, studioType));
                        break;
                    }
                    case "id_Long": {
                        schema.withEntry(this.toEntry(name, Schema.Type.LONG, originalDbColumnName, isNullable, comment, isKey, null, null, defaultValue, null, studioType));
                        break;
                    }
                    case "id_Float": {
                        schema.withEntry(this.toEntry(name, Schema.Type.FLOAT, originalDbColumnName, isNullable, comment, isKey, length, precision, defaultValue, null, studioType));
                        break;
                    }
                    case "id_Double": {
                        schema.withEntry(this.toEntry(name, Schema.Type.DOUBLE, originalDbColumnName, isNullable, comment, isKey, length, precision, defaultValue, null, studioType));
                        break;
                    }
                    case "id_Boolean": {
                        schema.withEntry(this.toEntry(name, Schema.Type.BOOLEAN, originalDbColumnName, isNullable, comment, isKey, null, null, defaultValue, null, studioType));
                        break;
                    }
                    case "id_Date": {
                        schema.withEntry(this.toEntry(name, Schema.Type.DATETIME, originalDbColumnName, isNullable, comment, isKey, null, null, defaultValue, pattern, studioType));
                        break;
                    }
                    case "id_byte[]": {
                        schema.withEntry(this.toEntry(name, Schema.Type.BYTES, originalDbColumnName, isNullable, comment, isKey, null, null, defaultValue, null, studioType));
                        break;
                    }
                    case "id_Dynamic": {
                        DynamicWrapper dynamic = new DynamicWrapper(raw);
                        dynamic.getDynamic().metadatas.forEach(meta -> {
                            Object value = dynamic.getDynamic().getColumnValue(meta.getName());
                            String metaName = Schema.sanitizeConnectionName((String)meta.getName());
                            String metaOriginalName = meta.getDbName();
                            boolean metaIsNullable = meta.isNullable();
                            boolean metaIsKey = meta.isKey();
                            int metaLength = meta.getLength() != -1 ? meta.getLength() : length.intValue();
                            int metaPrecision = meta.getPrecision() != -1 ? meta.getPrecision() : precision.intValue();
                            String metaPattern = !meta.getFormat().equals("dd-MM-yyyy HH:mm:ss") ? meta.getFormat() : pattern;
                            String metaStudioType = meta.getType();
                            log.debug("[inferSchema] Dynamic {}\t({})\t ==> {}.", new Object[]{meta.getName(), metaStudioType, value});
                            switch (metaStudioType) {
                                case "id_List": {
                                    schema.withEntry(this.toCollectionEntry(metaName, metaOriginalName, value));
                                    break;
                                }
                                case "id_Object": 
                                case "id_String": 
                                case "id_Character": {
                                    schema.withEntry(this.toEntry(metaName, Schema.Type.STRING, metaOriginalName, metaIsNullable, comment, metaIsKey, null, null, defaultValue, metaPattern, metaStudioType));
                                    break;
                                }
                                case "id_BigDecimal": {
                                    schema.withEntry(this.toEntry(metaName, Schema.Type.DECIMAL, metaOriginalName, metaIsNullable, comment, metaIsKey, metaLength, metaPrecision, defaultValue, null, metaStudioType));
                                    break;
                                }
                                case "id_byte[]": {
                                    schema.withEntry(this.toEntry(metaName, Schema.Type.BYTES, metaOriginalName, metaIsNullable, comment, metaIsKey, null, null, defaultValue, null, metaStudioType));
                                    break;
                                }
                                case "id_Byte": 
                                case "id_Short": 
                                case "id_Integer": {
                                    schema.withEntry(this.toEntry(metaName, Schema.Type.INT, metaOriginalName, metaIsNullable, comment, metaIsKey, null, null, defaultValue, null, metaStudioType));
                                    break;
                                }
                                case "id_Long": {
                                    schema.withEntry(this.toEntry(metaName, Schema.Type.LONG, metaOriginalName, metaIsNullable, comment, metaIsKey, null, null, defaultValue, null, metaStudioType));
                                    break;
                                }
                                case "id_Float": {
                                    schema.withEntry(this.toEntry(metaName, Schema.Type.FLOAT, metaOriginalName, metaIsNullable, comment, metaIsKey, metaLength, metaPrecision, defaultValue, null, metaStudioType));
                                    break;
                                }
                                case "id_Double": {
                                    schema.withEntry(this.toEntry(metaName, Schema.Type.DOUBLE, metaOriginalName, metaIsNullable, comment, metaIsKey, metaLength, metaPrecision, defaultValue, null, metaStudioType));
                                    break;
                                }
                                case "id_Boolean": {
                                    schema.withEntry(this.toEntry(metaName, Schema.Type.BOOLEAN, metaOriginalName, metaIsNullable, comment, metaIsKey, null, null, defaultValue, null, metaStudioType));
                                    break;
                                }
                                case "id_Date": {
                                    schema.withEntry(this.toEntry(metaName, Schema.Type.DATETIME, metaOriginalName, metaIsNullable, comment, metaIsKey, null, null, defaultValue, metaPattern, metaStudioType));
                                    break;
                                }
                                default: {
                                    schema.withEntry(this.toEntry(metaName, Schema.Type.STRING, metaOriginalName, metaIsNullable, comment, metaIsKey, metaLength, metaPrecision, defaultValue, metaPattern, metaStudioType));
                                }
                            }
                        });
                        break;
                    }
                    default: {
                        log.warn("Unmanaged type: {} for {}.", type, (Object)name);
                        break;
                    }
                }
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        });
        return schema.build();
    }

    private void onInt(String name, Object value) {
        this.recordBuilder.withInt(name, ((Integer)Integer.class.cast(MappingUtils.coerce(Integer.class, (Object)value, (String)name))).intValue());
    }

    private void onLong(String name, Object value) {
        this.recordBuilder.withLong(name, ((Long)Long.class.cast(MappingUtils.coerce(Long.class, (Object)value, (String)name))).longValue());
    }

    private void onFloat(String name, Object value) {
        this.recordBuilder.withFloat(name, ((Float)Float.class.cast(MappingUtils.coerce(Float.class, (Object)value, (String)name))).floatValue());
    }

    private void onDouble(String name, Object value) {
        this.recordBuilder.withDouble(name, ((Double)Double.class.cast(MappingUtils.coerce(Double.class, (Object)value, (String)name))).doubleValue());
    }

    private void onBoolean(String name, Object value) {
        this.recordBuilder.withBoolean(name, ((Boolean)Boolean.class.cast(MappingUtils.coerce(Boolean.class, (Object)value, (String)name))).booleanValue());
    }

    private void onString(String name, Object value) {
        this.recordBuilder.withString(name, (String)String.class.cast(MappingUtils.coerce(String.class, (Object)value, (String)name)));
    }

    private void onDecimal(String name, BigDecimal value) {
        this.recordBuilder.withDecimal(name, value);
    }

    private void onDatetime(String name, ZonedDateTime value) {
        this.recordBuilder.withDateTime(name, value);
    }

    private void onInstant(String name, Timestamp raw) {
        this.recordBuilder.withInstant(name, raw.toInstant());
    }

    private void onBytes(String name, byte[] value) {
        this.recordBuilder.withBytes(name, value);
    }

    private void onArray(Schema.Entry entry, Collection value) {
        this.recordBuilder.withArray(entry, value);
    }

    private void onObject(String name, Object value) {
        if (Record.class.isInstance(value)) {
            this.recordBuilder.withString(name, this.jsonb.toJson(value));
            return;
        }
        this.recordBuilder.with(this.rowStructSchema.getEntry(name), value);
    }

    private Schema.Entry toEntry(String name, Schema.Type type, String originalName, boolean isNullable, String comment, Boolean isKey, Integer length, Integer precision, String defaultValue, String pattern, String studioType) {
        HashMap<String, String> props = new HashMap<String, String>();
        if (isKey != null) {
            props.put("field.key", String.valueOf(isKey));
        }
        if (length != null) {
            props.put("field.size", String.valueOf(length));
        }
        if (precision != null) {
            props.put("field.scale", String.valueOf(precision));
        }
        if (pattern != null) {
            props.put("field.pattern", pattern);
        }
        props.put("talend.studio.type", studioType);
        return this.factory.newEntryBuilder().withName(name).withRawName(originalName).withNullable(isNullable).withType(type).withComment(comment).withDefaultValue((Object)defaultValue).withProps(props).build();
    }

    private Schema.Entry toCollectionEntry(String name, String originalName, Object value) {
        Schema.Type elementType = Schema.Type.STRING;
        if (value != null && !((Collection)Collection.class.cast(value)).isEmpty()) {
            Object coll = ((Collection)Collection.class.cast(value)).iterator().next();
            elementType = this.getTypeFromValue(coll);
        }
        return this.factory.newEntryBuilder().withName(name).withRawName(originalName).withNullable(true).withType(Schema.Type.ARRAY).withElementSchema(this.factory.newSchemaBuilder(elementType).build()).withProp("talend.studio.type", "id_List").build();
    }

    private Schema.Type getTypeFromValue(Object value) {
        if (String.class.isInstance(value)) {
            return Schema.Type.STRING;
        }
        if (Integer.class.isInstance(value)) {
            return Schema.Type.INT;
        }
        if (Long.class.isInstance(value)) {
            return Schema.Type.LONG;
        }
        if (Float.class.isInstance(value)) {
            return Schema.Type.FLOAT;
        }
        if (BigDecimal.class.isInstance(value)) {
            return Schema.Type.DECIMAL;
        }
        if (Double.class.isInstance(value)) {
            return Schema.Type.DOUBLE;
        }
        if (Boolean.class.isInstance(value)) {
            return Schema.Type.BOOLEAN;
        }
        if (Date.class.isInstance(value) || ZonedDateTime.class.isInstance(value)) {
            return Schema.Type.DATETIME;
        }
        if (byte[].class.isInstance(value)) {
            return Schema.Type.BYTES;
        }
        if (Collection.class.isInstance(value)) {
            return Schema.Type.ARRAY;
        }
        return Schema.Type.STRING;
    }
}

