/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.di;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;
import javax.json.bind.Jsonb;
import org.talend.sdk.component.api.service.record.RecordBuilderFactory;
import org.talend.sdk.component.runtime.record.RecordConverters;

public abstract class BaseIOHandler {
    protected final Jsonb jsonb;
    protected final RecordBuilderFactory recordBuilderMapper;
    protected final RecordConverters converters;
    protected final Map<String, IO> connections = new TreeMap<String, IO>();

    public BaseIOHandler(Jsonb jsonb, Map<Class<?>, Object> servicesMapper) {
        this.jsonb = jsonb;
        this.recordBuilderMapper = (RecordBuilderFactory)servicesMapper.get(RecordBuilderFactory.class);
        this.converters = new RecordConverters();
    }

    public void init(Collection<String> branchesOrder) {
        if (branchesOrder == null) {
            return;
        }
        HashMap<String, String> mapping = new HashMap<String, String>();
        Iterator<String> branches = branchesOrder.iterator();
        for (String rowStruct : this.connections.keySet()) {
            if (!branches.hasNext()) break;
            mapping.put(rowStruct, branches.next());
        }
        if (!mapping.isEmpty()) {
            mapping.forEach((row, branch) -> this.connections.putIfAbsent((String)branch, this.connections.get(row)));
        }
    }

    public void addConnection(String connectorName, Class<?> type) {
        this.connections.put(connectorName, new IO(type));
    }

    public void reset() {
        this.connections.values().forEach(rec$ -> ((IO)rec$).reset());
    }

    public <T> T getValue(String connectorName) {
        return this.connections.get(connectorName).next();
    }

    public boolean hasMoreData() {
        return this.connections.entrySet().stream().anyMatch(e -> ((IO)e.getValue()).hasNext());
    }

    protected String getActualName(String name) {
        return "__default__".equals(name) ? "FLOW" : name;
    }

    static class IO<T> {
        private final Queue<T> values = new LinkedList<T>();
        private final Class<T> type;

        private void reset() {
            this.values.clear();
        }

        boolean hasNext() {
            return this.values.size() != 0;
        }

        T next() {
            if (this.hasNext()) {
                return this.type.cast(this.values.poll());
            }
            return null;
        }

        void add(T e) {
            this.values.add(e);
        }

        Class<T> getType() {
            return this.type;
        }

        public IO(Class<T> type) {
            this.type = type;
        }
    }
}

