/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.di.studio;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.talend.sdk.component.runtime.base.Lifecycle;
import org.talend.sdk.component.runtime.base.lang.exception.InvocationExceptionWrapper;
import org.talend.sdk.component.runtime.serialization.ContainerFinder;

public class ReflectionUtils {
    static Stream<Method> findMethods(Object delegate, Class<? extends Annotation> marker, ClassLoader loader) {
        return ReflectionUtils.callInLoader(loader, () -> Stream.of(delegate.getClass().getMethods()).filter(m -> m.isAnnotationPresent(marker)).peek(m -> {
            if (!m.isAccessible()) {
                m.setAccessible(true);
            }
        }));
    }

    static Stream<Field> findFields(Object delegate, Class<? extends Annotation> marker) {
        return ReflectionUtils.findFields(delegate.getClass(), marker);
    }

    static Stream<Field> findFields(Class<?> delegateClass, Class<? extends Annotation> marker) {
        return Stream.of(delegateClass.getDeclaredFields()).filter(m -> m.isAnnotationPresent(marker)).peek(m -> {
            if (!m.isAccessible()) {
                m.setAccessible(true);
            }
        });
    }

    static ClassLoader getClassLoader(Lifecycle lifecycle) {
        return Optional.ofNullable(ContainerFinder.Instance.get().find(lifecycle.plugin()).classloader()).orElseGet(() -> Thread.currentThread().getContextClassLoader());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static <T> T callInLoader(ClassLoader loader, Callable<T> supplier) {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(loader);
        try {
            T t = supplier.call();
            return t;
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw InvocationExceptionWrapper.toRuntimeException((InvocationTargetException)e);
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }
}

