/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.di.schema;

public class JavaType {
    private String label;
    private String id;
    private Class nullableClass;
    private Class primitiveClass;
    private boolean generateWithCanonicalName;
    private boolean objectBased;

    protected JavaType(Class nullableClass, Class primitiveClass) {
        this.nullableClass = nullableClass;
        this.primitiveClass = primitiveClass;
        this.label = primitiveClass.getSimpleName() + " | " + nullableClass.getSimpleName();
        this.id = this.createId(nullableClass.getSimpleName());
    }

    public JavaType(Class nullableClass, boolean generateWithCanonicalName, boolean objectBased) {
        this.nullableClass = nullableClass;
        this.label = nullableClass.getSimpleName();
        this.id = this.createId(nullableClass.getSimpleName());
        this.generateWithCanonicalName = generateWithCanonicalName;
        this.objectBased = objectBased;
    }

    public JavaType(Class nullableClass, boolean generateWithCanonicalName, String label) {
        this.nullableClass = nullableClass;
        this.label = label;
        this.id = this.createId(label);
        this.generateWithCanonicalName = generateWithCanonicalName;
    }

    protected JavaType(String id, Class nullableClass, Class primitiveClass, String label) {
        this.label = label;
        this.nullableClass = nullableClass;
        this.primitiveClass = primitiveClass;
        this.id = this.createId(nullableClass.getSimpleName());
    }

    protected JavaType(String id, Class nullableClass, Class primitiveClass) {
        this.id = id;
        this.nullableClass = nullableClass;
        this.primitiveClass = primitiveClass;
    }

    public JavaType(String id, Class nullableClass) {
        this.id = id;
        this.nullableClass = nullableClass;
    }

    private String createId(String value) {
        return "id_" + value;
    }

    public String getLabel() {
        return this.label;
    }

    public String getId() {
        return this.id;
    }

    public Class getNullableClass() {
        return this.nullableClass;
    }

    public Class getPrimitiveClass() {
        return this.primitiveClass;
    }

    public boolean isGenerateWithCanonicalName() {
        return this.generateWithCanonicalName;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("JavaType[");
        buffer.append("label = ").append(this.label);
        buffer.append(" nullableClass = ").append(this.nullableClass);
        buffer.append(" primitiveClass = ").append(this.primitiveClass);
        buffer.append("]");
        return buffer.toString();
    }

    public boolean isPrimitive() {
        return this.primitiveClass != null;
    }

    public boolean isObjectBased() {
        return this.objectBased;
    }

    public void setObjectBased(boolean objectBased) {
        this.objectBased = objectBased;
    }
}

