/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.di.studio;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.runtime.base.Delegated;
import org.talend.sdk.component.runtime.base.Lifecycle;

public class ParameterSetter {
    private static final Logger log = LoggerFactory.getLogger(ParameterSetter.class);
    private final Object delegate;
    private Map<String, TargetAndField> cache;

    public ParameterSetter(Lifecycle lifecycle) {
        if (!(lifecycle instanceof Delegated)) {
            throw new IllegalArgumentException("Not supported implementation of lifecycle : " + lifecycle);
        }
        this.delegate = ((Delegated)lifecycle).getDelegate();
    }

    public void change(String path, Object value) {
        if (this.cache == null) {
            this.cache = new HashMap<String, TargetAndField>();
        }
        TargetAndField targetAndField = this.cache.get(path);
        Object target = this.delegate;
        Field field = null;
        if (targetAndField == null) {
            Class<?> currentClass = target.getClass();
            String[] names = path.split("\\.");
            for (int i = 0; i < names.length; ++i) {
                block12: {
                    String name = names[i];
                    int index = name.indexOf(91);
                    int arrayLocation = -1;
                    if (index > 0) {
                        arrayLocation = Integer.valueOf(name.substring(index + 1, name.lastIndexOf(93)));
                        name = name.substring(0, index);
                    }
                    if (!(field = this.findField(name, currentClass)).isAccessible()) {
                        field.setAccessible(true);
                    }
                    if (i == names.length - 1) break;
                    try {
                        target = field.get(target);
                        if (arrayLocation <= -1) break block12;
                        if (target instanceof List) {
                            target = ((List)List.class.cast(target)).get(arrayLocation);
                            break block12;
                        }
                        log.warn("expect a list, but not");
                        return;
                    }
                    catch (Exception e) {
                        log.warn("fail to get option value with path " + path, (Throwable)e);
                        return;
                    }
                }
                if (target == null) {
                    return;
                }
                currentClass = target.getClass();
            }
            this.cache.put(path, new TargetAndField(target, field));
        } else {
            target = targetAndField.getTarget();
            field = targetAndField.getField();
        }
        try {
            field.set(target, value);
        }
        catch (Exception e) {
            log.warn("fail to set option value with path " + path, (Throwable)e);
        }
    }

    private Field findField(String name, Class clazz) {
        for (Class type = clazz; type != Object.class && type != null; type = type.getSuperclass()) {
            try {
                return type.getDeclaredField(name);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown field: %s in class: %s.", name, clazz != null ? clazz.getName() : "null"));
    }

    private static class TargetAndField {
        Object target;
        Field field;

        public Object getTarget() {
            return this.target;
        }

        public Field getField() {
            return this.field;
        }

        public TargetAndField(Object target, Field field) {
            this.target = target;
            this.field = field;
        }
    }
}

