/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.di.record;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.bind.JsonbConfig;
import javax.json.bind.spi.JsonbProvider;
import javax.json.spi.JsonProvider;
import org.dom4j.DocumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.api.record.Record;
import org.talend.sdk.component.api.record.Schema;
import org.talend.sdk.component.api.service.record.RecordService;
import org.talend.sdk.component.api.service.record.RecordVisitor;
import org.talend.sdk.component.runtime.di.record.DynamicMetadataWrapper;
import org.talend.sdk.component.runtime.di.record.DynamicWrapper;
import org.talend.sdk.component.runtime.di.schema.StudioTypes;
import org.talend.sdk.component.runtime.manager.service.DefaultServiceProvider;
import org.talend.sdk.component.runtime.record.MappingUtils;
import org.talend.sdk.component.runtime.record.RecordBuilderFactoryImpl;
import routines.system.Document;
import routines.system.Dynamic;
import routines.system.ParserUtils;

public class DiRecordVisitor
implements RecordVisitor<Object> {
    private static final Logger log = LoggerFactory.getLogger(DiRecordVisitor.class);
    private final Class<?> clazz;
    private final Constructor<?> constructor;
    private Object instance;
    private final Map<String, Field> fields;
    private final boolean hasDynamic;
    private final DynamicWrapper dynamic;
    private final String dynamicColumn;
    private final int dynamicColumnLength;
    private final int dynamicColumnPrecision;
    private final String dynamicColumnPattern;
    private String recordPrefix = "";
    private String arrayOfRecordPrefix = "";
    private Set<String> recordFields;
    private Map<String, String> recordFieldsMap;
    private boolean initDynamicMetadata = true;
    private static final RecordService RECORD_SERVICE = (RecordService)new DefaultServiceProvider(null, JsonProvider.provider(), Json.createGeneratorFactory(Collections.emptyMap()), Json.createReaderFactory(Collections.emptyMap()), Json.createBuilderFactory(Collections.emptyMap()), Json.createParserFactory(Collections.emptyMap()), Json.createWriterFactory(Collections.emptyMap()), new JsonbConfig(), JsonbProvider.provider(), null, null, Collections.emptyList(), t -> new RecordBuilderFactoryImpl("di"), null).lookup(null, Thread.currentThread().getContextClassLoader(), null, null, RecordService.class, null, null);
    private boolean allowSpecialName;

    DiRecordVisitor(Class<?> clzz, Map<String, String> metadata) {
        this.clazz = clzz;
        try {
            this.constructor = clzz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        this.fields = Arrays.stream(this.clazz.getFields()).collect(Collectors.toMap(Field::getName, UnaryOperator.identity()));
        this.hasDynamic = this.fields.values().stream().anyMatch(field -> "routines.system.Dynamic".equals(field.getType().getName()));
        this.dynamicColumn = this.fields.values().stream().filter(field -> "routines.system.Dynamic".equals(field.getType().getName())).map(Field::getName).findAny().orElse(null);
        this.dynamic = this.hasDynamic ? new DynamicWrapper() : null;
        log.trace("[DiRecordVisitor] {} dynamic? {} ({} {}).", new Object[]{this.clazz.getName(), this.hasDynamic, this.dynamicColumn, metadata});
        this.dynamicColumnLength = Integer.parseInt(metadata.getOrDefault("field.size", "-1"));
        this.dynamicColumnPrecision = Integer.parseInt(metadata.getOrDefault("field.scale", "-1"));
        this.dynamicColumnPattern = metadata.getOrDefault("field.pattern", "yyyy-MM-dd");
    }

    public Object visit(Record record) {
        this.arrayOfRecordPrefix = "";
        this.recordPrefix = "";
        try {
            this.instance = this.constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
        if (this.hasDynamic) {
            Dynamic studioDynamic = new Dynamic();
            studioDynamic.setDbmsId(this.dynamic.getDynamic().getDbmsId());
            studioDynamic.metadatas = this.dynamic.getDynamic().metadatas;
            this.dynamic.setDynamic(studioDynamic);
            int count = studioDynamic.getColumnCount();
            for (int i = 0; i < count; ++i) {
                studioDynamic.addColumnValue(null);
            }
        }
        if (this.hasDynamic && this.initDynamicMetadata) {
            this.allowSpecialName = Boolean.parseBoolean(record.getSchema().getProp("field.special.name"));
            this.recordFieldsMap = new HashMap<String, String>();
            this.recordFields = record.getSchema().getAllEntries().filter(t -> t.getType().equals((Object)Schema.Type.RECORD)).map(rcdEntry -> {
                String root = rcdEntry.getName() + ".";
                ArrayList names = new ArrayList();
                rcdEntry.getElementSchema().getAllEntries().filter(e -> e.getType().equals((Object)Schema.Type.RECORD)).forEach(sr -> {
                    String sub = root + sr.getName() + ".";
                    sr.getElementSchema().getAllEntries().map(entry -> sub + entry.getName()).forEach(names::add);
                });
                rcdEntry.getElementSchema().getAllEntries().filter(e -> !e.getType().equals((Object)Schema.Type.RECORD)).map(entry -> root + entry.getName()).forEach(names::add);
                return names;
            }).flatMap(Collection::stream).collect(Collectors.toSet());
            record.getSchema().getAllEntries().filter(t -> !t.getType().equals((Object)Schema.Type.RECORD)).map(Schema.Entry::getName).forEach(this.recordFields::add);
            this.prefillDynamic(record.getSchema());
            this.initDynamicMetadata = false;
        }
        return RECORD_SERVICE.visit((RecordVisitor)this, record);
    }

    public Object get() {
        if (this.hasDynamic) {
            try {
                this.fields.get(this.dynamicColumn).set(this.instance, this.dynamic.getDynamic());
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }
        return this.instance;
    }

    private void prefillDynamic(Schema schema) {
        schema.getAllEntries().filter(entry -> !this.fields.containsKey(entry.getName()) || this.dynamicColumn.equals(entry.getName())).forEach(entry -> {
            this.dynamic.getDynamic().metadatas.add(this.generateMetadata((Schema.Entry)entry).getDynamicMetadata());
            this.dynamic.getDynamic().addColumnValue(null);
        });
    }

    private DynamicMetadataWrapper generateMetadata(Schema.Entry entry) {
        DynamicMetadataWrapper metadata = new DynamicMetadataWrapper();
        if (this.allowSpecialName) {
            metadata.getDynamicMetadata().setName(entry.getOriginalFieldName());
        } else {
            String name = this.recordFieldsMap.computeIfAbsent(entry.getName(), key -> this.recordFields.stream().filter(f -> f.endsWith("." + key)).findFirst().orElse((String)key));
            metadata.getDynamicMetadata().setName(name);
        }
        metadata.getDynamicMetadata().setDbName(entry.getOriginalFieldName());
        metadata.getDynamicMetadata().setNullable(entry.isNullable());
        metadata.getDynamicMetadata().setDescription(entry.getComment());
        metadata.initSourceType();
        Boolean isKey = Optional.ofNullable(entry.getProp("field.key")).filter(l -> !l.isEmpty()).map(Boolean::valueOf).orElse(false);
        Integer length = Optional.ofNullable(entry.getProp("field.size")).filter(l -> !l.isEmpty()).map(Integer::valueOf).orElse(this.dynamicColumnLength);
        Integer precision = Optional.ofNullable(entry.getProp("field.scale")).filter(l -> !l.isEmpty()).map(Integer::valueOf).orElse(this.dynamicColumnPrecision);
        String pattern = Optional.ofNullable(entry.getProp("field.pattern")).filter(l -> !l.isEmpty()).orElse(this.dynamicColumnPattern);
        String studioType = entry.getProps().getOrDefault("talend.studio.type", StudioTypes.typeFromRecord(entry.getType()));
        metadata.getDynamicMetadata().setKey(isKey.booleanValue());
        metadata.getDynamicMetadata().setType(studioType);
        String originType = entry.getProp("field.origin.type");
        if (originType != null && !originType.isEmpty()) {
            metadata.getDynamicMetadata().setDbType(originType);
        }
        if (length != null) {
            metadata.getDynamicMetadata().setLength(length.intValue());
        }
        if (precision != null) {
            metadata.getDynamicMetadata().setPrecision(precision.intValue());
        }
        switch (studioType) {
            case "id_Date": {
                metadata.getDynamicMetadata().setLogicalType("timestamp-millis");
                metadata.getDynamicMetadata().setFormat(pattern);
                break;
            }
        }
        return metadata;
    }

    private void setField(Schema.Entry entry, Object value) {
        Field field = this.fields.get(entry.getName());
        if (this.hasDynamic && (field == null || this.dynamicColumn.equals(entry.getName()))) {
            this.handleDynamic(entry, value);
            return;
        }
        if (field == null) {
            return;
        }
        try {
            if (Document.class == field.getType()) {
                log.trace("[setField] Document#{}.", (Object)entry.getName());
                field.set(this.instance, ParserUtils.parseTo_Document((String)value.toString()));
                return;
            }
            field.set(this.instance, MappingUtils.coerce(field.getType(), (Object)value, (String)entry.getName()));
        }
        catch (IllegalAccessException | DocumentException e) {
            log.error("[setField] exception message: {}", (Object)e.getMessage());
            throw new IllegalStateException(e);
        }
    }

    private void handleDynamic(Schema.Entry entry, Object value) {
        DynamicMetadataWrapper metadata;
        String name = this.allowSpecialName ? entry.getOriginalFieldName() : this.recordFieldsMap.computeIfAbsent(entry.getName(), key -> this.recordFields.stream().filter(f -> f.endsWith("." + key)).findFirst().orElse((String)key));
        int index = this.dynamic.getDynamic().getIndex(name);
        if (index < 0) {
            metadata = this.generateMetadata(entry);
            this.dynamic.getDynamic().metadatas.add(metadata.getDynamicMetadata());
            index = this.dynamic.getDynamic().getIndex(name);
        } else {
            metadata = new DynamicMetadataWrapper(this.dynamic.getDynamic().getColumnMetadata(index));
        }
        Class<?> clazz = StudioTypes.classFromType(metadata.getDynamicMetadata().getType());
        if (clazz != null) {
            this.dynamic.getDynamic().setColumnValue(index, MappingUtils.coerce(clazz, (Object)value, (String)name));
        } else {
            this.dynamic.getDynamic().setColumnValue(index, MappingUtils.coerce(value.getClass(), (Object)value, (String)name));
        }
        log.trace("[setField] Dynamic#{}\t{}\t({})\t ==> {}.", new Object[]{index, name, metadata.getDynamicMetadata().getType(), value});
    }

    public void onInt(Schema.Entry entry, OptionalInt optionalInt) {
        log.trace("[onInt] visiting {}.", (Object)entry.getName());
        optionalInt.ifPresent(value -> this.setField(entry, value));
    }

    public void onLong(Schema.Entry entry, OptionalLong optionalLong) {
        log.trace("[onLong] visiting {}.", (Object)entry.getName());
        optionalLong.ifPresent(value -> this.setField(entry, value));
    }

    public void onFloat(Schema.Entry entry, OptionalDouble optionalFloat) {
        log.trace("[onFloat] visiting {}.", (Object)entry.getName());
        optionalFloat.ifPresent(value -> this.setField(entry, Float.valueOf((float)value)));
    }

    public void onDouble(Schema.Entry entry, OptionalDouble optionalDouble) {
        log.trace("[onDouble] visiting {}.", (Object)entry.getName());
        optionalDouble.ifPresent(value -> this.setField(entry, value));
    }

    public void onBoolean(Schema.Entry entry, Optional<Boolean> optionalBoolean) {
        log.trace("[onBoolean] visiting {}.", (Object)entry.getName());
        optionalBoolean.ifPresent(value -> this.setField(entry, value));
    }

    public void onString(Schema.Entry entry, Optional<String> string) {
        log.trace("[onString] visiting {}.", (Object)entry.getName());
        string.ifPresent(value -> this.setField(entry, value));
    }

    public void onObject(Schema.Entry entry, Optional<Object> object) {
        log.trace("[onObject] visiting {}.", (Object)entry.getName());
        object.ifPresent(value -> this.setField(entry, value));
    }

    public void onDatetime(Schema.Entry entry, Optional<ZonedDateTime> dateTime) {
        log.trace("[onDatetime] visiting {}.", (Object)entry.getName());
        dateTime.ifPresent(value -> this.setField(entry, value.toInstant()));
    }

    public void onInstant(Schema.Entry entry, Optional<Instant> dateTime) {
        log.trace("[onInstant] visiting {}.", (Object)entry.getName());
        dateTime.ifPresent(value -> this.setField(entry, value));
    }

    public void onDecimal(Schema.Entry entry, Optional<BigDecimal> decimal) {
        log.trace("[onDecimal] visiting {}.", (Object)entry.getName());
        decimal.ifPresent(value -> this.setField(entry, value));
    }

    public void onBytes(Schema.Entry entry, Optional<byte[]> bytes) {
        log.trace("[onBytes] visiting {}.", (Object)entry.getName());
        bytes.ifPresent(value -> this.setField(entry, value));
    }

    public void onIntArray(Schema.Entry entry, Optional<Collection<Integer>> array) {
        log.trace("[onIntArray] visiting {}.", (Object)entry.getName());
        array.ifPresent(value -> this.setField(entry, value));
    }

    public void onLongArray(Schema.Entry entry, Optional<Collection<Long>> array) {
        log.trace("[onLongArray] visiting {}.", (Object)entry.getName());
        array.ifPresent(value -> this.setField(entry, value));
    }

    public void onFloatArray(Schema.Entry entry, Optional<Collection<Float>> array) {
        log.trace("[onFloatArray] visiting {}.", (Object)entry.getName());
        array.ifPresent(value -> this.setField(entry, value));
    }

    public void onDoubleArray(Schema.Entry entry, Optional<Collection<Double>> array) {
        log.trace("[onDoubleArray] visiting {}.", (Object)entry.getName());
        array.ifPresent(value -> this.setField(entry, value));
    }

    public void onBooleanArray(Schema.Entry entry, Optional<Collection<Boolean>> array) {
        log.trace("[onBooleanArray] visiting {}.", (Object)entry.getName());
        array.ifPresent(value -> this.setField(entry, value));
    }

    public void onStringArray(Schema.Entry entry, Optional<Collection<String>> array) {
        log.trace("[onStringArray] visiting {}.", (Object)entry.getName());
        array.ifPresent(value -> this.setField(entry, value));
    }

    public void onDatetimeArray(Schema.Entry entry, Optional<Collection<ZonedDateTime>> array) {
        log.trace("[onDatetimeArray] visiting {}.", (Object)entry.getName());
        array.ifPresent(value -> this.setField(entry, value));
    }

    public void onDecimalArray(Schema.Entry entry, Optional<Collection<BigDecimal>> array) {
        log.trace("[onDecimalArray] visiting {}.", (Object)entry.getName());
        array.ifPresent(value -> this.setField(entry, value));
    }

    public void onBytesArray(Schema.Entry entry, Optional<Collection<byte[]>> array) {
        log.trace("[onBytesArray] visiting {}.", (Object)entry.getName());
        array.ifPresent(value -> this.setField(entry, value));
    }

    public RecordVisitor<Object> onRecordArray(Schema.Entry entry, Optional<Collection<Record>> array) {
        log.trace("[onRecordArray] visiting {}.", (Object)entry.getName());
        this.arrayOfRecordPrefix = entry.getName() + ".";
        array.ifPresent(value -> this.setField(entry, value));
        return this;
    }

    public RecordVisitor<Object> onRecord(Schema.Entry entry, Optional<Record> record) {
        log.trace("[onRecord] visiting {}.", (Object)entry.getName());
        this.recordPrefix = entry.getName() + ".";
        record.ifPresent(value -> this.setField(entry, value));
        return null;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public Constructor<?> getConstructor() {
        return this.constructor;
    }

    public Object getInstance() {
        return this.instance;
    }

    public Map<String, Field> getFields() {
        return this.fields;
    }

    public boolean isHasDynamic() {
        return this.hasDynamic;
    }

    public DynamicWrapper getDynamic() {
        return this.dynamic;
    }

    public String getDynamicColumn() {
        return this.dynamicColumn;
    }

    public int getDynamicColumnLength() {
        return this.dynamicColumnLength;
    }

    public int getDynamicColumnPrecision() {
        return this.dynamicColumnPrecision;
    }

    public String getDynamicColumnPattern() {
        return this.dynamicColumnPattern;
    }

    public String getRecordPrefix() {
        return this.recordPrefix;
    }

    public String getArrayOfRecordPrefix() {
        return this.arrayOfRecordPrefix;
    }

    public Set<String> getRecordFields() {
        return this.recordFields;
    }

    public Map<String, String> getRecordFieldsMap() {
        return this.recordFieldsMap;
    }

    public boolean isInitDynamicMetadata() {
        return this.initDynamicMetadata;
    }

    public boolean isAllowSpecialName() {
        return this.allowSpecialName;
    }

    public void setInstance(Object instance) {
        this.instance = instance;
    }

    public void setRecordPrefix(String recordPrefix) {
        this.recordPrefix = recordPrefix;
    }

    public void setArrayOfRecordPrefix(String arrayOfRecordPrefix) {
        this.arrayOfRecordPrefix = arrayOfRecordPrefix;
    }

    public void setRecordFields(Set<String> recordFields) {
        this.recordFields = recordFields;
    }

    public void setRecordFieldsMap(Map<String, String> recordFieldsMap) {
        this.recordFieldsMap = recordFieldsMap;
    }

    public void setInitDynamicMetadata(boolean initDynamicMetadata) {
        this.initDynamicMetadata = initDynamicMetadata;
    }

    public void setAllowSpecialName(boolean allowSpecialName) {
        this.allowSpecialName = allowSpecialName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DiRecordVisitor)) {
            return false;
        }
        DiRecordVisitor other = (DiRecordVisitor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isHasDynamic() != other.isHasDynamic()) {
            return false;
        }
        if (this.getDynamicColumnLength() != other.getDynamicColumnLength()) {
            return false;
        }
        if (this.getDynamicColumnPrecision() != other.getDynamicColumnPrecision()) {
            return false;
        }
        if (this.isInitDynamicMetadata() != other.isInitDynamicMetadata()) {
            return false;
        }
        if (this.isAllowSpecialName() != other.isAllowSpecialName()) {
            return false;
        }
        Class<?> this$clazz = this.getClazz();
        Class<?> other$clazz = other.getClazz();
        if (this$clazz == null ? other$clazz != null : !this$clazz.equals(other$clazz)) {
            return false;
        }
        Constructor<?> this$constructor = this.getConstructor();
        Constructor<?> other$constructor = other.getConstructor();
        if (this$constructor == null ? other$constructor != null : !((Object)this$constructor).equals(other$constructor)) {
            return false;
        }
        Object this$instance = this.getInstance();
        Object other$instance = other.getInstance();
        if (this$instance == null ? other$instance != null : !this$instance.equals(other$instance)) {
            return false;
        }
        Map<String, Field> this$fields = this.getFields();
        Map<String, Field> other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        DynamicWrapper this$dynamic = this.getDynamic();
        DynamicWrapper other$dynamic = other.getDynamic();
        if (this$dynamic == null ? other$dynamic != null : !this$dynamic.equals(other$dynamic)) {
            return false;
        }
        String this$dynamicColumn = this.getDynamicColumn();
        String other$dynamicColumn = other.getDynamicColumn();
        if (this$dynamicColumn == null ? other$dynamicColumn != null : !this$dynamicColumn.equals(other$dynamicColumn)) {
            return false;
        }
        String this$dynamicColumnPattern = this.getDynamicColumnPattern();
        String other$dynamicColumnPattern = other.getDynamicColumnPattern();
        if (this$dynamicColumnPattern == null ? other$dynamicColumnPattern != null : !this$dynamicColumnPattern.equals(other$dynamicColumnPattern)) {
            return false;
        }
        String this$recordPrefix = this.getRecordPrefix();
        String other$recordPrefix = other.getRecordPrefix();
        if (this$recordPrefix == null ? other$recordPrefix != null : !this$recordPrefix.equals(other$recordPrefix)) {
            return false;
        }
        String this$arrayOfRecordPrefix = this.getArrayOfRecordPrefix();
        String other$arrayOfRecordPrefix = other.getArrayOfRecordPrefix();
        if (this$arrayOfRecordPrefix == null ? other$arrayOfRecordPrefix != null : !this$arrayOfRecordPrefix.equals(other$arrayOfRecordPrefix)) {
            return false;
        }
        Set<String> this$recordFields = this.getRecordFields();
        Set<String> other$recordFields = other.getRecordFields();
        if (this$recordFields == null ? other$recordFields != null : !((Object)this$recordFields).equals(other$recordFields)) {
            return false;
        }
        Map<String, String> this$recordFieldsMap = this.getRecordFieldsMap();
        Map<String, String> other$recordFieldsMap = other.getRecordFieldsMap();
        return !(this$recordFieldsMap == null ? other$recordFieldsMap != null : !((Object)this$recordFieldsMap).equals(other$recordFieldsMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DiRecordVisitor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isHasDynamic() ? 79 : 97);
        result = result * 59 + this.getDynamicColumnLength();
        result = result * 59 + this.getDynamicColumnPrecision();
        result = result * 59 + (this.isInitDynamicMetadata() ? 79 : 97);
        result = result * 59 + (this.isAllowSpecialName() ? 79 : 97);
        Class<?> $clazz = this.getClazz();
        result = result * 59 + ($clazz == null ? 43 : $clazz.hashCode());
        Constructor<?> $constructor = this.getConstructor();
        result = result * 59 + ($constructor == null ? 43 : ((Object)$constructor).hashCode());
        Object $instance = this.getInstance();
        result = result * 59 + ($instance == null ? 43 : $instance.hashCode());
        Map<String, Field> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        DynamicWrapper $dynamic = this.getDynamic();
        result = result * 59 + ($dynamic == null ? 43 : $dynamic.hashCode());
        String $dynamicColumn = this.getDynamicColumn();
        result = result * 59 + ($dynamicColumn == null ? 43 : $dynamicColumn.hashCode());
        String $dynamicColumnPattern = this.getDynamicColumnPattern();
        result = result * 59 + ($dynamicColumnPattern == null ? 43 : $dynamicColumnPattern.hashCode());
        String $recordPrefix = this.getRecordPrefix();
        result = result * 59 + ($recordPrefix == null ? 43 : $recordPrefix.hashCode());
        String $arrayOfRecordPrefix = this.getArrayOfRecordPrefix();
        result = result * 59 + ($arrayOfRecordPrefix == null ? 43 : $arrayOfRecordPrefix.hashCode());
        Set<String> $recordFields = this.getRecordFields();
        result = result * 59 + ($recordFields == null ? 43 : ((Object)$recordFields).hashCode());
        Map<String, String> $recordFieldsMap = this.getRecordFieldsMap();
        result = result * 59 + ($recordFieldsMap == null ? 43 : ((Object)$recordFieldsMap).hashCode());
        return result;
    }

    public String toString() {
        return "DiRecordVisitor(clazz=" + this.getClazz() + ", constructor=" + this.getConstructor() + ", instance=" + this.getInstance() + ", fields=" + this.getFields() + ", hasDynamic=" + this.isHasDynamic() + ", dynamic=" + this.getDynamic() + ", dynamicColumn=" + this.getDynamicColumn() + ", dynamicColumnLength=" + this.getDynamicColumnLength() + ", dynamicColumnPrecision=" + this.getDynamicColumnPrecision() + ", dynamicColumnPattern=" + this.getDynamicColumnPattern() + ", recordPrefix=" + this.getRecordPrefix() + ", arrayOfRecordPrefix=" + this.getArrayOfRecordPrefix() + ", recordFields=" + this.getRecordFields() + ", recordFieldsMap=" + this.getRecordFieldsMap() + ", initDynamicMetadata=" + this.isInitDynamicMetadata() + ", allowSpecialName=" + this.isAllowSpecialName() + ")";
    }
}

