/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.di.studio;

import org.talend.sdk.component.api.context.RuntimeContext;
import org.talend.sdk.component.api.context.RuntimeContextHolder;
import org.talend.sdk.component.container.Container;
import org.talend.sdk.component.runtime.base.Delegated;
import org.talend.sdk.component.runtime.base.Lifecycle;
import org.talend.sdk.component.runtime.di.studio.ReflectionUtils;
import org.talend.sdk.component.runtime.manager.ComponentManager;
import org.talend.sdk.component.runtime.manager.ContainerComponentRegistry;

public class RuntimeContextInjector {
    public static void injectLifecycle(Lifecycle lifecycle, RuntimeContextHolder runtimeContext) {
        if (lifecycle instanceof Delegated) {
            Object delegate = ((Delegated)lifecycle).getDelegate();
            for (Class<?> currentClass = delegate.getClass(); currentClass != null && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
                ReflectionUtils.findFields(currentClass, RuntimeContext.class).forEach(f -> {
                    try {
                        f.set(delegate, runtimeContext);
                        return;
                    }
                    catch (IllegalAccessException e) {
                        throw new IllegalStateException(e);
                    }
                });
            }
        } else {
            throw new IllegalArgumentException("Not supported implementation of lifecycle : " + lifecycle);
        }
    }

    public static void injectService(ComponentManager manager, String plugin, RuntimeContextHolder runtimeContext) {
        ((ContainerComponentRegistry)((Container)manager.findPlugin(plugin).orElseThrow(() -> new IllegalStateException("Can't find the plugin : " + plugin))).get(ContainerComponentRegistry.class)).getServices().stream().forEach(service -> ReflectionUtils.findFields(service.getInstance(), RuntimeContext.class).forEach(f -> {
            try {
                f.set(service.getInstance(), runtimeContext);
                return;
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }));
    }

    private RuntimeContextInjector() {
    }
}

