/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.junit.http.internal.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.__shade__.io.netty.buffer.ByteBuf;
import org.talend.__shade__.io.netty.buffer.Unpooled;
import org.talend.__shade__.io.netty.channel.ChannelHandler;
import org.talend.__shade__.io.netty.channel.ChannelHandlerContext;
import org.talend.__shade__.io.netty.channel.SimpleChannelInboundHandler;
import org.talend.__shade__.io.netty.handler.codec.http.DefaultFullHttpResponse;
import org.talend.__shade__.io.netty.handler.codec.http.FullHttpRequest;
import org.talend.__shade__.io.netty.handler.codec.http.HttpMethod;
import org.talend.__shade__.io.netty.handler.codec.http.HttpResponseStatus;
import org.talend.__shade__.io.netty.handler.codec.http.HttpUtil;
import org.talend.__shade__.io.netty.handler.codec.http.HttpVersion;
import org.talend.__shade__.io.netty.handler.ssl.SslHandler;
import org.talend.__shade__.io.netty.util.Attribute;
import org.talend.sdk.component.junit.http.api.HttpApiHandler;
import org.talend.sdk.component.junit.http.api.Response;
import org.talend.sdk.component.junit.http.internal.impl.Handlers;
import org.talend.sdk.component.junit.http.internal.impl.ResponseImpl;

public class PassthroughHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private static final Logger log = LoggerFactory.getLogger(PassthroughHandler.class);
    protected final HttpApiHandler api;

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest request) {
        if (HttpMethod.CONNECT.name().equalsIgnoreCase(request.method().name())) {
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.EMPTY_BUFFER);
            HttpUtil.setKeepAlive(response, true);
            HttpUtil.setContentLength(response, 0L);
            if (this.api.getSslContext() != null) {
                SSLEngine sslEngine = this.api.getSslContext().createSSLEngine();
                sslEngine.setUseClientMode(false);
                ctx.channel().pipeline().addFirst("ssl", (ChannelHandler)new SslHandler(sslEngine, true));
                String uri = request.uri();
                String[] parts = uri.split(":");
                ctx.channel().attr(Handlers.BASE).set("https://" + parts[0] + (parts.length > 1 && !"443".equals(parts[1]) ? ":" + parts[1] : ""));
            }
            ctx.writeAndFlush(response);
            return;
        }
        FullHttpRequest req = request.copy();
        this.api.getExecutor().execute(() -> this.doHttpRequest(req, ctx));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doHttpRequest(FullHttpRequest request, ChannelHandlerContext ctx) {
        try {
            ResponseImpl resp;
            Attribute<String> baseAttr = ctx.channel().attr(Handlers.BASE);
            String requestUri = (baseAttr == null || baseAttr.get() == null ? "" : baseAttr.get()) + request.uri();
            HashMap<String, String> otherHeaders = new HashMap<String, String>();
            try {
                URL url = new URL(requestUri);
                final HttpURLConnection connection = (HttpURLConnection)HttpURLConnection.class.cast(url.openConnection(Proxy.NO_PROXY));
                connection.setConnectTimeout(30000);
                connection.setReadTimeout(20000);
                if (HttpsURLConnection.class.isInstance(connection) && this.api.getSslContext() != null) {
                    HttpsURLConnection httpsURLConnection = (HttpsURLConnection)HttpsURLConnection.class.cast(connection);
                    httpsURLConnection.setHostnameVerifier((h, s) -> true);
                    httpsURLConnection.setSSLSocketFactory(this.api.getSslContext().getSocketFactory());
                }
                request.headers().entries().forEach(e -> connection.setRequestProperty((String)e.getKey(), (String)e.getValue()));
                if (request.method() != null) {
                    String requestMethod = request.method().name().toString();
                    connection.setRequestMethod(requestMethod);
                    if (!"HEAD".equalsIgnoreCase(requestMethod) && request.content().readableBytes() > 0) {
                        connection.setDoOutput(true);
                        request.content().readBytes(connection.getOutputStream(), request.content().readableBytes());
                    }
                }
                int responseCode = connection.getResponseCode();
                int defaultLength = Optional.ofNullable(connection.getHeaderField("content-length")).map(Integer::parseInt).orElse(8192);
                resp = new ResponseImpl(this.collectHeaders(connection, this.api.getHeaderFilter().negate()), responseCode, responseCode <= 399 ? this.slurp(connection.getInputStream(), defaultLength) : this.slurp(connection.getErrorStream(), defaultLength));
                otherHeaders.putAll(this.collectHeaders(connection, this.api.getHeaderFilter()));
                this.beforeResponse(requestUri, request, resp, (Map<String, List<String>>)new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER){
                    {
                        super(x0);
                        connection.getHeaderFields().entrySet().stream().filter(it -> it.getKey() != null && it.getValue() != null).forEach((? super T e) -> {
                            List cfr_ignored_0 = (List)this.put(e.getKey(), e.getValue());
                        });
                    }
                });
            }
            catch (Exception e2) {
                log.error(e2.getMessage(), (Throwable)e2);
                Handlers.sendError(ctx, HttpResponseStatus.BAD_REQUEST);
                request.release();
                return;
            }
            ByteBuf bytes = Optional.ofNullable(resp.payload()).map(Unpooled::copiedBuffer).orElse(Unpooled.EMPTY_BUFFER);
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf(resp.status()), bytes);
            HttpUtil.setContentLength(response, bytes.array().length);
            Stream.of(resp.headers(), otherHeaders).filter(Objects::nonNull).forEach(h -> h.forEach((k, v) -> response.headers().set((String)k, v)));
            ctx.writeAndFlush(response);
        }
        finally {
            request.release();
        }
    }

    private TreeMap<String, String> collectHeaders(HttpURLConnection connection, Predicate<String> filter) {
        return connection.getHeaderFields().entrySet().stream().filter(e -> e.getKey() != null).filter(h -> filter.test((String)h.getKey())).collect(Collectors.toMap(Map.Entry::getKey, e -> ((List)e.getValue()).stream().collect(Collectors.joining(",")), (a, b) -> a, () -> new TreeMap(String.CASE_INSENSITIVE_ORDER)));
    }

    protected void beforeResponse(String requestUri, FullHttpRequest request, Response resp, Map<String, List<String>> headerFields) {
    }

    private byte[] slurp(InputStream inputStream, int defaultLen) throws IOException {
        int read;
        if (inputStream == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(defaultLen);
        byte[] bytes = new byte[defaultLen];
        while ((read = inputStream.read(bytes)) >= 0) {
            byteArrayOutputStream.write(bytes, 0, read);
        }
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        log.error(cause.getMessage(), cause);
        Handlers.closeOnFlush(ctx.channel());
    }

    public PassthroughHandler(HttpApiHandler api) {
        this.api = api;
    }
}

