/*
 * Decompiled with CFR 0.152.
 */
package org.talend.__shade__.org.apache.johnzon.mapper;

import java.io.Closeable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.talend.__shade__.javax.json.JsonReaderFactory;
import org.talend.__shade__.javax.json.spi.JsonProvider;
import org.talend.__shade__.javax.json.stream.JsonGeneratorFactory;
import org.talend.__shade__.org.apache.johnzon.mapper.Adapter;
import org.talend.__shade__.org.apache.johnzon.mapper.Converter;
import org.talend.__shade__.org.apache.johnzon.mapper.Mapper;
import org.talend.__shade__.org.apache.johnzon.mapper.MapperConfig;
import org.talend.__shade__.org.apache.johnzon.mapper.MapperConverter;
import org.talend.__shade__.org.apache.johnzon.mapper.ObjectConverter;
import org.talend.__shade__.org.apache.johnzon.mapper.SerializeValueFilter;
import org.talend.__shade__.org.apache.johnzon.mapper.access.AccessMode;
import org.talend.__shade__.org.apache.johnzon.mapper.access.BaseAccessMode;
import org.talend.__shade__.org.apache.johnzon.mapper.access.FieldAccessMode;
import org.talend.__shade__.org.apache.johnzon.mapper.access.FieldAndMethodAccessMode;
import org.talend.__shade__.org.apache.johnzon.mapper.access.MethodAccessMode;
import org.talend.__shade__.org.apache.johnzon.mapper.converter.BigDecimalConverter;
import org.talend.__shade__.org.apache.johnzon.mapper.converter.BigIntegerConverter;
import org.talend.__shade__.org.apache.johnzon.mapper.converter.BooleanConverter;
import org.talend.__shade__.org.apache.johnzon.mapper.converter.ByteConverter;
import org.talend.__shade__.org.apache.johnzon.mapper.converter.CachedDelegateConverter;
import org.talend.__shade__.org.apache.johnzon.mapper.converter.CharacterConverter;
import org.talend.__shade__.org.apache.johnzon.mapper.converter.ClassConverter;
import org.talend.__shade__.org.apache.johnzon.mapper.converter.DateConverter;
import org.talend.__shade__.org.apache.johnzon.mapper.converter.DoubleConverter;
import org.talend.__shade__.org.apache.johnzon.mapper.converter.FloatConverter;
import org.talend.__shade__.org.apache.johnzon.mapper.converter.IntegerConverter;
import org.talend.__shade__.org.apache.johnzon.mapper.converter.LocaleConverter;
import org.talend.__shade__.org.apache.johnzon.mapper.converter.LongConverter;
import org.talend.__shade__.org.apache.johnzon.mapper.converter.ShortConverter;
import org.talend.__shade__.org.apache.johnzon.mapper.converter.StringConverter;
import org.talend.__shade__.org.apache.johnzon.mapper.converter.URIConverter;
import org.talend.__shade__.org.apache.johnzon.mapper.converter.URLConverter;
import org.talend.__shade__.org.apache.johnzon.mapper.internal.AdapterKey;
import org.talend.__shade__.org.apache.johnzon.mapper.internal.ConverterAdapter;

public class MapperBuilder {
    private static final Map<AdapterKey, Adapter<?, ?>> DEFAULT_CONVERTERS = new HashMap(24);
    private JsonReaderFactory readerFactory;
    private JsonGeneratorFactory generatorFactory;
    private boolean supportHiddenAccess = true;
    private int maxSize = -1;
    private int bufferSize = -1;
    private String bufferStrategy;
    private boolean autoAdjustStringBuffers;
    private Comparator<String> attributeOrder = null;
    private boolean supportConstructors;
    private boolean useGetterForCollections;
    private String accessModeName;
    private boolean pretty;
    private final Collection<Closeable> closeables = new ArrayList<Closeable>();
    private int version = -1;
    private boolean close;
    private boolean skipNull = true;
    private boolean skipEmptyArray;
    private boolean supportsComments;
    private boolean treatByteArrayAsBase64;
    private boolean treatByteArrayAsBase64URL;
    private boolean readAttributeBeforeWrite;
    private boolean enforceQuoteString;
    private AccessMode accessMode;
    private Charset encoding = Charset.forName(System.getProperty("johnzon.mapper.encoding", "UTF-8"));
    private ConcurrentMap<AdapterKey, Adapter<?, ?>> adapters = new ConcurrentHashMap(DEFAULT_CONVERTERS);
    private Map<Class<?>, ObjectConverter.Reader<?>> objectConverterReaders = new HashMap();
    private Map<Class<?>, ObjectConverter.Writer<?>> objectConverterWriters = new HashMap();
    private Map<Class<?>, String[]> ignoredForFields = new HashMap();
    private Map<Class<?>, Class<?>> interfaceImplementationMapping = new HashMap();
    private BaseAccessMode.FieldFilteringStrategy fieldFilteringStrategy = null;
    private boolean primitiveConverters;
    private boolean failOnUnknownProperties;
    private SerializeValueFilter serializeValueFilter;
    private boolean useBigDecimalForFloats;
    private Boolean deduplicateObjects = null;

    public Mapper build() {
        if (this.readerFactory == null || this.generatorFactory == null) {
            JsonProvider provider = JsonProvider.provider();
            HashMap<String, Object> config = new HashMap<String, Object>();
            if (this.bufferStrategy != null) {
                config.put("org.talend.__shade__.org.apache.johnzon.buffer-strategy", this.bufferStrategy);
            }
            if (this.pretty) {
                config.put("org.talend.__shade__.javax.json.stream.JsonGenerator.prettyPrinting", true);
            }
            if (this.generatorFactory == null) {
                this.generatorFactory = provider.createGeneratorFactory(config);
            }
            config.remove("org.talend.__shade__.javax.json.stream.JsonGenerator.prettyPrinting");
            if (this.supportsComments) {
                config.put("org.talend.__shade__.org.apache.johnzon.supports-comments", "true");
            }
            if (this.maxSize > 0) {
                config.put("org.talend.__shade__.org.apache.johnzon.max-string-length", this.maxSize);
            }
            if (this.bufferSize > 0) {
                config.put("org.talend.__shade__.org.apache.johnzon.default-char-buffer", this.bufferSize);
            }
            if (this.autoAdjustStringBuffers) {
                config.put("org.talend.__shade__.org.apache.johnzon.auto-adjust-buffer", true);
            }
            if (this.readerFactory == null) {
                this.readerFactory = provider.createReaderFactory(config);
            }
        }
        if (this.accessMode == null) {
            if ("field".equalsIgnoreCase(this.accessModeName)) {
                this.accessMode = new FieldAccessMode(this.supportConstructors, this.supportHiddenAccess);
            } else if ("method".equalsIgnoreCase(this.accessModeName)) {
                this.accessMode = new MethodAccessMode(this.supportConstructors, this.supportHiddenAccess, true);
            } else if ("strict-method".equalsIgnoreCase(this.accessModeName)) {
                this.accessMode = new MethodAccessMode(this.supportConstructors, this.supportHiddenAccess, false);
            } else if ("both".equalsIgnoreCase(this.accessModeName) || this.accessModeName == null) {
                this.accessMode = new FieldAndMethodAccessMode(this.supportConstructors, this.supportHiddenAccess, this.useGetterForCollections);
            } else {
                throw new IllegalArgumentException("Unsupported access mode: " + this.accessModeName);
            }
        }
        if (this.fieldFilteringStrategy != null) {
            if (!BaseAccessMode.class.isInstance(this.accessMode)) {
                throw new IllegalArgumentException("fieldFilteringStrategy can't be set with this access mode: " + this.accessMode);
            }
            ((BaseAccessMode)BaseAccessMode.class.cast(this.accessMode)).setFieldFilteringStrategy(this.fieldFilteringStrategy);
        }
        if (!this.ignoredForFields.isEmpty()) {
            if (BaseAccessMode.class.isInstance(this.accessMode)) {
                BaseAccessMode baseAccessMode = (BaseAccessMode)BaseAccessMode.class.cast(this.accessMode);
                BaseAccessMode.FieldFilteringStrategy strategy = baseAccessMode.getFieldFilteringStrategy();
                if (BaseAccessMode.ConfiguredFieldFilteringStrategy.class.isInstance(strategy)) {
                    BaseAccessMode.ConfiguredFieldFilteringStrategy filteringStrategy = (BaseAccessMode.ConfiguredFieldFilteringStrategy)BaseAccessMode.ConfiguredFieldFilteringStrategy.class.cast(strategy);
                    for (Map.Entry<Class<?>, String[]> ignored : this.ignoredForFields.entrySet()) {
                        String[] fields = ignored.getValue();
                        if (fields == null || fields.length == 0) {
                            filteringStrategy.getFieldsToRemove().remove(ignored.getKey());
                            continue;
                        }
                        filteringStrategy.getFieldsToRemove().put(ignored.getKey(), Arrays.asList(fields));
                    }
                }
            } else {
                throw new IllegalStateException("AccessMode is not an BaseAccessMode");
            }
        }
        if (this.primitiveConverters) {
            this.adapters.put(new AdapterKey((Type)((Object)Byte.class), (Type)((Object)String.class)), new ConverterAdapter<Byte>(new CachedDelegateConverter<Byte>(new ByteConverter())));
            this.adapters.put(new AdapterKey((Type)((Object)Character.class), (Type)((Object)String.class)), new ConverterAdapter<Character>(new CharacterConverter()));
            this.adapters.put(new AdapterKey((Type)((Object)Double.class), (Type)((Object)String.class)), new ConverterAdapter<Double>(new DoubleConverter()));
            this.adapters.put(new AdapterKey((Type)((Object)Float.class), (Type)((Object)String.class)), new ConverterAdapter<Float>(new FloatConverter()));
            this.adapters.put(new AdapterKey((Type)((Object)Integer.class), (Type)((Object)String.class)), new ConverterAdapter<Integer>(new IntegerConverter()));
            this.adapters.put(new AdapterKey((Type)((Object)Long.class), (Type)((Object)String.class)), new ConverterAdapter<Long>(new LongConverter()));
            this.adapters.put(new AdapterKey((Type)((Object)Short.class), (Type)((Object)String.class)), new ConverterAdapter<Short>(new ShortConverter()));
            this.adapters.put(new AdapterKey((Type)((Object)Boolean.class), (Type)((Object)String.class)), new ConverterAdapter<Boolean>(new CachedDelegateConverter<Boolean>(new BooleanConverter())));
            this.adapters.put(new AdapterKey(Byte.TYPE, (Type)((Object)String.class)), (Adapter<?, ?>)this.adapters.get(new AdapterKey((Type)((Object)Byte.class), (Type)((Object)String.class))));
            this.adapters.put(new AdapterKey(Character.TYPE, (Type)((Object)String.class)), (Adapter<?, ?>)this.adapters.get(new AdapterKey((Type)((Object)Character.class), (Type)((Object)String.class))));
            this.adapters.put(new AdapterKey(Double.TYPE, (Type)((Object)String.class)), (Adapter<?, ?>)this.adapters.get(new AdapterKey((Type)((Object)Double.class), (Type)((Object)String.class))));
            this.adapters.put(new AdapterKey(Float.TYPE, (Type)((Object)String.class)), (Adapter<?, ?>)this.adapters.get(new AdapterKey((Type)((Object)Float.class), (Type)((Object)String.class))));
            this.adapters.put(new AdapterKey(Integer.TYPE, (Type)((Object)String.class)), (Adapter<?, ?>)this.adapters.get(new AdapterKey((Type)((Object)Integer.class), (Type)((Object)String.class))));
            this.adapters.put(new AdapterKey(Long.TYPE, (Type)((Object)String.class)), (Adapter<?, ?>)this.adapters.get(new AdapterKey((Type)((Object)Long.class), (Type)((Object)String.class))));
            this.adapters.put(new AdapterKey(Short.TYPE, (Type)((Object)String.class)), (Adapter<?, ?>)this.adapters.get(new AdapterKey((Type)((Object)Short.class), (Type)((Object)String.class))));
            this.adapters.put(new AdapterKey(Boolean.TYPE, (Type)((Object)String.class)), (Adapter<?, ?>)this.adapters.get(new AdapterKey((Type)((Object)Boolean.class), (Type)((Object)String.class))));
        }
        return new Mapper(this.readerFactory, this.generatorFactory, new MapperConfig(this.adapters, this.objectConverterWriters, this.objectConverterReaders, this.version, this.close, this.skipNull, this.skipEmptyArray, this.treatByteArrayAsBase64, this.treatByteArrayAsBase64URL, this.readAttributeBeforeWrite, this.accessMode, this.encoding, this.attributeOrder, this.enforceQuoteString, this.failOnUnknownProperties, this.serializeValueFilter, this.useBigDecimalForFloats, this.deduplicateObjects, this.interfaceImplementationMapping), this.closeables);
    }

    public MapperBuilder setInterfaceImplementationMapping(Map<Class<?>, Class<?>> interfaceImplementationMapping) {
        this.interfaceImplementationMapping = interfaceImplementationMapping;
        return this;
    }

    public MapperBuilder setFailOnUnknownProperties(boolean failOnUnknownProperties) {
        this.failOnUnknownProperties = failOnUnknownProperties;
        return this;
    }

    public MapperBuilder addCloseable(Closeable closeable) {
        this.closeables.add(closeable);
        return this;
    }

    public MapperBuilder setIgnoreFieldsForType(Class<?> type, String ... fields) {
        this.ignoredForFields.put(type, fields == null ? new String[]{} : fields);
        return this;
    }

    public MapperBuilder setSupportGetterForCollections(boolean useGetterForCollections) {
        this.useGetterForCollections = useGetterForCollections;
        return this;
    }

    public MapperBuilder setSupportsComments(boolean supportsComments) {
        this.supportsComments = supportsComments;
        return this;
    }

    public MapperBuilder setPretty(boolean pretty) {
        this.pretty = pretty;
        return this;
    }

    public MapperBuilder setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
        return this;
    }

    public MapperBuilder setBufferStrategy(String bufferStrategy) {
        this.bufferStrategy = bufferStrategy;
        return this;
    }

    public MapperBuilder setMaxSize(int size) {
        this.maxSize = size;
        return this;
    }

    public MapperBuilder setAccessMode(AccessMode mode) {
        this.accessMode = mode;
        return this;
    }

    public MapperBuilder setAccessModeName(String mode) {
        if (!("field".equalsIgnoreCase(mode) || "method".equalsIgnoreCase(mode) || "strict-method".equalsIgnoreCase(mode) || "both".equalsIgnoreCase(mode))) {
            throw new IllegalArgumentException("Mode " + mode + " unsupported");
        }
        this.accessModeName = mode;
        return this;
    }

    public MapperBuilder setAccessModeFieldFilteringStrategy(BaseAccessMode.FieldFilteringStrategy strategy) {
        this.fieldFilteringStrategy = strategy;
        return this;
    }

    public MapperBuilder setAccessModeFieldFilteringStrategyName(String mode) {
        switch (mode.toLowerCase(Locale.ROOT)) {
            case "all": {
                return this.setAccessModeFieldFilteringStrategy(new BaseAccessMode.AllEntriesFieldFilteringStrategy());
            }
            case "single": {
                return this.setAccessModeFieldFilteringStrategy(new BaseAccessMode.SingleEntryFieldFilteringStrategy());
            }
        }
        throw new IllegalArgumentException("Unknown field filter strategy: " + mode);
    }

    public MapperBuilder setSupportHiddenAccess(boolean supportHiddenAccess) {
        this.supportHiddenAccess = supportHiddenAccess;
        return this;
    }

    public MapperBuilder setAttributeOrder(Comparator<String> attributeOrder) {
        this.attributeOrder = attributeOrder;
        return this;
    }

    public MapperBuilder setReaderFactory(JsonReaderFactory readerFactory) {
        this.readerFactory = readerFactory;
        return this;
    }

    public MapperBuilder setGeneratorFactory(JsonGeneratorFactory generatorFactory) {
        this.generatorFactory = generatorFactory;
        return this;
    }

    public MapperBuilder setDoCloseOnStreams(boolean doCloseOnStreams) {
        this.close = doCloseOnStreams;
        return this;
    }

    @Deprecated
    public MapperBuilder addPropertyEditor(Class<?> clazz, Converter<?> converter) {
        this.adapters.put(new AdapterKey(clazz, (Type)((Object)String.class)), new ConverterAdapter(converter));
        return this;
    }

    @Deprecated
    public MapperBuilder addConverter(Type clazz, Converter<?> converter) {
        this.adapters.put(new AdapterKey(clazz, (Type)((Object)String.class)), new ConverterAdapter(converter));
        return this;
    }

    public MapperBuilder addAdapter(Type from, Type to, Adapter<?, ?> adapter) {
        this.adapters.put(new AdapterKey(from, to), adapter);
        return this;
    }

    public MapperBuilder addAdapter(Adapter<?, ?> converter) {
        for (Type gi : converter.getClass().getGenericInterfaces()) {
            if (!ParameterizedType.class.isInstance(gi) || Adapter.class != ((ParameterizedType)ParameterizedType.class.cast(gi)).getRawType()) continue;
            Type[] args = ((ParameterizedType)ParameterizedType.class.cast(gi)).getActualTypeArguments();
            this.adapters.put(new AdapterKey(args[0], args[1]), converter);
            return this;
        }
        throw new IllegalArgumentException("Can't find Adapter generics from " + converter + ", please use addAdapter(t1, t2, adapter) instead");
    }

    public MapperBuilder setVersion(int version) {
        this.version = version;
        return this;
    }

    public MapperBuilder setSkipNull(boolean skipNull) {
        this.skipNull = skipNull;
        return this;
    }

    public MapperBuilder setSkipEmptyArray(boolean skipEmptyArray) {
        this.skipEmptyArray = skipEmptyArray;
        return this;
    }

    public MapperBuilder setTreatByteArrayAsBase64(boolean treatByteArrayAsBase64) {
        this.treatByteArrayAsBase64 = treatByteArrayAsBase64;
        return this;
    }

    public MapperBuilder setTreatByteArrayAsBase64URL(boolean treatByteArrayAsBase64URL) {
        this.treatByteArrayAsBase64URL = treatByteArrayAsBase64URL;
        return this;
    }

    public MapperBuilder setSupportConstructors(boolean supportConstructors) {
        this.supportConstructors = supportConstructors;
        return this;
    }

    public MapperBuilder setEncoding(String encoding) {
        this.encoding = Charset.forName(encoding);
        return this;
    }

    public MapperBuilder setReadAttributeBeforeWrite(boolean readAttributeBeforeWrite) {
        this.readAttributeBeforeWrite = readAttributeBeforeWrite;
        return this;
    }

    public <T> MapperBuilder addObjectConverter(Class<T> targetType, MapperConverter objectConverter) {
        if (ObjectConverter.Reader.class.isInstance(objectConverter)) {
            this.objectConverterReaders.put(targetType, (ObjectConverter.Reader<?>)ObjectConverter.Reader.class.cast(objectConverter));
        }
        if (ObjectConverter.Writer.class.isInstance(objectConverter)) {
            this.objectConverterWriters.put(targetType, (ObjectConverter.Writer<?>)ObjectConverter.Writer.class.cast(objectConverter));
        }
        return this;
    }

    public MapperBuilder setEnforceQuoteString() {
        return this.setEnforceQuoteString(true);
    }

    public MapperBuilder setEnforceQuoteString(boolean val) {
        this.enforceQuoteString = val;
        return this;
    }

    public MapperBuilder setPrimitiveConverters(boolean val) {
        this.primitiveConverters = val;
        return this;
    }

    public MapperBuilder setSerializeValueFilter(SerializeValueFilter serializeValueFilter) {
        this.serializeValueFilter = serializeValueFilter;
        return this;
    }

    public MapperBuilder setUseBigDecimalForFloats(boolean useBigDecimalForFloats) {
        this.useBigDecimalForFloats = useBigDecimalForFloats;
        return this;
    }

    public MapperBuilder setAutoAdjustStringBuffers(boolean autoAdjustStringBuffers) {
        this.autoAdjustStringBuffers = autoAdjustStringBuffers;
        return this;
    }

    public MapperBuilder setDeduplicateObjects(Boolean deduplicateObjects) {
        this.deduplicateObjects = deduplicateObjects;
        return this;
    }

    static {
        DEFAULT_CONVERTERS.put(new AdapterKey((Type)((Object)Date.class), (Type)((Object)String.class)), new ConverterAdapter<Date>(new DateConverter("yyyyMMddHHmmssZ")));
        DEFAULT_CONVERTERS.put(new AdapterKey((Type)((Object)URL.class), (Type)((Object)String.class)), new ConverterAdapter<URL>(new URLConverter()));
        DEFAULT_CONVERTERS.put(new AdapterKey((Type)((Object)URI.class), (Type)((Object)String.class)), new ConverterAdapter<URI>(new URIConverter()));
        DEFAULT_CONVERTERS.put(new AdapterKey((Type)((Object)Class.class), (Type)((Object)String.class)), new ConverterAdapter(new ClassConverter()));
        DEFAULT_CONVERTERS.put(new AdapterKey((Type)((Object)String.class), (Type)((Object)String.class)), new ConverterAdapter<String>(new StringConverter()));
        DEFAULT_CONVERTERS.put(new AdapterKey((Type)((Object)BigDecimal.class), (Type)((Object)String.class)), new ConverterAdapter<BigDecimal>(new BigDecimalConverter()));
        DEFAULT_CONVERTERS.put(new AdapterKey((Type)((Object)BigInteger.class), (Type)((Object)String.class)), new ConverterAdapter<BigInteger>(new BigIntegerConverter()));
        DEFAULT_CONVERTERS.put(new AdapterKey((Type)((Object)Locale.class), (Type)((Object)String.class)), new LocaleConverter());
    }
}

