/*
 * Decompiled with CFR 0.152.
 */
package org.talend.__shade__.org.apache.johnzon.mapper;

import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.stream.BaseStream;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.talend.__shade__.javax.json.JsonValue;
import org.talend.__shade__.javax.json.stream.JsonGenerator;
import org.talend.__shade__.org.apache.johnzon.mapper.Adapter;
import org.talend.__shade__.org.apache.johnzon.mapper.DynamicMappingGenerator;
import org.talend.__shade__.org.apache.johnzon.mapper.MapperConfig;
import org.talend.__shade__.org.apache.johnzon.mapper.MapperException;
import org.talend.__shade__.org.apache.johnzon.mapper.MappingGenerator;
import org.talend.__shade__.org.apache.johnzon.mapper.Mappings;
import org.talend.__shade__.org.apache.johnzon.mapper.ObjectConverter;
import org.talend.__shade__.org.apache.johnzon.mapper.internal.JsonPointerTracker;
import org.talend.__shade__.org.apache.johnzon.mapper.util.ArrayUtil;

public class MappingGeneratorImpl
implements MappingGenerator {
    private final MapperConfig config;
    private final JsonGenerator generator;
    private final Mappings mappings;
    private final Boolean isDeduplicateObjects;
    private Map<Object, String> jsonPointers;

    MappingGeneratorImpl(MapperConfig config, JsonGenerator jsonGenerator, Mappings mappings, Boolean isDeduplicateObjects) {
        this.config = config;
        this.generator = jsonGenerator;
        this.mappings = mappings;
        this.isDeduplicateObjects = isDeduplicateObjects;
        this.jsonPointers = isDeduplicateObjects != false ? new HashMap() : Collections.emptyMap();
    }

    @Override
    public JsonGenerator getJsonGenerator() {
        return this.generator;
    }

    @Override
    public MappingGenerator writeObject(String key, Object object, JsonGenerator generator) {
        if (object == null) {
            return this;
        }
        if (object instanceof JsonValue) {
            generator.write(key, (JsonValue)JsonValue.class.cast(object));
        } else {
            Class<?> objectClass = object.getClass();
            try {
                if (Map.class.isInstance(object)) {
                    this.writeValue(Map.class, false, false, false, false, true, null, key, object, null, Collections.emptyList(), this.isDeduplicateObjects != false ? new JsonPointerTracker(null, "/") : null, generator);
                } else if (!this.writePrimitives(key, objectClass, object, generator)) {
                    if (Enum.class.isAssignableFrom(objectClass)) {
                        Adapter adapter = this.config.findAdapter(objectClass);
                        String adaptedValue = adapter.from(object).toString();
                        generator.write(key, adaptedValue);
                    } else if (objectClass.isArray()) {
                        this.writeValue(Map.class, false, false, true, false, false, null, key, object, null, Collections.emptyList(), this.isDeduplicateObjects != false ? new JsonPointerTracker(null, "/") : null, generator);
                    } else if (Iterable.class.isInstance(object)) {
                        this.writeValue(Map.class, false, false, false, true, false, null, key, object, null, Collections.emptyList(), this.isDeduplicateObjects != false ? new JsonPointerTracker(null, "/") : null, generator);
                    } else {
                        ObjectConverter.Writer objectConverter = this.config.findObjectConverterWriter(objectClass);
                        if (objectConverter != null) {
                            DynamicMappingGenerator dynamicMappingGenerator = new DynamicMappingGenerator(this, generator::writeStartObject, generator::writeEnd, null);
                            objectConverter.writeJson(object, dynamicMappingGenerator);
                            dynamicMappingGenerator.flushIfNeeded();
                        } else {
                            this.writeValue(objectClass, false, false, false, false, false, null, key, object, null, Collections.emptyList(), this.isDeduplicateObjects != false ? new JsonPointerTracker(null, "/") : null, generator);
                        }
                    }
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new MapperException(e);
            }
        }
        return this;
    }

    @Override
    public MappingGenerator writeObject(Object object, JsonGenerator generator) {
        if (object == null) {
            return this;
        }
        if (object instanceof JsonValue) {
            generator.write((JsonValue)object);
        } else {
            this.doWriteObject(object, generator, false, null, this.isDeduplicateObjects != false ? new JsonPointerTracker(null, "/") : null);
        }
        return this;
    }

    public void doWriteObject(Object object, JsonGenerator generator, boolean writeBody, Collection<String> ignoredProperties, JsonPointerTracker jsonPointer) {
        try {
            if (object instanceof Map) {
                if (writeBody) {
                    generator.writeStartObject();
                }
                this.writeMapBody((Map)object, null);
                if (writeBody) {
                    generator.writeEnd();
                }
                return;
            }
            if (this.writePrimitives(object)) {
                return;
            }
            Class<?> objectClass = object.getClass();
            if (Enum.class.isAssignableFrom(objectClass)) {
                Adapter adapter = this.config.findAdapter(objectClass);
                String adaptedValue = adapter.from(object).toString();
                generator.write(adaptedValue);
                return;
            }
            if (objectClass.isArray()) {
                Adapter adapter = this.config.findAdapter(objectClass);
                this.writeArray(objectClass, adapter, null, object, ignoredProperties, jsonPointer);
                return;
            }
            if (object instanceof Iterable) {
                this.doWriteIterable((Iterable)object, ignoredProperties, jsonPointer);
                return;
            }
            Mappings.ClassMapping classMapping = this.mappings.getClassMapping(objectClass);
            if (classMapping != null && classMapping.adapter != null) {
                Object result = classMapping.adapter.from(object);
                this.doWriteObject(result, generator, writeBody, ignoredProperties, jsonPointer);
                return;
            }
            ObjectConverter.Writer objectConverter = this.config.findObjectConverterWriter(objectClass);
            if (writeBody && objectConverter != null) {
                if (!writeBody) {
                    objectConverter.writeJson(object, this);
                } else {
                    DynamicMappingGenerator dynamicMappingGenerator = new DynamicMappingGenerator(this, generator::writeStartObject, generator::writeEnd, null);
                    objectConverter.writeJson(object, dynamicMappingGenerator);
                    dynamicMappingGenerator.flushIfNeeded();
                }
            } else {
                if (writeBody) {
                    generator.writeStartObject();
                }
                if (this.config.getSerializationPredicate() != null && this.config.getSerializationPredicate().test(objectClass)) {
                    generator.write(this.config.getDiscriminator(), this.config.getDiscriminatorMapper().apply(objectClass));
                    this.doWriteObjectBody(object, ignoredProperties, jsonPointer, generator);
                } else {
                    this.doWriteObjectBody(object, ignoredProperties, jsonPointer, generator);
                }
                if (writeBody) {
                    generator.writeEnd();
                }
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new MapperException(e);
        }
    }

    private JsonGenerator writeMapBody(Map<?, ?> object, Adapter itemConverter) throws InvocationTargetException, IllegalAccessException {
        for (Map.Entry<?, ?> entry : object.entrySet()) {
            Object value = entry.getValue();
            Object key = entry.getKey();
            if (value == null) {
                if (this.config.isSkipNull()) continue;
                this.generator.writeNull(key == null ? "null" : key.toString());
                continue;
            }
            Class<?> valueClass = value.getClass();
            this.writeValue(valueClass, true, false, false, false, false, itemConverter, key == null ? "null" : key.toString(), value, null, null, null, this.generator);
        }
        return this.generator;
    }

    private boolean writePrimitives(Object value) {
        boolean handled = false;
        if (value == null) {
            return true;
        }
        Class<?> type = value.getClass();
        if (type == String.class) {
            this.generator.write(value.toString());
            handled = true;
        } else if (type == Long.TYPE || type == Long.class) {
            long longValue = (Long)Long.class.cast(value);
            if (this.isInJsRange(longValue)) {
                this.generator.write(longValue);
            } else {
                this.generator.write(value.toString());
            }
            handled = true;
        } else if (MappingGeneratorImpl.isInt(type)) {
            this.generator.write(((Number)Number.class.cast(value)).intValue());
            handled = true;
        } else if (MappingGeneratorImpl.isFloat(type)) {
            if (type == Float.class || type == Float.TYPE) {
                if (!Float.isNaN(((Float)Float.class.cast(value)).floatValue())) {
                    this.generator.write(new BigDecimal(value.toString()));
                }
            } else {
                double doubleValue = ((Number)Number.class.cast(value)).doubleValue();
                if (!Double.isNaN(doubleValue)) {
                    this.generator.write(doubleValue);
                }
            }
            handled = true;
        } else {
            if (type == Boolean.TYPE || type == Boolean.class) {
                this.generator.write((Boolean)Boolean.class.cast(value));
                return true;
            }
            if (type == BigDecimal.class) {
                this.generator.write((BigDecimal)BigDecimal.class.cast(value));
                handled = true;
            } else if (type == BigInteger.class) {
                this.generator.write((BigInteger)BigInteger.class.cast(value));
                handled = true;
            } else if (type == Character.TYPE || type == Character.class) {
                this.generator.write(((Character)Character.class.cast(value)).toString());
                handled = true;
            }
        }
        return handled;
    }

    private boolean writePrimitives(String key, Class<?> type, Object value, JsonGenerator generator) {
        boolean handled = false;
        if (type == String.class) {
            generator.write(key, value.toString());
            handled = true;
        } else if (JsonValue.class.isAssignableFrom(type)) {
            generator.write(key, (JsonValue)JsonValue.class.cast(value));
            handled = true;
        } else if (type == Long.TYPE || type == Long.class) {
            long longValue = (Long)Long.class.cast(value);
            if (this.isInJsRange(longValue)) {
                generator.write(key, longValue);
            } else {
                generator.write(key, value.toString());
            }
            handled = true;
        } else if (MappingGeneratorImpl.isInt(type)) {
            generator.write(key, ((Number)Number.class.cast(value)).intValue());
            handled = true;
        } else if (MappingGeneratorImpl.isFloat(type)) {
            if (type == Float.class || type == Float.TYPE) {
                if (!Float.isNaN(((Float)Float.class.cast(value)).floatValue())) {
                    generator.write(key, new BigDecimal(value.toString()));
                }
            } else {
                double doubleValue = ((Number)Number.class.cast(value)).doubleValue();
                if (!Double.isNaN(doubleValue)) {
                    generator.write(key, doubleValue);
                }
            }
            handled = true;
        } else if (type == Boolean.TYPE || type == Boolean.class) {
            generator.write(key, (Boolean)Boolean.class.cast(value));
            handled = true;
        } else if (type == BigDecimal.class) {
            generator.write(key, (BigDecimal)BigDecimal.class.cast(value));
            handled = true;
        } else if (type == BigInteger.class) {
            generator.write(key, (BigInteger)BigInteger.class.cast(value));
            handled = true;
        } else if (type == Character.TYPE || type == Character.class) {
            generator.write(key, ((Character)Character.class.cast(value)).toString());
            handled = true;
        }
        return handled;
    }

    private static boolean isInt(Class<?> type) {
        return type == Integer.TYPE || type == Integer.class || type == Byte.TYPE || type == Byte.class || type == Short.TYPE || type == Short.class;
    }

    private static boolean isFloat(Class<?> type) {
        return type == Double.TYPE || type == Double.class || type == Float.TYPE || type == Float.class;
    }

    private void doWriteObjectBody(Object object, Collection<String> ignored, JsonPointerTracker jsonPointer, JsonGenerator generator) throws IllegalAccessException, InvocationTargetException {
        Map any;
        Class<?> objectClass;
        Mappings.ClassMapping classMapping;
        if (jsonPointer != null) {
            this.jsonPointers.put(object, jsonPointer.toString());
        }
        if ((classMapping = this.mappings.findOrCreateClassMapping(objectClass = object.getClass())) == null) {
            throw new MapperException("No mapping for " + objectClass.getName());
        }
        if (classMapping.writer != null) {
            classMapping.writer.writeJson(object, this);
            return;
        }
        if (classMapping.adapter != null) {
            this.doWriteObjectBody(classMapping.adapter.from(object), ignored, jsonPointer, generator);
            return;
        }
        for (Map.Entry<String, Mappings.Getter> getterEntry : classMapping.getters.entrySet()) {
            Mappings.Getter getter = getterEntry.getValue();
            if (ignored != null && ignored.contains(getterEntry.getKey()) || getter.version >= 0 && this.config.getVersion() >= 0 && this.config.getVersion() < getter.version) continue;
            Object value = getter.reader.read(object);
            if (JsonValue.class.isInstance(value)) {
                generator.write(getterEntry.getKey(), (JsonValue)JsonValue.class.cast(value));
                continue;
            }
            if (value == null) {
                if (!getter.reader.isNillable(!this.config.isSkipNull())) continue;
                generator.writeNull(getterEntry.getKey());
                continue;
            }
            Object val = getter.converter == null ? value : getter.converter.from(value);
            String valJsonPointer = this.jsonPointers.get(val);
            if (valJsonPointer != null) {
                generator.write(getterEntry.getKey(), valJsonPointer);
                continue;
            }
            this.writeValue(val.getClass(), getter.dynamic, getter.primitive, getter.array, getter.collection, getter.map, getter.itemConverter, getterEntry.getKey(), val, getter.objectConverter, getter.ignoreNested, this.isDeduplicateObjects != false ? new JsonPointerTracker(jsonPointer, getterEntry.getKey()) : null, generator);
        }
        if (classMapping.anyGetter != null && (any = (Map)Map.class.cast(classMapping.anyGetter.reader.read(object))) != null) {
            this.writeMapBody(any, null);
        }
    }

    private void writeValue(Class<?> type, boolean dynamic, boolean primitive, boolean array, boolean collection, boolean map, Adapter itemConverter, String key, Object value, ObjectConverter.Writer objectConverter, Collection<String> ignoredProperties, JsonPointerTracker jsonPointer, JsonGenerator generator) throws InvocationTargetException, IllegalAccessException {
        if (this.config.getSerializeValueFilter().shouldIgnore(key, value)) {
            return;
        }
        if (!dynamic && array || dynamic && type.isArray()) {
            this.writeArray(type, itemConverter, key, value, ignoredProperties, jsonPointer);
        } else if (!dynamic && collection || dynamic && Iterable.class.isAssignableFrom(type)) {
            this.writeIterator(itemConverter, key, objectConverter, ignoredProperties, jsonPointer, generator, ((Iterable)Iterable.class.cast(value)).iterator(), value);
        } else if (!dynamic && map || dynamic && Map.class.isAssignableFrom(type)) {
            generator.writeStartObject(key);
            this.writeMapBody((Map)value, itemConverter);
            generator.writeEnd();
        } else if (!dynamic && primitive || dynamic && Mappings.isPrimitive(type)) {
            if (objectConverter != null) {
                DynamicMappingGenerator dynamicMappingGenerator = new DynamicMappingGenerator(this, () -> this.generator.writeStartObject(key), this.generator::writeEnd, key);
                objectConverter.writeJson(value, dynamicMappingGenerator);
                dynamicMappingGenerator.flushIfNeeded();
            } else {
                this.writePrimitives(key, type, value, generator);
            }
        } else if (BaseStream.class.isAssignableFrom(type)) {
            this.writeIterator(itemConverter, key, objectConverter, ignoredProperties, jsonPointer, generator, ((BaseStream)BaseStream.class.cast(value)).iterator(), value);
        } else if (Iterator.class.isAssignableFrom(type)) {
            this.writeIterator(itemConverter, key, objectConverter, ignoredProperties, jsonPointer, generator, (Iterator)Iterator.class.cast(value), value);
        } else {
            if (objectConverter != null) {
                DynamicMappingGenerator dynamicMappingGenerator = new DynamicMappingGenerator(this, () -> this.generator.writeStartObject(key), this.generator::writeEnd, key);
                objectConverter.writeJson(value, dynamicMappingGenerator);
                dynamicMappingGenerator.flushIfNeeded();
                return;
            }
            Adapter converter = this.config.findAdapter(type);
            if (converter != null) {
                Object adapted = this.doConvertFrom(value, converter);
                if (this.writePrimitives(key, adapted.getClass(), adapted, generator)) {
                    return;
                }
                this.writeValue(String.class, true, true, false, false, false, null, key, adapted, null, ignoredProperties, jsonPointer, generator);
                return;
            }
            ObjectConverter.Writer objectConverterToUse = objectConverter;
            if (objectConverterToUse == null) {
                objectConverterToUse = this.config.findObjectConverterWriter(type);
            }
            if (objectConverterToUse != null) {
                DynamicMappingGenerator dynamicMappingGenerator = new DynamicMappingGenerator(this, () -> this.generator.writeStartObject(key), this.generator::writeEnd, key);
                objectConverterToUse.writeJson(value, dynamicMappingGenerator);
                dynamicMappingGenerator.flushIfNeeded();
                return;
            }
            if (this.writePrimitives(key, type, value, generator)) {
                return;
            }
            generator.writeStartObject(key);
            this.doWriteObjectBody(value, ignoredProperties, jsonPointer, generator);
            generator.writeEnd();
        }
    }

    private void writeIterator(Adapter itemConverter, String key, ObjectConverter.Writer objectConverter, Collection<String> ignoredProperties, JsonPointerTracker jsonPointer, JsonGenerator generator, Iterator<?> iterator, Object originalValue) {
        if (objectConverter != null && objectConverter.isGlobal()) {
            List list = List.class.isInstance(originalValue) ? (List)List.class.cast(originalValue) : StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 1024), false).collect(Collectors.toList());
            objectConverter.writeJson(list, new DynamicMappingGenerator(this, generator::writeStartArray, generator::writeEnd, key));
            return;
        }
        int i = 0;
        generator.writeStartArray(key);
        while (iterator.hasNext()) {
            Object o = iterator.next();
            String valJsonPointer = this.jsonPointers.get(o);
            if (valJsonPointer != null) {
                this.writePrimitives(valJsonPointer);
            } else {
                ObjectConverter.Writer objectConverterToUse = objectConverter;
                if (o != null && objectConverterToUse == null) {
                    objectConverterToUse = this.config.findObjectConverterWriter(o.getClass());
                }
                if (objectConverterToUse != null) {
                    DynamicMappingGenerator dynamicMappingGenerator = new DynamicMappingGenerator(this, generator::writeStartObject, generator::writeEnd, null);
                    objectConverterToUse.writeJson(o, dynamicMappingGenerator);
                    dynamicMappingGenerator.flushIfNeeded();
                } else {
                    this.writeItem(itemConverter != null ? itemConverter.from(o) : o, ignoredProperties, this.isDeduplicateObjects != false ? new JsonPointerTracker(jsonPointer, i) : null);
                }
            }
            ++i;
        }
        generator.writeEnd();
    }

    private void writeArray(Class<?> type, Adapter itemConverter, String key, Object arrayValue, Collection<String> ignoredProperties, JsonPointerTracker jsonPointer) {
        int length = ArrayUtil.getArrayLength(arrayValue);
        if (length == 0 && this.config.isSkipEmptyArray()) {
            return;
        }
        if (this.config.isTreatByteArrayAsBase64() && type == byte[].class) {
            String base64EncodedByteArray = Base64.getEncoder().encodeToString((byte[])arrayValue);
            if (key != null) {
                this.generator.write(key, base64EncodedByteArray);
            } else {
                this.generator.write(base64EncodedByteArray);
            }
            return;
        }
        if (this.config.isTreatByteArrayAsBase64URL() && type == byte[].class) {
            if (key != null) {
                this.generator.write(key, Base64.getUrlEncoder().encodeToString((byte[])arrayValue));
            } else {
                this.generator.write(Base64.getUrlEncoder().encodeToString((byte[])arrayValue));
            }
            return;
        }
        if (key != null) {
            this.generator.writeStartArray(key);
        } else {
            this.generator.writeStartArray();
        }
        if (type == byte[].class) {
            byte[] tArrayValue = (byte[])arrayValue;
            for (int i = 0; i < length; ++i) {
                byte o = tArrayValue[i];
                this.generator.write(o);
            }
        } else if (type == short[].class) {
            short[] tArrayValue = (short[])arrayValue;
            for (int i = 0; i < length; ++i) {
                short o = tArrayValue[i];
                this.generator.write(o);
            }
        } else if (type == int[].class) {
            int[] tArrayValue = (int[])arrayValue;
            for (int i = 0; i < length; ++i) {
                int o = tArrayValue[i];
                this.generator.write(o);
            }
        } else if (type == long[].class) {
            long[] tArrayValue = (long[])arrayValue;
            for (int i = 0; i < length; ++i) {
                long o = tArrayValue[i];
                this.generator.write(o);
            }
        } else if (type == float[].class) {
            float[] tArrayValue = (float[])arrayValue;
            for (int i = 0; i < length; ++i) {
                float o = tArrayValue[i];
                this.generator.write(o);
            }
        } else if (type == double[].class) {
            double[] tArrayValue = (double[])arrayValue;
            for (int i = 0; i < length; ++i) {
                double o = tArrayValue[i];
                this.generator.write(o);
            }
        } else if (type == char[].class) {
            char[] tArrayValue = (char[])arrayValue;
            for (int i = 0; i < length; ++i) {
                char o = tArrayValue[i];
                this.generator.write(String.valueOf(o));
            }
        } else if (type == boolean[].class) {
            boolean[] tArrayValue = (boolean[])arrayValue;
            for (int i = 0; i < length; ++i) {
                boolean o = tArrayValue[i];
                this.generator.write(o);
            }
        } else if (type == Byte[].class || type == Short[].class || type == Integer[].class || type == Long[].class || type == Float[].class || type == Double[].class || type == Character[].class || type == Boolean[].class) {
            Object[] oArrayValue = (Object[])arrayValue;
            for (int i = 0; i < length; ++i) {
                Object o = oArrayValue[i];
                this.writeItem(itemConverter != null ? itemConverter.from(o) : o, ignoredProperties, null);
            }
        } else {
            for (int i = 0; i < length; ++i) {
                Object[] oArrayValue = (Object[])arrayValue;
                Object o = oArrayValue[i];
                String valJsonPointer = this.jsonPointers.get(o);
                if (valJsonPointer != null) {
                    this.generator.write(valJsonPointer);
                    continue;
                }
                if (o instanceof JsonValue) {
                    this.generator.write((JsonValue)o);
                    continue;
                }
                this.writeItem(itemConverter != null ? itemConverter.from(o) : o, ignoredProperties, this.isDeduplicateObjects != false ? new JsonPointerTracker(jsonPointer, i) : null);
            }
        }
        this.generator.writeEnd();
    }

    private void writeItem(Object o, Collection<String> ignoredProperties, JsonPointerTracker jsonPointer) {
        if (o == null) {
            this.generator.writeNull();
        } else if (!this.writePrimitives(o)) {
            if (Collection.class.isInstance(o)) {
                this.doWriteIterable((Iterable)Collection.class.cast(o), ignoredProperties, jsonPointer);
            } else if (o.getClass().isArray()) {
                int length = ArrayUtil.getArrayLength(o);
                if (length > 0 || !this.config.isSkipEmptyArray()) {
                    this.writeArray(o.getClass(), null, null, o, ignoredProperties, jsonPointer);
                }
            } else {
                String valJsonPointer = this.jsonPointers.get(o);
                if (valJsonPointer != null) {
                    this.generator.write(valJsonPointer);
                } else {
                    this.doWriteObject(o, this.generator, true, ignoredProperties, jsonPointer);
                }
            }
        }
    }

    private <T> void doWriteIterable(Iterable<T> object, Collection<String> ignoredProperties, JsonPointerTracker jsonPointer) {
        if (object == null) {
            this.generator.writeStartArray().writeEnd();
        } else {
            this.generator.writeStartArray();
            int i = 0;
            for (T t : object) {
                if (JsonValue.class.isInstance(t)) {
                    this.generator.write((JsonValue)JsonValue.class.cast(t));
                } else if (t == null) {
                    this.generator.writeNull();
                } else {
                    this.writeItem(t, ignoredProperties, this.isDeduplicateObjects != false ? new JsonPointerTracker(jsonPointer, i) : null);
                }
                ++i;
            }
            this.generator.writeEnd();
        }
    }

    private <T> Object doConvertFrom(T value, Adapter<T, Object> converter) {
        if (converter == null) {
            throw new MapperException("can't convert " + value + " to String");
        }
        return converter.from(value);
    }

    private boolean isInJsRange(Number longValue) {
        return !this.config.isUseJsRange() || longValue.longValue() <= 0x1FFFFFFFFFFFFFL && longValue.longValue() >= -9007199254740991L;
    }
}

