/*
 * Decompiled with CFR 0.152.
 */
package org.talend.__shade__.org.apache.johnzon.core;

import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.talend.__shade__.javax.json.JsonReader;
import org.talend.__shade__.javax.json.JsonReaderFactory;
import org.talend.__shade__.javax.json.stream.JsonParser;
import org.talend.__shade__.org.apache.johnzon.core.AbstractJsonFactory;
import org.talend.__shade__.org.apache.johnzon.core.JsonParserFactoryImpl;
import org.talend.__shade__.org.apache.johnzon.core.JsonReaderImpl;
import org.talend.__shade__.org.apache.johnzon.core.RejectDuplicateKeysMode;

class JsonReaderFactoryImpl
extends AbstractJsonFactory
implements JsonReaderFactory {
    static final Collection<String> SUPPORTED_CONFIG_KEYS = RejectDuplicateKeysMode.CONFIG_KEYS;
    private final JsonParserFactoryImpl parserFactory;
    private final RejectDuplicateKeysMode rejectDuplicateKeys;

    JsonReaderFactoryImpl(Map<String, ?> config) {
        super(config, SUPPORTED_CONFIG_KEYS, JsonParserFactoryImpl.SUPPORTED_CONFIG_KEYS);
        if (!this.internalConfig.isEmpty()) {
            RejectDuplicateKeysMode.CONFIG_KEYS.forEach(this.internalConfig::remove);
        }
        this.parserFactory = new JsonParserFactoryImpl(this.internalConfig);
        this.rejectDuplicateKeys = RejectDuplicateKeysMode.from(config);
    }

    @Override
    public JsonReader createReader(Reader reader) {
        return new JsonReaderImpl(this.parserFactory.createInternalParser(reader), this.parserFactory.getValueBufferProvider(), this.rejectDuplicateKeys);
    }

    @Override
    public JsonReader createReader(InputStream in) {
        return new JsonReaderImpl(this.parserFactory.createInternalParser(in), this.parserFactory.getValueBufferProvider(), this.rejectDuplicateKeys);
    }

    @Override
    public JsonReader createReader(InputStream in, Charset charset) {
        return new JsonReaderImpl(this.parserFactory.createInternalParser(in, charset), this.parserFactory.getValueBufferProvider(), this.rejectDuplicateKeys);
    }

    public JsonReader createReader(JsonParser parser) {
        return new JsonReaderImpl(parser, this.parserFactory.getValueBufferProvider(), this.rejectDuplicateKeys);
    }

    @Override
    public Map<String, ?> getConfigInUse() {
        return Collections.unmodifiableMap(this.internalConfig);
    }
}

