/*
 * Decompiled with CFR 0.152.
 */
package org.talend.__shade__.org.apache.johnzon.mapper;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import org.talend.__shade__.javax.json.JsonReader;
import org.talend.__shade__.javax.json.JsonReaderFactory;
import org.talend.__shade__.javax.json.JsonValue;
import org.talend.__shade__.javax.json.stream.JsonGeneratorFactory;
import org.talend.__shade__.javax.json.stream.JsonParser;
import org.talend.__shade__.org.apache.johnzon.core.Snippet;
import org.talend.__shade__.org.apache.johnzon.mapper.SnippetFactory;

public final class JohnzonCores {
    private static final Method CREATE_READER;

    private JohnzonCores() {
    }

    public static SnippetFactory snippetFactory(int max, JsonGeneratorFactory factory) {
        if (CREATE_READER == null) {
            return JsonValue::toString;
        }
        return Snippets.of(max, factory);
    }

    public static JsonReader map(JsonParser parser, JsonReaderFactory readerFactory) {
        if (CREATE_READER == null) {
            throw new IllegalStateException("Ensure to use johnzon-core as JSON-P provider for johnzon-mapper");
        }
        try {
            return (JsonReader)JsonReader.class.cast(CREATE_READER.invoke((Object)readerFactory, parser));
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e.getTargetException());
        }
    }

    static {
        Method m = null;
        try {
            Class<?> jrfi = Optional.ofNullable(JohnzonCores.class.getClassLoader()).orElseGet(ClassLoader::getSystemClassLoader).loadClass("org.talend.__shade__.org.apache.johnzon.core.JsonReaderFactoryImpl");
            m = jrfi.getDeclaredMethod("createReader", JsonParser.class);
            if (!m.isAccessible()) {
                m.setAccessible(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        CREATE_READER = m;
    }

    private static class Snippets {
        private Snippets() {
        }

        private static SnippetFactory of(int max, JsonGeneratorFactory factory) {
            return new Snippet(max, factory)::of;
        }
    }
}

