/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.junit.http.internal.impl;

import java.io.File;
import java.util.Optional;
import org.talend.__shade__.io.netty.buffer.Unpooled;
import org.talend.__shade__.io.netty.channel.Channel;
import org.talend.__shade__.io.netty.channel.ChannelHandlerContext;
import org.talend.__shade__.io.netty.handler.codec.http.DefaultFullHttpResponse;
import org.talend.__shade__.io.netty.handler.codec.http.HttpHeaderNames;
import org.talend.__shade__.io.netty.handler.codec.http.HttpResponseStatus;
import org.talend.__shade__.io.netty.handler.codec.http.HttpVersion;
import org.talend.__shade__.io.netty.util.AttributeKey;
import org.talend.__shade__.io.netty.util.CharsetUtil;

public class Handlers {
    static final AttributeKey<String> BASE = AttributeKey.newInstance(Handlers.class.getName() + "#BASE");

    static void closeOnFlush(Channel ch) {
        if (ch.isActive()) {
            ch.writeAndFlush(Unpooled.EMPTY_BUFFER);
        }
    }

    static void sendError(ChannelHandlerContext ctx, HttpResponseStatus status) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.copiedBuffer("Failure: " + status.toString() + "\r\n", CharsetUtil.UTF_8));
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/plain; charset=UTF-8");
        response.headers().set("X-Talend-Proxy-JUnit", (Object)"default-response");
        ctx.writeAndFlush(response);
    }

    public static boolean isActive(String handler) {
        return "capture".equals(handler) ? Handlers.getBaseCapture() != null : Boolean.parseBoolean(System.getProperty("talend.junit.http." + handler));
    }

    public static String getBaseCapture() {
        return Optional.ofNullable(System.getProperty("talend.junit.http.capture")).map(value -> {
            File file;
            if ("true".equalsIgnoreCase((String)value) && (file = new File("src/test/resources")).isDirectory()) {
                return file.getAbsolutePath();
            }
            return value;
        }).orElse(null);
    }

    private Handlers() {
    }
}

