/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.junit.http.internal.impl;

import java.io.IOException;
import java.net.ServerSocket;
import java.security.NoSuchAlgorithmException;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.__shade__.io.netty.bootstrap.ServerBootstrap;
import org.talend.__shade__.io.netty.channel.ChannelOption;
import org.talend.__shade__.io.netty.channel.nio.NioEventLoopGroup;
import org.talend.__shade__.io.netty.channel.socket.nio.NioServerSocketChannel;
import org.talend.__shade__.io.netty.util.concurrent.DefaultThreadFactory;
import org.talend.sdk.component.junit.http.api.HttpApiHandler;
import org.talend.sdk.component.junit.http.internal.impl.ProxyInitializer;

public class HandlerImpl<T extends HttpApiHandler<?>>
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(HandlerImpl.class);
    private final HttpApiHandler<T> handler;
    private Thread instance;
    private Runnable shutdown;

    public synchronized HandlerImpl<T> start() {
        if (this.instance != null) {
            throw new IllegalStateException("Instance already started");
        }
        if (this.handler.getPort() <= 0) {
            this.handler.setPort(this.newRandomPort());
        }
        CountDownLatch startingPistol = new CountDownLatch(1);
        int nProcessors = Math.max(1, Runtime.getRuntime().availableProcessors());
        ExecutorService boosExecutor = Executors.newFixedThreadPool(1, new DefaultThreadFactory("talend-api-boss"));
        ExecutorService workerExecutor = Executors.newFixedThreadPool(nProcessors, new DefaultThreadFactory("talend-api-worker"));
        this.instance = new Thread(() -> {
            NioEventLoopGroup bossGroup = new NioEventLoopGroup(1, boosExecutor);
            NioEventLoopGroup workerGroup = new NioEventLoopGroup(nProcessors, workerExecutor);
            try {
                ServerBootstrap b = new ServerBootstrap();
                ((ServerBootstrap)((ServerBootstrap)b.option(ChannelOption.SO_REUSEADDR, true)).group(bossGroup, workerGroup).channel(NioServerSocketChannel.class)).childHandler(new ProxyInitializer(this.handler)).bind("localhost", this.handler.getPort()).sync().addListener(f -> {
                    if (f.isSuccess()) {
                        this.shutdown = () -> {
                            bossGroup.shutdownGracefully();
                            workerGroup.shutdownGracefully();
                        };
                    } else {
                        log.error("Can't start API server");
                    }
                    startingPistol.countDown();
                }).channel().closeFuture().sync();
            }
            catch (InterruptedException e) {
                this.close();
                Thread.currentThread().interrupt();
            }
        }){
            {
                this.setName("Talend-API-monitor_" + HandlerImpl.this.getClass().getSimpleName() + "_" + HandlerImpl.this.hashCode());
            }
        };
        log.info("Starting Talend API server on port {}", (Object)this.handler.getPort());
        this.instance.start();
        try {
            if (!startingPistol.await(Integer.getInteger("talend.junit.http.starting.timeout", 60).intValue(), TimeUnit.SECONDS)) {
                log.warn("API server took more than the expected timeout to start, you can tune it setting talend.junit.http.starting.timeout system property");
            }
        }
        catch (InterruptedException e) {
            log.warn(e.getMessage());
            Thread.currentThread().interrupt();
        }
        if (this.shutdown != null && this.handler.isGlobalProxyConfiguration()) {
            String pt = Integer.toString(this.handler.getPort());
            Stream.of("", "s").forEach(s -> {
                this.shutdown = this.decorate(this.setProperty("http" + s + ".proxyHost", "localhost"), this.shutdown);
                this.shutdown = this.decorate(this.setProperty("http" + s + ".proxyPort", pt), this.shutdown);
                this.shutdown = this.decorate(this.setProperty("http" + s + ".nonProxyHosts", "local|*.local"), this.shutdown);
            });
            if (this.handler.getSslContext() != null) {
                try {
                    SSLContext defaultSslContext = SSLContext.getDefault();
                    HostnameVerifier defaultHostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
                    this.shutdown = this.decorate(() -> SSLContext.setDefault(defaultSslContext), this.shutdown);
                    this.shutdown = this.decorate(() -> {
                        HttpsURLConnection.setDefaultSSLSocketFactory(defaultSslContext.getSocketFactory());
                        HttpsURLConnection.setDefaultHostnameVerifier(defaultHostnameVerifier);
                    }, this.shutdown);
                    this.shutdown = this.decorate(() -> this.setProperty("jdk.internal.httpclient.disableHostnameVerification", "true"), this.shutdown);
                    SSLContext.setDefault(this.handler.getSslContext());
                    HttpsURLConnection.setDefaultSSLSocketFactory(this.handler.getSslContext().getSocketFactory());
                    HttpsURLConnection.setDefaultHostnameVerifier((host, sslSession) -> true);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IllegalStateException(e);
                }
            }
            log.info("Configured the JVM to use the {} API proxy localhost:{}", (Object)(this.handler.getSslContext() != null ? "SSL" : "plain"), (Object)this.handler.getPort());
        }
        return this;
    }

    @Override
    public synchronized void close() {
        Optional.ofNullable(this.shutdown).ifPresent(Runnable::run);
        if (this.instance != null) {
            log.info("Stopping Talend API server (port {})", (Object)this.handler.getPort());
            try {
                this.instance.join(TimeUnit.MINUTES.toMillis(5L));
            }
            catch (InterruptedException e) {
                log.warn(e.getMessage(), (Throwable)e);
                Thread.currentThread().interrupt();
            }
            finally {
                this.instance = null;
                this.shutdown = null;
            }
        }
        Stream.of(this.handler.getResponseLocator(), this.handler.getExecutor()).filter(AutoCloseable.class::isInstance).map(AutoCloseable.class::cast).forEach(c -> {
            try {
                c.close();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        });
        if (!AutoCloseable.class.isInstance(this.handler.getExecutor()) && ExecutorService.class.isInstance(this.handler.getExecutor())) {
            ExecutorService executorService = (ExecutorService)ExecutorService.class.cast(this.handler.getExecutor());
            executorService.shutdownNow();
        }
    }

    private Runnable decorate(Runnable last, Runnable first) {
        return () -> {
            first.run();
            last.run();
        };
    }

    private Runnable setProperty(String name, String value) {
        String val = System.getProperty(name);
        System.setProperty(name, value);
        return () -> {
            if (val == null) {
                System.clearProperty(name);
            } else {
                System.setProperty(name, val);
            }
        };
    }

    private int newRandomPort() {
        int n;
        ServerSocket socket = new ServerSocket(0);
        try {
            n = socket.getLocalPort();
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        socket.close();
        return n;
    }

    public HandlerImpl(HttpApiHandler<T> handler, Thread instance, Runnable shutdown) {
        this.handler = handler;
        this.instance = instance;
        this.shutdown = shutdown;
    }
}

