/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.junit.http.internal.junit5;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;
import org.talend.sdk.component.junit.base.junit5.JUnit5InjectionSupport;
import org.talend.sdk.component.junit.http.api.HttpApiHandler;
import org.talend.sdk.component.junit.http.api.ResponseLocator;
import org.talend.sdk.component.junit.http.internal.impl.DefaultResponseLocator;
import org.talend.sdk.component.junit.http.internal.impl.HandlerImpl;
import org.talend.sdk.component.junit.http.internal.impl.Handlers;
import org.talend.sdk.component.junit.http.junit5.HttpApi;
import org.talend.sdk.component.junit.http.junit5.HttpApiInject;
import org.talend.sdk.component.junit.http.junit5.HttpApiName;

public class JUnit5HttpApi
extends HttpApiHandler<JUnit5HttpApi>
implements BeforeAllCallback,
AfterAllCallback,
JUnit5InjectionSupport,
AfterEachCallback,
BeforeEachCallback {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{JUnit5HttpApi.class.getName()});

    public void beforeAll(ExtensionContext extensionContext) {
        HttpApi config = AnnotationUtils.findAnnotation((Optional)extensionContext.getElement(), HttpApi.class).orElse(null);
        if (config != null) {
            this.setGlobalProxyConfiguration(config.globalProxyConfiguration());
            this.setLogLevel(config.logLevel());
            this.setPort(config.port());
            JUnit5HttpApi.newInstance(config.responseLocator(), ResponseLocator.class).ifPresent(this::setResponseLocator);
            JUnit5HttpApi.newInstance(config.headerFilter(), Predicate.class).ifPresent(this::setHeaderFilter);
            JUnit5HttpApi.newInstance(config.executor(), Executor.class).ifPresent(this::setExecutor);
            JUnit5HttpApi.newInstance(config.sslContext(), Supplier.class).map(s -> (SSLContext)SSLContext.class.cast(s.get())).ifPresent(this::setSslContext);
            this.setSkipProxyHeaders(config.skipProxyHeaders());
            if (config.useSsl()) {
                this.activeSsl();
            }
        }
        extensionContext.getStore(NAMESPACE).put((Object)HttpApiHandler.class.getName(), (Object)this);
        HandlerImpl<JUnit5HttpApi> handler = new HandlerImpl<JUnit5HttpApi>(this, null, null);
        extensionContext.getStore(NAMESPACE).put((Object)HandlerImpl.class.getName(), handler);
        handler.start();
    }

    public void afterAll(ExtensionContext extensionContext) {
        ((HandlerImpl)HandlerImpl.class.cast(extensionContext.getStore(NAMESPACE).get((Object)HandlerImpl.class.getName()))).close();
    }

    public Class<? extends Annotation> injectionMarker() {
        return HttpApiInject.class;
    }

    public void beforeEach(ExtensionContext extensionContext) {
        ResponseLocator responseLocator = this.getResponseLocator();
        if (!DefaultResponseLocator.class.isInstance(responseLocator)) {
            return;
        }
        String test = extensionContext.getTestMethod().map(m -> {
            String displayName = this.sanitizeDisplayName(extensionContext.getDisplayName());
            return AnnotationUtils.findAnnotation((AnnotatedElement)m, HttpApiName.class).map(HttpApiName::value).map(it -> it.replace("${class}", m.getDeclaringClass().getName())).map(it -> it.replace("${method}", m.getName())).map(it -> it.replace("${displayName}", displayName)).orElseGet(() -> m.getDeclaringClass().getName() + "_" + m.getName() + (String)(displayName.equals(m.getName()) ? "" : "_" + displayName));
        }).orElse(null);
        ((DefaultResponseLocator)DefaultResponseLocator.class.cast(responseLocator)).setTest(test);
    }

    public void afterEach(ExtensionContext extensionContext) {
        if (Handlers.isActive("capture")) {
            Optional.of(this.getResponseLocator()).filter(DefaultResponseLocator.class::isInstance).map(DefaultResponseLocator.class::cast).ifPresent(r -> r.flush(Handlers.getBaseCapture()));
        }
    }

    private String sanitizeDisplayName(String displayName) {
        String base = displayName.replace(" ", "_");
        int parenthesis = base.indexOf(40);
        if (parenthesis > 0) {
            return base.substring(0, parenthesis);
        }
        return base;
    }

    private static <T> Optional<T> newInstance(Class<?> type, Class<T> api) {
        if (api == type) {
            return Optional.empty();
        }
        try {
            return Optional.of(api.cast(type.getConstructor(new Class[0]).newInstance(new Object[0])));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e.getTargetException());
        }
    }
}

