/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.output;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.JsonObject;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import org.talend.sdk.component.api.processor.AfterGroup;
import org.talend.sdk.component.api.processor.BeforeGroup;
import org.talend.sdk.component.api.processor.ElementListener;
import org.talend.sdk.component.api.processor.Input;
import org.talend.sdk.component.api.processor.Output;
import org.talend.sdk.component.runtime.base.Delegated;
import org.talend.sdk.component.runtime.base.LifecycleImpl;
import org.talend.sdk.component.runtime.output.InputFactory;
import org.talend.sdk.component.runtime.output.OutputFactory;
import org.talend.sdk.component.runtime.output.Processor;
import org.talend.sdk.component.runtime.serialization.ContainerFinder;
import org.talend.sdk.component.runtime.serialization.EnhancedObjectInputStream;

public class ProcessorImpl
extends LifecycleImpl
implements Processor,
Delegated {
    private transient List<Method> beforeGroup;
    private transient List<Method> afterGroup;
    private transient Method process;
    private transient List<BiFunction<InputFactory, OutputFactory, Object>> parameterBuilderProcess;
    private transient Map<Method, List<Function<OutputFactory, Object>>> parameterBuilderAfterGroup;
    private transient Jsonb jsonb;
    private boolean forwardReturn;
    private Map<String, String> internalConfiguration;

    public ProcessorImpl(String rootName, String name, String plugin, Map<String, String> internalConfiguration, Serializable delegate) {
        super(delegate, rootName, name, plugin);
        this.internalConfiguration = internalConfiguration;
    }

    protected ProcessorImpl() {
    }

    public Map<String, String> getInternalConfiguration() {
        return Optional.ofNullable(this.internalConfiguration).orElseGet(Collections::emptyMap);
    }

    @Override
    public void beforeGroup() {
        if (this.process == null) {
            this.beforeGroup = this.findMethods(BeforeGroup.class).collect(Collectors.toList());
            this.afterGroup = this.findMethods(AfterGroup.class).collect(Collectors.toList());
            this.process = this.findMethods(ElementListener.class).findFirst().get();
            this.parameterBuilderProcess = Stream.of(this.process.getParameters()).map(this::buildProcessParamBuilder).collect(Collectors.toList());
            this.parameterBuilderAfterGroup = this.afterGroup.stream().map(after -> new AbstractMap.SimpleEntry((Method)after, Stream.of(after.getParameters()).map(this::toOutputParamBuilder).collect(Collectors.toList()))).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
            this.forwardReturn = this.process.getReturnType() != Void.TYPE;
        }
        this.beforeGroup.forEach(x$0 -> this.doInvoke((Method)x$0, new Object[0]));
    }

    private BiFunction<InputFactory, OutputFactory, Object> buildProcessParamBuilder(Parameter parameter) {
        if (parameter.isAnnotationPresent(Output.class)) {
            return (inputs, outputs) -> {
                String name = parameter.getAnnotation(Output.class).value();
                return outputs.create(name);
            };
        }
        Class<?> parameterType = parameter.getType();
        boolean isGeneric = JsonObject.class.isAssignableFrom(parameterType);
        String inputName = Optional.ofNullable(parameter.getAnnotation(Input.class)).map(Input::value).orElse("__default__");
        return (inputs, outputs) -> this.doConvertInput(parameterType, isGeneric, inputs.read(inputName));
    }

    private Function<OutputFactory, Object> toOutputParamBuilder(Parameter parameter) {
        return outputs -> {
            String name = parameter.getAnnotation(Output.class).value();
            return outputs.create(name);
        };
    }

    private Object doConvertInput(Class<?> parameterType, boolean isGeneric, Object data) {
        if (data == null) {
            return null;
        }
        if (isGeneric) {
            if (JsonObject.class.isInstance(data)) {
                return data;
            }
            Jsonb jsonb = this.jsonb();
            return jsonb.fromJson(jsonb.toJson(data), JsonObject.class);
        }
        if (parameterType.isInstance(data) || parameterType.isPrimitive()) {
            return data;
        }
        Jsonb jsonb = this.jsonb();
        return jsonb.fromJson(JsonObject.class.isInstance(data) ? ((JsonObject)JsonObject.class.cast(data)).toString() : jsonb.toJson(data), parameterType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Jsonb jsonb() {
        if (this.jsonb == null) {
            ProcessorImpl processorImpl = this;
            synchronized (processorImpl) {
                if (this.jsonb == null) {
                    this.jsonb = ContainerFinder.Instance.get().find(this.plugin()).findService(Jsonb.class);
                }
                if (this.jsonb == null) {
                    this.jsonb = JsonbBuilder.create();
                }
            }
        }
        return this.jsonb;
    }

    @Override
    public void afterGroup(OutputFactory output) {
        this.afterGroup.forEach(after -> this.doInvoke((Method)after, this.parameterBuilderAfterGroup.get(after).stream().map(b -> b.apply(output)).toArray(Object[]::new)));
    }

    @Override
    public void onNext(InputFactory inputFactory, OutputFactory outputFactory) {
        Object out = this.doInvoke(this.process, this.parameterBuilderProcess.stream().map(b -> b.apply(inputFactory, outputFactory)).toArray(Object[]::new));
        if (this.forwardReturn) {
            outputFactory.create("__default__").emit(out);
        }
    }

    @Override
    public Object getDelegate() {
        return this.delegate;
    }

    Object writeReplace() throws ObjectStreamException {
        return new SerializationReplacer(this.plugin(), this.rootName(), this.name(), this.internalConfiguration, this.serializeDelegate());
    }

    protected static Serializable loadDelegate(byte[] value, String plugin) throws IOException, ClassNotFoundException {
        try (EnhancedObjectInputStream ois = new EnhancedObjectInputStream(new ByteArrayInputStream(value), ContainerFinder.Instance.get().find(plugin).classloader());){
            Serializable serializable = (Serializable)Serializable.class.cast(ois.readObject());
            return serializable;
        }
    }

    private static class SerializationReplacer
    implements Serializable {
        private final String plugin;
        private final String component;
        private final String name;
        private final Map<String, String> internalConfiguration;
        private final byte[] value;

        Object readResolve() throws ObjectStreamException {
            try {
                return new ProcessorImpl(this.component, this.name, this.plugin, this.internalConfiguration, ProcessorImpl.loadDelegate(this.value, this.plugin));
            }
            catch (IOException | ClassNotFoundException e) {
                throw new InvalidObjectException(e.getMessage());
            }
        }

        public SerializationReplacer(String plugin, String component, String name, Map<String, String> internalConfiguration, byte[] value) {
            this.plugin = plugin;
            this.component = component;
            this.name = name;
            this.internalConfiguration = internalConfiguration;
            this.value = value;
        }
    }
}

