/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.base.lang.exception;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.stream.Stream;

public class InvocationExceptionWrapper {
    public static RuntimeException toRuntimeException(InvocationTargetException e) {
        HashSet<Throwable> visited = new HashSet<Throwable>();
        visited.add(e.getTargetException());
        return InvocationExceptionWrapper.mapException(e.getTargetException(), visited);
    }

    private static RuntimeException mapException(Throwable targetException, Collection<Throwable> visited) {
        RuntimeException cast;
        if (targetException == null) {
            return null;
        }
        if (ComponentException.class.isInstance(targetException)) {
            return (RuntimeException)ComponentException.class.cast(targetException);
        }
        if (RuntimeException.class.isInstance(targetException) && targetException.getClass().getName().startsWith("java.") && ((cast = (RuntimeException)RuntimeException.class.cast(targetException)).getCause() == null || cast.getCause() != null && cast.getCause().getClass().getName().startsWith("java."))) {
            return cast;
        }
        ComponentException exception = new ComponentException(targetException.getClass().getName(), targetException.getMessage(), targetException.getStackTrace(), InvocationExceptionWrapper.mapCause(targetException, visited));
        if (exception.getSuppressed() != null && exception.getSuppressed().length > 0) {
            Stream.of(exception.getSuppressed()).map(it -> InvocationExceptionWrapper.mapCause(it, new HashSet<Throwable>())).filter(Objects::nonNull).forEach(exception::addSuppressed);
        }
        return exception;
    }

    private static Throwable mapCause(Throwable targetException, Collection<Throwable> visited) {
        Throwable cause = targetException.getCause();
        if (cause == null || !visited.add(cause)) {
            return null;
        }
        return InvocationExceptionWrapper.mapException(cause, visited);
    }

    public static class ComponentException
    extends IllegalStateException {
        private final String originalType;
        private final String originalMessage;

        public ComponentException(String type, String message, StackTraceElement[] stackTrace, Throwable cause) {
            super("(" + type + ") " + message, cause);
            this.originalType = type;
            this.originalMessage = message;
            this.setStackTrace(stackTrace);
        }

        public String getOriginalType() {
            return this.originalType;
        }

        public String getOriginalMessage() {
            return this.originalMessage;
        }
    }
}

