/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.record;

import java.io.ObjectStreamException;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.bind.Jsonb;
import javax.json.spi.JsonProvider;
import org.apache.johnzon.core.JsonLongImpl;
import org.apache.johnzon.jsonb.extension.JsonValueReader;
import org.talend.sdk.component.api.record.Record;
import org.talend.sdk.component.api.record.Schema;
import org.talend.sdk.component.api.service.record.RecordBuilderFactory;

public class RecordConverters
implements Serializable {
    private static final ZoneId UTC = ZoneId.of("UTC");

    public <T> T mapNumber(Class<T> expected, Number from) {
        if (expected == Double.class || expected == Double.TYPE) {
            return expected.cast(from.doubleValue());
        }
        if (expected == Float.class || expected == Float.TYPE) {
            return expected.cast(Float.valueOf(from.floatValue()));
        }
        if (expected == Integer.class || expected == Integer.TYPE) {
            return expected.cast(from.intValue());
        }
        if (expected == Long.class || expected == Long.TYPE) {
            return expected.cast(from.longValue());
        }
        throw new IllegalArgumentException("Can't convert " + from + " to " + expected);
    }

    public <T> Record toRecord(MappingMetaRegistry registry, T data, Supplier<Jsonb> jsonbProvider, Supplier<RecordBuilderFactory> recordBuilderProvider) {
        if (Record.class.isInstance(data)) {
            return (Record)Record.class.cast(data);
        }
        if (JsonObject.class.isInstance(data)) {
            return this.json2Record(recordBuilderProvider.get(), (JsonObject)JsonObject.class.cast(data));
        }
        MappingMeta meta = registry.find(data.getClass(), recordBuilderProvider);
        if (meta.isLinearMapping()) {
            return meta.newRecord(data, recordBuilderProvider.get());
        }
        Jsonb jsonb = jsonbProvider.get();
        return this.json2Record(recordBuilderProvider.get(), (JsonObject)jsonb.fromJson(jsonb.toJson(data), JsonObject.class));
    }

    private Record json2Record(RecordBuilderFactory factory, JsonObject object) {
        Record.Builder builder = factory.newRecordBuilder();
        object.forEach((key, value) -> {
            switch (value.getValueType()) {
                case ARRAY: {
                    List<Object> items = value.asJsonArray().stream().map(it -> this.mapJson(factory, (JsonValue)it)).collect(Collectors.toList());
                    builder.withArray(factory.newEntryBuilder().withName(key).withType(Schema.Type.ARRAY).withElementSchema(this.getArrayElementSchema(factory, items)).build(), items);
                    break;
                }
                case OBJECT: {
                    Record record = this.json2Record(factory, value.asJsonObject());
                    builder.withRecord(factory.newEntryBuilder().withName(key).withType(Schema.Type.RECORD).withElementSchema(record.getSchema()).build(), record);
                    break;
                }
                case TRUE: 
                case FALSE: {
                    builder.withBoolean(key, JsonValue.TRUE.equals(value));
                    break;
                }
                case STRING: {
                    builder.withString(key, ((JsonString)JsonString.class.cast(value)).getString());
                    break;
                }
                case NUMBER: {
                    JsonNumber number = (JsonNumber)JsonNumber.class.cast(value);
                    builder.withDouble(key, number.doubleValue());
                    break;
                }
                case NULL: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported value type: " + value);
                }
            }
        });
        return builder.build();
    }

    private Schema getArrayElementSchema(RecordBuilderFactory factory, List<Object> items) {
        if (items.isEmpty()) {
            return factory.newSchemaBuilder(Schema.Type.STRING).build();
        }
        Schema firstSchema = this.toSchema(factory, items.iterator().next());
        switch (firstSchema.getType()) {
            case RECORD: {
                return items.stream().map(it -> this.toSchema(factory, it)).reduce(null, (s1, s2) -> {
                    Set names2;
                    if (s1 == null) {
                        return s2;
                    }
                    if (s2 == null) {
                        return s1;
                    }
                    List entries1 = s1.getEntries();
                    List entries2 = s2.getEntries();
                    Set names1 = entries1.stream().map(Schema.Entry::getName).collect(Collectors.toSet());
                    if (!names1.equals(names2 = entries2.stream().map(Schema.Entry::getName).collect(Collectors.toSet()))) {
                        Schema.Builder builder = factory.newSchemaBuilder(Schema.Type.RECORD);
                        entries1.forEach(arg_0 -> ((Schema.Builder)builder).withEntry(arg_0));
                        names2.removeAll(names1);
                        entries2.stream().filter(it -> names2.contains(it.getName())).forEach(arg_0 -> ((Schema.Builder)builder).withEntry(arg_0));
                        return builder.build();
                    }
                    return s1;
                });
            }
        }
        return firstSchema;
    }

    private Object mapJson(RecordBuilderFactory factory, JsonValue it) {
        if (JsonObject.class.isInstance(it)) {
            return this.json2Record(factory, (JsonObject)JsonObject.class.cast(it));
        }
        if (JsonArray.class.isInstance(it)) {
            return ((JsonArray)JsonArray.class.cast(it)).stream().map(i -> this.mapJson(factory, (JsonValue)i)).collect(Collectors.toList());
        }
        if (JsonString.class.isInstance(it)) {
            return ((JsonString)JsonString.class.cast(it)).getString();
        }
        if (JsonNumber.class.isInstance(it)) {
            return ((JsonNumber)JsonNumber.class.cast(it)).numberValue();
        }
        if (JsonValue.FALSE.equals(it)) {
            return false;
        }
        if (JsonValue.TRUE.equals(it)) {
            return true;
        }
        if (JsonValue.NULL.equals(it)) {
            return null;
        }
        return it;
    }

    private Schema toSchema(RecordBuilderFactory factory, Object next) {
        if (String.class.isInstance(next) || JsonString.class.isInstance(next)) {
            return factory.newSchemaBuilder(Schema.Type.STRING).build();
        }
        if (Integer.class.isInstance(next)) {
            return factory.newSchemaBuilder(Schema.Type.INT).build();
        }
        if (Long.class.isInstance(next) || JsonLongImpl.class.isInstance(next)) {
            return factory.newSchemaBuilder(Schema.Type.LONG).build();
        }
        if (Float.class.isInstance(next)) {
            return factory.newSchemaBuilder(Schema.Type.FLOAT).build();
        }
        if (Double.class.isInstance(next) || JsonNumber.class.isInstance(next)) {
            return factory.newSchemaBuilder(Schema.Type.DOUBLE).build();
        }
        if (Boolean.class.isInstance(next) || JsonValue.TRUE.equals(next) || JsonValue.FALSE.equals(next)) {
            return factory.newSchemaBuilder(Schema.Type.BOOLEAN).build();
        }
        if (Date.class.isInstance(next) || ZonedDateTime.class.isInstance(next)) {
            return factory.newSchemaBuilder(Schema.Type.DATETIME).build();
        }
        if (byte[].class.isInstance(next)) {
            return factory.newSchemaBuilder(Schema.Type.BYTES).build();
        }
        if (Collection.class.isInstance(next) || JsonArray.class.isInstance(next)) {
            Collection collection = (Collection)Collection.class.cast(next);
            if (collection.isEmpty()) {
                return factory.newSchemaBuilder(Schema.Type.STRING).build();
            }
            return factory.newSchemaBuilder(Schema.Type.ARRAY).withElementSchema(this.toSchema(factory, collection.iterator().next())).build();
        }
        if (Record.class.isInstance(next)) {
            return ((Record)Record.class.cast(next)).getSchema();
        }
        throw new IllegalArgumentException("unsupported type for " + next);
    }

    public Object toType(MappingMetaRegistry registry, Object data, Class<?> parameterType, Supplier<JsonBuilderFactory> factorySupplier, Supplier<JsonProvider> providerSupplier, Supplier<Jsonb> jsonbProvider, Supplier<RecordBuilderFactory> recordBuilderProvider) {
        JsonObject inputAsJson;
        if (parameterType.isInstance(data)) {
            return data;
        }
        if (JsonObject.class.isInstance(data)) {
            if (JsonObject.class == parameterType) {
                return data;
            }
            inputAsJson = (JsonObject)JsonObject.class.cast(data);
        } else if (Record.class.isInstance(data)) {
            MappingMeta mappingMeta;
            Record record = (Record)Record.class.cast(data);
            if (!JsonObject.class.isAssignableFrom(parameterType) && (mappingMeta = registry.find(parameterType, recordBuilderProvider)).isLinearMapping()) {
                return mappingMeta.newInstance(record);
            }
            JsonObject asJson = this.toJson(factorySupplier, providerSupplier, record);
            if (JsonObject.class == parameterType) {
                return asJson;
            }
            inputAsJson = asJson;
        } else {
            if (parameterType == Record.class) {
                return this.toRecord(registry, data, jsonbProvider, recordBuilderProvider);
            }
            Jsonb jsonb = jsonbProvider.get();
            inputAsJson = (JsonObject)jsonb.fromJson(jsonb.toJson(data), JsonObject.class);
        }
        return jsonbProvider.get().fromJson((Reader)new JsonValueReader((JsonStructure)inputAsJson), parameterType);
    }

    private JsonObject toJson(Supplier<JsonBuilderFactory> factorySupplier, Supplier<JsonProvider> providerSupplier, Record record) {
        return this.buildRecord(factorySupplier.get(), providerSupplier, record).build();
    }

    private JsonObjectBuilder buildRecord(JsonBuilderFactory factory, Supplier<JsonProvider> providerSupplier, Record record) {
        Schema schema = record.getSchema();
        JsonObjectBuilder builder = factory.createObjectBuilder();
        schema.getEntries().forEach(entry -> {
            String name = entry.getName();
            switch (entry.getType()) {
                case STRING: {
                    String value = (String)record.get(String.class, name);
                    if (value == null) break;
                    builder.add(name, value);
                    break;
                }
                case INT: {
                    Integer value = (Integer)record.get(Integer.class, name);
                    if (value == null) break;
                    builder.add(name, value.intValue());
                    break;
                }
                case LONG: {
                    Long value = (Long)record.get(Long.class, name);
                    if (value == null) break;
                    builder.add(name, value.longValue());
                    break;
                }
                case FLOAT: {
                    Float value = (Float)record.get(Float.class, name);
                    if (value == null) break;
                    builder.add(name, (double)value.floatValue());
                    break;
                }
                case DOUBLE: {
                    Double value = (Double)record.get(Double.class, name);
                    if (value == null) break;
                    builder.add(name, value.doubleValue());
                    break;
                }
                case BOOLEAN: {
                    Boolean value = (Boolean)record.get(Boolean.class, name);
                    if (value == null) break;
                    builder.add(name, value.booleanValue());
                    break;
                }
                case BYTES: {
                    byte[] value = (byte[])record.get(byte[].class, name);
                    if (value == null) break;
                    builder.add(name, Base64.getEncoder().encodeToString(value));
                    break;
                }
                case DATETIME: {
                    ZonedDateTime value = (ZonedDateTime)record.get(ZonedDateTime.class, name);
                    if (value == null) break;
                    builder.add(name, value.format(DateTimeFormatter.ISO_ZONED_DATE_TIME));
                    break;
                }
                case RECORD: {
                    Record value = (Record)record.get(Record.class, name);
                    if (value == null) break;
                    builder.add(name, this.buildRecord(factory, providerSupplier, value));
                    break;
                }
                case ARRAY: {
                    Collection collection = (Collection)record.get(Collection.class, name);
                    if (collection == null) break;
                    if (collection.isEmpty()) {
                        builder.add(name, (JsonValue)factory.createArrayBuilder().build());
                        break;
                    }
                    Object item = collection.iterator().next();
                    if (String.class.isInstance(item)) {
                        JsonProvider jsonProvider = (JsonProvider)providerSupplier.get();
                        builder.add(name, (JsonValue)this.toArray(factory, v -> jsonProvider.createValue((String)String.class.cast(v)), collection));
                        break;
                    }
                    if (Double.class.isInstance(item)) {
                        JsonProvider jsonProvider = (JsonProvider)providerSupplier.get();
                        builder.add(name, (JsonValue)this.toArray(factory, v -> jsonProvider.createValue(((Double)Double.class.cast(v)).doubleValue()), collection));
                        break;
                    }
                    if (Float.class.isInstance(item)) {
                        JsonProvider jsonProvider = (JsonProvider)providerSupplier.get();
                        builder.add(name, (JsonValue)this.toArray(factory, v -> jsonProvider.createValue((double)((Float)Float.class.cast(v)).floatValue()), collection));
                        break;
                    }
                    if (Double.class.isInstance(item)) {
                        JsonProvider jsonProvider = (JsonProvider)providerSupplier.get();
                        builder.add(name, (JsonValue)this.toArray(factory, v -> jsonProvider.createValue(((Double)Double.class.cast(v)).doubleValue()), collection));
                        break;
                    }
                    if (Integer.class.isInstance(item)) {
                        JsonProvider jsonProvider = (JsonProvider)providerSupplier.get();
                        builder.add(name, (JsonValue)this.toArray(factory, v -> jsonProvider.createValue(((Integer)Integer.class.cast(v)).intValue()), collection));
                        break;
                    }
                    if (Long.class.isInstance(item)) {
                        JsonProvider jsonProvider = (JsonProvider)providerSupplier.get();
                        builder.add(name, (JsonValue)this.toArray(factory, v -> jsonProvider.createValue(((Long)Long.class.cast(v)).longValue()), collection));
                        break;
                    }
                    if (Boolean.class.isInstance(item)) {
                        builder.add(name, (JsonValue)this.toArray(factory, v -> (Boolean)Boolean.class.cast(v) != false ? JsonValue.TRUE : JsonValue.FALSE, collection));
                        break;
                    }
                    if (ZonedDateTime.class.isInstance(item)) {
                        JsonProvider jsonProvider = (JsonProvider)providerSupplier.get();
                        builder.add(name, (JsonValue)this.toArray(factory, v -> jsonProvider.createValue(((ZonedDateTime)ZonedDateTime.class.cast(v)).toInstant().toEpochMilli()), collection));
                        break;
                    }
                    if (Date.class.isInstance(item)) {
                        JsonProvider jsonProvider = (JsonProvider)providerSupplier.get();
                        builder.add(name, (JsonValue)this.toArray(factory, v -> jsonProvider.createValue(((Date)Date.class.cast(v)).getTime()), collection));
                        break;
                    }
                    if (!Record.class.isInstance(item)) break;
                    builder.add(name, (JsonValue)this.toArray(factory, arg_0 -> this.lambda$null$15(factory, (Supplier)providerSupplier, arg_0), collection));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported type: " + entry.getType() + " for '" + name + "'");
                }
            }
        });
        return builder;
    }

    private JsonArray toArray(JsonBuilderFactory factory, Function<Object, JsonValue> valueFactory, Collection<?> collection) {
        Collector<JsonValue, JsonArrayBuilder, JsonArray> collector = Collector.of(() -> ((JsonBuilderFactory)factory).createArrayBuilder(), JsonArrayBuilder::add, JsonArrayBuilder::addAll, JsonArrayBuilder::build, new Collector.Characteristics[0]);
        return collection.stream().map(valueFactory).collect(collector);
    }

    public <T> T coerce(Class<T> expectedType, Object value, String name) {
        if (value == null) {
            return null;
        }
        if (Long.class.isInstance(value) && expectedType != Long.class) {
            if (expectedType == ZonedDateTime.class) {
                long epochMilli = ((Number)Number.class.cast(value)).longValue();
                if (epochMilli == -1L) {
                    return null;
                }
                return expectedType.cast(ZonedDateTime.ofInstant(Instant.ofEpochMilli(epochMilli), UTC));
            }
            if (expectedType == Date.class) {
                return expectedType.cast(new Date(((Number)Number.class.cast(value)).longValue()));
            }
        }
        if (!expectedType.isInstance(value)) {
            if (Number.class.isInstance(value) && Number.class.isAssignableFrom(expectedType)) {
                return this.mapNumber(expectedType, (Number)Number.class.cast(value));
            }
            if (String.class.isInstance(value)) {
                if (ZonedDateTime.class == expectedType) {
                    return expectedType.cast(ZonedDateTime.parse(String.valueOf(value)));
                }
                if (byte[].class == expectedType) {
                    return expectedType.cast(Base64.getDecoder().decode(String.valueOf(value)));
                }
            }
            throw new IllegalArgumentException(name + " can't be converted to " + expectedType);
        }
        return expectedType.cast(value);
    }

    private /* synthetic */ JsonValue lambda$null$15(JsonBuilderFactory factory, Supplier providerSupplier, Object v) {
        return this.buildRecord(factory, providerSupplier, (Record)Record.class.cast(v)).build();
    }

    public static class MappingMetaRegistry
    implements Serializable {
        private final Map<Class<?>, MappingMeta> registry = new ConcurrentHashMap();

        private Object writeReplace() throws ObjectStreamException {
            return new Factory();
        }

        public MappingMeta find(Class<?> parameterType, Supplier<RecordBuilderFactory> factorySupplier) {
            MappingMeta meta = this.registry.get(parameterType);
            if (meta != null) {
                return meta;
            }
            MappingMeta mappingMeta = new MappingMeta(parameterType, this, factorySupplier);
            MappingMeta existing = this.registry.putIfAbsent(parameterType, mappingMeta);
            if (existing != null) {
                return existing;
            }
            return mappingMeta;
        }

        public Map<Class<?>, MappingMeta> getRegistry() {
            return this.registry;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MappingMetaRegistry)) {
                return false;
            }
            MappingMetaRegistry other = (MappingMetaRegistry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<Class<?>, MappingMeta> this$registry = this.getRegistry();
            Map<Class<?>, MappingMeta> other$registry = other.getRegistry();
            return !(this$registry == null ? other$registry != null : !((Object)this$registry).equals(other$registry));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MappingMetaRegistry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<Class<?>, MappingMeta> $registry = this.getRegistry();
            result = result * 59 + ($registry == null ? 43 : ((Object)$registry).hashCode());
            return result;
        }

        public String toString() {
            return "RecordConverters.MappingMetaRegistry(registry=" + this.getRegistry() + ")";
        }

        public static class Factory
        implements Serializable {
            private Object readResolve() throws ObjectStreamException {
                return new MappingMetaRegistry();
            }
        }
    }

    public static class MappingMeta {
        private final boolean linearMapping;
        private final Constructor<?> constructor;
        private final Collection<BiConsumer<Object, Record>> instanceProvisionners;
        private final Schema recordSchema;
        private final Collection<BiConsumer<Record.Builder, Object>> recordProvisionners;

        private MappingMeta(Class<?> type, MappingMetaRegistry registry, Supplier<RecordBuilderFactory> factory) {
            this.linearMapping = Stream.of(type.getInterfaces()).anyMatch(it -> it.getName().startsWith("routines.system."));
            if (!this.linearMapping) {
                this.instanceProvisionners = null;
                this.recordProvisionners = null;
                this.recordSchema = null;
                this.constructor = null;
            } else {
                RecordBuilderFactory builderFactory = factory.get();
                Schema.Builder schemaBuilder = builderFactory.newSchemaBuilder(Schema.Type.RECORD);
                Field[] fields = type.getFields();
                this.instanceProvisionners = new ArrayList<BiConsumer<Object, Record>>(fields.length);
                this.recordProvisionners = new ArrayList<BiConsumer<Record.Builder, Object>>(fields.length);
                Stream.of(fields).filter(field -> !Modifier.isStatic(field.getModifiers())).forEach(field -> {
                    String name = field.getName();
                    Class<?> fieldType = field.getType();
                    if (fieldType == String.class) {
                        this.instanceProvisionners.add((instance, record) -> this.setField(instance, (Field)field, record.getOptionalString(name).orElse(null)));
                        Schema.Entry entry = this.newEntry(builderFactory, name, true, Schema.Type.STRING);
                        schemaBuilder.withEntry(entry);
                        this.recordProvisionners.add((builder, instance) -> Optional.ofNullable(this.getField(instance, (Field)field, (Class)String.class)).ifPresent(value -> builder.withString(entry, value)));
                    } else if (fieldType == Integer.TYPE) {
                        this.instanceProvisionners.add((instance, record) -> this.setField(instance, (Field)field, record.getOptionalInt(name).orElse(0)));
                        Schema.Entry entry = this.newEntry(builderFactory, name, false, Schema.Type.INT);
                        schemaBuilder.withEntry(entry);
                        this.recordProvisionners.add((builder, instance) -> Optional.ofNullable(this.getField(instance, (Field)field, (Class)Integer.class)).ifPresent(value -> builder.withInt(entry, value.intValue())));
                    } else if (fieldType == Integer.class) {
                        this.instanceProvisionners.add((instance, record) -> {
                            OptionalInt value = record.getOptionalInt(name);
                            this.setField(instance, (Field)field, value.isPresent() ? Integer.valueOf(value.getAsInt()) : null);
                        });
                        Schema.Entry entry = this.newEntry(builderFactory, name, true, Schema.Type.INT);
                        schemaBuilder.withEntry(entry);
                        this.recordProvisionners.add((builder, instance) -> Optional.ofNullable(this.getField(instance, (Field)field, (Class)Integer.class)).ifPresent(value -> builder.withInt(entry, value.intValue())));
                    } else if (fieldType == Long.TYPE) {
                        this.instanceProvisionners.add((instance, record) -> this.setField(instance, (Field)field, record.getOptionalLong(name).orElse(0L)));
                        Schema.Entry entry = this.newEntry(builderFactory, name, false, Schema.Type.LONG);
                        schemaBuilder.withEntry(entry);
                        this.recordProvisionners.add((builder, instance) -> Optional.ofNullable(this.getField(instance, (Field)field, (Class)Long.class)).ifPresent(value -> builder.withLong(entry, value.longValue())));
                    } else if (fieldType == Long.class) {
                        this.instanceProvisionners.add((instance, record) -> {
                            OptionalLong value = record.getOptionalLong(name);
                            this.setField(instance, (Field)field, value.isPresent() ? Long.valueOf(value.getAsLong()) : null);
                        });
                        Schema.Entry entry = this.newEntry(builderFactory, name, true, Schema.Type.LONG);
                        schemaBuilder.withEntry(entry);
                        this.recordProvisionners.add((builder, instance) -> Optional.ofNullable(this.getField(instance, (Field)field, (Class)Long.class)).ifPresent(value -> builder.withLong(entry, value.longValue())));
                    } else if (fieldType == Float.TYPE) {
                        this.instanceProvisionners.add((instance, record) -> this.setField(instance, (Field)field, record.getOptionalFloat(name).orElse(0.0)));
                        Schema.Entry entry = this.newEntry(builderFactory, name, false, Schema.Type.FLOAT);
                        schemaBuilder.withEntry(entry);
                        this.recordProvisionners.add((builder, instance) -> Optional.ofNullable(this.getField(instance, (Field)field, (Class)Float.class)).ifPresent(value -> builder.withFloat(entry, value.floatValue())));
                    } else if (fieldType == Float.class) {
                        this.instanceProvisionners.add((instance, record) -> {
                            OptionalDouble value = record.getOptionalFloat(name);
                            this.setField(instance, (Field)field, value.isPresent() ? Float.valueOf((float)value.getAsDouble()) : null);
                        });
                        Schema.Entry entry = this.newEntry(builderFactory, name, true, Schema.Type.FLOAT);
                        schemaBuilder.withEntry(entry);
                        this.recordProvisionners.add((builder, instance) -> Optional.ofNullable(this.getField(instance, (Field)field, (Class)Float.class)).ifPresent(value -> builder.withFloat(entry, value.floatValue())));
                    } else if (fieldType == Short.TYPE) {
                        this.instanceProvisionners.add((instance, record) -> this.setField(instance, (Field)field, (short)record.getOptionalInt(name).orElse(0)));
                        Schema.Entry entry = this.newEntry(builderFactory, name, false, Schema.Type.INT);
                        schemaBuilder.withEntry(entry);
                        this.recordProvisionners.add((builder, instance) -> Optional.ofNullable(this.getField(instance, (Field)field, (Class)Short.class)).ifPresent(value -> builder.withInt(entry, (int)value.shortValue())));
                    } else if (fieldType == Short.class) {
                        this.instanceProvisionners.add((instance, record) -> {
                            OptionalInt value = record.getOptionalInt(name);
                            this.setField(instance, (Field)field, value.isPresent() ? Short.valueOf((short)value.getAsInt()) : null);
                        });
                        Schema.Entry entry = this.newEntry(builderFactory, name, true, Schema.Type.INT);
                        schemaBuilder.withEntry(entry);
                        this.recordProvisionners.add((builder, instance) -> Optional.ofNullable(this.getField(instance, (Field)field, (Class)Short.class)).ifPresent(value -> builder.withInt(entry, (int)value.shortValue())));
                    } else if (fieldType == Byte.TYPE) {
                        this.instanceProvisionners.add((instance, record) -> this.setField(instance, (Field)field, (byte)record.getOptionalInt(name).orElse(0)));
                        Schema.Entry entry = this.newEntry(builderFactory, name, false, Schema.Type.INT);
                        schemaBuilder.withEntry(entry);
                        this.recordProvisionners.add((builder, instance) -> Optional.ofNullable(this.getField(instance, (Field)field, (Class)Byte.class)).ifPresent(value -> builder.withInt(entry, (int)value.byteValue())));
                    } else if (fieldType == Byte.class) {
                        this.instanceProvisionners.add((instance, record) -> {
                            OptionalInt value = record.getOptionalInt(name);
                            this.setField(instance, (Field)field, value.isPresent() ? Byte.valueOf((byte)value.getAsInt()) : null);
                        });
                        Schema.Entry entry = this.newEntry(builderFactory, name, true, Schema.Type.INT);
                        schemaBuilder.withEntry(entry);
                        this.recordProvisionners.add((builder, instance) -> Optional.ofNullable(this.getField(instance, (Field)field, (Class)Byte.class)).ifPresent(value -> builder.withInt(entry, (int)value.byteValue())));
                    } else if (fieldType == Double.TYPE) {
                        this.instanceProvisionners.add((instance, record) -> this.setField(instance, (Field)field, record.getOptionalDouble(name).orElse(0.0)));
                        Schema.Entry entry = this.newEntry(builderFactory, name, false, Schema.Type.DOUBLE);
                        schemaBuilder.withEntry(entry);
                        this.recordProvisionners.add((builder, instance) -> Optional.ofNullable(this.getField(instance, (Field)field, (Class)Double.class)).ifPresent(value -> builder.withDouble(entry, value.doubleValue())));
                    } else if (fieldType == Double.class) {
                        this.instanceProvisionners.add((instance, record) -> {
                            OptionalDouble value = record.getOptionalDouble(name);
                            this.setField(instance, (Field)field, value.isPresent() ? Double.valueOf(value.getAsDouble()) : null);
                        });
                        Schema.Entry entry = this.newEntry(builderFactory, name, true, Schema.Type.DOUBLE);
                        schemaBuilder.withEntry(entry);
                        this.recordProvisionners.add((builder, instance) -> Optional.ofNullable(this.getField(instance, (Field)field, (Class)Double.class)).ifPresent(value -> builder.withDouble(entry, value.doubleValue())));
                    } else if (fieldType == BigDecimal.class) {
                        this.handleBigDecimal(builderFactory, schemaBuilder, (Field)field, name);
                    } else if (fieldType == byte[].class) {
                        this.instanceProvisionners.add((instance, record) -> this.setField(instance, (Field)field, record.getOptionalBytes(name).orElse(null)));
                        Schema.Entry entry = this.newEntry(builderFactory, name, true, Schema.Type.BYTES);
                        schemaBuilder.withEntry(entry);
                        this.recordProvisionners.add((builder, instance) -> Optional.ofNullable(this.getField(instance, (Field)field, (Class)byte[].class)).ifPresent(value -> builder.withBytes(entry, value)));
                    } else if (fieldType == Boolean.TYPE) {
                        this.instanceProvisionners.add((instance, record) -> this.setField(instance, (Field)field, record.getOptionalBoolean(name).orElse(false)));
                        Schema.Entry entry = this.newEntry(builderFactory, name, false, Schema.Type.BOOLEAN);
                        schemaBuilder.withEntry(entry);
                        this.recordProvisionners.add((builder, instance) -> Optional.ofNullable(this.getField(instance, (Field)field, (Class)Boolean.class)).ifPresent(value -> builder.withBoolean(entry, value.booleanValue())));
                    } else if (fieldType == Boolean.class) {
                        this.instanceProvisionners.add((instance, record) -> this.setField(instance, (Field)field, record.getOptionalBoolean(name).orElse(null)));
                        Schema.Entry entry = this.newEntry(builderFactory, name, true, Schema.Type.BOOLEAN);
                        schemaBuilder.withEntry(entry);
                        this.recordProvisionners.add((builder, instance) -> Optional.ofNullable(this.getField(instance, (Field)field, (Class)Boolean.class)).ifPresent(value -> builder.withBoolean(entry, value.booleanValue())));
                    } else if (fieldType == Character.class) {
                        this.instanceProvisionners.add((instance, record) -> this.setField(instance, (Field)field, record.getOptionalString(name).map(s -> s.isEmpty() ? null : Character.valueOf(s.charAt(0))).orElse(null)));
                        Schema.Entry entry = this.newEntry(builderFactory, name, true, Schema.Type.STRING);
                        schemaBuilder.withEntry(entry);
                        this.recordProvisionners.add((builder, instance) -> Optional.ofNullable(this.getField(instance, (Field)field, (Class)Character.class)).ifPresent(value -> builder.withString(entry, Character.toString(value.charValue()))));
                    } else if (fieldType.isArray()) {
                        this.handleArray(registry, factory, builderFactory, schemaBuilder, (Field)field, name, fieldType);
                    } else if (Set.class.isAssignableFrom(fieldType)) {
                        this.handleSet(registry, factory, builderFactory, schemaBuilder, (Field)field, name, fieldType);
                    } else if (Collection.class.isAssignableFrom(fieldType)) {
                        this.handleCollection(registry, factory, builderFactory, schemaBuilder, (Field)field, name, fieldType);
                    } else if (Date.class.isAssignableFrom(fieldType)) {
                        this.instanceProvisionners.add((instance, record) -> this.setField(instance, (Field)field, record.getOptionalDateTime(name).map(dt -> new Date(dt.toInstant().toEpochMilli())).orElse(null)));
                        Schema.Entry entry = this.newEntry(builderFactory, name, true, Schema.Type.DATETIME);
                        schemaBuilder.withEntry(entry);
                        this.recordProvisionners.add((builder, instance) -> Optional.ofNullable(this.getField(instance, (Field)field, (Class)Date.class)).ifPresent(value -> builder.withDateTime(entry, value)));
                    } else {
                        MappingMeta mappingMeta = registry.find(fieldType, factory);
                        if (mappingMeta.linearMapping) {
                            this.instanceProvisionners.add((instance, record) -> this.setField(instance, (Field)field, record.getOptionalRecord(name).map(mappingMeta::newInstance).orElse(null)));
                            Schema.Entry entry = builderFactory.newEntryBuilder().withNullable(true).withName(name).withType(Schema.Type.RECORD).withElementSchema(mappingMeta.recordSchema).build();
                            schemaBuilder.withEntry(entry);
                            this.recordProvisionners.add((builder, instance) -> Optional.ofNullable(this.getField(instance, (Field)field, (Class)Date.class)).ifPresent(value -> builder.withRecord(entry, mappingMeta.newRecord(value, builderFactory))));
                        }
                    }
                });
                this.recordSchema = schemaBuilder.build();
                try {
                    this.constructor = type.getConstructor(new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalStateException("No constructor for " + type.getName(), e);
                }
            }
        }

        private void handleCollection(MappingMetaRegistry registry, Supplier<RecordBuilderFactory> factory, RecordBuilderFactory builderFactory, Schema.Builder schemaBuilder, Field field, String name, Class<?> fieldType) {
            this.instanceProvisionners.add((instance, record) -> this.setField(instance, field, record.getOptionalArray(fieldType.getComponentType(), name).orElse(null)));
            Class<?> elementType = this.findCollectionType(field);
            Schema.Entry entry = builderFactory.newEntryBuilder().withNullable(true).withName(name).withType(Schema.Type.ARRAY).withElementSchema(registry.find(elementType, factory).recordSchema).build();
            schemaBuilder.withEntry(entry);
            this.recordProvisionners.add((builder, instance) -> Optional.ofNullable(this.getField(instance, field, Collection.class)).ifPresent(value -> builder.withArray(entry, value)));
        }

        private void handleSet(MappingMetaRegistry registry, Supplier<RecordBuilderFactory> factory, RecordBuilderFactory builderFactory, Schema.Builder schemaBuilder, Field field, String name, Class<?> fieldType) {
            this.instanceProvisionners.add((instance, record) -> this.setField(instance, field, record.getOptionalArray(fieldType.getComponentType(), name).map(LinkedHashSet::new).orElse(null)));
            Class<?> elementType = this.findCollectionType(field);
            Schema.Entry entry = builderFactory.newEntryBuilder().withNullable(true).withName(name).withType(Schema.Type.ARRAY).withElementSchema(registry.find(elementType, factory).recordSchema).build();
            schemaBuilder.withEntry(entry);
            this.recordProvisionners.add((builder, instance) -> Optional.ofNullable(this.getField(instance, field, Collection.class)).ifPresent(value -> builder.withArray(entry, value)));
        }

        private void handleArray(MappingMetaRegistry registry, Supplier<RecordBuilderFactory> factory, RecordBuilderFactory builderFactory, Schema.Builder schemaBuilder, Field field, String name, Class<?> fieldType) {
            this.instanceProvisionners.add((instance, record) -> this.setField(instance, field, record.getOptionalArray(fieldType.getComponentType(), name).map(Collection::toArray).orElse(null)));
            Schema.Entry entry = builderFactory.newEntryBuilder().withNullable(true).withName(name).withType(Schema.Type.ARRAY).withElementSchema(registry.find(fieldType.getComponentType(), factory).recordSchema).build();
            schemaBuilder.withEntry(entry);
            this.recordProvisionners.add((builder, instance) -> Optional.ofNullable(this.getField(instance, field, Object[].class)).map(Arrays::asList).ifPresent(value -> builder.withArray(entry, (Collection)value)));
        }

        private void handleBigDecimal(RecordBuilderFactory builderFactory, Schema.Builder schemaBuilder, Field field, String name) {
            ConcurrentHashMap typeCache = new ConcurrentHashMap();
            this.instanceProvisionners.add((instance, record) -> {
                Schema.Type st = typeCache.computeIfAbsent(record.getSchema(), s -> s.getEntries().stream().filter(e -> name.equals(e.getName())).findFirst().orElseThrow(IllegalStateException::new).getType());
                switch (st) {
                    case DOUBLE: {
                        OptionalDouble value = record.getOptionalDouble(name);
                        if (!value.isPresent()) break;
                        this.setField(instance, field, BigDecimal.valueOf(value.orElseThrow(IllegalStateException::new)));
                        break;
                    }
                    case STRING: {
                        record.getOptionalString(name).ifPresent(str -> this.setField(instance, field, new BigDecimal((String)str)));
                        break;
                    }
                }
            });
            Schema.Entry entry = this.newEntry(builderFactory, name, true, Schema.Type.STRING);
            schemaBuilder.withEntry(entry);
            this.recordProvisionners.add((builder, instance) -> Optional.ofNullable(this.getField(instance, field, BigDecimal.class)).ifPresent(value -> builder.withString(entry, value.toString())));
        }

        private Schema.Entry newEntry(RecordBuilderFactory builderFactory, String name, boolean nullable, Schema.Type type) {
            return builderFactory.newEntryBuilder().withNullable(nullable).withName(name).withType(type).build();
        }

        private Class<?> findCollectionType(Field field) {
            ParameterizedType parameterizedType;
            Class<Object> elementType = ParameterizedType.class.isInstance(field.getGenericType()) ? ((parameterizedType = (ParameterizedType)ParameterizedType.class.cast(field.getGenericType())).getActualTypeArguments().length == 1 && Class.class.isInstance(parameterizedType.getActualTypeArguments()[0]) ? (Class<Object>)Class.class.cast(parameterizedType.getActualTypeArguments()[0]) : Object.class) : Object.class;
            return elementType;
        }

        Object newInstance(Record record) {
            try {
                Object instance = this.constructor.newInstance(new Object[0]);
                this.instanceProvisionners.forEach(consumer -> consumer.accept(instance, record));
                return instance;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalStateException(e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException(e.getTargetException());
            }
        }

        <T> Record newRecord(T data, RecordBuilderFactory factory) {
            Record.Builder builder = factory.newRecordBuilder(this.recordSchema);
            this.recordProvisionners.forEach(consumer -> consumer.accept(builder, data));
            return builder.build();
        }

        private <T> T getField(Object instance, Field field, Class<T> type) {
            try {
                return type.cast(field.get(instance));
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }

        private void setField(Object instance, Field field, Object value) {
            try {
                field.set(instance, value);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }

        public boolean isLinearMapping() {
            return this.linearMapping;
        }

        public Constructor<?> getConstructor() {
            return this.constructor;
        }

        public Collection<BiConsumer<Object, Record>> getInstanceProvisionners() {
            return this.instanceProvisionners;
        }

        public Schema getRecordSchema() {
            return this.recordSchema;
        }

        public Collection<BiConsumer<Record.Builder, Object>> getRecordProvisionners() {
            return this.recordProvisionners;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MappingMeta)) {
                return false;
            }
            MappingMeta other = (MappingMeta)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isLinearMapping() != other.isLinearMapping()) {
                return false;
            }
            Constructor<?> this$constructor = this.getConstructor();
            Constructor<?> other$constructor = other.getConstructor();
            if (this$constructor == null ? other$constructor != null : !((Object)this$constructor).equals(other$constructor)) {
                return false;
            }
            Collection<BiConsumer<Object, Record>> this$instanceProvisionners = this.getInstanceProvisionners();
            Collection<BiConsumer<Object, Record>> other$instanceProvisionners = other.getInstanceProvisionners();
            if (this$instanceProvisionners == null ? other$instanceProvisionners != null : !((Object)this$instanceProvisionners).equals(other$instanceProvisionners)) {
                return false;
            }
            Schema this$recordSchema = this.getRecordSchema();
            Schema other$recordSchema = other.getRecordSchema();
            if (this$recordSchema == null ? other$recordSchema != null : !this$recordSchema.equals(other$recordSchema)) {
                return false;
            }
            Collection<BiConsumer<Record.Builder, Object>> this$recordProvisionners = this.getRecordProvisionners();
            Collection<BiConsumer<Record.Builder, Object>> other$recordProvisionners = other.getRecordProvisionners();
            return !(this$recordProvisionners == null ? other$recordProvisionners != null : !((Object)this$recordProvisionners).equals(other$recordProvisionners));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MappingMeta;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isLinearMapping() ? 79 : 97);
            Constructor<?> $constructor = this.getConstructor();
            result = result * 59 + ($constructor == null ? 43 : ((Object)$constructor).hashCode());
            Collection<BiConsumer<Object, Record>> $instanceProvisionners = this.getInstanceProvisionners();
            result = result * 59 + ($instanceProvisionners == null ? 43 : ((Object)$instanceProvisionners).hashCode());
            Schema $recordSchema = this.getRecordSchema();
            result = result * 59 + ($recordSchema == null ? 43 : $recordSchema.hashCode());
            Collection<BiConsumer<Record.Builder, Object>> $recordProvisionners = this.getRecordProvisionners();
            result = result * 59 + ($recordProvisionners == null ? 43 : ((Object)$recordProvisionners).hashCode());
            return result;
        }

        public String toString() {
            return "RecordConverters.MappingMeta(linearMapping=" + this.isLinearMapping() + ", constructor=" + this.getConstructor() + ", instanceProvisionners=" + this.getInstanceProvisionners() + ", recordSchema=" + this.getRecordSchema() + ", recordProvisionners=" + this.getRecordProvisionners() + ")";
        }
    }
}

