/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.record;

import java.io.ObjectStreamException;
import java.io.Serializable;
import org.talend.sdk.component.api.record.Record;
import org.talend.sdk.component.api.record.Schema;
import org.talend.sdk.component.api.service.record.RecordBuilderFactory;
import org.talend.sdk.component.runtime.record.RecordImpl;
import org.talend.sdk.component.runtime.record.SchemaImpl;
import org.talend.sdk.component.runtime.record.Schemas;
import org.talend.sdk.component.runtime.serialization.SerializableService;

public class RecordBuilderFactoryImpl
implements RecordBuilderFactory,
Serializable {
    private final String plugin;

    public Schema.Builder newSchemaBuilder(Schema.Type type) {
        switch (type) {
            case RECORD: 
            case ARRAY: {
                return new SchemaImpl.BuilderImpl().withType(type);
            }
        }
        return Schemas.valueOf(type.name());
    }

    public Record.Builder newRecordBuilder(Schema schema) {
        return new RecordImpl.BuilderImpl(schema);
    }

    public Record.Builder newRecordBuilder() {
        return new RecordImpl.BuilderImpl();
    }

    public Schema.Entry.Builder newEntryBuilder() {
        return new SchemaImpl.EntryImpl.BuilderImpl();
    }

    Object writeReplace() throws ObjectStreamException {
        return new SerializableService(this.plugin, RecordBuilderFactory.class.getName());
    }

    public RecordBuilderFactoryImpl(String plugin) {
        this.plugin = plugin;
    }

    public String getPlugin() {
        return this.plugin;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RecordBuilderFactoryImpl)) {
            return false;
        }
        RecordBuilderFactoryImpl other = (RecordBuilderFactoryImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$plugin = this.getPlugin();
        String other$plugin = other.getPlugin();
        return !(this$plugin == null ? other$plugin != null : !this$plugin.equals(other$plugin));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RecordBuilderFactoryImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $plugin = this.getPlugin();
        result = result * 59 + ($plugin == null ? 43 : $plugin.hashCode());
        return result;
    }

    public String toString() {
        return "RecordBuilderFactoryImpl(plugin=" + this.getPlugin() + ")";
    }
}

