/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.input;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.talend.sdk.component.runtime.base.Delegated;
import org.talend.sdk.component.runtime.base.Named;
import org.talend.sdk.component.runtime.input.Input;
import org.talend.sdk.component.runtime.input.InputImpl;
import org.talend.sdk.component.runtime.input.Mapper;
import org.talend.sdk.component.runtime.serialization.ContainerFinder;
import org.talend.sdk.component.runtime.serialization.EnhancedObjectInputStream;

public class LocalPartitionMapper
extends Named
implements Mapper,
Delegated {
    private Serializable input;

    protected LocalPartitionMapper() {
    }

    public LocalPartitionMapper(String rootName, String name, String plugin, Serializable instance) {
        super(rootName, name, plugin);
        this.input = instance;
    }

    @Override
    public long assess() {
        return 1L;
    }

    @Override
    public List<Mapper> split(long desiredSize) {
        return new ArrayList<Mapper>(Collections.singletonList(this));
    }

    @Override
    public Input create() {
        return Input.class.isInstance(this.input) ? (Input)Input.class.cast(this.input) : new InputImpl(this.rootName(), this.name(), this.plugin(), this.input);
    }

    @Override
    public boolean isStream() {
        return false;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public Object getDelegate() {
        return this.input;
    }

    Object writeReplace() throws ObjectStreamException {
        Thread thread = Thread.currentThread();
        ClassLoader old = thread.getContextClassLoader();
        thread.setContextClassLoader(this.input.getClass().getClassLoader());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(this.input);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            thread.setContextClassLoader(old);
        }
        return new SerializationReplacer(this.plugin(), this.rootName(), this.name(), baos.toByteArray());
    }

    private static class SerializationReplacer
    implements Serializable {
        private final String plugin;
        private final String component;
        private final String name;
        private final byte[] input;

        Object readResolve() throws ObjectStreamException {
            try {
                return new LocalPartitionMapper(this.component, this.name, this.plugin, this.loadDelegate());
            }
            catch (IOException | ClassNotFoundException e) {
                throw new InvalidObjectException(e.getMessage());
            }
        }

        private Serializable loadDelegate() throws IOException, ClassNotFoundException {
            try (EnhancedObjectInputStream ois = new EnhancedObjectInputStream(new ByteArrayInputStream(this.input), ContainerFinder.Instance.get().find(this.plugin).classloader());){
                Serializable serializable = (Serializable)Serializable.class.cast(ois.readObject());
                return serializable;
            }
        }

        public SerializationReplacer(String plugin, String component, String name, byte[] input) {
            this.plugin = plugin;
            this.component = component;
            this.name = name;
            this.input = input;
        }
    }
}

