/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.record.json;

import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.bind.Jsonb;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;
import org.talend.sdk.component.api.record.Record;
import org.talend.sdk.component.api.record.Schema;
import org.talend.sdk.component.api.service.record.RecordBuilderFactory;
import org.talend.sdk.component.runtime.record.RecordConverters;
import org.talend.sdk.component.runtime.record.json.OutputRecordHolder;

public class RecordJsonGenerator
implements JsonGenerator {
    private final RecordBuilderFactory factory;
    private final Jsonb jsonb;
    private final OutputRecordHolder holder;
    private final LinkedList<Object> builders = new LinkedList();
    private Record.Builder objectBuilder;
    private Collection<Object> arrayBuilder;
    private final RecordConverters recordConverters = new RecordConverters();
    private final RecordConverters.MappingMetaRegistry mappingRegistry = new RecordConverters.MappingMetaRegistry();

    public JsonGenerator writeStartObject() {
        this.objectBuilder = this.factory.newRecordBuilder();
        this.builders.add(this.objectBuilder);
        this.arrayBuilder = null;
        return this;
    }

    public JsonGenerator writeStartObject(String name) {
        if (this.holder.getData() != null) {
            try {
                Field f = this.holder.getData().getClass().getDeclaredField(name);
                f.setAccessible(true);
                Object o = f.get(this.holder.getData());
                Record r = this.recordConverters.toRecord(this.mappingRegistry, o, () -> this.jsonb, () -> this.factory);
                this.objectBuilder = this.factory.newRecordBuilder(r.getSchema(), r);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new IllegalStateException(e.getMessage());
            }
        } else {
            this.objectBuilder = this.factory.newRecordBuilder();
        }
        this.builders.add(new NamedBuilder<Record.Builder>(this.objectBuilder, name));
        this.arrayBuilder = null;
        return this;
    }

    public JsonGenerator writeStartArray() {
        this.arrayBuilder = new ArrayList<Object>();
        this.builders.add(this.arrayBuilder);
        this.objectBuilder = null;
        return this;
    }

    public JsonGenerator writeStartArray(String name) {
        this.arrayBuilder = new ArrayList<Object>();
        this.builders.add(new NamedBuilder<Collection<Object>>(this.arrayBuilder, name));
        this.objectBuilder = null;
        return this;
    }

    public JsonGenerator writeKey(String name) {
        throw new UnsupportedOperationException();
    }

    public JsonGenerator write(String name, JsonValue value) {
        switch (value.getValueType()) {
            case ARRAY: {
                JsonValue jv = (JsonValue)JsonValue.class.cast(((Collection)Collection.class.cast(value)).iterator().next());
                if (jv.getValueType().equals((Object)JsonValue.ValueType.TRUE) || jv.getValueType().equals((Object)JsonValue.ValueType.FALSE)) {
                    this.objectBuilder.withArray(this.factory.newEntryBuilder().withName(name).withType(Schema.Type.ARRAY).withElementSchema(this.factory.newSchemaBuilder(Schema.Type.BOOLEAN).build()).build(), (Collection)Collection.class.cast(((Collection)Collection.class.cast(value)).stream().map(v -> ((JsonValue)JsonValue.class.cast(v)).getValueType().equals((Object)JsonValue.ValueType.TRUE)).collect(Collectors.toList())));
                    break;
                }
                this.objectBuilder.withArray(this.createEntryForJsonArray(name, (Collection)Collection.class.cast(value)), (Collection)Collection.class.cast(value));
                break;
            }
            case OBJECT: {
                Record r = this.recordConverters.toRecord(this.mappingRegistry, value, () -> this.jsonb, () -> this.factory);
                this.objectBuilder.withRecord(name, r);
                break;
            }
            case STRING: {
                this.objectBuilder.withString(name, ((JsonString)JsonString.class.cast(value)).getString());
                break;
            }
            case NUMBER: {
                this.objectBuilder.withDouble(name, ((JsonNumber)JsonNumber.class.cast(value)).numberValue().doubleValue());
                break;
            }
            case TRUE: {
                this.objectBuilder.withBoolean(name, true);
                break;
            }
            case FALSE: {
                this.objectBuilder.withBoolean(name, false);
                break;
            }
            case NULL: {
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + value.getValueType());
            }
        }
        return this;
    }

    public JsonGenerator write(String name, String value) {
        this.objectBuilder.withString(name, value);
        return this;
    }

    public JsonGenerator write(String name, BigInteger value) {
        this.objectBuilder.withLong(name, value.longValue());
        return this;
    }

    public JsonGenerator write(String name, BigDecimal value) {
        this.objectBuilder.withDouble(name, value.doubleValue());
        return this;
    }

    public JsonGenerator write(String name, int value) {
        this.objectBuilder.withInt(name, value);
        return this;
    }

    public JsonGenerator write(String name, long value) {
        this.objectBuilder.withLong(name, value);
        return this;
    }

    public JsonGenerator write(String name, double value) {
        this.objectBuilder.withDouble(name, value);
        return this;
    }

    public JsonGenerator write(String name, boolean value) {
        this.objectBuilder.withBoolean(name, value);
        return this;
    }

    public JsonGenerator writeNull(String name) {
        return this;
    }

    public JsonGenerator write(JsonValue value) {
        switch (value.getValueType()) {
            case ARRAY: {
                this.arrayBuilder.add(Collection.class.cast(value));
                break;
            }
            case OBJECT: {
                Record r = this.recordConverters.toRecord(this.mappingRegistry, value, () -> this.jsonb, () -> this.factory);
                this.arrayBuilder.add(this.factory.newRecordBuilder(r.getSchema(), r));
                break;
            }
            case STRING: {
                this.arrayBuilder.add(((JsonString)JsonString.class.cast(value)).getString());
                break;
            }
            case NUMBER: {
                this.arrayBuilder.add(((JsonNumber)JsonNumber.class.cast(value)).numberValue().doubleValue());
                break;
            }
            case TRUE: {
                this.arrayBuilder.add(true);
                break;
            }
            case FALSE: {
                this.arrayBuilder.add(false);
                break;
            }
            case NULL: {
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + value.getValueType());
            }
        }
        return this;
    }

    public JsonGenerator write(String value) {
        this.arrayBuilder.add(value);
        return this;
    }

    public JsonGenerator write(BigDecimal value) {
        this.arrayBuilder.add(value);
        return this;
    }

    public JsonGenerator write(BigInteger value) {
        this.arrayBuilder.add(value);
        return this;
    }

    public JsonGenerator write(int value) {
        this.arrayBuilder.add(value);
        return this;
    }

    public JsonGenerator write(long value) {
        this.arrayBuilder.add(value);
        return this;
    }

    public JsonGenerator write(double value) {
        this.arrayBuilder.add(value);
        return this;
    }

    public JsonGenerator write(boolean value) {
        this.arrayBuilder.add(value);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JsonGenerator writeEnd() {
        String name;
        NamedBuilder namedBuilder;
        if (this.builders.size() == 1) {
            return this;
        }
        Object last = this.builders.removeLast();
        Object previous = this.builders.getLast();
        if (NamedBuilder.class.isInstance(previous)) {
            namedBuilder = (NamedBuilder)NamedBuilder.class.cast(previous);
            name = namedBuilder.name;
            previous = namedBuilder.builder;
        } else {
            name = null;
        }
        if (List.class.isInstance(last)) {
            List array = (List)List.class.cast(last);
            if (Collection.class.isInstance(previous)) {
                this.arrayBuilder = (Collection)Collection.class.cast(previous);
                this.objectBuilder = null;
                this.arrayBuilder.add(array);
                return this;
            } else {
                if (!Record.Builder.class.isInstance(previous)) throw new IllegalArgumentException("Unsupported previous builder: " + previous);
                this.objectBuilder = (Record.Builder)Record.Builder.class.cast(previous);
                this.arrayBuilder = null;
                this.objectBuilder.withArray(this.createEntryBuilderForArray(name, array).build(), (Collection)this.prepareArray(array));
            }
            return this;
        } else if (Record.Builder.class.isInstance(last)) {
            Record.Builder object = (Record.Builder)Record.Builder.class.cast(last);
            if (Collection.class.isInstance(previous)) {
                this.arrayBuilder = (Collection)Collection.class.cast(previous);
                this.objectBuilder = null;
                this.arrayBuilder.add(object);
                return this;
            } else {
                if (!Record.Builder.class.isInstance(previous)) throw new IllegalArgumentException("Unsupported previous builder: " + previous);
                this.objectBuilder = (Record.Builder)Record.Builder.class.cast(previous);
                this.arrayBuilder = null;
                this.objectBuilder.withRecord(name, this.objectBuilder.build());
            }
            return this;
        } else {
            if (!NamedBuilder.class.isInstance(last)) throw new IllegalArgumentException("Unsupported previous builder: " + previous);
            namedBuilder = (NamedBuilder)NamedBuilder.class.cast(last);
            if (!Record.Builder.class.isInstance(previous)) throw new IllegalArgumentException("Unsupported previous builder, expected object builder: " + previous);
            this.objectBuilder = (Record.Builder)Record.Builder.class.cast(previous);
            if (List.class.isInstance(namedBuilder.builder)) {
                List array = (List)List.class.cast(namedBuilder.builder);
                this.objectBuilder.withArray(this.createEntryBuilderForArray(namedBuilder.name, array).build(), (Collection)this.prepareArray(array));
                this.arrayBuilder = null;
                return this;
            } else {
                if (!Record.Builder.class.isInstance(namedBuilder.builder)) throw new IllegalArgumentException("Unsupported previous builder: " + previous);
                this.objectBuilder.withRecord(namedBuilder.name, ((Record.Builder)Record.Builder.class.cast(namedBuilder.builder)).build());
                this.arrayBuilder = null;
            }
        }
        return this;
    }

    private List prepareArray(List array) {
        return array.stream().map(it -> Record.Builder.class.isInstance(it) ? ((Record.Builder)Record.Builder.class.cast(it)).build() : it).collect(Collectors.toList());
    }

    private Schema.Entry createEntryForJsonArray(String name, Collection array) {
        Schema.Type type = this.findType(array);
        Schema.Entry.Builder builder = this.factory.newEntryBuilder().withName(name).withType(Schema.Type.ARRAY);
        if (type == Schema.Type.RECORD) {
            JsonObject first = (JsonObject)JsonObject.class.cast(array.iterator().next());
            Schema.Builder rBuilder = first.entrySet().stream().collect(Collector.of(() -> this.factory.newSchemaBuilder(Schema.Type.RECORD), (schemaBuilder, entry) -> {
                String k = (String)entry.getKey();
                JsonValue v = (JsonValue)entry.getValue();
                schemaBuilder.withEntry(this.factory.newEntryBuilder().withName(k).withType(this.findType(v.getClass())).build());
            }, (b1, b2) -> {
                throw new IllegalStateException();
            }, new Collector.Characteristics[0]));
            builder.withElementSchema(rBuilder.build());
        } else {
            builder.withElementSchema(this.factory.newSchemaBuilder(type).build());
        }
        return builder.build();
    }

    private Schema.Entry.Builder createEntryBuilderForArray(String name, List array) {
        Schema.Type type = this.findType(array);
        Schema.Entry.Builder builder = this.factory.newEntryBuilder().withName(name).withType(Schema.Type.ARRAY);
        if (type == Schema.Type.RECORD) {
            Record first = ((Record.Builder)Record.Builder.class.cast(array.iterator().next())).build();
            array.set(0, this.factory.newRecordBuilder(first.getSchema(), first));
            builder.withElementSchema(first.getSchema());
        } else {
            builder.withElementSchema(this.factory.newSchemaBuilder(type).build());
        }
        return builder;
    }

    private Schema.Type findType(Collection<?> array) {
        if (array.isEmpty()) {
            return Schema.Type.STRING;
        }
        Class clazz = array.stream().filter(Objects::nonNull).findFirst().map(Object::getClass).orElse(null);
        return this.findType(clazz);
    }

    private Schema.Type findType(Class<?> clazz) {
        if (clazz == null) {
            return Schema.Type.STRING;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return Schema.Type.ARRAY;
        }
        if (CharSequence.class.isAssignableFrom(clazz)) {
            return Schema.Type.STRING;
        }
        if (Integer.TYPE == clazz || Integer.class == clazz) {
            return Schema.Type.INT;
        }
        if (Long.TYPE == clazz || Long.class == clazz) {
            return Schema.Type.LONG;
        }
        if (Boolean.TYPE == clazz || Boolean.class == clazz) {
            return Schema.Type.BOOLEAN;
        }
        if (Float.TYPE == clazz || Float.class == clazz) {
            return Schema.Type.FLOAT;
        }
        if (Double.TYPE == clazz || Double.class == clazz) {
            return Schema.Type.DOUBLE;
        }
        if (byte[].class == clazz) {
            return Schema.Type.BYTES;
        }
        if (ZonedDateTime.class == clazz) {
            return Schema.Type.DATETIME;
        }
        if (JsonArray.class.isAssignableFrom(clazz)) {
            return Schema.Type.ARRAY;
        }
        if (JsonObject.class.isAssignableFrom(clazz)) {
            return Schema.Type.RECORD;
        }
        if (JsonNumber.class.isAssignableFrom(clazz)) {
            return Schema.Type.DOUBLE;
        }
        if (JsonString.class.isAssignableFrom(clazz)) {
            return Schema.Type.STRING;
        }
        if (JsonValue.class.isAssignableFrom(clazz)) {
            return Schema.Type.STRING;
        }
        return Schema.Type.RECORD;
    }

    public JsonGenerator writeNull() {
        return this;
    }

    public void close() {
        this.holder.setRecord(((Record.Builder)Record.Builder.class.cast(this.builders.getLast())).build());
    }

    public void flush() {
    }

    public RecordJsonGenerator(RecordBuilderFactory factory, Jsonb jsonb, OutputRecordHolder holder) {
        this.factory = factory;
        this.jsonb = jsonb;
        this.holder = holder;
    }

    private static class NamedBuilder<T> {
        private final T builder;
        private final String name;

        public NamedBuilder(T builder, String name) {
            this.builder = builder;
            this.name = name;
        }
    }

    public static class Factory
    implements JsonGeneratorFactory {
        private final Supplier<RecordBuilderFactory> factory;
        private final Supplier<Jsonb> jsonb;
        private final Map<String, ?> configuration;

        public JsonGenerator createGenerator(Writer writer) {
            if (OutputRecordHolder.class.isInstance(writer)) {
                return new RecordJsonGenerator(this.factory.get(), this.jsonb.get(), (OutputRecordHolder)OutputRecordHolder.class.cast(writer));
            }
            throw new IllegalArgumentException("Unsupported writer: " + writer);
        }

        public JsonGenerator createGenerator(OutputStream out) {
            return this.createGenerator(out, StandardCharsets.UTF_8);
        }

        public JsonGenerator createGenerator(OutputStream out, Charset charset) {
            throw new UnsupportedOperationException();
        }

        public Map<String, ?> getConfigInUse() {
            return this.configuration;
        }

        public Factory(Supplier<RecordBuilderFactory> factory, Supplier<Jsonb> jsonb, Map<String, ?> configuration) {
            this.factory = factory;
            this.jsonb = jsonb;
            this.configuration = configuration;
        }
    }
}

