/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.record;

import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.json.bind.JsonbConfig;
import javax.json.bind.annotation.JsonbTransient;
import javax.json.spi.JsonProvider;
import org.talend.sdk.component.api.record.Record;
import org.talend.sdk.component.api.record.Schema;
import org.talend.sdk.component.runtime.record.RecordBuilderFactoryImpl;
import org.talend.sdk.component.runtime.record.RecordConverters;
import org.talend.sdk.component.runtime.record.SchemaImpl;

public final class RecordImpl
implements Record {
    private static final RecordConverters RECORD_CONVERTERS = new RecordConverters();
    private final Map<String, Object> values;
    @JsonbTransient
    private final Schema schema;

    private RecordImpl(Map<String, Object> values, Schema schema) {
        this.values = values;
        this.schema = schema;
    }

    public <T> T get(Class<T> expectedType, String name) {
        Object value = this.values.get(name);
        if (value == null || expectedType.isInstance(value)) {
            return expectedType.cast(value);
        }
        return RECORD_CONVERTERS.coerce(expectedType, value, name);
    }

    public String toString() {
        String string;
        block8: {
            Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withFormatting(Boolean.valueOf(true)).withPropertyOrderStrategy("LEXICOGRAPHICAL").setProperty("johnzon.cdi.activated", (Object)false));
            try {
                string = new RecordConverters().toType(new RecordConverters.MappingMetaRegistry(), this, JsonObject.class, () -> Json.createBuilderFactory(Collections.emptyMap()), JsonProvider::provider, () -> jsonb, () -> new RecordBuilderFactoryImpl("tostring")).toString();
                if (jsonb == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jsonb != null) {
                        try {
                            jsonb.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return super.toString();
                }
            }
            jsonb.close();
        }
        return string;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RecordImpl)) {
            return false;
        }
        RecordImpl other = (RecordImpl)o;
        Map<String, Object> this$values = this.values;
        Map<String, Object> other$values = other.values;
        if (this$values == null ? other$values != null : !((Object)this$values).equals(other$values)) {
            return false;
        }
        Schema this$schema = this.getSchema();
        Schema other$schema = other.getSchema();
        return !(this$schema == null ? other$schema != null : !this$schema.equals(other$schema));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Object> $values = this.values;
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        Schema $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        return result;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public static class BuilderImpl
    implements Record.Builder {
        private final Map<String, Object> values = new HashMap<String, Object>(8);
        private final List<Schema.Entry> entries = new ArrayList<Schema.Entry>(8);
        private final Schema providedSchema;
        private Map<String, Schema.Entry> entryIndex;

        public BuilderImpl() {
            this(null);
        }

        public BuilderImpl(Schema providedSchema) {
            this.providedSchema = providedSchema;
        }

        private BuilderImpl(List<Schema.Entry> entries, Map<String, Object> values) {
            this.entries.addAll(entries);
            this.values.putAll(values);
            this.providedSchema = null;
        }

        public Object getValue(String name) {
            return this.values.get(name);
        }

        public Record.Builder with(Schema.Entry entry, Object value) {
            this.validateTypeAgainstProvidedSchema(entry.getName(), entry.getType(), value);
            if (!entry.getType().isCompatible(value)) {
                throw new IllegalArgumentException(String.format("Entry '%s' of type %s is not compatible with value of type '%s'", entry.getName(), entry.getType(), value.getClass().getName()));
            }
            if (entry.getType() == Schema.Type.DATETIME) {
                if (value == null) {
                    return this;
                }
                if (value instanceof Long) {
                    this.withTimestamp(entry, (long)((Long)value));
                } else if (value instanceof Date) {
                    this.withDateTime(entry, (Date)value);
                } else if (value instanceof ZonedDateTime) {
                    this.withDateTime(entry, (ZonedDateTime)value);
                } else if (value instanceof Temporal) {
                    this.withTimestamp(entry, (long)((Temporal)value).get(ChronoField.INSTANT_SECONDS) * 1000L);
                }
                return this;
            }
            return this.append(entry, value);
        }

        public List<Schema.Entry> getCurrentEntries() {
            if (this.providedSchema != null) {
                return Collections.unmodifiableList(this.providedSchema.getEntries());
            }
            return Collections.unmodifiableList(this.entries);
        }

        public Record.Builder removeEntry(Schema.Entry schemaEntry) {
            if (this.providedSchema == null) {
                Optional<Schema.Entry> entry = this.entries.stream().filter(e -> Objects.equals(e.getName(), schemaEntry.getName())).findFirst();
                if (!entry.isPresent()) {
                    throw new IllegalArgumentException("No entry '" + schemaEntry.getName() + "' expected in entries: " + this.entries);
                }
                this.entries.remove(entry.get());
                this.values.remove(schemaEntry.getName());
                return this;
            }
            BuilderImpl builder = new BuilderImpl(this.providedSchema.getEntries(), this.values);
            return builder.removeEntry(schemaEntry);
        }

        public Record.Builder updateEntryByName(String name, Schema.Entry schemaEntry) {
            if (this.providedSchema == null) {
                Object value = this.values.get(name);
                if (!schemaEntry.getType().isCompatible(value)) {
                    throw new IllegalArgumentException(String.format("Entry '%s' of type %s is not compatible with value of type '%s'", schemaEntry.getName(), schemaEntry.getType(), value.getClass().getName()));
                }
                boolean found = false;
                for (int i = 0; i < this.entries.size() && !found; ++i) {
                    Schema.Entry entry = this.entries.get(i);
                    if (!Objects.equals(entry.getName(), name)) continue;
                    this.entries.set(i, schemaEntry);
                    found = true;
                }
                if (!found) {
                    throw new IllegalArgumentException("No entry '" + schemaEntry.getName() + "' expected in entries: " + this.entries);
                }
                this.values.remove(name);
                this.values.put(schemaEntry.getName(), value);
                return this;
            }
            BuilderImpl builder = new BuilderImpl(this.providedSchema.getEntries(), this.values);
            return builder.updateEntryByName(name, schemaEntry);
        }

        private Schema.Entry findExistingEntry(String name) {
            Schema.Entry entry;
            if (this.entryIndex == null) {
                this.entryIndex = this.providedSchema.getEntries().stream().collect(Collectors.toMap(Schema.Entry::getName, Function.identity()));
            }
            if ((entry = this.entryIndex.get(name)) == null) {
                throw new IllegalArgumentException("No entry '" + name + "' expected in provided schema: " + this.entryIndex.keySet());
            }
            return entry;
        }

        private Schema.Entry findOrBuildEntry(String name, Schema.Type type, boolean nullable) {
            if (this.providedSchema == null) {
                return new SchemaImpl.EntryImpl.BuilderImpl().withName(name).withType(type).withNullable(nullable).build();
            }
            return this.findExistingEntry(name);
        }

        private Schema.Entry validateTypeAgainstProvidedSchema(String name, Schema.Type type, Object value) {
            if (this.providedSchema == null) {
                return null;
            }
            Schema.Entry entry = this.findExistingEntry(name);
            if (entry.getType() != type) {
                throw new IllegalArgumentException("Entry '" + name + "' expected to be a " + entry.getType() + ", got a " + type);
            }
            if (value == null && !entry.isNullable()) {
                throw new IllegalArgumentException("Entry '" + name + "' is not nullable");
            }
            return entry;
        }

        public Record build() {
            String missing;
            if (this.providedSchema != null && !(missing = this.providedSchema.getEntries().stream().filter(it -> !it.isNullable() && !this.values.containsKey(it.getName())).map(Schema.Entry::getName).collect(Collectors.joining(", "))).isEmpty()) {
                throw new IllegalArgumentException("Missing entries: " + missing);
            }
            return new RecordImpl(Collections.unmodifiableMap(this.values), this.providedSchema == null ? new SchemaImpl(Schema.Type.RECORD, null, Collections.unmodifiableList(this.entries)) : this.providedSchema);
        }

        public Record.Builder withString(String name, String value) {
            Schema.Entry entry = this.findOrBuildEntry(name, Schema.Type.STRING, true);
            return this.withString(entry, value);
        }

        public Record.Builder withString(Schema.Entry entry, String value) {
            this.assertType(entry.getType(), Schema.Type.STRING);
            this.validateTypeAgainstProvidedSchema(entry.getName(), Schema.Type.STRING, value);
            return this.append(entry, value);
        }

        public Record.Builder withBytes(String name, byte[] value) {
            Schema.Entry entry = this.findOrBuildEntry(name, Schema.Type.BYTES, true);
            return this.withBytes(entry, value);
        }

        public Record.Builder withBytes(Schema.Entry entry, byte[] value) {
            this.assertType(entry.getType(), Schema.Type.BYTES);
            this.validateTypeAgainstProvidedSchema(entry.getName(), Schema.Type.BYTES, value);
            return this.append(entry, value);
        }

        public Record.Builder withDateTime(String name, Date value) {
            Schema.Entry entry = this.findOrBuildEntry(name, Schema.Type.DATETIME, true);
            return this.withDateTime(entry, value);
        }

        public Record.Builder withDateTime(Schema.Entry entry, Date value) {
            if (value == null && !entry.isNullable()) {
                throw new IllegalArgumentException("date '" + entry.getName() + "' is not allowed to be null");
            }
            this.validateTypeAgainstProvidedSchema(entry.getName(), Schema.Type.DATETIME, value);
            return this.withTimestamp(entry, value == null ? -1L : value.getTime());
        }

        public Record.Builder withDateTime(String name, ZonedDateTime value) {
            Schema.Entry entry = this.findOrBuildEntry(name, Schema.Type.DATETIME, true);
            return this.withDateTime(entry, value);
        }

        public Record.Builder withDateTime(Schema.Entry entry, ZonedDateTime value) {
            if (value == null && !entry.isNullable()) {
                throw new IllegalArgumentException("datetime '" + entry.getName() + "' is not allowed to be null");
            }
            this.validateTypeAgainstProvidedSchema(entry.getName(), Schema.Type.DATETIME, value);
            return this.withTimestamp(entry, value == null ? -1L : value.toInstant().toEpochMilli());
        }

        public Record.Builder withTimestamp(String name, long value) {
            Schema.Entry entry = this.findOrBuildEntry(name, Schema.Type.DATETIME, false);
            return this.withTimestamp(entry, value);
        }

        public Record.Builder withTimestamp(Schema.Entry entry, long value) {
            this.assertType(entry.getType(), Schema.Type.DATETIME);
            this.validateTypeAgainstProvidedSchema(entry.getName(), Schema.Type.DATETIME, value);
            return this.append(entry, value);
        }

        public Record.Builder withInt(String name, int value) {
            Schema.Entry entry = this.findOrBuildEntry(name, Schema.Type.INT, false);
            return this.withInt(entry, value);
        }

        public Record.Builder withInt(Schema.Entry entry, int value) {
            this.assertType(entry.getType(), Schema.Type.INT);
            this.validateTypeAgainstProvidedSchema(entry.getName(), Schema.Type.INT, value);
            return this.append(entry, value);
        }

        public Record.Builder withLong(String name, long value) {
            Schema.Entry entry = this.findOrBuildEntry(name, Schema.Type.LONG, false);
            return this.withLong(entry, value);
        }

        public Record.Builder withLong(Schema.Entry entry, long value) {
            this.assertType(entry.getType(), Schema.Type.LONG);
            this.validateTypeAgainstProvidedSchema(entry.getName(), Schema.Type.LONG, value);
            return this.append(entry, value);
        }

        public Record.Builder withFloat(String name, float value) {
            Schema.Entry entry = this.findOrBuildEntry(name, Schema.Type.FLOAT, false);
            return this.withFloat(entry, value);
        }

        public Record.Builder withFloat(Schema.Entry entry, float value) {
            this.assertType(entry.getType(), Schema.Type.FLOAT);
            this.validateTypeAgainstProvidedSchema(entry.getName(), Schema.Type.FLOAT, Float.valueOf(value));
            return this.append(entry, Float.valueOf(value));
        }

        public Record.Builder withDouble(String name, double value) {
            Schema.Entry entry = this.findOrBuildEntry(name, Schema.Type.DOUBLE, false);
            return this.withDouble(entry, value);
        }

        public Record.Builder withDouble(Schema.Entry entry, double value) {
            this.assertType(entry.getType(), Schema.Type.DOUBLE);
            this.validateTypeAgainstProvidedSchema(entry.getName(), Schema.Type.DOUBLE, value);
            return this.append(entry, value);
        }

        public Record.Builder withBoolean(String name, boolean value) {
            Schema.Entry entry = this.findOrBuildEntry(name, Schema.Type.BOOLEAN, false);
            return this.withBoolean(entry, value);
        }

        public Record.Builder withBoolean(Schema.Entry entry, boolean value) {
            this.assertType(entry.getType(), Schema.Type.BOOLEAN);
            this.validateTypeAgainstProvidedSchema(entry.getName(), Schema.Type.BOOLEAN, value);
            return this.append(entry, value);
        }

        public Record.Builder withRecord(Schema.Entry entry, Record value) {
            this.assertType(entry.getType(), Schema.Type.RECORD);
            if (entry.getElementSchema() == null) {
                throw new IllegalArgumentException("No schema for the nested record");
            }
            this.validateTypeAgainstProvidedSchema(entry.getName(), Schema.Type.RECORD, value);
            return this.append(entry, value);
        }

        public Record.Builder withRecord(String name, Record value) {
            return this.withRecord(new SchemaImpl.EntryImpl.BuilderImpl().withName(name).withElementSchema(value.getSchema()).withType(Schema.Type.RECORD).withNullable(true).build(), value);
        }

        public <T> Record.Builder withArray(Schema.Entry entry, Collection<T> values) {
            this.assertType(entry.getType(), Schema.Type.ARRAY);
            if (entry.getElementSchema() == null) {
                throw new IllegalArgumentException("No schema for the collection items");
            }
            this.validateTypeAgainstProvidedSchema(entry.getName(), Schema.Type.ARRAY, values);
            return this.append(entry, values);
        }

        private void assertType(Schema.Type actual, Schema.Type expected) {
            if (actual != expected) {
                throw new IllegalArgumentException("Expected entry type: " + expected + ", got: " + actual);
            }
        }

        private <T> Record.Builder append(Schema.Entry entry, T value) {
            if (value != null) {
                this.values.put(entry.getName(), value);
            } else if (!entry.isNullable()) {
                throw new IllegalArgumentException(entry.getName() + " is not nullable but got a null value");
            }
            if (this.providedSchema == null && this.entries.stream().noneMatch(e -> Objects.equals(e.getName(), entry.getName()))) {
                this.entries.add(entry);
            }
            return this;
        }
    }
}

