/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.record;

import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.json.bind.JsonbConfig;
import javax.json.bind.annotation.JsonbTransient;
import javax.json.spi.JsonProvider;
import org.talend.sdk.component.api.record.OrderedMap;
import org.talend.sdk.component.api.record.Record;
import org.talend.sdk.component.api.record.Schema;
import org.talend.sdk.component.runtime.record.RecordBuilderFactoryImpl;
import org.talend.sdk.component.runtime.record.RecordConverters;
import org.talend.sdk.component.runtime.record.SchemaImpl;

public final class RecordImpl
implements Record {
    private static final RecordConverters RECORD_CONVERTERS = new RecordConverters();
    private final Map<String, Object> values;
    @JsonbTransient
    private final Schema schema;

    private RecordImpl(Map<String, Object> values, Schema schema) {
        this.values = values;
        this.schema = schema;
    }

    public <T> T get(Class<T> expectedType, String name) {
        Object value = this.values.get(name);
        if (value == null || expectedType.isInstance(value)) {
            return expectedType.cast(value);
        }
        return RECORD_CONVERTERS.coerce(expectedType, value, name);
    }

    public String toString() {
        String string;
        block8: {
            Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withFormatting(Boolean.valueOf(true)).withPropertyOrderStrategy("LEXICOGRAPHICAL").setProperty("johnzon.cdi.activated", (Object)false));
            try {
                string = new RecordConverters().toType(new RecordConverters.MappingMetaRegistry(), this, JsonObject.class, () -> Json.createBuilderFactory(Collections.emptyMap()), JsonProvider::provider, () -> jsonb, () -> new RecordBuilderFactoryImpl("tostring")).toString();
                if (jsonb == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jsonb != null) {
                        try {
                            jsonb.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return super.toString();
                }
            }
            jsonb.close();
        }
        return string;
    }

    public Record.Builder withNewSchema(Schema newSchema) {
        BuilderImpl builder = new BuilderImpl(newSchema);
        newSchema.getAllEntries().filter(e -> Objects.equals(this.schema.getEntry(e.getName()), e)).forEach(e -> builder.with((Schema.Entry)e, this.values.get(e.getName())));
        return builder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RecordImpl)) {
            return false;
        }
        RecordImpl other = (RecordImpl)o;
        Map<String, Object> this$values = this.values;
        Map<String, Object> other$values = other.values;
        if (this$values == null ? other$values != null : !((Object)this$values).equals(other$values)) {
            return false;
        }
        Schema this$schema = this.getSchema();
        Schema other$schema = other.getSchema();
        return !(this$schema == null ? other$schema != null : !this$schema.equals(other$schema));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Object> $values = this.values;
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        Schema $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        return result;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public static class BuilderImpl
    implements Record.Builder {
        private final Map<String, Object> values = new HashMap<String, Object>(8);
        private final OrderedMap<Schema.Entry> entries;
        private final Schema providedSchema;
        private final OrderState orderState;

        public BuilderImpl() {
            this(null);
        }

        public BuilderImpl(Schema providedSchema) {
            this.providedSchema = providedSchema;
            if (this.providedSchema == null) {
                this.entries = new OrderedMap(Schema.Entry::getName, Collections.emptyList());
                this.orderState = new OrderState(Collections.emptyList());
            } else {
                this.entries = null;
                List<Schema.Entry> fields = providedSchema.naturalOrder().getFieldsOrder().map(arg_0 -> ((Schema)providedSchema).getEntry(arg_0)).collect(Collectors.toList());
                this.orderState = new OrderState(fields);
            }
        }

        private BuilderImpl(List<Schema.Entry> entries, Map<String, Object> values) {
            this.providedSchema = null;
            this.entries = new OrderedMap(Schema.Entry::getName, entries);
            this.values.putAll(values);
            this.orderState = null;
        }

        public Object getValue(String name) {
            return this.values.get(name);
        }

        public Record.Builder with(Schema.Entry entry, Object value) {
            this.validateTypeAgainstProvidedSchema(entry.getName(), entry.getType(), value);
            if (!entry.getType().isCompatible(value)) {
                throw new IllegalArgumentException(String.format("Entry '%s' of type %s is not compatible with value of type '%s'", entry.getName(), entry.getType(), value.getClass().getName()));
            }
            if (entry.getType() == Schema.Type.DATETIME) {
                if (value == null) {
                    return this;
                }
                if (value instanceof Long) {
                    this.withTimestamp(entry, (long)((Long)value));
                } else if (value instanceof Date) {
                    this.withDateTime(entry, (Date)value);
                } else if (value instanceof ZonedDateTime) {
                    this.withDateTime(entry, (ZonedDateTime)value);
                } else if (value instanceof Temporal) {
                    this.withTimestamp(entry, (long)((Temporal)value).get(ChronoField.INSTANT_SECONDS) * 1000L);
                }
                return this;
            }
            return this.append(entry, value);
        }

        public Schema.Entry getEntry(String name) {
            if (this.providedSchema != null) {
                return this.providedSchema.getEntry(name);
            }
            return (Schema.Entry)this.entries.getValue(name);
        }

        public List<Schema.Entry> getCurrentEntries() {
            if (this.providedSchema != null) {
                return Collections.unmodifiableList(this.providedSchema.getAllEntries().collect(Collectors.toList()));
            }
            return this.entries.streams().collect(Collectors.toList());
        }

        public Record.Builder removeEntry(Schema.Entry schemaEntry) {
            if (this.providedSchema == null) {
                this.entries.removeValue((Object)schemaEntry);
                this.values.remove(schemaEntry.getName());
                return this;
            }
            BuilderImpl builder = new BuilderImpl(this.providedSchema.getAllEntries().collect(Collectors.toList()), this.values);
            return builder.removeEntry(schemaEntry);
        }

        public Record.Builder updateEntryByName(String name, Schema.Entry schemaEntry) {
            if (this.providedSchema == null) {
                if (this.entries.getValue(name) == null) {
                    throw new IllegalArgumentException("No entry '" + schemaEntry.getName() + "' expected in entries");
                }
                Object value = this.values.get(name);
                if (!schemaEntry.getType().isCompatible(value)) {
                    throw new IllegalArgumentException(String.format("Entry '%s' of type %s is not compatible with value of type '%s'", schemaEntry.getName(), schemaEntry.getType(), value.getClass().getName()));
                }
                this.entries.replace(name, (Object)schemaEntry);
                this.values.remove(name);
                this.values.put(schemaEntry.getName(), value);
                return this;
            }
            BuilderImpl builder = new BuilderImpl(this.providedSchema.getAllEntries().collect(Collectors.toList()), this.values);
            return builder.updateEntryByName(name, schemaEntry);
        }

        public Record.Builder updateEntryByName(String name, Schema.Entry schemaEntry, Function<Object, Object> valueCastFunction) {
            Object currentValue = this.values.get(name);
            this.values.put(name, valueCastFunction.apply(currentValue));
            return this.updateEntryByName(name, schemaEntry);
        }

        public Record.Builder before(String entryName) {
            this.orderState.before(entryName);
            return this;
        }

        public Record.Builder after(String entryName) {
            this.orderState.after(entryName);
            return this;
        }

        private Schema.Entry findExistingEntry(String name) {
            Schema.Entry entry = this.providedSchema != null ? this.providedSchema.getEntry(name) : (Schema.Entry)this.entries.getValue(name);
            if (entry == null) {
                throw new IllegalArgumentException("No entry '" + name + "' expected in provided schema");
            }
            return entry;
        }

        private Schema.Entry findOrBuildEntry(String name, Schema.Type type, boolean nullable) {
            if (this.providedSchema == null) {
                return new SchemaImpl.EntryImpl.BuilderImpl().withName(name).withType(type).withNullable(nullable).build();
            }
            return this.findExistingEntry(name);
        }

        private Schema.Entry validateTypeAgainstProvidedSchema(String name, Schema.Type type, Object value) {
            if (this.providedSchema == null) {
                return null;
            }
            Schema.Entry entry = this.findExistingEntry(name);
            if (entry.getType() != type) {
                throw new IllegalArgumentException("Entry '" + name + "' expected to be a " + entry.getType() + ", got a " + type);
            }
            if (value == null && !entry.isNullable()) {
                throw new IllegalArgumentException("Entry '" + name + "' is not nullable");
            }
            return entry;
        }

        public Record build() {
            Schema currentSchema;
            if (this.providedSchema != null) {
                String missing = this.providedSchema.getAllEntries().filter(it -> !it.isNullable() && !this.values.containsKey(it.getName())).map(Schema.Entry::getName).collect(Collectors.joining(", "));
                if (!missing.isEmpty()) {
                    throw new IllegalArgumentException("Missing entries: " + missing);
                }
                currentSchema = this.orderState.isOverride() ? this.providedSchema.toBuilder().build(this.orderState.buildComparator()) : this.providedSchema;
            } else {
                Schema.Builder builder = new SchemaImpl.BuilderImpl().withType(Schema.Type.RECORD);
                this.entries.forEachValue(arg_0 -> ((Schema.Builder)builder).withEntry(arg_0));
                currentSchema = builder.build(this.orderState.buildComparator());
            }
            return new RecordImpl(Collections.unmodifiableMap(this.values), currentSchema);
        }

        public Record.Builder withString(String name, String value) {
            Schema.Entry entry = this.findOrBuildEntry(name, Schema.Type.STRING, true);
            return this.withString(entry, value);
        }

        public Record.Builder withString(Schema.Entry entry, String value) {
            this.assertType(entry.getType(), Schema.Type.STRING);
            this.validateTypeAgainstProvidedSchema(entry.getName(), Schema.Type.STRING, value);
            return this.append(entry, value);
        }

        public Record.Builder withBytes(String name, byte[] value) {
            Schema.Entry entry = this.findOrBuildEntry(name, Schema.Type.BYTES, true);
            return this.withBytes(entry, value);
        }

        public Record.Builder withBytes(Schema.Entry entry, byte[] value) {
            this.assertType(entry.getType(), Schema.Type.BYTES);
            this.validateTypeAgainstProvidedSchema(entry.getName(), Schema.Type.BYTES, value);
            return this.append(entry, value);
        }

        public Record.Builder withDateTime(String name, Date value) {
            Schema.Entry entry = this.findOrBuildEntry(name, Schema.Type.DATETIME, true);
            return this.withDateTime(entry, value);
        }

        public Record.Builder withDateTime(Schema.Entry entry, Date value) {
            if (value == null && !entry.isNullable()) {
                throw new IllegalArgumentException("date '" + entry.getName() + "' is not allowed to be null");
            }
            this.validateTypeAgainstProvidedSchema(entry.getName(), Schema.Type.DATETIME, value);
            return this.append(entry, value == null ? null : Long.valueOf(value.getTime()));
        }

        public Record.Builder withDateTime(String name, ZonedDateTime value) {
            Schema.Entry entry = this.findOrBuildEntry(name, Schema.Type.DATETIME, true);
            return this.withDateTime(entry, value);
        }

        public Record.Builder withDateTime(Schema.Entry entry, ZonedDateTime value) {
            if (value == null && !entry.isNullable()) {
                throw new IllegalArgumentException("datetime '" + entry.getName() + "' is not allowed to be null");
            }
            this.validateTypeAgainstProvidedSchema(entry.getName(), Schema.Type.DATETIME, value);
            return this.append(entry, value == null ? null : Long.valueOf(value.toInstant().toEpochMilli()));
        }

        public Record.Builder withDecimal(String name, BigDecimal value) {
            Schema.Entry entry = this.findOrBuildEntry(name, Schema.Type.DECIMAL, true);
            return this.withDecimal(entry, value);
        }

        public Record.Builder withDecimal(Schema.Entry entry, BigDecimal value) {
            this.assertType(entry.getType(), Schema.Type.DECIMAL);
            this.validateTypeAgainstProvidedSchema(entry.getName(), Schema.Type.DECIMAL, value);
            return this.append(entry, value);
        }

        public Record.Builder withTimestamp(String name, long value) {
            Schema.Entry entry = this.findOrBuildEntry(name, Schema.Type.DATETIME, false);
            return this.withTimestamp(entry, value);
        }

        public Record.Builder withTimestamp(Schema.Entry entry, long value) {
            this.assertType(entry.getType(), Schema.Type.DATETIME);
            this.validateTypeAgainstProvidedSchema(entry.getName(), Schema.Type.DATETIME, value);
            return this.append(entry, value);
        }

        public Record.Builder withInt(String name, int value) {
            Schema.Entry entry = this.findOrBuildEntry(name, Schema.Type.INT, false);
            return this.withInt(entry, value);
        }

        public Record.Builder withInt(Schema.Entry entry, int value) {
            this.assertType(entry.getType(), Schema.Type.INT);
            this.validateTypeAgainstProvidedSchema(entry.getName(), Schema.Type.INT, value);
            return this.append(entry, value);
        }

        public Record.Builder withLong(String name, long value) {
            Schema.Entry entry = this.findOrBuildEntry(name, Schema.Type.LONG, false);
            return this.withLong(entry, value);
        }

        public Record.Builder withLong(Schema.Entry entry, long value) {
            this.assertType(entry.getType(), Schema.Type.LONG);
            this.validateTypeAgainstProvidedSchema(entry.getName(), Schema.Type.LONG, value);
            return this.append(entry, value);
        }

        public Record.Builder withFloat(String name, float value) {
            Schema.Entry entry = this.findOrBuildEntry(name, Schema.Type.FLOAT, false);
            return this.withFloat(entry, value);
        }

        public Record.Builder withFloat(Schema.Entry entry, float value) {
            this.assertType(entry.getType(), Schema.Type.FLOAT);
            this.validateTypeAgainstProvidedSchema(entry.getName(), Schema.Type.FLOAT, Float.valueOf(value));
            return this.append(entry, Float.valueOf(value));
        }

        public Record.Builder withDouble(String name, double value) {
            Schema.Entry entry = this.findOrBuildEntry(name, Schema.Type.DOUBLE, false);
            return this.withDouble(entry, value);
        }

        public Record.Builder withDouble(Schema.Entry entry, double value) {
            this.assertType(entry.getType(), Schema.Type.DOUBLE);
            this.validateTypeAgainstProvidedSchema(entry.getName(), Schema.Type.DOUBLE, value);
            return this.append(entry, value);
        }

        public Record.Builder withBoolean(String name, boolean value) {
            Schema.Entry entry = this.findOrBuildEntry(name, Schema.Type.BOOLEAN, false);
            return this.withBoolean(entry, value);
        }

        public Record.Builder withBoolean(Schema.Entry entry, boolean value) {
            this.assertType(entry.getType(), Schema.Type.BOOLEAN);
            this.validateTypeAgainstProvidedSchema(entry.getName(), Schema.Type.BOOLEAN, value);
            return this.append(entry, value);
        }

        public Record.Builder withRecord(Schema.Entry entry, Record value) {
            this.assertType(entry.getType(), Schema.Type.RECORD);
            if (entry.getElementSchema() == null) {
                throw new IllegalArgumentException("No schema for the nested record");
            }
            this.validateTypeAgainstProvidedSchema(entry.getName(), Schema.Type.RECORD, value);
            return this.append(entry, value);
        }

        public Record.Builder withRecord(String name, Record value) {
            if (value == null) {
                throw new IllegalArgumentException("No schema for the nested record due to null record value");
            }
            return this.withRecord(new SchemaImpl.EntryImpl.BuilderImpl().withName(name).withElementSchema(value.getSchema()).withType(Schema.Type.RECORD).withNullable(true).build(), value);
        }

        public <T> Record.Builder withArray(Schema.Entry entry, Collection<T> values) {
            this.assertType(entry.getType(), Schema.Type.ARRAY);
            if (entry.getElementSchema() == null) {
                throw new IllegalArgumentException("No schema for the collection items");
            }
            this.validateTypeAgainstProvidedSchema(entry.getName(), Schema.Type.ARRAY, values);
            return this.append(entry, values);
        }

        private void assertType(Schema.Type actual, Schema.Type expected) {
            if (actual != expected) {
                throw new IllegalArgumentException("Expected entry type: " + expected + ", got: " + actual);
            }
        }

        private <T> Record.Builder append(Schema.Entry entry, T value) {
            Schema.Entry realEntry = this.entries != null ? Optional.ofNullable(Schema.avoidCollision((Schema.Entry)entry, arg_0 -> this.entries.getValue(arg_0), (arg_0, arg_1) -> this.entries.replace(arg_0, arg_1))).orElse(entry) : entry;
            if (value != null) {
                this.values.put(realEntry.getName(), value);
            } else if (!realEntry.isNullable()) {
                throw new IllegalArgumentException(realEntry.getName() + " is not nullable but got a null value");
            }
            if (this.entries != null) {
                this.entries.addValue((Object)realEntry);
            }
            this.orderState.update(realEntry);
            return this;
        }

        static class OrderState {
            private Order state = Order.LAST;
            private String target = "";
            private boolean override = false;
            private final OrderedMap<Schema.Entry> orderedEntries;

            public OrderState(Iterable<Schema.Entry> orderedEntries) {
                this.orderedEntries = new OrderedMap(Schema.Entry::getName, orderedEntries);
            }

            public void before(String entryName) {
                this.setState(Order.BEFORE, entryName);
            }

            public void after(String entryName) {
                this.setState(Order.AFTER, entryName);
            }

            private void setState(Order order, String target) {
                this.state = order;
                this.target = target;
                this.override = true;
            }

            private void resetState() {
                this.target = "";
                this.state = Order.LAST;
            }

            public void update(Schema.Entry entry) {
                Schema.Entry existingEntry = (Schema.Entry)this.orderedEntries.getValue(entry.getName());
                if (this.state == Order.LAST) {
                    if (existingEntry == null) {
                        this.orderedEntries.addValue((Object)entry);
                    }
                } else {
                    Schema.Entry targetIndex = (Schema.Entry)this.orderedEntries.getValue(this.target);
                    if (targetIndex == null) {
                        throw new IllegalArgumentException(String.format("'%s' not in schema.", this.target));
                    }
                    if (existingEntry == null) {
                        this.orderedEntries.addValue((Object)entry);
                    }
                    if (this.state == Order.BEFORE) {
                        this.orderedEntries.moveBefore(this.target, (Object)entry);
                    } else {
                        this.orderedEntries.moveAfter(this.target, (Object)entry);
                    }
                }
                this.resetState();
            }

            public Comparator<Schema.Entry> buildComparator() {
                List orderedFields = this.orderedEntries.streams().map(Schema.Entry::getName).collect(Collectors.toList());
                return Schema.EntriesOrder.of(orderedFields);
            }

            public boolean isOverride() {
                return this.override;
            }
        }

        private static enum Order {
            BEFORE,
            AFTER,
            LAST;

        }
    }
}

