/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.serialization;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Optional;
import org.talend.sdk.component.api.service.serialization.Serial;
import org.talend.sdk.component.runtime.serialization.ContainerFinder;
import org.talend.sdk.component.runtime.serialization.LightContainer;

public class SerializableService
implements Serializable,
Serial {
    private final String plugin;
    private final String type;

    public Object readResolve() throws ObjectStreamException {
        ContainerFinder containerFinder = ContainerFinder.Instance.get();
        LightContainer container = containerFinder.find(this.plugin);
        try {
            return Optional.ofNullable(container.findService(container.classloader().loadClass(this.type))).orElseThrow(() -> new IllegalStateException("Didn't find service " + this.type + ", ensure a ContainerFinder is setup (current=" + containerFinder + ") and " + this.type + " is registered as a @Service in " + this.plugin));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(this.type + " not found");
        }
    }

    public SerializableService(String plugin, String type) {
        this.plugin = plugin;
        this.type = type;
    }
}

