/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.reflect;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Defaults {
    private static final Logger log = LoggerFactory.getLogger(Defaults.class);
    private static final Handler HANDLER;

    public static boolean isDefaultAndShouldHandle(Method method) {
        return method.isDefault();
    }

    public static Object handleDefault(Class<?> declaringClass, Method method, Object proxy, Object[] args) throws Throwable {
        return HANDLER.handle(declaringClass, method, proxy, args);
    }

    private static Method findPrivateLookup() {
        try {
            return MethodHandles.class.getMethod("privateLookupIn", Class.class, MethodHandles.Lookup.class);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static Constructor<MethodHandles.Lookup> findLookupConstructor(Boolean isJava8) {
        try {
            Constructor<MethodHandles.Lookup> constructor = isJava8 != false ? MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE) : MethodHandles.Lookup.class.getDeclaredConstructor(Class.class);
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            return constructor;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private Defaults() {
    }

    static {
        String[] versionElements = System.getProperty("java.version").split("\\.");
        int unsureVersion = Integer.parseInt(versionElements[0]);
        int javaVersion = unsureVersion == 1 ? Integer.parseInt(versionElements[1]) : unsureVersion;
        Boolean isJava8 = javaVersion == 8;
        if (javaVersion > 8 && javaVersion < 17) {
            try {
                Class<?> unsafeClazz = Class.forName("sun.misc.Unsafe");
                Field field = unsafeClazz.getDeclaredField("theUnsafe");
                field.setAccessible(true);
                Object unsafe = field.get(null);
                Method putObjectVolatile = unsafeClazz.getDeclaredMethod("putObjectVolatile", Object.class, Long.TYPE, Object.class);
                Method staticFieldOffset = unsafeClazz.getDeclaredMethod("staticFieldOffset", Field.class);
                Class<?> loggerClass = Class.forName("jdk.internal.module.IllegalAccessLogger");
                Field loggerField = loggerClass.getDeclaredField("logger");
                Long offset = (Long)staticFieldOffset.invoke(unsafe, loggerField);
                putObjectVolatile.invoke(unsafe, loggerClass, offset, null);
            }
            catch (Exception e) {
                System.err.println("Disabling unsafe warnings failed: " + e.getMessage());
            }
        }
        Constructor<MethodHandles.Lookup> constructor = Defaults.findLookupConstructor(isJava8);
        if (isJava8.booleanValue()) {
            HANDLER = (clazz, method, proxy, args) -> ((MethodHandles.Lookup)constructor.newInstance(clazz, 2)).unreflectSpecial(method, clazz).bindTo(proxy).invokeWithArguments(args);
        } else {
            Method privateLookup = Defaults.findPrivateLookup();
            HANDLER = (clazz, method, proxy, args) -> ((MethodHandles.Lookup)MethodHandles.Lookup.class.cast(privateLookup.invoke(null, clazz, constructor.newInstance(clazz)))).unreflectSpecial(method, clazz).bindTo(proxy).invokeWithArguments(args);
        }
    }

    private static interface Handler {
        public Object handle(Class<?> var1, Method var2, Object var3, Object[] var4) throws Throwable;
    }
}

