/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.internationalization;

import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.stream.Stream;
import org.talend.sdk.component.runtime.internationalization.InternalBundle;

public class ParameterBundle
extends InternalBundle {
    private final String[] simpleNames;

    public ParameterBundle(ResourceBundle[] bundles, String prefix, String ... simpleNames) {
        super(bundles, prefix);
        this.simpleNames = simpleNames;
    }

    public Optional<String> documentation(ParameterBundle parent) {
        return this.get(parent, "_documentation", false);
    }

    public Optional<String> displayName(ParameterBundle parent) {
        return this.get(parent, "_displayName", false);
    }

    public Optional<String> enumDisplayName(ParameterBundle parent, String enumName) {
        return this.get(parent, enumName + "._displayName", true);
    }

    public Optional<String> placeholder(ParameterBundle parent) {
        return this.get(parent, "_placeholder", false);
    }

    public Optional<String> gridLayoutName(ParameterBundle parent, String tabName) {
        return this.get(parent, "_gridlayout." + tabName + "._displayName", false);
    }

    private Optional<String> get(ParameterBundle parentBundle, String suffix, boolean stripLastSegment) {
        Optional<String> v = this.readValue(suffix);
        if (!v.isPresent()) {
            v = Stream.of(this.simpleNames).map(s -> !stripLastSegment || s.lastIndexOf(46) < 0 ? s : s.substring(0, s.lastIndexOf(46))).map(s -> {
                String k = s + "." + suffix;
                return this.readRawValue(k).orElse(parentBundle == null ? null : (String)parentBundle.readRawValue(k).orElse(null));
            }).filter(Objects::nonNull).findFirst();
        }
        return v;
    }
}

