/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.input;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.function.Consumer;
import javax.json.bind.Jsonb;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.api.component.Version;
import org.talend.sdk.component.api.input.Producer;
import org.talend.sdk.component.api.input.checkpoint.CheckpointAvailable;
import org.talend.sdk.component.api.input.checkpoint.CheckpointData;
import org.talend.sdk.component.api.service.record.RecordBuilderFactory;
import org.talend.sdk.component.runtime.base.Delegated;
import org.talend.sdk.component.runtime.base.LifecycleImpl;
import org.talend.sdk.component.runtime.input.CheckpointState;
import org.talend.sdk.component.runtime.input.Input;
import org.talend.sdk.component.runtime.record.RecordConverters;
import org.talend.sdk.component.runtime.serialization.ContainerFinder;
import org.talend.sdk.component.runtime.serialization.EnhancedObjectInputStream;
import org.talend.sdk.component.runtime.serialization.LightContainer;

public class InputImpl
extends LifecycleImpl
implements Input,
Delegated {
    private static final Logger log = LoggerFactory.getLogger(InputImpl.class);
    private transient Method next;
    private transient RecordConverters converters;
    private transient RecordConverters.MappingMetaRegistry registry;
    private transient Jsonb jsonb;
    private transient RecordBuilderFactory recordBuilderFactory;
    private transient Method checkpoint;
    private transient Method shouldCheckpoint;
    private transient Consumer<CheckpointState> checkpointCallback;
    private boolean checkpointEnabled = Boolean.parseBoolean(System.getProperty("talend.checkpoint.enabled", "false"));

    public InputImpl(String rootName, String name, String plugin, Serializable instance) {
        super(instance, rootName, name, plugin);
    }

    protected InputImpl() {
    }

    @Override
    public void start() {
        super.start();
        this.initCheckpointFunctions();
    }

    @Override
    public void start(Consumer<CheckpointState> checkpointCallback) {
        this.start();
        if (this.checkpointEnabled) {
            this.checkpointCallback = checkpointCallback;
        }
    }

    protected void initCheckpointFunctions() {
        if (this.checkpointEnabled) {
            this.checkpoint = this.findMethods(CheckpointData.class).findFirst().orElse(null);
            this.shouldCheckpoint = this.findMethods(CheckpointAvailable.class).findFirst().orElse(null);
        }
    }

    @Override
    public Object next() {
        Class<?> recordClass;
        Object data;
        if (this.next == null) {
            this.init();
        }
        if ((data = this.readNext()) == null) {
            return null;
        }
        if (this.isCheckpointReady() && this.checkpointCallback != null) {
            this.checkpointCallback.accept(this.getCheckpoint());
        }
        if ((recordClass = data.getClass()).isPrimitive() || String.class == recordClass) {
            return data;
        }
        return this.converters.toRecord(this.registry, data, this::jsonb, this::recordBuilderFactory);
    }

    @Override
    public CheckpointState getCheckpoint() {
        if (this.checkpoint != null) {
            Object state = this.doInvoke(this.checkpoint, new Object[0]);
            int version = 1;
            if (Optional.ofNullable(state.getClass().getAnnotation(Version.class)).isPresent()) {
                version = state.getClass().getAnnotation(Version.class).value();
            }
            return new CheckpointState(version, state);
        }
        return null;
    }

    @Override
    public boolean isCheckpointReady() {
        boolean checked = this.checkpointEnabled;
        if (this.shouldCheckpoint != null) {
            checked = (Boolean)this.doInvoke(this.shouldCheckpoint, new Object[0]);
        }
        return checked;
    }

    @Override
    public void stop() {
        if (this.checkpointCallback != null) {
            this.checkpointCallback.accept(this.getCheckpoint());
        }
        super.stop();
    }

    @Override
    public Object getDelegate() {
        return this.delegate;
    }

    protected Object readNext() {
        return this.doInvoke(this.next, new Object[0]);
    }

    protected void init() {
        this.next = this.findMethods(Producer.class).findFirst().get();
        this.converters = new RecordConverters();
        this.registry = new RecordConverters.MappingMetaRegistry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Jsonb jsonb() {
        if (this.jsonb != null) {
            return this.jsonb;
        }
        InputImpl inputImpl = this;
        synchronized (inputImpl) {
            if (this.jsonb == null) {
                LightContainer container = ContainerFinder.Instance.get().find(this.plugin());
                this.jsonb = container.findService(Jsonb.class);
            }
        }
        return this.jsonb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RecordBuilderFactory recordBuilderFactory() {
        if (this.recordBuilderFactory != null) {
            return this.recordBuilderFactory;
        }
        InputImpl inputImpl = this;
        synchronized (inputImpl) {
            if (this.recordBuilderFactory == null) {
                LightContainer container = ContainerFinder.Instance.get().find(this.plugin());
                this.recordBuilderFactory = container.findService(RecordBuilderFactory.class);
            }
        }
        return this.recordBuilderFactory;
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new SerializationReplacer(this.plugin(), this.rootName(), this.name(), this.serializeDelegate());
    }

    protected static class SerializationReplacer
    implements Serializable {
        protected String plugin;
        protected String component;
        protected String name;
        protected byte[] value;

        protected Object readResolve() throws ObjectStreamException {
            try {
                return new InputImpl(this.component, this.name, this.plugin, this.loadDelegate());
            }
            catch (IOException | ClassNotFoundException e) {
                InvalidObjectException invalidObjectException = new InvalidObjectException(e.getMessage());
                invalidObjectException.initCause(e);
                throw invalidObjectException;
            }
        }

        protected Serializable loadDelegate() throws IOException, ClassNotFoundException {
            try (EnhancedObjectInputStream ois = new EnhancedObjectInputStream(new ByteArrayInputStream(this.value), ContainerFinder.Instance.get().find(this.plugin).classloader());){
                Serializable serializable = (Serializable)Serializable.class.cast(ois.readObject());
                return serializable;
            }
        }

        public SerializationReplacer(String plugin, String component, String name, byte[] value) {
            this.plugin = plugin;
            this.component = component;
            this.name = name;
            this.value = value;
        }
    }
}

