/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.junit.environment;

import java.lang.annotation.Annotation;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Optional;
import java.util.stream.Stream;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependency;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.junit.environment.BaseEnvironmentProvider;
import org.talend.sdk.component.junit.environment.Dependencies;

public abstract class ClassLoaderEnvironment
extends BaseEnvironmentProvider {
    private static final Logger log = LoggerFactory.getLogger(ClassLoaderEnvironment.class);

    protected abstract MavenDependency[] rootDependencies();

    @Override
    protected AutoCloseable doStart(Class<?> clazz, Annotation[] annotations) {
        try {
            Optional.ofNullable(Thread.currentThread().getContextClassLoader()).orElseGet(ClassLoader::getSystemClassLoader).loadClass("org.jboss.shrinkwrap.resolver.api.maven.Maven");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Don't forget to add to your dependencies:\n  org.jboss.shrinkwrap.resolver:shrinkwrap-resolver-impl-maven:3.0.1");
        }
        Thread thread = Thread.currentThread();
        URLClassLoader classLoader = new URLClassLoader((URL[])Stream.of(this.rootDependencies()).peek(dep -> log.info("Resolving " + dep + "...")).flatMap(dep -> Stream.of(Dependencies.resolve(dep))).toArray(URL[]::new), Thread.currentThread().getContextClassLoader());
        ClassLoader original = thread.getContextClassLoader();
        thread.setContextClassLoader(classLoader);
        return () -> {
            thread.setContextClassLoader(original);
            classLoader.close();
        };
    }
}

