/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.junit.environment.builtin.beam;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.jboss.shrinkwrap.resolver.api.maven.ScopeType;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependencies;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependency;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependencyExclusion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.junit.environment.ClassLoaderEnvironment;

public abstract class BeamEnvironment
extends ClassLoaderEnvironment {
    private static final Logger log = LoggerFactory.getLogger(BeamEnvironment.class);
    private boolean skipBeamSdk;
    private String beamVersion;

    @Override
    protected AutoCloseable doStart(Class<?> clazz, Annotation[] annotations) {
        this.beamVersion = System.getProperty("talend.junit.beam.version", "2.4.0");
        try {
            BeamEnvironment.class.getClassLoader().loadClass("org.talend.sdk.component.runtime.beam.TalendIO");
            this.skipBeamSdk = true;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            this.skipBeamSdk = false;
        }
        this.resetBeamCache();
        AutoCloseable delegate = super.doStart(clazz, annotations);
        return () -> {
            try {
                delegate.close();
            }
            finally {
                this.resetBeamCache();
            }
        };
    }

    private void resetBeamCache() {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> pof = loader.loadClass("org.apache.beam.sdk.options.PipelineOptionsFactory");
            Stream.of("COMBINED_CACHE", "INTERFACE_CACHE", "SUPPORTED_PIPELINE_RUNNERS").forEach(mapField -> {
                try {
                    Field field = pof.getDeclaredField((String)mapField);
                    field.setAccessible(true);
                    Optional.ofNullable(Map.class.cast(field.get(null))).ifPresent(Map::clear);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            Method initializeRegistry = pof.getDeclaredMethod("resetRegistry", new Class[0]);
            initializeRegistry.setAccessible(true);
            initializeRegistry.invoke(null, new Object[0]);
        }
        catch (Exception | NoClassDefFoundError ex) {
            log.warn(ex.getMessage());
        }
    }

    @Override
    protected MavenDependency[] rootDependencies() {
        MavenDependencyExclusion[] mavenDependencyExclusionArray;
        MavenDependency[] mavenDependencyArray = new MavenDependency[1];
        String string = this.rootDependencyBase() + ":jar:" + this.beamVersion;
        if (this.skipBeamSdk) {
            MavenDependencyExclusion[] mavenDependencyExclusionArray2 = new MavenDependencyExclusion[1];
            mavenDependencyExclusionArray = mavenDependencyExclusionArray2;
            mavenDependencyExclusionArray2[0] = MavenDependencies.createExclusion((String)"org.apache.beam", (String)"beam-sdks-java-core");
        } else {
            mavenDependencyExclusionArray = new MavenDependencyExclusion[]{};
        }
        mavenDependencyArray[0] = MavenDependencies.createDependency((String)string, (ScopeType)ScopeType.RUNTIME, (boolean)false, (MavenDependencyExclusion[])mavenDependencyExclusionArray);
        return mavenDependencyArray;
    }

    @Override
    public String getName() {
        return super.getName().replace("Runner", "");
    }

    protected abstract String rootDependencyBase();
}

