/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import lombok.Generated;
import org.talend.sdk.component.maven.Server;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

public class MavenDecrypter {
    private static final String M2_HOME = "M2_HOME";
    private static final String MAVEN_HOME = "MAVEN_HOME";
    private static final String USER_HOME = "user.home";
    private static final String FILE_SETTINGS = "settings.xml";
    private static final String FILE_SECURITY = "settings-security.xml";
    private final List<File> settings;
    private final File settingsSecurity;

    public MavenDecrypter() {
        this(MavenDecrypter.findSettingsFiles(), new File(MavenDecrypter.getM2(), FILE_SECURITY));
    }

    @Deprecated
    public MavenDecrypter(File settings, File settingsSecurity) {
        this(Collections.singletonList(settings), settingsSecurity);
    }

    public MavenDecrypter(List<File> settings, File settingsSecurity) {
        this.settings = settings.stream().filter(File::exists).collect(Collectors.toList());
        this.settingsSecurity = settingsSecurity;
    }

    public Server find(String serverId) {
        String master;
        DefaultHandler extractor;
        SAXParser parser = MavenDecrypter.newSaxParser();
        if (this.settings.isEmpty()) {
            throw new IllegalArgumentException("No " + this.settings + " found, ensure your credentials configuration is valid");
        }
        if (this.settingsSecurity.isFile()) {
            extractor = new MvnMasterExtractor();
            try (FileInputStream is = new FileInputStream(this.settingsSecurity);){
                parser.parse((InputStream)is, extractor);
            }
            catch (IOException | SAXException e) {
                throw new IllegalArgumentException(e);
            }
            master = ((MvnMasterExtractor)extractor).current == null ? null : ((MvnMasterExtractor)extractor).current.toString().trim();
        } else {
            master = null;
        }
        extractor = new MvnServerExtractor(master, serverId);
        for (File file : this.settings) {
            try (FileInputStream is = new FileInputStream(file);){
                parser.parse((InputStream)is, extractor);
            }
            catch (IOException | SAXException e) {
                throw new IllegalArgumentException(e);
            }
            if (((MvnServerExtractor)extractor).server == null) continue;
            return ((MvnServerExtractor)extractor).server;
        }
        throw new IllegalArgumentException("Didn't find " + serverId + " in " + this.settings);
    }

    private static SAXParser newSaxParser() {
        SAXParser parser;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(false);
        factory.setValidating(false);
        try {
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        }
        catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException exception) {
            // empty catch block
        }
        try {
            parser = factory.newSAXParser();
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IllegalStateException(e);
        }
        try {
            parser.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            parser.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
            // empty catch block
        }
        return parser;
    }

    private static File getM2() {
        return Optional.ofNullable(System.getProperty("talend.maven.decrypter.m2.location")).map(File::new).orElseGet(() -> new File(System.getProperty(USER_HOME), ".m2"));
    }

    private static List<File> findSettingsFiles() {
        return Stream.of(new File(MavenDecrypter.getM2(), FILE_SETTINGS), MavenDecrypter.findMavenHome(M2_HOME), MavenDecrypter.findMavenHome(MAVEN_HOME)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static File findMavenHome(String mavenHome) {
        return Optional.ofNullable(System.getenv(mavenHome)).map(File::new).map(it -> new File((File)it, "conf/settings.xml")).orElse(null);
    }

    public static void main(String[] args) {
        System.out.println(new MavenDecrypter().find(args[0]));
    }

    @Generated
    public String toString() {
        return "MavenDecrypter(settings=" + this.settings + ", settingsSecurity=" + this.settingsSecurity + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MavenDecrypter)) {
            return false;
        }
        MavenDecrypter other = (MavenDecrypter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<File> this$settings = this.settings;
        List<File> other$settings = other.settings;
        if (this$settings == null ? other$settings != null : !((Object)this$settings).equals(other$settings)) {
            return false;
        }
        File this$settingsSecurity = this.settingsSecurity;
        File other$settingsSecurity = other.settingsSecurity;
        return !(this$settingsSecurity == null ? other$settingsSecurity != null : !((Object)this$settingsSecurity).equals(other$settingsSecurity));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MavenDecrypter;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<File> $settings = this.settings;
        result = result * 59 + ($settings == null ? 43 : ((Object)$settings).hashCode());
        File $settingsSecurity = this.settingsSecurity;
        result = result * 59 + ($settingsSecurity == null ? 43 : ((Object)$settingsSecurity).hashCode());
        return result;
    }

    private static class MvnMasterExtractor
    extends DefaultHandler {
        private StringBuilder current;

        private MvnMasterExtractor() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if ("master".equalsIgnoreCase(qName)) {
                this.current = new StringBuilder();
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this.current != null) {
                this.current.append(new String(ch, start, length));
            }
        }
    }

    private static class MvnServerExtractor
    extends DefaultHandler {
        private static final Pattern ENCRYPTED_PATTERN = Pattern.compile(".*?[^\\\\]?\\{(.*?[^\\\\])\\}.*");
        private final String passphrase;
        private final String serverId;
        private Server server;
        private String encryptedPassword;
        private boolean done;
        private StringBuilder current;

        private MvnServerExtractor(String passphrase, String serverId) {
            this.passphrase = this.doDecrypt(passphrase, "settings.security");
            this.serverId = serverId;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if ("server".equalsIgnoreCase(qName)) {
                if (!this.done) {
                    this.server = new Server();
                }
            } else if (this.server != null) {
                this.current = new StringBuilder();
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this.current != null) {
                this.current.append(new String(ch, start, length));
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (this.done) {
                this.server.setPassword(this.doDecrypt(this.encryptedPassword, this.passphrase));
                return;
            }
            if ("server".equalsIgnoreCase(qName)) {
                if (this.server.getId().equals(this.serverId)) {
                    this.done = true;
                } else if (!this.done) {
                    this.server = null;
                    this.encryptedPassword = null;
                }
            } else if (this.server != null && this.current != null) {
                switch (qName) {
                    case "id": {
                        this.server.setId(this.current.toString());
                        break;
                    }
                    case "username": {
                        try {
                            this.server.setUsername(this.doDecrypt(this.current.toString(), this.passphrase));
                        }
                        catch (RuntimeException re) {
                            this.server.setUsername(this.current.toString());
                        }
                        break;
                    }
                    case "password": {
                        this.encryptedPassword = this.current.toString();
                        break;
                    }
                }
                this.current = null;
            }
        }

        private String doDecrypt(String value, String pwd) {
            if (value == null) {
                return null;
            }
            Matcher matcher = ENCRYPTED_PATTERN.matcher(value);
            if (!matcher.matches() && !matcher.find()) {
                return value;
            }
            String bare = matcher.group(1);
            if (value.startsWith("${env.")) {
                String key = bare.substring("env.".length());
                return Optional.ofNullable(System.getenv(key)).orElseGet(() -> System.getProperty(bare));
            }
            if (value.startsWith("${")) {
                return System.getProperty(bare);
            }
            if (pwd == null || pwd.isEmpty()) {
                throw new IllegalArgumentException("Master password can't be null or empty.");
            }
            if (bare.contains("[") && bare.contains("]") && bare.contains("type=")) {
                throw new IllegalArgumentException("Unsupported encryption for " + value);
            }
            byte[] allEncryptedBytes = Base64.getMimeDecoder().decode(bare);
            int totalLen = allEncryptedBytes.length;
            byte[] salt = new byte[8];
            System.arraycopy(allEncryptedBytes, 0, salt, 0, 8);
            byte padLen = allEncryptedBytes[8];
            byte[] encryptedBytes = new byte[totalLen - 8 - 1 - padLen];
            System.arraycopy(allEncryptedBytes, 9, encryptedBytes, 0, encryptedBytes.length);
            try {
                MessageDigest digest = MessageDigest.getInstance("SHA-256");
                byte[] keyAndIv = new byte[32];
                int currentPos = 0;
                while (currentPos < keyAndIv.length) {
                    digest.update(pwd.getBytes(StandardCharsets.UTF_8));
                    digest.update(salt, 0, 8);
                    byte[] result = digest.digest();
                    int stillNeed = keyAndIv.length - currentPos;
                    if (result.length > stillNeed) {
                        byte[] b = new byte[stillNeed];
                        System.arraycopy(result, 0, b, 0, b.length);
                        result = b;
                    }
                    System.arraycopy(result, 0, keyAndIv, currentPos, result.length);
                    if ((currentPos += result.length) >= keyAndIv.length) continue;
                    digest.reset();
                    digest.update(result);
                }
                byte[] key = new byte[16];
                byte[] iv = new byte[16];
                System.arraycopy(keyAndIv, 0, key, 0, key.length);
                System.arraycopy(keyAndIv, key.length, iv, 0, iv.length);
                Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
                cipher.init(2, (Key)new SecretKeySpec(key, "AES"), new IvParameterSpec(iv));
                byte[] clearBytes = cipher.doFinal(encryptedBytes);
                return new String(clearBytes, StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

