/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.junit;

import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.talend.sdk.component.api.DecryptedServer;
import org.talend.sdk.component.base.BaseMavenDecrypter;
import org.talend.sdk.component.maven.Server;

public class MavenDecrypterRule
implements TestRule {
    private final Object instance;
    private final BaseMavenDecrypter decrypter = new BaseMavenDecrypter();

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                MavenDecrypterRule.this.doInject(MavenDecrypterRule.this.instance, MavenDecrypterRule.this.instance.getClass());
                base.evaluate();
            }
        };
    }

    private void doInject(Object instance, Class<?> base) {
        Stream.of(base.getDeclaredFields()).filter(f -> f.isAnnotationPresent(DecryptedServer.class)).forEach(f -> {
            DecryptedServer annotation = f.getAnnotation(DecryptedServer.class);
            Server server = this.decrypter.createInstance(annotation);
            if (!f.isAccessible()) {
                f.setAccessible(true);
            }
            try {
                f.set(instance, server);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        });
        Optional.ofNullable(base.getSuperclass()).filter(s -> s != Object.class).ifPresent(c -> this.doInject(instance, (Class<?>)c));
    }

    @Generated
    public MavenDecrypterRule(Object instance) {
        this.instance = instance;
    }
}

