/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.talend.sdk.component.api.configuration.Option;
import org.talend.sdk.component.api.internationalization.Internationalized;
import org.talend.sdk.component.api.service.Service;
import org.talend.sdk.component.api.service.http.Request;
import org.talend.sdk.component.runtime.manager.ParameterMeta;
import org.talend.sdk.component.runtime.manager.reflect.Primitives;
import org.talend.sdk.component.runtime.manager.reflect.StringCompatibleTypes;
import org.talend.sdk.component.spi.parameter.ParameterExtensionEnricher;

public class ParameterModelService {
    private static final Annotation[] NO_ANNOTATIONS = new Annotation[0];
    private final Collection<ParameterExtensionEnricher> enrichers;

    protected ParameterModelService(Collection<ParameterExtensionEnricher> enrichers) {
        this.enrichers = enrichers;
    }

    public ParameterModelService() {
        this(StreamSupport.stream(Spliterators.spliteratorUnknownSize(ServiceLoader.load(ParameterExtensionEnricher.class).iterator(), 1024), false).collect(Collectors.toList()));
    }

    public boolean isService(Parameter parameter) {
        Class<?> type = parameter.getType();
        return !parameter.isAnnotationPresent(Option.class) && (type.isAnnotationPresent(Service.class) || type.isAnnotationPresent(Internationalized.class) || Stream.of(type.getMethods()).anyMatch(m -> m.isAnnotationPresent(Request.class)) || type.getName().startsWith("org.talend.sdk.component.") && type.getName().contains(".service.") || type.getName().startsWith("javax."));
    }

    private List<ParameterMeta> doBuildParameterMetas(Executable executable, String i18nPackage, boolean ignoreI18n) {
        return Stream.of(executable.getParameters()).filter(p -> !this.isService((Parameter)p)).map(parameter -> {
            String name = this.findName((Parameter)parameter);
            return this.buildParameter(name, name, new ParameterMeta.Source((Parameter)parameter, executable){
                final /* synthetic */ Parameter val$parameter;
                final /* synthetic */ Executable val$executable;
                {
                    this.val$parameter = parameter;
                    this.val$executable = executable;
                }

                @Override
                public String name() {
                    return this.val$parameter.getName();
                }

                @Override
                public Class<?> declaringClass() {
                    return this.val$executable.getDeclaringClass();
                }
            }, parameter.getParameterizedType(), (Annotation[])Stream.concat(Stream.of(parameter.getType().getAnnotations()), Stream.of(parameter.getAnnotations())).toArray(Annotation[]::new), new ArrayList<String>(Collections.singletonList(i18nPackage)), ignoreI18n);
        }).collect(Collectors.toList());
    }

    public List<ParameterMeta> buildServiceParameterMetas(Executable executable, String i18nPackage) {
        return this.doBuildParameterMetas(executable, i18nPackage, true);
    }

    public List<ParameterMeta> buildParameterMetas(Executable executable, String i18nPackage) {
        return this.doBuildParameterMetas(executable, i18nPackage, false);
    }

    protected ParameterMeta buildParameter(String name, String prefix, ParameterMeta.Source source, Type genericType, Annotation[] annotations, Collection<String> i18nPackages, boolean ignoreI18n) {
        ParameterMeta.Type type = this.findType(genericType);
        String normalizedPrefix = prefix.endsWith(".") ? prefix.substring(0, prefix.length() - 1) : prefix;
        ArrayList<ParameterMeta> nested = new ArrayList<ParameterMeta>();
        ArrayList<String> proposals = new ArrayList<String>();
        switch (type) {
            case OBJECT: {
                this.addI18nPackageIfPossible(i18nPackages, genericType);
                List<ParameterMeta> meta = this.buildParametersMetas(name, normalizedPrefix + ".", genericType, annotations, i18nPackages, ignoreI18n);
                meta.sort(Comparator.comparing(ParameterMeta::getName));
                nested.addAll(meta);
                break;
            }
            case ARRAY: {
                Class<?> nestedType = Class.class.isInstance(genericType) && ((Class)Class.class.cast(genericType)).isArray() ? ((Class)Class.class.cast(genericType)).getComponentType() : ((ParameterizedType)ParameterizedType.class.cast(genericType)).getActualTypeArguments()[0];
                this.addI18nPackageIfPossible(i18nPackages, nestedType);
                nested.addAll(this.buildParametersMetas(name + "[${index}]", normalizedPrefix + "[${index}].", nestedType, Class.class.isInstance(nestedType) ? ((Class)Class.class.cast(nestedType)).getAnnotations() : NO_ANNOTATIONS, i18nPackages, ignoreI18n));
                break;
            }
            case ENUM: {
                this.addI18nPackageIfPossible(i18nPackages, genericType);
                proposals.addAll(Stream.of(((Class)genericType).getEnumConstants()).map(Enum::name).sorted().collect(Collectors.toList()));
                break;
            }
        }
        return new ParameterMeta(source, genericType, type, normalizedPrefix, name, i18nPackages.toArray(new String[i18nPackages.size()]), nested, proposals, this.buildExtensions(name, genericType, annotations), false);
    }

    private void addI18nPackageIfPossible(Collection<String> i18nPackages, Type type) {
        Package typePck;
        if (Class.class.isInstance(type) && (typePck = ((Class)Class.class.cast(type)).getPackage()) != null && !typePck.getName().isEmpty()) {
            i18nPackages.add(typePck.getName());
        }
    }

    private Map<String, String> buildExtensions(String name, Type genericType, Annotation[] annotations) {
        return Stream.concat(Stream.of(annotations), Class.class.isInstance(genericType) ? Stream.of(((Class)Class.class.cast(genericType)).getAnnotations()).filter(a -> Stream.of(annotations).noneMatch(o -> o.annotationType() == a.annotationType())) : (ParameterizedType.class.isInstance(genericType) && ((ParameterizedType)ParameterizedType.class.cast(genericType)).getActualTypeArguments().length == 1 && Class.class.isInstance(((ParameterizedType)ParameterizedType.class.cast(genericType)).getActualTypeArguments()[0]) ? Stream.of(((Class)Class.class.cast(((ParameterizedType)ParameterizedType.class.cast(genericType)).getActualTypeArguments()[0])).getAnnotations()).filter(a -> Stream.of(annotations).noneMatch(o -> o.annotationType() == a.annotationType())) : Stream.empty())).distinct().flatMap(a -> this.enrichers.stream().map(e -> e.onParameterAnnotation(name, genericType, a))).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private List<ParameterMeta> buildParametersMetas(final String name, String prefix, final Type type, Annotation[] annotations, Collection<String> i18nPackages, boolean ignoreI18n) {
        if (ParameterizedType.class.isInstance(type)) {
            ParameterizedType pt = (ParameterizedType)ParameterizedType.class.cast(type);
            if (!Class.class.isInstance(pt.getRawType())) {
                throw new IllegalArgumentException("Unsupported raw type in ParameterizedType parameter: " + pt);
            }
            Class raw = (Class)Class.class.cast(pt.getRawType());
            if (Collection.class.isAssignableFrom(raw)) {
                if (!Class.class.isInstance(pt.getActualTypeArguments()[0])) {
                    throw new IllegalArgumentException("Unsupported list: " + pt + ", ensure to use a concrete class as generic");
                }
                return this.buildParametersMetas(name, prefix, (Type)Class.class.cast(type), annotations, i18nPackages, ignoreI18n);
            }
            if (Map.class.isAssignableFrom(raw)) {
                if (!Class.class.isInstance(pt.getActualTypeArguments()[0]) || !Class.class.isInstance(pt.getActualTypeArguments()[1])) {
                    throw new IllegalArgumentException("Unsupported map: " + pt + ", ensure to use a concrete class as generics");
                }
                return Stream.concat(this.buildParametersMetas(name + ".key[${index}]", prefix + "key[${index}].", (Type)Class.class.cast(pt.getActualTypeArguments()[0]), annotations, i18nPackages, ignoreI18n).stream(), this.buildParametersMetas(name + ".value[${index}]", prefix + "value[${index}].", (Type)Class.class.cast(pt.getActualTypeArguments()[1]), annotations, i18nPackages, ignoreI18n).stream()).collect(Collectors.toList());
            }
        }
        if (Class.class.isInstance(type)) {
            switch (this.findType(type)) {
                case ENUM: 
                case STRING: 
                case NUMBER: 
                case BOOLEAN: {
                    return Collections.singletonList(this.buildParameter(name, prefix, new ParameterMeta.Source(){

                        @Override
                        public String name() {
                            return name;
                        }

                        @Override
                        public Class<?> declaringClass() {
                            return (Class)Class.class.cast(type);
                        }
                    }, type, annotations, i18nPackages, ignoreI18n));
                }
            }
            return this.buildObjectParameters(prefix, (Class)Class.class.cast(type), i18nPackages, ignoreI18n);
        }
        throw new IllegalArgumentException("Unsupported parameter type: " + type);
    }

    private List<ParameterMeta> buildObjectParameters(String prefix, Class type, Collection<String> i18nPackages, boolean ignoreI18n) {
        HashMap fields = new HashMap();
        ArrayList<ParameterMeta> out = new ArrayList<ParameterMeta>();
        for (Class current = type; current != null && current != Object.class; current = current.getSuperclass()) {
            out.addAll(Stream.of(current.getDeclaredFields()).filter(f -> f.isAnnotationPresent(Option.class)).filter(f -> !"$jacocoData".equals(f.getName()) && !Modifier.isStatic(f.getModifiers()) && (f.getModifiers() & 0x1000) == 0).filter(f -> fields.putIfAbsent(f.getName(), f) == null).map(f -> {
                String path = prefix + f.getName();
                return this.buildParameter(f.getName(), path + ".", new ParameterMeta.Source((Field)f){
                    final /* synthetic */ Field val$f;
                    {
                        this.val$f = field;
                    }

                    @Override
                    public String name() {
                        return this.val$f.getName();
                    }

                    @Override
                    public Class<?> declaringClass() {
                        return this.val$f.getDeclaringClass();
                    }
                }, f.getGenericType(), f.getAnnotations(), i18nPackages, ignoreI18n);
            }).collect(Collectors.toList()));
        }
        return out;
    }

    public String findName(Parameter parameter) {
        return Optional.ofNullable(parameter.getAnnotation(Option.class)).map(Option::value).filter(v -> !v.isEmpty()).orElseGet(parameter::getName);
    }

    private ParameterMeta.Type findType(Type type) {
        if (Class.class.isInstance(type)) {
            Class clazz = (Class)Class.class.cast(type);
            if (Primitives.unwrap(clazz) == Boolean.TYPE) {
                return ParameterMeta.Type.BOOLEAN;
            }
            if (clazz.isPrimitive() || Primitives.unwrap(clazz) != clazz) {
                return ParameterMeta.Type.NUMBER;
            }
            if (clazz.isEnum()) {
                return ParameterMeta.Type.ENUM;
            }
            if (clazz.isArray()) {
                return ParameterMeta.Type.ARRAY;
            }
        }
        if (ParameterizedType.class.isInstance(type)) {
            ParameterizedType pt = (ParameterizedType)ParameterizedType.class.cast(type);
            if (Class.class.isInstance(pt.getRawType())) {
                Class raw = (Class)Class.class.cast(pt.getRawType());
                if (Collection.class.isAssignableFrom(raw)) {
                    return ParameterMeta.Type.ARRAY;
                }
                if (Map.class.isAssignableFrom(raw)) {
                    return ParameterMeta.Type.OBJECT;
                }
            }
            throw new IllegalArgumentException("Unsupported type: " + pt);
        }
        if (StringCompatibleTypes.isKnown(type)) {
            return ParameterMeta.Type.STRING;
        }
        return ParameterMeta.Type.OBJECT;
    }
}

