/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.reflect;

import java.beans.ConstructorProperties;
import java.lang.reflect.Array;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.xbean.propertyeditor.PropertyEditors;
import org.apache.xbean.recipe.ObjectRecipe;
import org.apache.xbean.recipe.Option;
import org.apache.xbean.recipe.UnsetPropertiesRecipe;
import org.talend.sdk.component.runtime.manager.ParameterMeta;
import org.talend.sdk.component.runtime.manager.reflect.Copiable;
import org.talend.sdk.component.runtime.manager.reflect.ParameterModelService;
import org.talend.sdk.component.runtime.manager.reflect.Primitives;

public class ReflectionService {
    private final ParameterModelService parameterModelService;

    public Function<Map<String, String>, Object[]> parameterFactory(Executable executable, Map<Class<?>, Object> precomputed, List<ParameterMeta> metas) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Function<Supplier, Object> contextualSupplier = supplier -> {
            Thread thread = Thread.currentThread();
            ClassLoader old = thread.getContextClassLoader();
            thread.setContextClassLoader(loader);
            try {
                Object t = supplier.get();
                return t;
            }
            finally {
                thread.setContextClassLoader(old);
            }
        };
        Collection factories = Stream.of(executable.getParameters()).map(parameter -> {
            ParameterizedType pt;
            String name = this.parameterModelService.findName((Parameter)parameter);
            Type parameterizedType = parameter.getParameterizedType();
            if (Class.class.isInstance(parameterizedType)) {
                Object value = precomputed.get(parameterizedType);
                if (value != null) {
                    if (Copiable.class.isInstance(value)) {
                        Copiable copiable = (Copiable)Copiable.class.cast(value);
                        return config -> copiable.copy(value);
                    }
                    return config -> value;
                }
                BiFunction<String, Map<String, Object>, Object> objectFactory = this.createObjectFactory(loader, contextualSupplier, parameterizedType, this.translate(metas, name));
                return config -> objectFactory.apply(name, (Map<String, Object>)Map.class.cast(config));
            }
            if (ParameterizedType.class.isInstance(parameterizedType) && Class.class.isInstance((pt = (ParameterizedType)ParameterizedType.class.cast(parameterizedType)).getRawType())) {
                if (Collection.class.isAssignableFrom((Class)Class.class.cast(pt.getRawType()))) {
                    Class collectionType = (Class)Class.class.cast(pt.getRawType());
                    Type itemType = pt.getActualTypeArguments()[0];
                    if (!Class.class.isInstance(itemType)) {
                        throw new IllegalArgumentException("For now we only support Collection<T> with T a Class<?>");
                    }
                    Class itemClass = (Class)Class.class.cast(itemType);
                    Collection services = precomputed.entrySet().stream().sorted(Comparator.comparing(e -> ((Class)e.getKey()).getName())).filter(e -> itemClass.isAssignableFrom((Class)e.getKey())).map(Map.Entry::getValue).collect(Collectors.toList());
                    if (!services.isEmpty()) {
                        return config -> services;
                    }
                    Collector collector = Set.class == collectionType ? Collectors.toSet() : Collectors.toList();
                    List<ParameterMeta> parameterMetas = this.translate(metas, name);
                    BiFunction<String, Map<String, Object>, Object> itemFactory = this.createObjectFactory(loader, contextualSupplier, itemClass, parameterMetas);
                    return config -> this.createList(loader, contextualSupplier, name, collectionType, itemClass, collector, itemFactory, (Map)Map.class.cast(config), parameterMetas);
                }
                if (Map.class.isAssignableFrom((Class)Class.class.cast(pt.getRawType()))) {
                    Class mapType = (Class)Class.class.cast(pt.getRawType());
                    Type keyItemType = pt.getActualTypeArguments()[0];
                    Type valueItemType = pt.getActualTypeArguments()[1];
                    if (!Class.class.isInstance(keyItemType) || !Class.class.isInstance(valueItemType)) {
                        throw new IllegalArgumentException("For now we only support Map<A, B> with A and B a Class<?>");
                    }
                    Class keyItemClass = (Class)Class.class.cast(keyItemType);
                    Class valueItemClass = (Class)Class.class.cast(valueItemType);
                    List<ParameterMeta> parameterMetas = this.translate(metas, name);
                    BiFunction<String, Map<String, Object>, Object> keyItemFactory = this.createObjectFactory(loader, contextualSupplier, keyItemClass, parameterMetas);
                    BiFunction<String, Map<String, Object>, Object> valueItemFactory = this.createObjectFactory(loader, contextualSupplier, valueItemClass, parameterMetas);
                    Collector collector = this.createMapCollector(mapType, keyItemClass, valueItemClass);
                    return config -> this.createMap(name, mapType, keyItemFactory, valueItemFactory, collector, (Map)Map.class.cast(config));
                }
            }
            throw new IllegalArgumentException("Unsupported type: " + parameterizedType);
        }).collect(Collectors.toList());
        return config -> {
            Map notNullConfig = Optional.ofNullable(config).orElseGet(Collections::emptyMap);
            return factories.stream().map(f -> f.apply(notNullConfig)).toArray(Object[]::new);
        };
    }

    private List<ParameterMeta> translate(List<ParameterMeta> metas, String name) {
        if (metas == null) {
            return null;
        }
        return metas.stream().filter(it -> it.getName().equals(name)).flatMap(it -> it.getNestedParameters().stream()).collect(Collectors.toList());
    }

    private Collector createMapCollector(Class<?> mapType, Class<?> keyItemClass, Class<?> valueItemClass) {
        Function<Map.Entry, Object> keyMapper = o -> this.doConvert(keyItemClass, o.getKey());
        Function<Map.Entry, Object> valueMapper = o -> this.doConvert(valueItemClass, o.getValue());
        return ConcurrentMap.class.isAssignableFrom(mapType) ? Collectors.toConcurrentMap(keyMapper, valueMapper) : Collectors.toMap(keyMapper, valueMapper);
    }

    private Object createList(ClassLoader loader, Function<Supplier<Object>, Object> contextualSupplier, String name, Class<?> collectionType, Class<?> itemClass, Collector collector, BiFunction<String, Map<String, Object>, Object> itemFactory, Map<String, Object> config, List<ParameterMeta> metas) {
        Object obj = config.get(name);
        if (collectionType.isInstance(obj)) {
            return ((Collection)Collection.class.cast(obj)).stream().map(o -> this.doConvert(itemClass, o)).collect(collector);
        }
        AbstractCollection collection = List.class.isAssignableFrom(collectionType) ? new ArrayList() : new HashSet();
        int paramIdx = 0;
        String[] args = null;
        while (true) {
            String configName;
            if (!config.containsKey(configName = String.format("%s[%d]", name, paramIdx))) {
                if (!config.keySet().stream().anyMatch(k -> k.startsWith(configName + "."))) break;
                if (paramIdx == 0) {
                    args = this.findArgsName(itemClass);
                }
                collection.add(this.createObject(loader, contextualSupplier, itemClass, args, configName, config, metas));
            } else {
                collection.add(itemFactory.apply(configName, config));
            }
            ++paramIdx;
        }
        return collection;
    }

    private Object createMap(String name, Class<?> mapType, BiFunction<String, Map<String, Object>, Object> keyItemFactory, BiFunction<String, Map<String, Object>, Object> valueItemFactory, Collector collector, Map<String, Object> config) {
        Object obj = config.get(name);
        if (mapType.isInstance(obj)) {
            return ((Map)Map.class.cast(obj)).entrySet().stream().collect(collector);
        }
        AbstractMap map = ConcurrentMap.class.isAssignableFrom(mapType) ? new ConcurrentHashMap() : new HashMap();
        int paramIdx = 0;
        while (true) {
            String keyConfigName = String.format("%s.key[%d]", name, paramIdx);
            String valueConfigName = String.format("%s.value[%d]", name, paramIdx);
            if ((!config.containsKey(keyConfigName) || !config.containsKey(valueConfigName)) && config.keySet().stream().noneMatch(k -> k.startsWith(keyConfigName)) && config.keySet().stream().noneMatch(k -> k.startsWith(valueConfigName))) break;
            map.put(keyItemFactory.apply(keyConfigName, config), valueItemFactory.apply(valueConfigName, config));
            ++paramIdx;
        }
        return map;
    }

    private BiFunction<String, Map<String, Object>, Object> createObjectFactory(ClassLoader loader, Function<Supplier<Object>, Object> contextualSupplier, Type type, List<ParameterMeta> metas) {
        Class clazz = (Class)Class.class.cast(type);
        if (clazz.isPrimitive() || Primitives.unwrap(clazz) != clazz || String.class == clazz) {
            return (name, config) -> this.doConvert(clazz, config.get(name));
        }
        String[] args = this.findArgsName(clazz);
        return (name, config) -> contextualSupplier.apply(() -> this.createObject(loader, contextualSupplier, clazz, args, (String)name, (Map<String, Object>)config, metas));
    }

    private String[] findArgsName(Class clazz) {
        return Stream.of(clazz.getConstructors()).filter(c -> c.isAnnotationPresent(ConstructorProperties.class)).findFirst().map(c -> ((ConstructorProperties)ConstructorProperties.class.cast(c.getAnnotation(ConstructorProperties.class))).value()).orElse(null);
    }

    private Object createObject(ClassLoader loader, Function<Supplier<Object>, Object> contextualSupplier, Class clazz, String[] args, String name, Map<String, Object> config, List<ParameterMeta> metas) {
        Object configValue;
        if (PropertyEditors.canConvert((Class)clazz) && config.size() == 1 && String.class.isInstance(configValue = config.values().iterator().next())) {
            return PropertyEditors.getValue((Type)clazz, (String)((String)String.class.cast(configValue)));
        }
        String prefix = name + ".";
        ObjectRecipe recipe = new ObjectRecipe(clazz);
        recipe.allow(Option.FIELD_INJECTION);
        recipe.allow(Option.PRIVATE_PROPERTIES);
        recipe.allow(Option.CASE_INSENSITIVE_PROPERTIES);
        recipe.allow(Option.IGNORE_MISSING_PROPERTIES);
        recipe.setProperty("rawProperties", (Object)new UnsetPropertiesRecipe());
        Optional.ofNullable(args).ifPresent(arg_0 -> ((ObjectRecipe)recipe).setConstructorArgNames(arg_0));
        Map<String, Object> specificMapping = config.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(prefix)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<String, Object> mapEntries = specificMapping.entrySet().stream().filter(e -> {
            String key = (String)e.getKey();
            int idxStart = key.indexOf(91, prefix.length());
            return idxStart > 0 && (idxStart > ".key".length() && key.substring(idxStart - ".key".length(), idxStart).equals(".key") || idxStart > ".value".length() && key.substring(idxStart - ".value".length(), idxStart).equals(".value"));
        }).sorted(this::sortIndexEntry).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        mapEntries.keySet().forEach(specificMapping::remove);
        HashMap<String, Object> preparedMaps = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : mapEntries.entrySet()) {
            String key = entry.getKey();
            int n = key.indexOf(91, prefix.length());
            String enclosingName = key.substring(prefix.length(), n);
            if (enclosingName.endsWith(".key")) {
                enclosingName = enclosingName.substring(0, enclosingName.length() - ".key".length());
            } else if (enclosingName.endsWith(".value")) {
                enclosingName = enclosingName.substring(0, enclosingName.length() - ".value".length());
            } else {
                throw new IllegalArgumentException("'" + (String)key + "' is not supported, it is considered as a map binding");
            }
            if (preparedMaps.containsKey(enclosingName)) continue;
            Type type = this.findField(enclosingName.substring(enclosingName.indexOf(46) + 1), clazz).getGenericType();
            if (!ParameterizedType.class.isInstance(type)) {
                throw new IllegalArgumentException(clazz + "#" + enclosingName + " should be a generic map and not a " + type);
            }
            ParameterizedType pt = (ParameterizedType)ParameterizedType.class.cast(type);
            if (pt.getActualTypeArguments().length != 2 || !Class.class.isInstance(pt.getActualTypeArguments()[0]) || !Class.class.isInstance(pt.getActualTypeArguments()[1])) {
                throw new IllegalArgumentException(clazz + "#" + enclosingName + " should be a generic map with a key and value class type (" + pt + ")");
            }
            Class keyType = (Class)Class.class.cast(pt.getActualTypeArguments()[0]);
            Class valueType = (Class)Class.class.cast(pt.getActualTypeArguments()[1]);
            preparedMaps.put(enclosingName, this.createMap(prefix + enclosingName, Map.class, this.createObjectFactory(loader, contextualSupplier, keyType, metas), this.createObjectFactory(loader, contextualSupplier, valueType, metas), this.createMapCollector((Class)Class.class.cast(pt.getRawType()), keyType, valueType), new HashMap<String, Object>(mapEntries)));
        }
        Map<String, Object> listEntries = specificMapping.entrySet().stream().filter(e -> {
            String key = (String)e.getKey();
            int idxStart = key.indexOf(91, prefix.length());
            int idxEnd = key.indexOf(93, prefix.length());
            int sep = key.indexOf(46, prefix.length() + 1);
            return idxStart > 0 && key.endsWith("]") && (sep > idxEnd || sep < 0);
        }).sorted(this::sortIndexEntry).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        listEntries.keySet().forEach(specificMapping::remove);
        HashMap<String, Object> preparedLists = new HashMap<String, Object>();
        for (Map.Entry entry : listEntries.entrySet()) {
            Class arrayClass;
            String key = (String)entry.getKey();
            int n = key.indexOf(91, prefix.length());
            String enclosingName = key.substring(prefix.length(), n);
            if (preparedLists.containsKey(enclosingName)) continue;
            Type genericType = this.findField(enclosingName, clazz).getGenericType();
            if (Class.class.isInstance(genericType) && (arrayClass = (Class)Class.class.cast(genericType)).isArray()) {
                Collection list = (Collection)Collection.class.cast(this.createList(loader, contextualSupplier, prefix + enclosingName, List.class, arrayClass.getComponentType(), Collectors.toList(), this.createObjectFactory(loader, contextualSupplier, arrayClass.getComponentType(), metas), new HashMap<String, Object>(listEntries), metas));
                Object array = Array.newInstance(arrayClass.getComponentType(), list.size());
                int idx = 0;
                for (Object o3 : list) {
                    Array.set(array, idx++, o3);
                }
                preparedLists.put(enclosingName, array);
                continue;
            }
            if (!ParameterizedType.class.isInstance(genericType)) {
                throw new IllegalArgumentException(clazz + "#" + enclosingName + " should be a generic collection and not a " + genericType);
            }
            ParameterizedType pt = (ParameterizedType)ParameterizedType.class.cast(genericType);
            if (pt.getActualTypeArguments().length != 1 || !Class.class.isInstance(pt.getActualTypeArguments()[0])) {
                throw new IllegalArgumentException(clazz + "#" + enclosingName + " should use concrete class items and not a " + pt.getActualTypeArguments()[0]);
            }
            Type itemType = pt.getActualTypeArguments()[0];
            preparedLists.put(enclosingName, this.createList(loader, contextualSupplier, prefix + enclosingName, (Class)Class.class.cast(pt.getRawType()), (Class)Class.class.cast(itemType), Collectors.toList(), this.createObjectFactory(loader, contextualSupplier, itemType, metas), new HashMap<String, Object>(listEntries), metas));
        }
        Map objectEntries = specificMapping.entrySet().stream().filter(e -> {
            String key = (String)e.getKey();
            return key.indexOf(46, prefix.length() + 1) > 0;
        }).sorted((o1, o2) -> {
            String key2;
            String key1 = (String)o1.getKey();
            if (key1.equals(key2 = (String)o2.getKey())) {
                return 0;
            }
            String nestedName1 = key1.substring(prefix.length(), key1.indexOf(46, prefix.length() + 1));
            String nestedName2 = key2.substring(prefix.length(), key2.indexOf(46, prefix.length() + 1));
            int idxStart1 = nestedName1.indexOf(91);
            int idxStart2 = nestedName2.indexOf(91);
            if (idxStart1 > 0 && idxStart2 > 0 && nestedName1.substring(0, idxStart1).equals(nestedName2.substring(0, idxStart2))) {
                int idx1 = Integer.parseInt(nestedName1.substring(idxStart1 + 1, nestedName1.length() - 1));
                int idx2 = Integer.parseInt(nestedName2.substring(idxStart2 + 1, nestedName2.length() - 1));
                return idx1 - idx2;
            }
            return key1.compareTo(key2);
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (o, o2) -> {
            throw new IllegalArgumentException("Can't merge " + o + " and " + o2);
        }, LinkedHashMap::new));
        objectEntries.keySet().forEach(specificMapping::remove);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Map.Entry entry : objectEntries.entrySet()) {
            String nestedName = ((String)entry.getKey()).substring(prefix.length(), ((String)entry.getKey()).indexOf(46, prefix.length() + 1));
            if (nestedName.endsWith("]")) {
                int idxStart = nestedName.indexOf(91);
                if (idxStart > 0) {
                    String listName = nestedName.substring(0, idxStart);
                    Field field = this.findField(listName, clazz);
                    if (ParameterizedType.class.isInstance(field.getGenericType())) {
                        ParameterizedType pt = (ParameterizedType)ParameterizedType.class.cast(field.getGenericType());
                        if (Class.class.isInstance(pt.getRawType())) {
                            Class rawType = (Class)Class.class.cast(pt.getRawType());
                            if (Set.class.isAssignableFrom(rawType)) {
                                this.addListElement(loader, contextualSupplier, config, prefix, hashMap, nestedName, listName, pt, () -> new HashSet(2), this.translate(metas, listName));
                                continue;
                            }
                            if (Collection.class.isAssignableFrom(rawType)) {
                                this.addListElement(loader, contextualSupplier, config, prefix, hashMap, nestedName, listName, pt, () -> new ArrayList(2), this.translate(metas, listName));
                                continue;
                            }
                            throw new IllegalArgumentException("unsupported configuration type: " + pt);
                        }
                        throw new IllegalArgumentException("unsupported configuration type: " + pt);
                    }
                    throw new IllegalArgumentException("unsupported configuration type: " + field.getType());
                }
                throw new IllegalArgumentException("unsupported configuration type: " + nestedName);
            }
            Field field = this.findField(nestedName, clazz);
            hashMap.put(nestedName, this.createObject(loader, contextualSupplier, field.getType(), this.findArgsName(field.getType()), prefix + nestedName, config, this.translate(metas, nestedName)));
        }
        Map<String, Object> normalizedConfig = specificMapping.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(prefix) && ((String)e.getKey()).substring(prefix.length()).indexOf(46) < 0).collect(Collectors.toMap(e -> {
            int end;
            String specificConfig = ((String)e.getKey()).substring(prefix.length());
            int index = specificConfig.indexOf(91);
            if (index > 0 && (end = specificConfig.indexOf(93, index)) > index) {
                String leadingString = specificConfig.substring(0, index);
                if (leadingString.endsWith(".key") || leadingString.endsWith(".value")) {
                    leadingString = leadingString.substring(0, leadingString.lastIndexOf(46));
                }
                return leadingString + specificConfig.substring(end + 1);
            }
            return specificConfig;
        }, Map.Entry::getValue));
        this.doValidate(metas, preparedLists, normalizedConfig);
        preparedMaps.forEach((arg_0, arg_1) -> ((ObjectRecipe)recipe).setProperty(arg_0, arg_1));
        preparedLists.forEach((arg_0, arg_1) -> ((ObjectRecipe)recipe).setProperty(arg_0, arg_1));
        hashMap.forEach((arg_0, arg_1) -> ((ObjectRecipe)recipe).setProperty(arg_0, arg_1));
        normalizedConfig.forEach((arg_0, arg_1) -> ((ObjectRecipe)recipe).setProperty(arg_0, arg_1));
        return recipe.create(loader);
    }

    private void doValidate(List<ParameterMeta> metas, Map<String, Object> preparedLists, Map<String, Object> normalizedConfig) {
        String error;
        if (metas != null && !Boolean.getBoolean("talend.component.configuration.validation.skip") && !(error = Stream.concat(metas.stream().filter(it -> "true".equalsIgnoreCase(it.getMetadata().get("tcomp::validation::required"))).filter(it -> !normalizedConfig.containsKey(it.getName())).map(it -> "Missing configuration " + it.getPath()), Stream.concat(metas.stream().map(it -> Optional.ofNullable(normalizedConfig.get(it.getName())).map(v -> this.errorFactory((ParameterMeta)it).apply(v).stream().collect(Collectors.joining("\n"))).orElse(null)), metas.stream().map(it -> Optional.ofNullable(preparedLists.get(it.getName())).map(v -> this.errorFactory((ParameterMeta)it).apply(v).stream().collect(Collectors.joining("\n"))).orElse(null)))).filter(Objects::nonNull).collect(Collectors.joining("\n")).trim()).isEmpty()) {
            throw new IllegalArgumentException(error);
        }
    }

    private void addListElement(ClassLoader loader, Function<Supplier<Object>, Object> contextualSupplier, Map<String, Object> config, String prefix, Map<String, Object> preparedObjects, String nestedName, String listName, ParameterizedType pt, Supplier<?> init, List<ParameterMeta> metas) {
        Collection aggregator = (Collection)Collection.class.cast(preparedObjects.computeIfAbsent(listName, k -> init.get()));
        Class itemType = (Class)Class.class.cast(pt.getActualTypeArguments()[0]);
        int index = Integer.parseInt(nestedName.substring(listName.length() + 1, nestedName.length() - 1));
        if (aggregator.size() <= index) {
            aggregator.add(this.createObject(loader, contextualSupplier, itemType, this.findArgsName(itemType), prefix + nestedName, config, metas));
        }
    }

    private Field findField(String name, Class clazz) {
        for (Class type = clazz; type != Object.class && type != null; type = type.getSuperclass()) {
            try {
                return type.getDeclaredField(name);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        throw new IllegalArgumentException("Unknown field: " + name);
    }

    private int sortIndexEntry(Map.Entry<String, Object> e1, Map.Entry<String, Object> e2) {
        String name1 = e1.getKey();
        String name2 = e2.getKey();
        int index1 = name1.indexOf(91);
        int index2 = name2.indexOf(91);
        if (index1 > 0 && index2 == index1 && name1.substring(0, index1).equals(name2.substring(0, index1))) {
            int end1 = name1.indexOf(93, index1);
            int end2 = name2.indexOf(93, index2);
            if (end1 > index1 && end2 > index2) {
                String idx1 = name1.substring(index1 + 1, end1);
                String idx2 = name2.substring(index2 + 1, end2);
                return Integer.parseInt(idx1) - Integer.parseInt(idx2);
            }
        }
        return name1.compareTo(name2);
    }

    private Object doConvert(Class<?> type, Object value) {
        if (value == null) {
            return this.getPrimitiveDefault(type);
        }
        if (type.isInstance(value)) {
            return value;
        }
        if (PropertyEditors.canConvert(type)) {
            return PropertyEditors.getValue(type, (String)String.valueOf(value));
        }
        throw new IllegalArgumentException("Can't convert '" + value + "' to " + type);
    }

    private Function<Object, Collection<String>> errorFactory(ParameterMeta parameterMeta) {
        String pattern;
        String unique;
        String max;
        double bound;
        Map<String, String> metadata = parameterMeta.getMetadata();
        ArrayList<Function<Object, String>> errors = new ArrayList<Function<Object, String>>();
        String min = metadata.get("tcomp::validation::min");
        if (min != null) {
            bound = Double.parseDouble(min);
            errors.add(it -> {
                Object value = this.tryToGetNumber(it);
                if (Number.class.isInstance(value) && ((Number)Number.class.cast(value)).doubleValue() < bound) {
                    return parameterMeta.getPath() + " should be >= " + bound;
                }
                return null;
            });
        }
        if ((max = metadata.get("tcomp::validation::max")) != null) {
            bound = Double.parseDouble(max);
            errors.add(it -> {
                Object value = this.tryToGetNumber(it);
                if (Number.class.isInstance(it) && ((Number)Number.class.cast(value)).doubleValue() > bound) {
                    return parameterMeta.getPath() + " should be <= " + bound;
                }
                return null;
            });
        }
        if ((min = metadata.get("tcomp::validation::minLength")) != null) {
            bound = Double.parseDouble(min);
            errors.add(it -> {
                if (CharSequence.class.isInstance(it) && (double)((CharSequence)CharSequence.class.cast(it)).length() < bound) {
                    return parameterMeta.getPath() + " size should be >= " + bound;
                }
                return null;
            });
        }
        if ((max = metadata.get("tcomp::validation::maxLength")) != null) {
            bound = Double.parseDouble(max);
            errors.add(it -> {
                if (CharSequence.class.isInstance(it) && (double)((CharSequence)CharSequence.class.cast(it)).length() > bound) {
                    return parameterMeta.getPath() + " size should be <= " + bound;
                }
                return null;
            });
        }
        if ((min = metadata.get("tcomp::validation::minItems")) != null) {
            bound = Double.parseDouble(min);
            errors.add(it -> {
                if (Collection.class.isInstance(it) && (double)((Collection)Collection.class.cast(it)).size() < bound) {
                    return parameterMeta.getPath() + " size should be >= " + bound;
                }
                return null;
            });
        }
        if ((max = metadata.get("tcomp::validation::maxItems")) != null) {
            bound = Double.parseDouble(max);
            errors.add(it -> {
                if (Collection.class.isInstance(it) && (double)((Collection)Collection.class.cast(it)).size() > bound) {
                    return parameterMeta.getPath() + " size should be <= " + bound;
                }
                return null;
            });
        }
        if ((unique = metadata.get("tcomp::validation::uniqueItems")) != null) {
            errors.add(it -> {
                if (Collection.class.isInstance(it) && new HashSet((Collection)Collection.class.cast(it)).size() != ((Collection)Collection.class.cast(it)).size()) {
                    return parameterMeta.getPath() + " items must be unique";
                }
                return null;
            });
        }
        if ((pattern = metadata.get("tcomp::validation::pattern")) != null) {
            errors.add(it -> {
                if (CharSequence.class.isInstance(it) && !new JavascriptRegex(pattern).test((CharSequence)CharSequence.class.cast(it))) {
                    return parameterMeta.getPath() + " doesn't match '" + pattern + "'";
                }
                return null;
            });
        }
        return it -> errors.stream().map(fn -> (String)fn.apply(it)).filter(Objects::nonNull).sorted().collect(Collectors.toList());
    }

    private Object tryToGetNumber(Object it) {
        String str;
        Object value = String.class.isInstance(it) ? (!(str = String.valueOf(it)).isEmpty() ? Double.valueOf(Double.parseDouble(String.valueOf(it))) : null) : it;
        return value;
    }

    private Object getPrimitiveDefault(Class<?> type) {
        Class<?> convergedType = Primitives.unwrap(type);
        if (Character.TYPE == convergedType || Short.TYPE == convergedType || Byte.TYPE == convergedType || Integer.TYPE == convergedType) {
            return 0;
        }
        if (Long.TYPE == convergedType) {
            return 0L;
        }
        if (Boolean.TYPE == convergedType) {
            return false;
        }
        if (Double.TYPE == convergedType) {
            return 0.0;
        }
        if (Float.TYPE == convergedType) {
            return Float.valueOf(0.0f);
        }
        return null;
    }

    public ReflectionService(ParameterModelService parameterModelService) {
        this.parameterModelService = parameterModelService;
    }

    public static class JavascriptRegex
    implements Predicate<CharSequence> {
        private static final ScriptEngine ENGINE = new ScriptEngineManager().getEngineByName("javascript");
        private final String regex;
        private final String indicators;

        private JavascriptRegex(String regex) {
            if (regex.startsWith("/") && regex.length() > 1) {
                int end = regex.lastIndexOf(47);
                if (end < 0) {
                    this.regex = regex;
                    this.indicators = "";
                } else {
                    this.regex = regex.substring(1, end);
                    this.indicators = regex.substring(end + 1);
                }
            } else {
                this.regex = regex;
                this.indicators = "";
            }
        }

        @Override
        public boolean test(CharSequence string) {
            Bindings bindings = ENGINE.createBindings();
            bindings.put("text", (Object)string);
            bindings.put("regex", (Object)this.regex);
            bindings.put("indicators", (Object)this.indicators);
            try {
                return (Boolean)Boolean.class.cast(ENGINE.eval("new RegExp(regex, indicators).test(text)", bindings));
            }
            catch (ScriptException e) {
                return false;
            }
        }
    }
}

