/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.stream.Collectors;
import org.talend.sdk.component.runtime.manager.ParameterMeta;

public class DefaultValueInspector {
    public Object createDemoInstance(Object rootInstance, ParameterMeta param) {
        ParameterizedType pt;
        Type rawType;
        Object field;
        if (rootInstance != null && (field = this.findField(rootInstance, param)) != null) {
            return field;
        }
        Type javaType = param.getJavaType();
        if (Class.class.isInstance(javaType)) {
            return this.tryCreatingObjectInstance(javaType);
        }
        if (ParameterizedType.class.isInstance(javaType) && Class.class.isInstance(rawType = (pt = (ParameterizedType)ParameterizedType.class.cast(javaType)).getRawType()) && Collection.class.isAssignableFrom((Class)Class.class.cast(rawType)) && pt.getActualTypeArguments().length == 1 && Class.class.isInstance(pt.getActualTypeArguments()[0])) {
            return this.tryCreatingObjectInstance(pt.getActualTypeArguments()[0]);
        }
        return null;
    }

    public String findDefault(Object instance, ParameterMeta param) {
        if (instance == null) {
            return null;
        }
        ParameterMeta.Type type = param.getType();
        switch (type) {
            case OBJECT: {
                return null;
            }
            case ENUM: {
                return ((Enum)Enum.class.cast(instance)).name();
            }
            case STRING: 
            case NUMBER: 
            case BOOLEAN: {
                return String.valueOf(instance);
            }
            case ARRAY: {
                if (!param.getNestedParameters().isEmpty()) {
                    return null;
                }
                if (Collection.class.isInstance(instance)) {
                    return ((Collection)instance).stream().map(String::valueOf).collect(Collectors.joining(","));
                }
                return String.valueOf(instance);
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + (Object)((Object)param.getType()));
    }

    private Object findField(Object rootInstance, ParameterMeta param) {
        if (param.getName().startsWith("$")) {
            return null;
        }
        for (Class<?> current = rootInstance.getClass(); current != null; current = current.getSuperclass()) {
            try {
                Field declaredField = current.getDeclaredField(param.getName());
                if (!declaredField.isAccessible()) {
                    declaredField.setAccessible(true);
                }
                return declaredField.get(rootInstance);
            }
            catch (IllegalAccessException | NoSuchFieldException declaredField) {
                continue;
            }
        }
        if (Collection.class.isInstance(rootInstance)) {
            Collection collection = (Collection)Collection.class.cast(rootInstance);
            if (!collection.isEmpty()) {
                return this.findField(collection.iterator().next(), param);
            }
            return null;
        }
        throw new IllegalArgumentException("Didn't find field '" + param.getName() + "' in " + rootInstance);
    }

    private Object tryCreatingObjectInstance(Type javaType) {
        Class type = (Class)Class.class.cast(javaType);
        if (type.isPrimitive()) {
            if (Integer.TYPE == type) {
                return 0;
            }
            if (Long.TYPE == type) {
                return 0L;
            }
            if (Double.TYPE == type) {
                return 0.0;
            }
            if (Float.TYPE == type) {
                return Float.valueOf(0.0f);
            }
            if (Short.TYPE == type) {
                return (short)0;
            }
            if (Byte.TYPE == type) {
                return (byte)0;
            }
            if (Boolean.TYPE == type) {
                return false;
            }
            throw new IllegalArgumentException("Not a primitive: " + type);
        }
        if (type.getName().startsWith("java.") || type.getName().startsWith("javax.")) {
            return null;
        }
        try {
            return type.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            return null;
        }
    }
}

