/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.xbean;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import org.apache.xbean.finder.archive.Archive;
import org.talend.sdk.component.classloader.ConfigurableClassLoader;
import org.talend.sdk.component.runtime.manager.xbean.KeepingOpenInputStream;

public class NestedJarArchive
implements Archive,
AutoCloseable {
    private final JarInputStream jarStream;
    private final ConfigurableClassLoader loader;

    public InputStream getBytecode(String className) throws IOException, ClassNotFoundException {
        return this.loader.getResourceAsStream(className);
    }

    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return this.loader.loadClass(className);
    }

    public Iterator<Archive.Entry> iterator() {
        return new Iterator<Archive.Entry>(){
            private ZipEntry entry;

            @Override
            public boolean hasNext() {
                if (this.entry == null) {
                    try {
                        while ((this.entry = NestedJarArchive.this.jarStream.getNextEntry()) != null && !this.entry.getName().endsWith(".class")) {
                        }
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Invalid nested jar", e);
                    }
                }
                return this.entry != null;
            }

            @Override
            public Archive.Entry next() {
                final ZipEntry returned = this.entry;
                this.entry = null;
                return new Archive.Entry(){

                    public String getName() {
                        return returned.getName();
                    }

                    public InputStream getBytecode() throws IOException {
                        return new KeepingOpenInputStream(NestedJarArchive.this.jarStream);
                    }
                };
            }
        };
    }

    @Override
    public void close() throws Exception {
        this.jarStream.close();
    }

    public NestedJarArchive(JarInputStream jarStream, ConfigurableClassLoader loader) {
        this.jarStream = jarStream;
        this.loader = loader;
    }
}

