/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.service.http;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.talend.sdk.component.api.service.http.Configurer;
import org.talend.sdk.component.runtime.manager.service.http.HttpRequest;

public class HttpRequestCreator
implements BiFunction<String, Object[], HttpRequest> {
    private final Function<Object[], String> httpMethodProvider;
    private final Function<Object[], String> urlProvide;
    private final String pathTemplate;
    private final BiFunction<String, Object[], String> pathProvider;
    private final Function<Object[], Collection<String>> queryParamsProvider;
    private final Function<Object[], Map<String, String>> headersProvider;
    private final BiFunction<String, Object[], Optional<byte[]>> payloadProvider;
    private final Configurer configurer;
    private final Map<String, Function<Object[], Object>> configurerOptions;

    @Override
    public HttpRequest apply(String base, Object[] params) {
        return new HttpRequest(this.buildUrl(base, params), this.httpMethodProvider.apply(params), this.queryParamsProvider.apply(params), this.headersProvider.apply(params), this.configurer, this.configurerOptions, this.payloadProvider, params, null);
    }

    private String buildUrl(String base, Object[] params) {
        if (this.urlProvide == null) {
            String path = this.pathProvider.apply(this.pathTemplate, params);
            return base + (path.isEmpty() ? "" : "/" + path);
        }
        return this.pathProvider.apply(this.urlProvide.apply(params), params);
    }

    public HttpRequestCreator(Function<Object[], String> httpMethodProvider, Function<Object[], String> urlProvide, String pathTemplate, BiFunction<String, Object[], String> pathProvider, Function<Object[], Collection<String>> queryParamsProvider, Function<Object[], Map<String, String>> headersProvider, BiFunction<String, Object[], Optional<byte[]>> payloadProvider, Configurer configurer, Map<String, Function<Object[], Object>> configurerOptions) {
        this.httpMethodProvider = httpMethodProvider;
        this.urlProvide = urlProvide;
        this.pathTemplate = pathTemplate;
        this.pathProvider = pathProvider;
        this.queryParamsProvider = queryParamsProvider;
        this.headersProvider = headersProvider;
        this.payloadProvider = payloadProvider;
        this.configurer = configurer;
        this.configurerOptions = configurerOptions;
    }
}

