/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.chain.internal;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.talend.sdk.component.runtime.manager.util.Overrides;

public class DSLParser {
    public static Step parse(String rawUri) {
        URI uri = URI.create(rawUri);
        Map<String, String> query = DSLParser.parseQuery(uri.getRawQuery());
        String version = query.remove("__version");
        return new Step(uri.getScheme(), uri.getAuthority(), version != null ? Integer.parseInt(version.trim()) : -1, query);
    }

    private static Map<String, String> parseQuery(String query) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (query == null || query.trim().isEmpty()) {
            return parameters;
        }
        byte[] bytes = query.getBytes(StandardCharsets.UTF_8);
        int pos = 0;
        int end = bytes.length;
        while (pos < end) {
            String value;
            int nameStart = pos;
            int nameEnd = -1;
            int valueStart = -1;
            int valueEnd = -1;
            boolean parsingName = true;
            boolean decodeName = false;
            boolean decodeValue = false;
            boolean parameterComplete = false;
            do {
                switch (bytes[pos]) {
                    case 61: {
                        if (parsingName) {
                            nameEnd = pos++;
                            parsingName = false;
                            valueStart = pos;
                            break;
                        }
                        ++pos;
                        break;
                    }
                    case 38: {
                        if (parsingName) {
                            nameEnd = pos;
                        } else {
                            valueEnd = pos;
                        }
                        parameterComplete = true;
                        ++pos;
                        break;
                    }
                    case 37: 
                    case 43: {
                        if (parsingName) {
                            decodeName = true;
                        } else {
                            decodeValue = true;
                        }
                        ++pos;
                        break;
                    }
                    default: {
                        ++pos;
                    }
                }
            } while (!parameterComplete && pos < end);
            if (pos == end) {
                if (nameEnd == -1) {
                    nameEnd = pos;
                } else if (valueStart > -1 && valueEnd == -1) {
                    valueEnd = pos;
                }
            }
            if (nameEnd <= nameStart) continue;
            String name = new String(bytes, nameStart, nameEnd - nameStart);
            if (decodeName) {
                name = DSLParser.decode(name);
            }
            if (valueStart >= 0) {
                value = new String(bytes, valueStart, valueEnd - valueStart);
                if (decodeValue) {
                    value = DSLParser.decode(value);
                }
            } else {
                value = "true";
            }
            parameters.put(name, value);
        }
        return parameters;
    }

    private static String decode(String query) {
        return URI.create("foo://bar?" + query).getQuery();
    }

    private DSLParser() {
    }

    public static class Step {
        private final String family;
        private final String component;
        private final int version;
        private final Map<String, String> configuration;

        public Step withOverride(boolean override) {
            if (override) {
                return new Step(this.family, this.component, this.version, Overrides.override(this.family + '.' + this.component, this.configuration));
            }
            return this;
        }

        public Step(String family, String component, int version, Map<String, String> configuration) {
            this.family = family;
            this.component = component;
            this.version = version;
            this.configuration = configuration;
        }

        public String getFamily() {
            return this.family;
        }

        public String getComponent() {
            return this.component;
        }

        public int getVersion() {
            return this.version;
        }

        public Map<String, String> getConfiguration() {
            return this.configuration;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step)) {
                return false;
            }
            Step other = (Step)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getVersion() != other.getVersion()) {
                return false;
            }
            String this$family = this.getFamily();
            String other$family = other.getFamily();
            if (this$family == null ? other$family != null : !this$family.equals(other$family)) {
                return false;
            }
            String this$component = this.getComponent();
            String other$component = other.getComponent();
            if (this$component == null ? other$component != null : !this$component.equals(other$component)) {
                return false;
            }
            Map<String, String> this$configuration = this.getConfiguration();
            Map<String, String> other$configuration = other.getConfiguration();
            return !(this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Step;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getVersion();
            String $family = this.getFamily();
            result = result * 59 + ($family == null ? 43 : $family.hashCode());
            String $component = this.getComponent();
            result = result * 59 + ($component == null ? 43 : $component.hashCode());
            Map<String, String> $configuration = this.getConfiguration();
            result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
            return result;
        }

        public String toString() {
            return "DSLParser.Step(family=" + this.getFamily() + ", component=" + this.getComponent() + ", version=" + this.getVersion() + ", configuration=" + this.getConfiguration() + ")";
        }
    }
}

