/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import java.util.Optional;
import java.util.stream.Stream;
import org.talend.sdk.component.api.component.Icon;

public class IconFinder {
    public String findIcon(AnnotatedElement type) {
        return this.findDirectIcon(type).orElseGet(() -> this.findIndirectIcon(type).orElse("default"));
    }

    public Optional<String> findIndirectIcon(AnnotatedElement type) {
        return Optional.ofNullable(this.findMetaIconAnnotation(type).map(this::getMetaIcon).orElseGet(() -> this.findImplicitIcon(type).orElse(null)));
    }

    private Optional<Annotation> findMetaIconAnnotation(AnnotatedElement type) {
        return Stream.of(type.getAnnotations()).filter(this::isMetaIcon).min(Comparator.comparing(it -> it.annotationType().getName()));
    }

    private boolean isMetaIcon(Annotation it) {
        return it.annotationType().isAnnotationPresent(Icon.class) && this.hasMethod(it.annotationType(), "value");
    }

    private Optional<String> findImplicitIcon(AnnotatedElement type) {
        return this.findImplicitIconAnnotation(type).map(it -> String.valueOf(this.invoke(it, it.annotationType(), "value")));
    }

    private Optional<Annotation> findImplicitIconAnnotation(AnnotatedElement type) {
        return Stream.of(type.getAnnotations()).filter(it -> it.annotationType().getSimpleName().endsWith("Icon") && this.hasMethod(it.annotationType(), "value")).findFirst();
    }

    private String getMetaIcon(Annotation it) {
        Object enumValue;
        if (this.hasMethod(it.annotationType(), "type") && !"custom".equalsIgnoreCase(String.valueOf(enumValue = this.invoke(it, it.annotationType(), "type")))) {
            return this.getEnumKey(enumValue).orElseGet(() -> String.valueOf(this.invoke(it, it.annotationType(), "value")));
        }
        Object value = this.invoke(it, it.annotationType(), "value");
        if (value.getClass().isEnum()) {
            return this.getEnumKey(value).orElseGet(() -> String.valueOf(value));
        }
        return String.valueOf(value);
    }

    private Optional<String> getEnumKey(Object enumValue) {
        return Stream.of("getKey", "getValue", "name").filter(getter -> this.hasMethod(enumValue.getClass(), (String)getter)).map(name -> String.valueOf(this.invoke(enumValue, enumValue.getClass(), (String)name))).findFirst();
    }

    private boolean hasMethod(Class<?> clazz, String method) {
        try {
            return clazz.getMethod(method, new Class[0]) != null;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private Object invoke(Object instance, Class<?> type, String method) {
        try {
            return type.getMethod(method, new Class[0]).invoke(instance, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e.getTargetException());
        }
    }

    public Optional<String> findDirectIcon(AnnotatedElement type) {
        return Optional.ofNullable(type.getAnnotation(Icon.class)).map(i -> i.value() == Icon.IconType.CUSTOM ? Optional.of(i.custom()).filter(s -> !s.isEmpty()).orElse("default") : i.value().getKey());
    }

    public boolean isCustom(Annotation icon) {
        if (Icon.class == icon.annotationType()) {
            return ((Icon)Icon.class.cast(icon)).value() == Icon.IconType.CUSTOM;
        }
        if (this.hasMethod(icon.annotationType(), "type")) {
            return "custom".equalsIgnoreCase(String.valueOf(this.invoke(icon, icon.annotationType(), "type")));
        }
        return false;
    }

    public Annotation extractIcon(AnnotatedElement annotatedElement) {
        return Optional.ofNullable(annotatedElement.getAnnotation(Icon.class)).map(Annotation.class::cast).orElseGet(() -> this.findMetaIconAnnotation(annotatedElement).orElseGet(() -> this.findImplicitIconAnnotation(annotatedElement).orElse(null)));
    }
}

