/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.instrument.ClassFileTransformer;
import java.lang.management.ManagementFactory;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.Spliterators;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.json.JsonBuilderFactory;
import javax.json.JsonReaderFactory;
import javax.json.JsonWriterFactory;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbConfig;
import javax.json.bind.spi.JsonbProvider;
import javax.json.spi.JsonProvider;
import javax.json.stream.JsonGeneratorFactory;
import javax.json.stream.JsonParserFactory;
import org.apache.johnzon.core.JsonProviderImpl;
import org.apache.johnzon.jsonb.JohnzonProvider;
import org.apache.xbean.asm9.Type;
import org.apache.xbean.finder.AnnotationFinder;
import org.apache.xbean.finder.ClassFinder;
import org.apache.xbean.finder.archive.Archive;
import org.apache.xbean.finder.archive.ClassesArchive;
import org.apache.xbean.finder.archive.ClasspathArchive;
import org.apache.xbean.finder.archive.CompositeArchive;
import org.apache.xbean.finder.archive.FileArchive;
import org.apache.xbean.finder.archive.FilteredArchive;
import org.apache.xbean.finder.archive.JarArchive;
import org.apache.xbean.finder.filter.ExcludeIncludeFilter;
import org.apache.xbean.finder.filter.Filter;
import org.apache.xbean.finder.filter.FilterList;
import org.apache.xbean.finder.filter.Filters;
import org.apache.xbean.finder.filter.IncludeExcludeFilter;
import org.apache.xbean.finder.filter.PrefixFilter;
import org.apache.xbean.finder.util.Files;
import org.apache.xbean.propertyeditor.Converter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.api.component.Components;
import org.talend.sdk.component.api.component.Version;
import org.talend.sdk.component.api.input.Emitter;
import org.talend.sdk.component.api.input.PartitionMapper;
import org.talend.sdk.component.api.internationalization.Internationalized;
import org.talend.sdk.component.api.processor.AfterGroup;
import org.talend.sdk.component.api.processor.Processor;
import org.talend.sdk.component.api.service.ActionType;
import org.talend.sdk.component.api.service.Service;
import org.talend.sdk.component.api.service.configuration.LocalConfiguration;
import org.talend.sdk.component.api.service.http.HttpClient;
import org.talend.sdk.component.api.service.http.HttpClientFactory;
import org.talend.sdk.component.api.service.http.Request;
import org.talend.sdk.component.api.service.injector.Injector;
import org.talend.sdk.component.api.service.record.RecordBuilderFactory;
import org.talend.sdk.component.classloader.ConfigurableClassLoader;
import org.talend.sdk.component.classloader.ThreadHelper;
import org.talend.sdk.component.container.Container;
import org.talend.sdk.component.container.ContainerListener;
import org.talend.sdk.component.container.ContainerManager;
import org.talend.sdk.component.dependencies.EmptyResolver;
import org.talend.sdk.component.dependencies.Resolver;
import org.talend.sdk.component.dependencies.maven.Artifact;
import org.talend.sdk.component.dependencies.maven.MvnDependencyListLocalRepositoryResolver;
import org.talend.sdk.component.jmx.JmxManager;
import org.talend.sdk.component.path.PathFactory;
import org.talend.sdk.component.runtime.base.Delegated;
import org.talend.sdk.component.runtime.base.Lifecycle;
import org.talend.sdk.component.runtime.base.lang.exception.InvocationExceptionWrapper;
import org.talend.sdk.component.runtime.impl.Mode;
import org.talend.sdk.component.runtime.input.LocalPartitionMapper;
import org.talend.sdk.component.runtime.input.Mapper;
import org.talend.sdk.component.runtime.input.PartitionMapperImpl;
import org.talend.sdk.component.runtime.internationalization.InternationalizationServiceFactory;
import org.talend.sdk.component.runtime.manager.ComponentFamilyMeta;
import org.talend.sdk.component.runtime.manager.ComponentInstanceImpl;
import org.talend.sdk.component.runtime.manager.ContainerComponentRegistry;
import org.talend.sdk.component.runtime.manager.ParameterMeta;
import org.talend.sdk.component.runtime.manager.ServiceMeta;
import org.talend.sdk.component.runtime.manager.asm.ProxyGenerator;
import org.talend.sdk.component.runtime.manager.builtinparams.MaxBatchSizeParamBuilder;
import org.talend.sdk.component.runtime.manager.builtinparams.StreamingLongParamBuilder;
import org.talend.sdk.component.runtime.manager.extension.ComponentContextImpl;
import org.talend.sdk.component.runtime.manager.extension.ComponentContexts;
import org.talend.sdk.component.runtime.manager.json.TalendAccessMode;
import org.talend.sdk.component.runtime.manager.proxy.JavaProxyEnricherFactory;
import org.talend.sdk.component.runtime.manager.reflect.ComponentMetadataService;
import org.talend.sdk.component.runtime.manager.reflect.Constructors;
import org.talend.sdk.component.runtime.manager.reflect.IconFinder;
import org.talend.sdk.component.runtime.manager.reflect.MigrationHandlerFactory;
import org.talend.sdk.component.runtime.manager.reflect.ParameterModelService;
import org.talend.sdk.component.runtime.manager.reflect.ReflectionService;
import org.talend.sdk.component.runtime.manager.reflect.parameterenricher.BaseParameterEnricher;
import org.talend.sdk.component.runtime.manager.service.DefaultServiceProvider;
import org.talend.sdk.component.runtime.manager.service.MavenRepositoryDefaultResolver;
import org.talend.sdk.component.runtime.manager.service.ServiceHelper;
import org.talend.sdk.component.runtime.manager.service.api.ComponentInstantiator;
import org.talend.sdk.component.runtime.manager.service.record.RecordBuilderFactoryProvider;
import org.talend.sdk.component.runtime.manager.spi.ContainerListenerExtension;
import org.talend.sdk.component.runtime.manager.util.Lazy;
import org.talend.sdk.component.runtime.manager.util.LazyMap;
import org.talend.sdk.component.runtime.manager.xbean.KnownClassesFilter;
import org.talend.sdk.component.runtime.manager.xbean.NestedJarArchive;
import org.talend.sdk.component.runtime.manager.xbean.registry.EnrichedPropertyEditorRegistry;
import org.talend.sdk.component.runtime.output.ProcessorImpl;
import org.talend.sdk.component.runtime.record.RecordBuilderFactoryImpl;
import org.talend.sdk.component.runtime.serialization.LightContainer;
import org.talend.sdk.component.runtime.standalone.DriverRunner;
import org.talend.sdk.component.runtime.standalone.DriverRunnerImpl;
import org.talend.sdk.component.runtime.visitor.ModelListener;
import org.talend.sdk.component.runtime.visitor.ModelVisitor;
import org.talend.sdk.component.spi.component.ComponentExtension;
import org.talend.sdk.component.spi.component.GenericComponentExtension;

public class ComponentManager
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(ComponentManager.class);
    private static final Components DEFAULT_COMPONENT = new Components(){

        public Class<? extends Annotation> annotationType() {
            return Components.class;
        }

        public String family() {
            return "";
        }

        public String[] categories() {
            return new String[]{"Misc"};
        }
    };
    protected final ContainerManager container;
    private final Filter classesFilter;
    private final ParameterModelService parameterModelService;
    private final InternationalizationServiceFactory internationalizationServiceFactory;
    private final JsonProvider jsonpProvider;
    private final JsonGeneratorFactory jsonpGeneratorFactory;
    private final JsonReaderFactory jsonpReaderFactory;
    private final JsonBuilderFactory jsonpBuilderFactory;
    private final JsonParserFactory jsonpParserFactory;
    private final JsonWriterFactory jsonpWriterFactory;
    private final JsonbProvider jsonbProvider;
    private final ProxyGenerator proxyGenerator = new ProxyGenerator();
    private final JavaProxyEnricherFactory javaProxyEnricherFactory = new JavaProxyEnricherFactory();
    private final ReflectionService reflections;
    private final MigrationHandlerFactory migrationHandlerFactory;
    private final Collection<ComponentExtension> extensions;
    private final Collection<ClassFileTransformer> transformers;
    private final Collection<LocalConfiguration> localConfigurations;
    private final Level logInfoLevelMapping;
    private final List<Customizer> customizers;
    private final Function<String, RecordBuilderFactory> recordBuilderFactoryProvider;
    private final JsonbConfig jsonbConfig = new JsonbConfig().withBinaryDataStrategy("BASE_64").setProperty("johnzon.cdi.activated", (Object)false).setProperty("johnzon.accessModeDelegate", (Object)new TalendAccessMode());
    private final EnrichedPropertyEditorRegistry propertyEditorRegistry;
    private final List<ContainerClasspathContributor> classpathContributors;
    private final IconFinder iconFinder = new IconFinder();
    private final DefaultServiceProvider defaultServiceProvider;

    public ComponentManager(File m2) {
        this(m2.toPath());
    }

    public ComponentManager(File m2, String dependenciesResource, String jmxNamePattern) {
        this(m2.toPath(), dependenciesResource, jmxNamePattern);
    }

    public ComponentManager(Path m2) {
        this(m2, "TALEND-INF/dependencies.txt", "org.talend.sdk.component:type=component,value=%s");
    }

    public ComponentManager(Path m2, String dependenciesResource, String jmxNamePattern) {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        this.internationalizationServiceFactory = new InternationalizationServiceFactory(this.getLocalSupplier());
        this.customizers = ComponentManager.toStream(ComponentManager.loadServiceProviders(Customizer.class, tccl)).collect(Collectors.toList());
        if (!this.customizers.isEmpty()) {
            this.customizers.forEach(c -> c.setCustomizers(this.customizers));
        }
        this.classpathContributors = !Boolean.getBoolean("talend.component.manager.classpathcontributor.skip") ? ComponentManager.toStream(ComponentManager.loadServiceProviders(ContainerClasspathContributor.class, tccl)).collect(Collectors.toList()) : Collections.emptyList();
        this.classesFilter = new FilterList((Filter[])Stream.concat(Stream.of("org.talend.sdk.component.api.", "org.talend.sdk.component.spi.", "javax.annotation.", "javax.json.", "org.talend.sdk.component.classloader.", "org.talend.sdk.component.runtime.", "org.slf4j.", "org.apache.johnzon."), this.additionalContainerClasses()).distinct().map(PrefixFilter::new).toArray(Filter[]::new));
        this.jsonpProvider = this.loadJsonProvider();
        this.jsonbProvider = this.loadJsonbProvider();
        this.jsonpGeneratorFactory = (JsonGeneratorFactory)JsonGeneratorFactory.class.cast(this.javaProxyEnricherFactory.asSerializable(tccl, null, JsonGeneratorFactory.class.getName(), this.jsonpProvider.createGeneratorFactory(Collections.emptyMap())));
        this.jsonpReaderFactory = (JsonReaderFactory)JsonReaderFactory.class.cast(this.javaProxyEnricherFactory.asSerializable(tccl, null, JsonReaderFactory.class.getName(), this.jsonpProvider.createReaderFactory(Collections.emptyMap())));
        this.jsonpBuilderFactory = (JsonBuilderFactory)JsonBuilderFactory.class.cast(this.javaProxyEnricherFactory.asSerializable(tccl, null, JsonBuilderFactory.class.getName(), this.jsonpProvider.createBuilderFactory(Collections.emptyMap())));
        this.jsonpParserFactory = (JsonParserFactory)JsonParserFactory.class.cast(this.javaProxyEnricherFactory.asSerializable(tccl, null, JsonParserFactory.class.getName(), this.jsonpProvider.createParserFactory(Collections.emptyMap())));
        this.jsonpWriterFactory = (JsonWriterFactory)JsonWriterFactory.class.cast(this.javaProxyEnricherFactory.asSerializable(tccl, null, JsonWriterFactory.class.getName(), this.jsonpProvider.createWriterFactory(Collections.emptyMap())));
        this.logInfoLevelMapping = this.findLogInfoLevel();
        this.propertyEditorRegistry = this.createPropertyEditorRegistry();
        this.localConfigurations = ComponentManager.createRawLocalConfigurations();
        this.parameterModelService = new ParameterModelService(this.propertyEditorRegistry);
        this.reflections = new ReflectionService(this.parameterModelService, this.propertyEditorRegistry);
        this.migrationHandlerFactory = new MigrationHandlerFactory(this.reflections);
        Predicate<String> isContainerClass = name -> this.isContainerClass(this.classesFilter, (String)name);
        ContainerManager.ClassLoaderConfiguration defaultClassLoaderConfiguration = ContainerManager.ClassLoaderConfiguration.builder().parent(tccl).parentClassesFilter(isContainerClass).classesFilter(isContainerClass.negate()).supportsResourceDependencies(true).create();
        this.container = new ContainerManager(ContainerManager.DependenciesResolutionConfiguration.builder().resolver((Resolver)(this.customizers.stream().noneMatch(Customizer::ignoreDefaultDependenciesDescriptor) ? new MvnDependencyListLocalRepositoryResolver(dependenciesResource, this::resolve) : new EmptyResolver())).rootRepositoryLocation(m2).create(), defaultClassLoaderConfiguration, container -> {}, this.logInfoLevelMapping){

            public Path resolve(String path) {
                return ComponentManager.this.classpathContributors.stream().filter(it -> it.canResolve(path)).map(it -> it.resolve(path)).filter(Objects::nonNull).findFirst().orElseGet(() -> super.resolve(path));
            }
        };
        this.container.registerListener((ContainerListener)new Updater(dependenciesResource));
        if (!Boolean.getBoolean("talend.component.manager.jmx.skip")) {
            Optional.ofNullable(jmxNamePattern).map(String::trim).filter(n -> !n.isEmpty()).ifPresent(p -> this.container.registerListener((ContainerListener)new JmxManager(this.container, p, ManagementFactory.getPlatformMBeanServer())));
        }
        ComponentManager.toStream(ComponentManager.loadServiceProviders(ContainerListenerExtension.class, tccl)).peek(e -> e.setComponentManager(this)).sorted(Comparator.comparing(ContainerListenerExtension::order)).forEach(arg_0 -> ((ContainerManager)this.container).registerListener(arg_0));
        this.extensions = ComponentManager.toStream(ComponentManager.loadServiceProviders(ComponentExtension.class, tccl)).filter(ComponentExtension::isActive).sorted(Comparator.comparing(ComponentExtension::priority)).collect(Collectors.toList());
        this.transformers = this.extensions.stream().flatMap(e -> e.getTransformers().stream()).collect(Collectors.toList());
        Iterator<RecordBuilderFactoryProvider> recordBuilderFactoryIterator = ServiceLoader.load(RecordBuilderFactoryProvider.class, tccl).iterator();
        if (recordBuilderFactoryIterator.hasNext()) {
            RecordBuilderFactoryProvider factory = recordBuilderFactoryIterator.next();
            this.recordBuilderFactoryProvider = factory::apply;
            if (recordBuilderFactoryIterator.hasNext()) {
                throw new IllegalArgumentException("Ambiguous recordBuilderFactory: " + factory + "/" + recordBuilderFactoryIterator.next());
            }
        } else {
            this.recordBuilderFactoryProvider = RecordBuilderFactoryImpl::new;
        }
        this.defaultServiceProvider = new DefaultServiceProvider(this.reflections, this.jsonpProvider, this.jsonpGeneratorFactory, this.jsonpReaderFactory, this.jsonpBuilderFactory, this.jsonpParserFactory, this.jsonpWriterFactory, this.jsonbConfig, this.jsonbProvider, this.proxyGenerator, this.javaProxyEnricherFactory, this.localConfigurations, this.recordBuilderFactoryProvider, this.propertyEditorRegistry);
    }

    private JsonbProvider loadJsonbProvider() {
        try {
            return new JohnzonProvider();
        }
        catch (RuntimeException re) {
            return JsonbProvider.provider();
        }
    }

    private JsonProvider loadJsonProvider() {
        try {
            return new JsonProviderImpl();
        }
        catch (RuntimeException re) {
            return JsonProvider.provider();
        }
    }

    protected Supplier<Locale> getLocalSupplier() {
        return Locale::getDefault;
    }

    private Path resolve(String artifact) {
        return this.container.resolve(artifact);
    }

    private EnrichedPropertyEditorRegistry createPropertyEditorRegistry() {
        return new EnrichedPropertyEditorRegistry();
    }

    private Level findLogInfoLevel() {
        if (Boolean.getBoolean("talend.component.manager.log.info")) {
            return Level.INFO;
        }
        try {
            ComponentManager.class.getClassLoader().loadClass("routines.TalendString");
            return Level.FINE;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return Level.INFO;
        }
    }

    public static ComponentManager instance() {
        return SingletonHolder.CONTEXTUAL_INSTANCE.updateAndGet(x$0 -> SingletonHolder.renew(x$0));
    }

    protected static AtomicReference<ComponentManager> contextualInstance() {
        return SingletonHolder.CONTEXTUAL_INSTANCE;
    }

    private static <T> Stream<T> parallelIf(boolean condition, Stream<T> stringStream) {
        return condition ? (Stream)stringStream.parallel() : stringStream;
    }

    protected void info(String msg) {
        switch (this.logInfoLevelMapping.intValue()) {
            case 500: {
                log.debug(msg);
                break;
            }
            default: {
                log.info(msg);
            }
        }
    }

    private Stream<String> additionalContainerClasses() {
        return Stream.concat(this.customizers.stream().flatMap(Customizer::containerClassesAndPackages), Optional.ofNullable(System.getProperty("talend.component.manager.classloader.container.classesAndPackages")).map(s -> s.split(",")).map(Stream::of).orElseGet(Stream::empty));
    }

    public static Path findM2() {
        return new MavenRepositoryDefaultResolver().discover();
    }

    private static String getIdentifiers() {
        return "(classloader=" + ComponentManager.class.getClassLoader() + ", jvm=" + ManagementFactory.getRuntimeMXBean().getName() + ")";
    }

    private static <T> Stream<T> toStream(Iterator<T> iterator) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 1024), false);
    }

    private static <T> Iterator<T> loadServiceProviders(Class<T> service, ClassLoader classLoader) {
        return ServiceLoader.load(service, classLoader).iterator();
    }

    private static Path toFile(String classFileName, URL url) {
        String path = url.getFile();
        path = path.substring(0, path.length() - classFileName.length());
        return PathFactory.get((String)FileArchive.decode((String)path));
    }

    public void addCallerAsPlugin() {
        try {
            ClassLoader tmpLoader = Optional.ofNullable(Thread.currentThread().getContextClassLoader()).orElseGet(ClassLoader::getSystemClassLoader);
            StackTraceElement[] stackTrace = new Throwable().getStackTrace();
            Class<?> jarMarker = tmpLoader.loadClass(Stream.of(stackTrace).filter(c -> !c.getClassName().startsWith("org.talend.sdk.component.runtime.manager.") && !c.getClassName().startsWith("org.talend.sdk.component.runtime.beam.dsl.") && !c.getClassName().startsWith("org.talend.sdk.component.runtime.standalone.") && !c.getClassName().startsWith("org.talend.sdk.component.runtime.avro.") && !c.getClassName().startsWith("org.talend.daikon.") && !c.getClassName().startsWith("org.talend.designer.") && !c.getClassName().startsWith("org.eclipse.") && !c.getClassName().startsWith("java.") && !c.getClassName().startsWith("javax.") && !c.getClassName().startsWith("sun.") && !c.getClassName().startsWith("com.sun.") && !c.getClassName().startsWith("com.oracle.")).findFirst().map(StackTraceElement::getClassName).orElse(ComponentManager.class.getName()));
            if (jarMarker == ComponentManager.class) {
                return;
            }
            this.addJarContaining(tmpLoader, jarMarker.getName().replace(".", "/") + ".class");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    protected List<String> addJarContaining(ClassLoader loader, String resource) {
        URL url = loader.getResource(resource);
        if (url != null) {
            Path plugin = null;
            switch (url.getProtocol()) {
                case "bundleresource": {
                    break;
                }
                case "file": {
                    plugin = ComponentManager.toFile(resource, url);
                    break;
                }
                case "jar": {
                    String spec;
                    int separator;
                    if (url.getPath() != null && url.getPath().startsWith("mvn:") || (separator = (spec = url.getFile()).indexOf(33)) <= 0) break;
                    try {
                        plugin = PathFactory.get((String)FileArchive.decode((String)new URL(spec.substring(0, separator)).getFile()));
                    }
                    catch (MalformedURLException malformedURLException) {}
                    break;
                }
            }
            if (plugin == null) {
                log.warn("Can't find " + url);
                return null;
            }
            return Stream.of(plugin).flatMap(this::toPluginLocations).filter(path -> !this.container.find(path.getFileName().toString()).isPresent()).map(file -> {
                String id = this.addPlugin(file.toAbsolutePath().toString());
                if (((ContainerComponentRegistry)((Container)this.container.find(id).get()).get(ContainerComponentRegistry.class)).getComponents().isEmpty()) {
                    this.removePlugin(id);
                    return null;
                }
                return id;
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private Stream<Path> toPluginLocations(Path src) {
        String filename = src.getFileName().toString();
        if ("test-classes".equals(filename) && src.getParent() != null) {
            return Stream.of(src.getParent().resolve("classes"), src);
        }
        if ("classes".equals(filename) && src.getParent() != null && "test".equals(src.getParent().getFileName().toString()) && src.getParent().getParent() != null) {
            return Stream.of(src.getParent().getParent().resolve("production/classes"), src).filter(x$0 -> java.nio.file.Files.exists(x$0, new LinkOption[0]));
        }
        if ("test".equals(filename) && src.getParent() != null && "java".equals(src.getParent().getFileName().toString())) {
            return Stream.of(src.getParent().resolve("main"), src).filter(x$0 -> java.nio.file.Files.exists(x$0, new LinkOption[0]));
        }
        return Stream.of(src);
    }

    public <T> Stream<T> find(Function<Container, Stream<T>> mapper) {
        return this.container.findAll().stream().flatMap(mapper);
    }

    public Optional<Object> createComponent(String plugin, String name, ComponentType componentType, int version, Map<String, String> configuration) {
        return this.findComponentInternal(plugin, name, componentType, version, configuration).map(i -> Delegated.class.isInstance(i) ? ((Delegated)Delegated.class.cast(i)).getDelegate() : i);
    }

    private Optional<Object> findComponentInternal(String plugin, String name, ComponentType componentType, int version, Map<String, String> configuration) {
        if (this.container.findAll().isEmpty()) {
            this.autoDiscoverPlugins(false, true);
        }
        return this.find(pluginContainer -> Stream.of(this.findInstance(plugin, name, componentType, version, configuration, (Container)pluginContainer))).filter(Objects::nonNull).findFirst();
    }

    public void autoDiscoverPlugins(boolean callers, boolean classpath) {
        if (callers && !Boolean.getBoolean("component.manager.callers.skip")) {
            this.addCallerAsPlugin();
        }
        if (classpath && !Boolean.getBoolean("component.manager.classpath.skip")) {
            try {
                Enumeration<URL> componentMarkers = Thread.currentThread().getContextClassLoader().getResources("TALEND-INF/dependencies.txt");
                while (componentMarkers.hasMoreElements()) {
                    File file = Files.toFile((URL)componentMarkers.nextElement());
                    if (file.getName().equals("dependencies.txt") && file.getParentFile() != null && file.getParentFile().getName().equals("TALEND-INF")) {
                        file = file.getParentFile().getParentFile();
                    }
                    if (this.hasPlugin(this.container.buildAutoIdFromName(file.getName()))) continue;
                    this.addPlugin(file.getAbsolutePath());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private Object findInstance(String plugin, String name, ComponentType componentType, int version, Map<String, String> configuration, Container pluginContainer) {
        return this.findGenericInstance(plugin, name, componentType, version, configuration, pluginContainer).orElseGet(() -> this.findDeployedInstance(plugin, name, componentType, version, configuration, pluginContainer).orElse(null));
    }

    private Optional<Object> findDeployedInstance(String plugin, String name, ComponentType componentType, int version, Map<String, String> configuration, Container pluginContainer) {
        String pluginIdentifier = this.container.buildAutoIdFromName(plugin);
        ComponentInstantiator.BuilderDefault builder = new ComponentInstantiator.BuilderDefault(() -> Stream.of((ContainerComponentRegistry)pluginContainer.get(ContainerComponentRegistry.class)));
        return Optional.ofNullable(builder.build(pluginIdentifier, ComponentInstantiator.MetaFinder.ofComponent(name), componentType)).map(instantiator -> instantiator.instantiate(configuration, version));
    }

    private Optional<Object> findGenericInstance(String plugin, String name, ComponentType componentType, int version, Map<String, String> configuration, Container pluginContainer) {
        return Optional.ofNullable((GenericComponentExtension)pluginContainer.get(GenericComponentExtension.class)).filter(ext -> ext.canHandle(componentType.runtimeType(), plugin, name)).map(ext -> Object.class.cast(ext.createInstance(componentType.runtimeType(), plugin, name, version, configuration, Optional.ofNullable((AllServices)pluginContainer.get(AllServices.class)).map(AllServices::getServices).orElseGet(Collections::emptyMap))));
    }

    public Optional<Mapper> findMapper(String plugin, String name, int version, Map<String, String> configuration) {
        return this.findComponentInternal(plugin, name, ComponentType.MAPPER, version, configuration).map(Mapper.class::cast);
    }

    public Optional<DriverRunner> findDriverRunner(String plugin, String name, int version, Map<String, String> configuration) {
        return this.findComponentInternal(plugin, name, ComponentType.DRIVER_RUNNER, version, configuration).map(DriverRunner.class::cast);
    }

    public Optional<org.talend.sdk.component.runtime.output.Processor> findProcessor(String plugin, String name, int version, Map<String, String> configuration) {
        return this.findComponentInternal(plugin, name, ComponentType.PROCESSOR, version, configuration).map(org.talend.sdk.component.runtime.output.Processor.class::cast);
    }

    public boolean hasPlugin(String plugin) {
        return this.container.find(plugin).isPresent();
    }

    public Optional<Container> findPlugin(String plugin) {
        return this.container.find(plugin);
    }

    public synchronized String addPlugin(String pluginRootFile) {
        Optional<Container> pl = this.findPlugin(pluginRootFile);
        if (pl.isPresent()) {
            return pl.get().getId();
        }
        String id = this.container.builder(pluginRootFile).withCustomizer(this.createContainerCustomizer(pluginRootFile)).withAdditionalClasspath(this.findAdditionalClasspathFor(this.container.buildAutoIdFromName(pluginRootFile))).create().getId();
        this.info("Adding plugin: " + pluginRootFile + ", as " + id);
        return id;
    }

    public String addWithLocationPlugin(String location, String pluginRootFile) {
        String id = this.container.builder(pluginRootFile).withCustomizer(this.createContainerCustomizer(location)).withAdditionalClasspath(this.findAdditionalClasspathFor(this.container.buildAutoIdFromName(location))).create().getId();
        this.info("Adding plugin: " + pluginRootFile + ", as " + id);
        return id;
    }

    protected String addPlugin(String forcedId, String pluginRootFile) {
        String id = this.container.builder(forcedId, pluginRootFile).withCustomizer(this.createContainerCustomizer(forcedId)).withAdditionalClasspath(this.findAdditionalClasspathFor(forcedId)).create().getId();
        this.info("Adding plugin: " + pluginRootFile + ", as " + id);
        return id;
    }

    private Collection<Artifact> findAdditionalClasspathFor(String pluginId) {
        return this.classpathContributors.stream().flatMap(it -> it.findContributions(pluginId).stream()).distinct().collect(Collectors.toList());
    }

    public void removePlugin(String id) {
        this.container.find(id).ifPresent(Container::close);
        this.info("Removed plugin: " + id);
    }

    protected boolean isContainerClass(Filter filter, String name) {
        return name != null && filter.accept(name);
    }

    @Override
    public void close() {
        this.container.close();
        this.propertyEditorRegistry.close();
    }

    private Consumer<Container> createContainerCustomizer(String originalId) {
        return c -> {
            c.set(OriginalId.class, (Object)new OriginalId(originalId));
            this.transformers.forEach(arg_0 -> ((Container)c).registerTransformer(arg_0));
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T executeInContainer(String plugin, Supplier<T> supplier) {
        Thread thread = Thread.currentThread();
        ClassLoader old = thread.getContextClassLoader();
        thread.setContextClassLoader(this.container.find(plugin).map(Container::getLoader).map(ClassLoader.class::cast).orElse(old));
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            thread.setContextClassLoader(old);
        }
    }

    public List<String> availablePlugins() {
        return this.container.findAll().stream().map(Container::getId).collect(Collectors.toList());
    }

    protected void containerServices(Container container, Map<Class<?>, Object> services) {
    }

    protected static Collection<LocalConfiguration> createRawLocalConfigurations() {
        ArrayList<LocalConfiguration> configurations = new ArrayList<LocalConfiguration>(2);
        if (!Boolean.getBoolean("talend.component.manager.localconfiguration.skip")) {
            configurations.addAll(ComponentManager.toStream(ComponentManager.loadServiceProviders(LocalConfiguration.class, LocalConfiguration.class.getClassLoader())).collect(Collectors.toList()));
        }
        configurations.addAll(Arrays.asList(new LocalConfiguration(){

            public String get(String key) {
                return System.getProperty(key);
            }

            public Set<String> keys() {
                return System.getProperties().stringPropertyNames();
            }
        }, new LocalConfiguration(){

            public String get(String key) {
                String val = System.getenv(key);
                if (val != null) {
                    return val;
                }
                String k = key.replaceAll("[^A-Za-z0-9]", "_");
                val = System.getenv(k);
                if (val != null) {
                    return val;
                }
                val = System.getenv(k.toUpperCase(Locale.ROOT));
                if (val != null) {
                    return val;
                }
                return null;
            }

            public Set<String> keys() {
                return System.getenv().keySet();
            }
        }));
        return configurations;
    }

    private <T extends Annotation> T findComponentsConfig(Map<String, AnnotatedElement> componentDefaults, Class<?> type, ConfigurableClassLoader loader, final Class<T> annotation, final T defaultValue) {
        AnnotatedElement annotatedElement = componentDefaults.computeIfAbsent(this.getAnnotatedElementCacheKey(type), p -> {
            if (p != null) {
                String currentPackage = p;
                while (true) {
                    try {
                        Class pckInfo = loader.loadClass(currentPackage + ".package-info");
                        if (pckInfo.isAnnotationPresent(annotation)) {
                            return pckInfo;
                        }
                    }
                    catch (ClassNotFoundException pckInfo) {
                        // empty catch block
                    }
                    int endPreviousPackage = currentPackage.lastIndexOf(46);
                    if (endPreviousPackage < 0) break;
                    currentPackage = currentPackage.substring(0, endPreviousPackage);
                }
            }
            return new AnnotatedElement(){

                @Override
                public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
                    return (T)(annotationClass == annotation ? (Annotation)annotationClass.cast(defaultValue) : null);
                }

                @Override
                public Annotation[] getAnnotations() {
                    return new Annotation[]{defaultValue};
                }

                @Override
                public Annotation[] getDeclaredAnnotations() {
                    return this.getAnnotations();
                }
            };
        });
        return annotatedElement.getAnnotation(annotation);
    }

    private String getAnnotatedElementCacheKey(Class<?> type) {
        return Optional.ofNullable(type.getPackage().getName()).orElse("");
    }

    private Function<Map<String, String>, Object[]> createParametersFactory(String plugin, Executable method, Map<Class<?>, Object> services, Supplier<List<ParameterMeta>> metas) {
        return config -> (Object[])this.executeInContainer(plugin, Lazy.lazy(() -> this.lambda$createParametersFactory$25(method, services, (Supplier)metas))).apply(config);
    }

    public ContainerManager getContainer() {
        return this.container;
    }

    public JsonProvider getJsonpProvider() {
        return this.jsonpProvider;
    }

    public JsonGeneratorFactory getJsonpGeneratorFactory() {
        return this.jsonpGeneratorFactory;
    }

    public JsonReaderFactory getJsonpReaderFactory() {
        return this.jsonpReaderFactory;
    }

    public JsonBuilderFactory getJsonpBuilderFactory() {
        return this.jsonpBuilderFactory;
    }

    public JsonParserFactory getJsonpParserFactory() {
        return this.jsonpParserFactory;
    }

    public JsonWriterFactory getJsonpWriterFactory() {
        return this.jsonpWriterFactory;
    }

    public JsonbProvider getJsonbProvider() {
        return this.jsonbProvider;
    }

    public MigrationHandlerFactory getMigrationHandlerFactory() {
        return this.migrationHandlerFactory;
    }

    public List<Customizer> getCustomizers() {
        return this.customizers;
    }

    public Function<String, RecordBuilderFactory> getRecordBuilderFactoryProvider() {
        return this.recordBuilderFactoryProvider;
    }

    public JsonbConfig getJsonbConfig() {
        return this.jsonbConfig;
    }

    private /* synthetic */ Function lambda$createParametersFactory$25(Executable method, Map services, Supplier metas) {
        return this.reflections.parameterFactory(method, services, metas == null ? null : (List)metas.get());
    }

    public static interface Customizer {
        public Stream<String> containerClassesAndPackages();

        default public boolean ignoreBeamClassLoaderExclusions() {
            return false;
        }

        default public boolean ignoreDefaultDependenciesDescriptor() {
            return false;
        }

        @Deprecated
        default public void setCustomizers(Collection<Customizer> customizers) {
        }
    }

    public static interface ContainerClasspathContributor {
        public Collection<Artifact> findContributions(String var1);

        public boolean canResolve(String var1);

        public Path resolve(String var1);
    }

    private class Updater
    implements ContainerListener {
        private final String dependenciesResource;
        private final ModelVisitor visitor = new ModelVisitor();
        private final Collection<String> supportedAnnotations = Stream.of(Internationalized.class, Service.class, Request.class, PartitionMapper.class, Processor.class, Emitter.class, org.talend.sdk.component.api.standalone.DriverRunner.class).map(Type::getDescriptor).collect(Collectors.toSet());

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void onCreate(final Container container) {
            boolean isGeneric;
            AnnotationFinder finder;
            ConcurrentHashMap xbeanConverterCache;
            block22: {
                ConfigurableClassLoader loader = container.getLoader();
                OriginalId originalId = (OriginalId)OriginalId.class.cast(container.get(OriginalId.class));
                xbeanConverterCache = new ConcurrentHashMap();
                Archive archive = null;
                try {
                    String alreadyScannedClasses = null;
                    Filter filter = KnownClassesFilter.INSTANCE;
                    try (InputStream containerFilterConfig = container.getLoader().getResourceAsStream("TALEND-INF/scanning.properties");){
                        if (containerFilterConfig != null) {
                            Properties config = new Properties();
                            config.load(containerFilterConfig);
                            filter = this.createScanningFilter(config);
                            alreadyScannedClasses = config.getProperty("classes.list");
                        }
                    }
                    catch (IOException e) {
                        log.debug(e.getMessage(), (Throwable)e);
                    }
                    AnnotationFinder optimizedFinder = null;
                    if (alreadyScannedClasses != null && !(alreadyScannedClasses = alreadyScannedClasses.trim()).isEmpty()) {
                        final List classes = Stream.of(alreadyScannedClasses.split(",")).map(String::trim).map(it -> {
                            try {
                                return loader.loadClass(it);
                            }
                            catch (ClassNotFoundException e) {
                                throw new IllegalArgumentException(e);
                            }
                        }).collect(Collectors.toList());
                        if (KnownClassesFilter.INSTANCE == filter) {
                            archive = new ClassesArchive(new Class[0]);
                            optimizedFinder = new AnnotationFinder(archive){

                                public List<Class<?>> findAnnotatedClasses(Class<? extends Annotation> marker) {
                                    return classes.stream().filter(c -> c.isAnnotationPresent(marker)).collect(Collectors.toList());
                                }

                                public List<Method> findAnnotatedMethods(Class<? extends Annotation> annotation) {
                                    if (Request.class == annotation) {
                                        return classes.stream().filter(HttpClient.class::isAssignableFrom).flatMap(client -> Stream.of(client.getMethods()).filter(m -> m.isAnnotationPresent(annotation))).collect(Collectors.toList());
                                    }
                                    return super.findAnnotatedMethods(annotation);
                                }
                            };
                        }
                    } else {
                        archive = this.toArchive(container.getRootModule(), originalId, loader);
                    }
                    AnnotationFinder annotationFinder = finder = optimizedFinder == null ? new AnnotationFinder((Archive)new FilteredArchive(archive, filter)){

                        protected boolean cleanOnNaked() {
                            return true;
                        }

                        protected boolean isTracked(String annotationType) {
                            return Updater.this.supportedAnnotations.contains(annotationType);
                        }
                    } : optimizedFinder;
                    if (!AutoCloseable.class.isInstance(archive)) break block22;
                }
                catch (Throwable throwable) {
                    if (!AutoCloseable.class.isInstance(archive)) throw throwable;
                    try {
                        ((AutoCloseable)AutoCloseable.class.cast(archive)).close();
                        throw throwable;
                    }
                    catch (Exception e) {
                        log.warn(e.getMessage());
                    }
                    throw throwable;
                }
                try {
                    ((AutoCloseable)AutoCloseable.class.cast(archive)).close();
                }
                catch (Exception e) {
                    log.warn(e.getMessage());
                }
            }
            ContainerComponentRegistry registry = new ContainerComponentRegistry();
            container.set(ContainerComponentRegistry.class, (Object)registry);
            Iterator<GenericComponentExtension> genericExtension = ServiceLoader.load(GenericComponentExtension.class, (ClassLoader)container.getLoader()).iterator();
            if (genericExtension.hasNext()) {
                GenericComponentExtension first = genericExtension.next();
                container.set(GenericComponentExtension.class, (Object)first);
                isGeneric = true;
                if (genericExtension.hasNext()) {
                    throw new IllegalArgumentException("A component can't have two generic component extensions: " + finder + ", " + genericExtension.next());
                }
            } else {
                isGeneric = false;
            }
            AtomicReference seviceLookupRef = new AtomicReference();
            ContainerManager containerManager = ComponentManager.this.getContainer();
            Supplier<Stream<ContainerComponentRegistry>> registriesSupplier = () -> containerManager.findAll().stream().map(c -> (ContainerComponentRegistry)c.get(ContainerComponentRegistry.class));
            ComponentInstantiator.BuilderDefault builder = new ComponentInstantiator.BuilderDefault(registriesSupplier);
            final LazyMap services = new LazyMap(24, type -> ComponentManager.this.defaultServiceProvider.lookup(container.getId(), (ClassLoader)container.getLoader(), () -> container.getLoader().findContainedResources("TALEND-INF/local-configuration.properties"), container.getLocalDependencyRelativeResolver(), type, seviceLookupRef, builder));
            seviceLookupRef.set(services);
            AllServices allServices = new AllServices(services);
            container.set(AllServices.class, (Object)allServices);
            ComponentManager.this.containerServices(container, services);
            container.set(LightContainer.class, (Object)new LightContainer(){

                public ClassLoader classloader() {
                    return container.getLoader();
                }

                public <T> T findService(Class<T> key) {
                    return key.cast(services.get(key));
                }
            });
            HashMap componentDefaults = new HashMap();
            finder.findAnnotatedClasses(Internationalized.class).forEach(proxy -> {
                Object service = ComponentManager.this.internationalizationServiceFactory.create(proxy, (ClassLoader)container.getLoader());
                Object instance = ComponentManager.this.javaProxyEnricherFactory.asSerializable((ClassLoader)container.getLoader(), container.getId(), proxy.getName(), service, true);
                services.put(proxy, instance);
                registry.getServices().add(new ServiceMeta(instance, Collections.emptyList()));
            });
            finder.findAnnotatedMethods(Request.class).stream().map(Method::getDeclaringClass).distinct().filter(HttpClient.class::isAssignableFrom).forEach(proxy -> {
                Object instance = ((HttpClientFactory)HttpClientFactory.class.cast(services.get(HttpClientFactory.class))).create(proxy, null);
                services.put(proxy, instance);
                registry.getServices().add(new ServiceMeta(instance, Collections.emptyList()));
            });
            ServiceHelper serviceHelper = new ServiceHelper(ComponentManager.this.proxyGenerator, services);
            Map userServices = finder.findAnnotatedClasses(Service.class).stream().filter(s -> !services.containsKey(s)).collect(Collectors.toMap(Function.identity(), service -> ThreadHelper.runWithClassLoader(() -> serviceHelper.createServiceInstance((ClassLoader)container.getLoader(), container.getId(), (Class<?>)service), (ClassLoader)container.getLoader())));
            Injector injector = (Injector)Injector.class.cast(services.get(Injector.class));
            services.putAll(userServices);
            userServices.forEach((service, instance) -> {
                injector.inject(instance);
                this.doInvoke(container.getId(), instance, PostConstruct.class);
                services.put(service, instance);
                registry.getServices().add(new ServiceMeta(instance, Stream.of(service.getMethods()).filter(m -> Stream.of(m.getAnnotations()).anyMatch(a -> a.annotationType().isAnnotationPresent(ActionType.class))).map(serviceMethod -> this.createServiceMeta(container, services, componentDefaults, (Class<?>)service, instance, (Method)serviceMethod, (Class<?>)service)).collect(Collectors.toList())));
                ComponentManager.this.info("Added @Service " + service + " for container-id=" + container.getId());
            });
            ComponentContexts componentContexts = new ComponentContexts();
            container.set(ComponentContexts.class, (Object)componentContexts);
            if (isGeneric) return;
            Stream.of(PartitionMapper.class, Processor.class, Emitter.class, org.talend.sdk.component.api.standalone.DriverRunner.class).flatMap(a -> finder.findAnnotatedClasses(a).stream()).filter(t -> Modifier.isPublic(t.getModifiers())).forEach(type -> this.onComponent(container, registry, services, allServices, componentDefaults, componentContexts, (Class<?>)type, xbeanConverterCache));
        }

        private Filter createScanningFilter(Properties config) {
            String includes = config.getProperty("classloader.includes");
            String excludes = config.getProperty("classloader.excludes");
            if (includes == null && excludes == null) {
                return KnownClassesFilter.INSTANCE;
            }
            Filter accept = Optional.ofNullable(includes).map(String::trim).filter(v -> !v.isEmpty()).map(s -> s.split(",")).map(Filters::patterns).orElseGet(() -> name -> true);
            Filter reject = Optional.ofNullable(excludes).map(String::trim).filter(v -> !v.isEmpty()).map(s -> s.split(",")).map(Filters::patterns).orElseGet(() -> name -> false);
            if ("include-exclude".equals(config.getProperty("classloader.filter.strategy"))) {
                return new IncludeExcludeFilter(accept, reject);
            }
            return new ExcludeIncludeFilter(accept, reject);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onComponent(Container container, ContainerComponentRegistry registry, Map<Class<?>, Object> services, AllServices allServices, Map<String, AnnotatedElement> componentDefaults, ComponentContexts componentContexts, Class<?> type, Map<java.lang.reflect.Type, Optional<Converter>> xbeanConverterCache) {
            Components components = (Components)ComponentManager.this.findComponentsConfig(componentDefaults, type, container.getLoader(), Components.class, (Annotation)DEFAULT_COMPONENT);
            ComponentContextImpl context = new ComponentContextImpl(type);
            componentContexts.getContexts().put(type, context);
            ComponentManager.this.extensions.forEach(e -> {
                context.setCurrentExtension((ComponentExtension)e);
                try {
                    e.onComponent((ComponentExtension.ComponentContext)context);
                }
                finally {
                    context.setCurrentExtension(null);
                }
                if (context.getOwningExtension() == e) {
                    Optional.ofNullable(e.getExtensionServices(container.getId())).ifPresent(services::putAll);
                }
            });
            ComponentMetaBuilder builder = new ComponentMetaBuilder(container.getId(), allServices, components, componentDefaults.get(ComponentManager.this.getAnnotatedElementCacheKey(type)), context, ComponentManager.this.migrationHandlerFactory, ComponentManager.this.iconFinder, xbeanConverterCache);
            Thread thread = Thread.currentThread();
            ClassLoader old = thread.getContextClassLoader();
            thread.setContextClassLoader((ClassLoader)container.getLoader());
            try {
                this.visitor.visit(type, (ModelListener)builder, Mode.mode != Mode.UNSAFE && !context.isNoValidation());
            }
            finally {
                thread.setContextClassLoader(old);
            }
            Optional.ofNullable(builder.component).ifPresent(c -> {
                ComponentFamilyMeta componentFamilyMeta = registry.getComponents().computeIfAbsent(c.getName(), n -> c);
                if (componentFamilyMeta != c) {
                    if (componentFamilyMeta.getProcessors().keySet().stream().anyMatch(k -> c.getProcessors().containsKey(k))) {
                        throw new IllegalArgumentException("Conflicting processors in " + c);
                    }
                    if (componentFamilyMeta.getPartitionMappers().keySet().stream().anyMatch(k -> c.getPartitionMappers().containsKey(k))) {
                        throw new IllegalArgumentException("Conflicting mappers in " + c);
                    }
                    if (componentFamilyMeta.getDriverRunners().keySet().stream().anyMatch(k -> c.getDriverRunners().containsKey(k))) {
                        throw new IllegalArgumentException("Conflicting driver runners in " + c);
                    }
                    componentFamilyMeta.getProcessors().putAll(c.getProcessors());
                    componentFamilyMeta.getPartitionMappers().putAll(c.getPartitionMappers());
                    componentFamilyMeta.getDriverRunners().putAll(c.getDriverRunners());
                }
            });
            ComponentManager.this.info("Parsed component " + type + " for container-id=" + container.getId());
        }

        private ServiceMeta.ActionMeta createServiceMeta(Container container, Map<Class<?>, Object> services, Map<String, AnnotatedElement> componentDefaults, Class<?> service, Object instance, Method serviceMethod, Class<?> declaringClass) {
            Components components = (Components)ComponentManager.this.findComponentsConfig(componentDefaults, declaringClass, container.getLoader(), Components.class, (Annotation)DEFAULT_COMPONENT);
            Annotation marker = Stream.of(serviceMethod.getAnnotations()).filter(a -> a.annotationType().isAnnotationPresent(ActionType.class)).findFirst().orElseThrow(() -> new IllegalStateException("Something went wrong with " + serviceMethod));
            ActionType actionType = marker.annotationType().getAnnotation(ActionType.class);
            if (actionType.expectedReturnedType() != Object.class && !actionType.expectedReturnedType().isAssignableFrom(serviceMethod.getReturnType())) {
                throw new IllegalArgumentException("Can't use " + marker + " on " + serviceMethod + ", expected returned type: " + actionType.expectedReturnedType() + ", actual one: " + serviceMethod.getReturnType());
            }
            String component = "";
            try {
                component = Optional.ofNullable((String)String.class.cast(marker.annotationType().getMethod("family", new Class[0]).invoke((Object)marker, new Object[0]))).filter(c -> !c.isEmpty()).orElseGet(() -> ((Components)components).family());
            }
            catch (NoSuchMethodException e) {
                component = components.family();
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
            catch (InvocationTargetException e) {
                throw InvocationExceptionWrapper.toRuntimeException((InvocationTargetException)e);
            }
            if (component.isEmpty()) {
                throw new IllegalArgumentException("No component for " + serviceMethod + ", maybe add a @Components on your package " + service.getPackage());
            }
            String name = Stream.of("name", "value").map(mName -> {
                try {
                    return (String)String.class.cast(marker.annotationType().getMethod((String)mName, new Class[0]).invoke((Object)marker, new Object[0]));
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
                catch (InvocationTargetException e) {
                    throw InvocationExceptionWrapper.toRuntimeException((InvocationTargetException)e);
                }
                catch (NoSuchMethodException e) {
                    return null;
                }
            }).filter(Objects::nonNull).findFirst().orElse("default");
            Function parameterFactory = ComponentManager.this.createParametersFactory(container.getId(), serviceMethod, services, null);
            Object actionInstance = Modifier.isStatic(serviceMethod.getModifiers()) ? null : instance;
            Function<Map<String, String>, Object> invoker = arg -> ComponentManager.this.executeInContainer(container.getId(), () -> {
                try {
                    Object[] args = (Object[])parameterFactory.apply(arg);
                    return serviceMethod.invoke(actionInstance, args);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
                catch (InvocationTargetException e) {
                    throw InvocationExceptionWrapper.toRuntimeException((InvocationTargetException)e);
                }
            });
            return new ServiceMeta.ActionMeta(component, actionType.value(), name, serviceMethod.getGenericParameterTypes(), () -> (List)ComponentManager.this.executeInContainer(container.getId(), () -> ComponentManager.this.parameterModelService.buildServiceParameterMetas(serviceMethod, Optional.ofNullable(serviceMethod.getDeclaringClass().getPackage()).map(Package::getName).orElse(""), new BaseParameterEnricher.Context((LocalConfiguration)LocalConfiguration.class.cast(((AllServices)container.get(AllServices.class)).getServices().get(LocalConfiguration.class))))), invoker);
        }

        private Archive toArchive(String module, OriginalId originalId, ConfigurableClassLoader loader) {
            ArrayList<Archive> archives = new ArrayList<Archive>();
            Archive mainArchive = this.toArchive(module, Optional.ofNullable(originalId).map(OriginalId::getValue).orElse(module), loader);
            archives.add(mainArchive);
            URL mainUrl = this.archiveToUrl(mainArchive);
            try {
                archives.addAll(Collections.list(loader.getResources(this.dependenciesResource)).stream().map(url -> {
                    String rawUrl = url.toExternalForm();
                    try {
                        if (rawUrl.startsWith("nested")) {
                            return loader.getParent().getResource(rawUrl.substring("nested:".length(), rawUrl.indexOf("!/")));
                        }
                        return new URL(rawUrl.substring(0, rawUrl.length() - this.dependenciesResource.length()));
                    }
                    catch (MalformedURLException e) {
                        throw new IllegalArgumentException(e);
                    }
                }).filter(Objects::nonNull).filter(url -> {
                    if (Objects.equals(mainUrl, url)) {
                        return false;
                    }
                    if (mainUrl == null) {
                        return true;
                    }
                    String mainPath = mainUrl.getPath();
                    String path = url.getPath();
                    String marker = "!/MAVEN-INF/repository/";
                    if (path != null && path.contains("!/MAVEN-INF/repository/") && !mainPath.contains("!/MAVEN-INF/repository/")) {
                        String mvnPath = path.substring(path.lastIndexOf("!/MAVEN-INF/repository/") + "!/MAVEN-INF/repository/".length());
                        Path asFile = Optional.ofNullable(ComponentManager.this.container.getRootRepositoryLocationPath()).orElseGet(() -> PathFactory.get((String)".")).resolve(mvnPath);
                        return !Objects.equals(Files.toFile((URL)mainUrl).toPath(), asFile);
                    }
                    return true;
                }).map(nested -> {
                    if ("nested".equals(nested.getProtocol()) || nested.getPath() != null && nested.getPath().contains("!/MAVEN-INF/repository/")) {
                        JarInputStream jarStream = null;
                        try {
                            jarStream = new JarInputStream(nested.openStream());
                            log.debug("Found a nested resource for " + nested);
                            return new NestedJarArchive((URL)nested, jarStream, loader);
                        }
                        catch (IOException e) {
                            if (jarStream != null) {
                                try {
                                    jarStream.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            throw new IllegalStateException(e);
                        }
                    }
                    try {
                        return ClasspathArchive.archive((ClassLoader)loader, (URL)Files.toFile((URL)nested).toURI().toURL());
                    }
                    catch (MalformedURLException e) {
                        throw new IllegalStateException(e);
                    }
                }).collect(Collectors.toList()));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Error scanning " + module, e);
            }
            return new CompositeArchive(archives);
        }

        private URL archiveToUrl(Archive mainArchive) {
            if (JarArchive.class.isInstance(mainArchive)) {
                return ((JarArchive)JarArchive.class.cast(mainArchive)).getUrl();
            }
            if (FileArchive.class.isInstance(mainArchive)) {
                try {
                    return ((FileArchive)FileArchive.class.cast(mainArchive)).getDir().toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new IllegalStateException(e);
                }
            }
            if (NestedJarArchive.class.isInstance(mainArchive)) {
                return ((NestedJarArchive)NestedJarArchive.class.cast(mainArchive)).getRootMarker();
            }
            return null;
        }

        private Archive toArchive(String module, String moduleId, ConfigurableClassLoader loader) {
            block8: {
                Path file = Optional.of(PathFactory.get((String)module)).filter(x$0 -> java.nio.file.Files.exists(x$0, new LinkOption[0])).orElseGet(() -> ComponentManager.this.container.resolve(module));
                if (java.nio.file.Files.exists(file, new LinkOption[0])) {
                    try {
                        return ClasspathArchive.archive((ClassLoader)loader, (URL)file.toUri().toURL());
                    }
                    catch (MalformedURLException e) {
                        throw new IllegalArgumentException(e);
                    }
                }
                ComponentManager.this.info(module + " (" + moduleId + ") is not a file, will try to look it up from a nested maven repository");
                URL nestedJar = loader.getParent().getResource("MAVEN-INF/repository/" + module);
                if (nestedJar != null) {
                    InputStream nestedStream = null;
                    try {
                        nestedStream = nestedJar.openStream();
                        JarInputStream jarStream = new JarInputStream(nestedStream);
                        log.debug("Found a nested resource for " + module);
                        return new NestedJarArchive(nestedJar, jarStream, loader);
                    }
                    catch (IOException e) {
                        if (nestedStream == null) break block8;
                        try {
                            nestedStream.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            }
            throw new IllegalArgumentException("Module error: check that the module exist and is a jar or a directory. " + moduleId);
        }

        public void onClose(Container container) {
            Optional.ofNullable((ContainerComponentRegistry)container.get(ContainerComponentRegistry.class)).ifPresent(r -> {
                ContainerComponentRegistry registry = (ContainerComponentRegistry)container.remove(ContainerComponentRegistry.class);
                registry.getComponents().clear();
                registry.getServices().stream().filter(i -> !Proxy.isProxyClass(i.getInstance().getClass())).forEach(s -> this.doInvoke(container.getId(), s.getInstance(), PreDestroy.class));
                registry.getServices().clear();
            });
            Optional.ofNullable((AllServices)container.get(AllServices.class)).map(s -> s.getServices().get(Jsonb.class)).map(Jsonb.class::cast).ifPresent(jsonb -> {
                try {
                    jsonb.close();
                }
                catch (Exception e) {
                    log.warn(e.getMessage(), (Throwable)e);
                }
            });
        }

        private void doInvoke(String container, Object instance, Class<? extends Annotation> marker) {
            ComponentManager.this.executeInContainer(container, () -> {
                Class<?> instanceClass = instance.getClass();
                new ClassFinder(new Class[]{instanceClass.getName().contains("$$") ? instanceClass.getSuperclass() : instanceClass}).findAnnotatedMethods(marker).stream().filter(m -> Modifier.isPublic(m.getModifiers())).forEach(m -> {
                    try {
                        m.invoke(instance, new Object[0]);
                    }
                    catch (IllegalAccessException e) {
                        throw new IllegalStateException(e);
                    }
                    catch (InvocationTargetException e) {
                        throw InvocationExceptionWrapper.toRuntimeException((InvocationTargetException)e);
                    }
                });
                return null;
            });
        }

        public Updater(String dependenciesResource) {
            this.dependenciesResource = dependenciesResource;
        }
    }

    private static class SingletonHolder {
        protected static final AtomicReference<ComponentManager> CONTEXTUAL_INSTANCE = new AtomicReference();

        private SingletonHolder() {
        }

        private static ComponentManager buildNewComponentManager() {
            final Thread shutdownHook = SingletonHolder.buildShutDownHook();
            ComponentManager componentManager = new ComponentManager(ComponentManager.findM2()){
                private final AtomicBoolean closed;
                {
                    super(m2);
                    this.closed = new AtomicBoolean(false);
                    this.info("ComponentManager version: 1.64.7");
                    this.info("Creating the contextual ComponentManager instance " + ComponentManager.getIdentifiers());
                    ComponentManager.parallelIf(Boolean.getBoolean("talend.component.manager.plugins.parallel"), this.container.getDefinedNestedPlugin().stream().filter(p -> !this.hasPlugin((String)p))).forEach(this::addPlugin);
                    this.info("Components: " + this.availablePlugins());
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() {
                    log.debug("Closing ComponentManager.");
                    if (!this.closed.compareAndSet(false, true)) {
                        log.debug("ComponentManager already closed");
                        return;
                    }
                    try {
                        AtomicReference<ComponentManager> atomicReference = CONTEXTUAL_INSTANCE;
                        synchronized (atomicReference) {
                            if (CONTEXTUAL_INSTANCE.compareAndSet(this, null)) {
                                try {
                                    log.debug("ComponentManager : remove shutdown hook");
                                    Runtime.getRuntime().removeShutdownHook(shutdownHook);
                                }
                                catch (IllegalStateException illegalStateException) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    finally {
                        CONTEXTUAL_INSTANCE.set(null);
                        super.close();
                        this.info("Released the contextual ComponentManager instance " + ComponentManager.getIdentifiers());
                    }
                }

                Object readResolve() throws ObjectStreamException {
                    return new SerializationReplacer();
                }
            };
            try {
                Runtime.getRuntime().addShutdownHook(shutdownHook);
            }
            catch (IllegalStateException e) {
                log.warn("addShutdownHook: Shutdown already in progress.");
            }
            componentManager.info("Created the contextual ComponentManager instance " + ComponentManager.getIdentifiers());
            if (!CONTEXTUAL_INSTANCE.compareAndSet(null, componentManager)) {
                componentManager = CONTEXTUAL_INSTANCE.get();
            }
            return componentManager;
        }

        private static synchronized ComponentManager renew(ComponentManager current) {
            ComponentManager manager;
            if (current == null) {
                log.info("rebuild new component manager");
                manager = SingletonHolder.buildNewComponentManager();
            } else {
                manager = current;
            }
            return manager;
        }

        private static final Thread buildShutDownHook() {
            return new Thread(ComponentManager.class.getName() + "-" + ComponentManager.class.hashCode()){

                @Override
                public void run() {
                    Optional.ofNullable(CONTEXTUAL_INSTANCE.get()).ifPresent(ComponentManager::close);
                }
            };
        }

        static {
            ComponentManager componentManager = SingletonHolder.buildNewComponentManager();
        }
    }

    public static enum ComponentType {
        MAPPER{

            @Override
            public Map<String, ? extends ComponentFamilyMeta.BaseMeta> findMeta(ComponentFamilyMeta family) {
                return family.getPartitionMappers();
            }

            @Override
            Class<? extends Lifecycle> runtimeType() {
                return Mapper.class;
            }
        }
        ,
        PROCESSOR{

            @Override
            public Map<String, ? extends ComponentFamilyMeta.BaseMeta> findMeta(ComponentFamilyMeta family) {
                return family.getProcessors();
            }

            @Override
            Class<? extends Lifecycle> runtimeType() {
                return org.talend.sdk.component.runtime.output.Processor.class;
            }
        }
        ,
        DRIVER_RUNNER{

            @Override
            public Map<String, ? extends ComponentFamilyMeta.BaseMeta> findMeta(ComponentFamilyMeta family) {
                return family.getDriverRunners();
            }

            @Override
            Class<? extends Lifecycle> runtimeType() {
                return DriverRunner.class;
            }
        };


        public abstract Map<String, ? extends ComponentFamilyMeta.BaseMeta> findMeta(ComponentFamilyMeta var1);

        abstract Class<? extends Lifecycle> runtimeType();
    }

    public static class OriginalId {
        private final String value;

        public OriginalId(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OriginalId)) {
                return false;
            }
            OriginalId other = (OriginalId)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OriginalId;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "ComponentManager.OriginalId(value=" + this.getValue() + ")";
        }
    }

    public static class AllServices {
        private final Map<Class<?>, Object> services;

        public Map<Class<?>, Object> getServices() {
            return this.services;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AllServices)) {
                return false;
            }
            AllServices other = (AllServices)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<Class<?>, Object> this$services = this.getServices();
            Map<Class<?>, Object> other$services = other.getServices();
            return !(this$services == null ? other$services != null : !((Object)this$services).equals(other$services));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AllServices;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<Class<?>, Object> $services = this.getServices();
            result = result * 59 + ($services == null ? 43 : ((Object)$services).hashCode());
            return result;
        }

        public String toString() {
            return "ComponentManager.AllServices(services=" + this.getServices() + ")";
        }

        public AllServices(Map<Class<?>, Object> services) {
            this.services = services;
        }
    }

    private class ComponentMetaBuilder
    implements ModelListener {
        private final String plugin;
        private final AllServices services;
        private final Components components;
        private final AnnotatedElement familyAnnotationElement;
        private final ComponentContextImpl context;
        private final MigrationHandlerFactory migrationHandlerFactory;
        private final IconFinder iconFinder;
        private final Map<java.lang.reflect.Type, Optional<Converter>> xbeanConverterCache;
        private ComponentMetadataService metadataService = new ComponentMetadataService();
        private ComponentFamilyMeta component;

        public void onPartitionMapper(Class<?> type, PartitionMapper partitionMapper) {
            Constructor<?> constructor = Constructors.findConstructor(type);
            boolean infinite = partitionMapper.infinite();
            Supplier<List<ParameterMeta>> parameterMetas = Lazy.lazy(() -> (List)ComponentManager.this.executeInContainer(this.plugin, () -> {
                List<ParameterMeta> params = ComponentManager.this.parameterModelService.buildParameterMetas(constructor, this.getPackage(type), new BaseParameterEnricher.Context((LocalConfiguration)LocalConfiguration.class.cast(this.services.getServices().get(LocalConfiguration.class))));
                if (infinite && partitionMapper.stoppable()) {
                    this.addInfiniteMapperBuiltInParameters(type, params);
                }
                return params;
            }));
            Function parameterFactory = ComponentManager.this.createParametersFactory(this.plugin, constructor, this.services.getServices(), parameterMetas);
            String name = Optional.of(partitionMapper.name()).filter(n -> !n.isEmpty()).orElseGet(type::getName);
            ComponentFamilyMeta component = this.getOrCreateComponent(partitionMapper.family());
            Function<Map, Mapper> instantiator = this.context.getOwningExtension() != null && this.context.getOwningExtension().supports(Mapper.class) ? config -> (Mapper)ComponentManager.this.executeInContainer(this.plugin, () -> (Mapper)this.context.getOwningExtension().convert((ComponentExtension.ComponentInstance)new ComponentInstanceImpl(this.doInvoke(constructor, (Object[])parameterFactory.apply(config)), this.plugin, component.getName(), name), Mapper.class)) : config -> new PartitionMapperImpl(component.getName(), name, null, this.plugin, infinite, Optional.ofNullable(config).map(it -> it.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("$") || ((String)e.getKey()).contains(".$")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).orElseGet(Collections::emptyMap), this.doInvoke(constructor, (Object[])parameterFactory.apply(config)));
            Map<String, String> metadata = this.metadataService.getMetadata(type);
            component.getPartitionMappers().put(name, new ComponentFamilyMeta.PartitionMapperMeta(component, name, this.iconFinder.findIcon(type), this.findVersion(type), type, parameterMetas, args -> ComponentManager.this.propertyEditorRegistry.withCache(this.xbeanConverterCache, () -> (Mapper)instantiator.apply((Map)args)), Lazy.lazy(() -> this.migrationHandlerFactory.findMigrationHandler(parameterMetas, type, this.services)), !this.context.isNoValidation(), metadata));
        }

        public void onEmitter(Class<?> type, Emitter emitter) {
            Constructor<?> constructor = Constructors.findConstructor(type);
            Supplier<List<ParameterMeta>> parameterMetas = Lazy.lazy(() -> (List)ComponentManager.this.executeInContainer(this.plugin, () -> ComponentManager.this.parameterModelService.buildParameterMetas(constructor, this.getPackage(type), new BaseParameterEnricher.Context((LocalConfiguration)LocalConfiguration.class.cast(this.services.getServices().get(LocalConfiguration.class))))));
            Function parameterFactory = ComponentManager.this.createParametersFactory(this.plugin, constructor, this.services.getServices(), parameterMetas);
            String name = Optional.of(emitter.name()).filter(n -> !n.isEmpty()).orElseGet(type::getName);
            ComponentFamilyMeta component = this.getOrCreateComponent(emitter.family());
            Function<Map, Mapper> instantiator = this.context.getOwningExtension() != null && this.context.getOwningExtension().supports(Mapper.class) ? config -> (Mapper)ComponentManager.this.executeInContainer(this.plugin, () -> (Mapper)this.context.getOwningExtension().convert((ComponentExtension.ComponentInstance)new ComponentInstanceImpl(this.doInvoke(constructor, (Object[])parameterFactory.apply(config)), this.plugin, component.getName(), name), Mapper.class)) : config -> new LocalPartitionMapper(component.getName(), name, this.plugin, this.doInvoke(constructor, (Object[])parameterFactory.apply(config)));
            Map<String, String> metadata = this.metadataService.getMetadata(type);
            component.getPartitionMappers().put(name, new ComponentFamilyMeta.PartitionMapperMeta(component, name, this.iconFinder.findIcon(type), this.findVersion(type), type, parameterMetas, args -> ComponentManager.this.propertyEditorRegistry.withCache(this.xbeanConverterCache, () -> (Mapper)instantiator.apply((Map)args)), Lazy.lazy(() -> this.migrationHandlerFactory.findMigrationHandler(parameterMetas, type, this.services)), !this.context.isNoValidation(), metadata));
        }

        public void onProcessor(Class<?> type, Processor processor) {
            Constructor<?> constructor = Constructors.findConstructor(type);
            Supplier<List<ParameterMeta>> parameterMetas = Lazy.lazy(() -> (List)ComponentManager.this.executeInContainer(this.plugin, () -> {
                List<ParameterMeta> params = ComponentManager.this.parameterModelService.buildParameterMetas(constructor, this.getPackage(type), new BaseParameterEnricher.Context((LocalConfiguration)LocalConfiguration.class.cast(this.services.getServices().get(LocalConfiguration.class))));
                this.addProcessorsBuiltInParameters(type, params);
                return params;
            }));
            Function parameterFactory = ComponentManager.this.createParametersFactory(this.plugin, constructor, this.services.getServices(), parameterMetas);
            String name = Optional.of(processor.name()).filter(n -> !n.isEmpty()).orElseGet(type::getName);
            ComponentFamilyMeta component = this.getOrCreateComponent(processor.family());
            Function<Map, org.talend.sdk.component.runtime.output.Processor> instantiator = this.context.getOwningExtension() != null && this.context.getOwningExtension().supports(org.talend.sdk.component.runtime.output.Processor.class) ? config -> (org.talend.sdk.component.runtime.output.Processor)ComponentManager.this.executeInContainer(this.plugin, () -> (org.talend.sdk.component.runtime.output.Processor)this.context.getOwningExtension().convert((ComponentExtension.ComponentInstance)new ComponentInstanceImpl(this.doInvoke(constructor, (Object[])parameterFactory.apply(config)), this.plugin, component.getName(), name), org.talend.sdk.component.runtime.output.Processor.class)) : config -> new ProcessorImpl(this.component.getName(), name, this.plugin, Optional.ofNullable(config).map(it -> it.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("$") || ((String)e.getKey()).contains(".$")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).orElseGet(Collections::emptyMap), this.doInvoke(constructor, (Object[])parameterFactory.apply(config)));
            Map<String, String> metadata = this.metadataService.getMetadata(type);
            component.getProcessors().put(name, new ComponentFamilyMeta.ProcessorMeta(component, name, this.iconFinder.findIcon(type), this.findVersion(type), type, parameterMetas, args -> ComponentManager.this.propertyEditorRegistry.withCache(this.xbeanConverterCache, () -> (org.talend.sdk.component.runtime.output.Processor)instantiator.apply((Map)args)), Lazy.lazy(() -> this.migrationHandlerFactory.findMigrationHandler(parameterMetas, type, this.services)), !this.context.isNoValidation(), metadata));
        }

        private void addInfiniteMapperBuiltInParameters(Class<?> type, List<ParameterMeta> parameterMetas) {
            ParameterMeta root = parameterMetas.stream().filter(p -> p.getName().equals(p.getPath())).findFirst().orElseGet(() -> {
                ParameterMeta umbrella = new ParameterMeta(new ParameterMeta.Source(){

                    @Override
                    public String name() {
                        return "$configuration";
                    }

                    @Override
                    public Class<?> declaringClass() {
                        return Object.class;
                    }
                }, (java.lang.reflect.Type)((Object)Object.class), ParameterMeta.Type.OBJECT, "$configuration", "$configuration", new String[0], (List<ParameterMeta>)new ArrayList<ParameterMeta>(), (Collection<String>)new ArrayList<String>(), (Map<String, String>)new HashMap<String, String>(), true);
                parameterMetas.add(umbrella);
                return umbrella;
            });
            StreamingLongParamBuilder.StreamingMaxRecordsParamBuilder paramBuilder = new StreamingLongParamBuilder.StreamingMaxRecordsParamBuilder(root, type.getSimpleName(), (LocalConfiguration)LocalConfiguration.class.cast(this.services.services.get(LocalConfiguration.class)));
            ParameterMeta maxRecords = paramBuilder.newBulkParameter();
            ParameterMeta maxDuration = new StreamingLongParamBuilder.StreamingMaxDurationMsParamBuilder(root, type.getSimpleName(), (LocalConfiguration)LocalConfiguration.class.cast(this.services.services.get(LocalConfiguration.class))).newBulkParameter();
            String layoutOptions = maxRecords.getName() + "|" + maxDuration.getName();
            String layoutType = paramBuilder.getLayoutType();
            if (layoutType == null) {
                root.getMetadata().put("tcomp::ui::gridlayout::Advanced::value", layoutOptions);
                root.getMetadata().put("tcomp::ui::gridlayout::Main::value", root.getNestedParameters().stream().map(ParameterMeta::getName).collect(Collectors.joining("|")));
            } else if (!root.getMetadata().containsKey(layoutType)) {
                root.getMetadata().put(layoutType, layoutType.contains("gridlayout") ? layoutOptions : "true");
            } else if (layoutType.contains("gridlayout")) {
                String oldLayout = root.getMetadata().get(layoutType);
                root.getMetadata().put(layoutType, layoutOptions + "|" + oldLayout);
            }
            root.getNestedParameters().add(maxRecords);
            root.getNestedParameters().add(maxDuration);
        }

        private void addProcessorsBuiltInParameters(Class<?> type, List<ParameterMeta> parameterMetas) {
            MaxBatchSizeParamBuilder paramBuilder;
            ParameterMeta maxBatchSize;
            ParameterMeta root = parameterMetas.stream().filter(p -> p.getName().equals(p.getPath())).findFirst().orElseGet(() -> {
                ParameterMeta umbrella = new ParameterMeta(new ParameterMeta.Source(){

                    @Override
                    public String name() {
                        return "$configuration";
                    }

                    @Override
                    public Class<?> declaringClass() {
                        return Object.class;
                    }
                }, (java.lang.reflect.Type)((Object)Object.class), ParameterMeta.Type.OBJECT, "$configuration", "$configuration", new String[0], (List<ParameterMeta>)new ArrayList<ParameterMeta>(), (Collection<String>)new ArrayList<String>(), (Map<String, String>)new HashMap<String, String>(), true);
                parameterMetas.add(umbrella);
                return umbrella;
            });
            if (Stream.of(type.getMethods()).anyMatch(p -> p.isAnnotationPresent(AfterGroup.class)) && (maxBatchSize = (paramBuilder = new MaxBatchSizeParamBuilder(root, type.getSimpleName(), (LocalConfiguration)LocalConfiguration.class.cast(this.services.services.get(LocalConfiguration.class)))).newBulkParameter()) != null) {
                String layoutType = paramBuilder.getLayoutType();
                if (layoutType == null) {
                    root.getMetadata().put("tcomp::ui::gridlayout::Advanced::value", maxBatchSize.getName());
                    root.getMetadata().put("tcomp::ui::gridlayout::Main::value", root.getNestedParameters().stream().map(ParameterMeta::getName).collect(Collectors.joining("|")));
                } else if (!root.getMetadata().containsKey(layoutType)) {
                    root.getMetadata().put(layoutType, layoutType.contains("gridlayout") ? maxBatchSize.getName() : "true");
                } else if (layoutType.contains("gridlayout")) {
                    String oldLayout = root.getMetadata().get(layoutType);
                    root.getMetadata().put(layoutType, maxBatchSize.getName() + "|" + oldLayout);
                }
                root.getNestedParameters().add(maxBatchSize);
            }
        }

        public void onDriverRunner(Class<?> type, org.talend.sdk.component.api.standalone.DriverRunner processor) {
            Constructor<?> constructor = Constructors.findConstructor(type);
            Supplier<List<ParameterMeta>> parameterMetas = Lazy.lazy(() -> (List)ComponentManager.this.executeInContainer(this.plugin, () -> ComponentManager.this.parameterModelService.buildParameterMetas(constructor, this.getPackage(type), new BaseParameterEnricher.Context((LocalConfiguration)LocalConfiguration.class.cast(this.services.getServices().get(LocalConfiguration.class))))));
            Function parameterFactory = ComponentManager.this.createParametersFactory(this.plugin, constructor, this.services.getServices(), parameterMetas);
            String name = Optional.of(processor.name()).filter(n -> !n.isEmpty()).orElseGet(type::getName);
            ComponentFamilyMeta component = this.getOrCreateComponent(processor.family());
            Function<Map, DriverRunner> instantiator = this.context.getOwningExtension() != null && this.context.getOwningExtension().supports(DriverRunner.class) ? config -> (DriverRunner)ComponentManager.this.executeInContainer(this.plugin, () -> (DriverRunner)this.context.getOwningExtension().convert((ComponentExtension.ComponentInstance)new ComponentInstanceImpl(this.doInvoke(constructor, (Object[])parameterFactory.apply(config)), this.plugin, component.getName(), name), DriverRunner.class)) : config -> new DriverRunnerImpl(this.component.getName(), name, this.plugin, (Object)this.doInvoke(constructor, (Object[])parameterFactory.apply(config)));
            Map<String, String> metadata = this.metadataService.getMetadata(type);
            component.getDriverRunners().put(name, new ComponentFamilyMeta.DriverRunnerMeta(component, name, this.iconFinder.findIcon(type), this.findVersion(type), type, parameterMetas, args -> ComponentManager.this.propertyEditorRegistry.withCache(this.xbeanConverterCache, () -> (DriverRunner)instantiator.apply((Map)args)), Lazy.lazy(() -> this.migrationHandlerFactory.findMigrationHandler(parameterMetas, type, this.services)), !this.context.isNoValidation(), metadata));
        }

        private String getPackage(Class<?> type) {
            return Optional.ofNullable(type.getPackage()).map(Package::getName).orElse("");
        }

        private int findVersion(Class<?> type) {
            return Optional.ofNullable(type.getAnnotation(Version.class)).map(Version::value).orElse(1);
        }

        private ComponentFamilyMeta getOrCreateComponent(String component) {
            String comp = Optional.ofNullable(component).filter(s -> !s.isEmpty()).orElseGet(() -> ((Components)this.components).family());
            if (comp.isEmpty()) {
                throw new IllegalArgumentException("Missing component");
            }
            return this.component == null || !component.equals(this.component.getName()) ? (this.component = new ComponentFamilyMeta(this.plugin, Arrays.asList(this.components.categories()), this.iconFinder.findIcon(this.familyAnnotationElement), comp, Class.class.isInstance(this.familyAnnotationElement) ? this.getPackage((Class)Class.class.cast(this.familyAnnotationElement)) : "")) : this.component;
        }

        private Serializable doInvoke(Constructor<?> constructor, Object[] args) {
            return (Serializable)ComponentManager.this.executeInContainer(this.plugin, () -> {
                try {
                    return (Serializable)Serializable.class.cast(constructor.newInstance(args));
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
                catch (ClassCastException e) {
                    throw new IllegalArgumentException(constructor + " should return a Serializable", e);
                }
                catch (InvocationTargetException e) {
                    throw InvocationExceptionWrapper.toRuntimeException((InvocationTargetException)e);
                }
                catch (InstantiationException e) {
                    throw new IllegalArgumentException(e);
                }
            });
        }

        public ComponentMetaBuilder(String plugin, AllServices services, Components components, AnnotatedElement familyAnnotationElement, ComponentContextImpl context, MigrationHandlerFactory migrationHandlerFactory, IconFinder iconFinder, Map<java.lang.reflect.Type, Optional<Converter>> xbeanConverterCache) {
            this.plugin = plugin;
            this.services = services;
            this.components = components;
            this.familyAnnotationElement = familyAnnotationElement;
            this.context = context;
            this.migrationHandlerFactory = migrationHandlerFactory;
            this.iconFinder = iconFinder;
            this.xbeanConverterCache = xbeanConverterCache;
        }
    }

    private static class SerializationReplacer
    implements Serializable {
        Object readResolve() throws ObjectStreamException {
            return ComponentManager.instance();
        }
    }
}

