/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.asm;

import java.io.InputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.xbean.asm9.ClassReader;
import org.apache.xbean.asm9.ClassVisitor;
import org.apache.xbean.asm9.ClassWriter;
import org.apache.xbean.asm9.Label;
import org.apache.xbean.asm9.MethodVisitor;
import org.apache.xbean.asm9.Type;
import org.apache.xbean.asm9.shade.commons.EmptyVisitor;
import org.talend.sdk.component.api.service.interceptor.InterceptorHandler;
import org.talend.sdk.component.api.service.interceptor.Intercepts;
import org.talend.sdk.component.runtime.manager.asm.Unsafes;
import org.talend.sdk.component.runtime.manager.interceptor.InterceptorHandlerFacade;

public class ProxyGenerator
implements Serializable {
    private static final String FIELD_INTERCEPTOR_HANDLER = "tacokitIntDecHandler";
    private static final String FIELD_INTERCEPTED_METHODS = "tacokitIntDecMethods";
    private static final ProxyGenerator SINGLETON = new ProxyGenerator();
    private final int javaVersion = this.determineDefaultJavaVersion();

    private int determineDefaultJavaVersion() {
        String javaVersionProp = System.getProperty("java.version", "1.8");
        if (javaVersionProp.startsWith("1.8")) {
            return 52;
        }
        return 52;
    }

    private void createSerialisation(ClassWriter cw, String pluginId, String key) {
        MethodVisitor mv = cw.visitMethod(1, "writeReplace", "()Ljava/lang/Object;", null, new String[]{Type.getType(ObjectStreamException.class).getInternalName()});
        mv.visitCode();
        mv.visitTypeInsn(187, "org/talend/sdk/component/runtime/serialization/SerializableService");
        mv.visitInsn(89);
        mv.visitLdcInsn((Object)pluginId);
        mv.visitLdcInsn((Object)key);
        mv.visitMethodInsn(183, "org/talend/sdk/component/runtime/serialization/SerializableService", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", false);
        mv.visitInsn(176);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private String createConstructor(ClassWriter cw, Class<?> classToProxy, String classFileName, String proxyClassFileName, Constructor<?> constructor, boolean withInterceptors) {
        try {
            Constructor<Object> superDefaultCt;
            String parentClassFileName;
            String[] exceptions = null;
            if (classToProxy.isInterface()) {
                parentClassFileName = Type.getInternalName(Object.class);
                superDefaultCt = Object.class.getConstructor(new Class[0]);
            } else {
                parentClassFileName = classFileName;
                if (constructor == null) {
                    superDefaultCt = classToProxy.getConstructor(new Class[0]);
                } else {
                    superDefaultCt = constructor;
                    Class<?>[] exceptionTypes = constructor.getExceptionTypes();
                    exceptions = exceptionTypes.length == 0 ? null : new String[exceptionTypes.length];
                    for (int i = 0; i < exceptionTypes.length; ++i) {
                        exceptions[i] = Type.getInternalName(exceptionTypes[i]);
                    }
                }
            }
            String descriptor = Type.getConstructorDescriptor(superDefaultCt);
            MethodVisitor mv = cw.visitMethod(1, "<init>", descriptor, null, exceptions);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            if (constructor != null) {
                for (int i = 1; i <= constructor.getParameterTypes().length; ++i) {
                    mv.visitVarInsn(25, i);
                }
            }
            mv.visitMethodInsn(183, parentClassFileName, "<init>", descriptor, false);
            if (withInterceptors) {
                mv.visitVarInsn(25, 0);
                mv.visitInsn(1);
                mv.visitFieldInsn(181, proxyClassFileName, FIELD_INTERCEPTOR_HANDLER, Type.getDescriptor(InterceptorHandler.class));
            }
            mv.visitInsn(177);
            mv.visitMaxs(-1, -1);
            mv.visitEnd();
            return parentClassFileName;
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
    }

    private void delegateMethod(ClassWriter cw, Method method, String proxyClassFileName, int methodIndex) {
        Class<?> returnType = method.getReturnType();
        Class<?>[] parameterTypes = method.getParameterTypes();
        Class<?>[] exceptionTypes = method.getExceptionTypes();
        int modifiers = method.getModifiers();
        if (Modifier.isFinal(modifiers) || Modifier.isStatic(modifiers)) {
            throw new IllegalStateException("It's not possible to proxy a final or static method: " + method.getDeclaringClass().getName() + " " + method.getName());
        }
        int modifier = modifiers & 0x85;
        MethodVisitor mv = cw.visitMethod(modifier, method.getName(), Type.getMethodDescriptor((Method)method), null, null);
        mv.visitCode();
        Label l0 = new Label();
        Label l1 = new Label();
        Label l2 = new Label();
        if (exceptionTypes.length > 0) {
            mv.visitTryCatchBlock(l0, l1, l2, "java/lang/reflect/InvocationTargetException");
        }
        mv.visitLabel(l0);
        String classNameToOverride = method.getDeclaringClass().getName().replace('.', '/');
        mv.visitLdcInsn((Object)Type.getType((String)("L" + classNameToOverride + ";")));
        mv.visitLdcInsn((Object)method.getName());
        this.createArrayDefinition(mv, parameterTypes.length, Class.class);
        int length = 1;
        for (int i = 0; i < parameterTypes.length; ++i) {
            mv.visitInsn(89);
            Class<?> parameterType = parameterTypes[i];
            this.pushIntOntoStack(mv, i);
            if (parameterType.isPrimitive()) {
                String wrapperType = this.getWrapperType(parameterType);
                mv.visitFieldInsn(178, wrapperType, "TYPE", "Ljava/lang/Class;");
            } else {
                mv.visitLdcInsn((Object)Type.getType(parameterType));
            }
            mv.visitInsn(83);
            if (Long.TYPE.equals(parameterType) || Double.TYPE.equals(parameterType)) {
                length += 2;
                continue;
            }
            ++length;
        }
        Label l4 = new Label();
        mv.visitLabel(l4);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, proxyClassFileName, FIELD_INTERCEPTOR_HANDLER, Type.getDescriptor(InterceptorHandler.class));
        mv.visitFieldInsn(178, proxyClassFileName, FIELD_INTERCEPTED_METHODS, Type.getDescriptor(Method[].class));
        if (methodIndex < 128) {
            mv.visitIntInsn(16, methodIndex);
        } else if (methodIndex < 32267) {
            mv.visitIntInsn(17, methodIndex);
        } else {
            throw new IllegalStateException("Sorry, we only support Classes with 2^15 methods...");
        }
        mv.visitInsn(50);
        this.pushMethodParameterArray(mv, parameterTypes);
        mv.visitMethodInsn(185, Type.getInternalName(InterceptorHandler.class), "invoke", "(Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;", true);
        mv.visitTypeInsn(192, this.getCastType(returnType));
        if (returnType.isPrimitive() && !Void.TYPE.equals(returnType)) {
            mv.visitMethodInsn(182, this.getWrapperType(returnType), this.getPrimitiveMethod(returnType), "()" + Type.getDescriptor(returnType), false);
        }
        mv.visitLabel(l1);
        if (!Void.TYPE.equals(returnType)) {
            mv.visitInsn(this.getReturnInsn(returnType));
        } else {
            mv.visitInsn(87);
            mv.visitInsn(177);
        }
        if (exceptionTypes.length > 0) {
            mv.visitLabel(l2);
            mv.visitVarInsn(58, length);
            Label l5 = new Label();
            mv.visitLabel(l5);
            for (int i = 0; i < exceptionTypes.length; ++i) {
                Class<?> exceptionType = exceptionTypes[i];
                mv.visitLdcInsn((Object)Type.getType((String)("L" + exceptionType.getCanonicalName().replace('.', '/') + ";")));
                mv.visitVarInsn(25, length);
                mv.visitMethodInsn(182, "java/lang/reflect/InvocationTargetException", "getCause", "()Ljava/lang/Throwable;", false);
                mv.visitMethodInsn(182, "java/lang/Object", "getClass", "()Ljava/lang/Class;", false);
                mv.visitMethodInsn(182, "java/lang/Object", "equals", "(Ljava/lang/Object;)Z", false);
                Label l6 = new Label();
                mv.visitJumpInsn(153, l6);
                Label l7 = new Label();
                mv.visitLabel(l7);
                mv.visitVarInsn(25, length);
                mv.visitMethodInsn(182, "java/lang/reflect/InvocationTargetException", "getCause", "()Ljava/lang/Throwable;", false);
                mv.visitTypeInsn(192, this.getCastType(exceptionType));
                mv.visitInsn(191);
                mv.visitLabel(l6);
                if (i != exceptionTypes.length - 1) continue;
                mv.visitTypeInsn(187, "java/lang/reflect/UndeclaredThrowableException");
                mv.visitInsn(89);
                mv.visitVarInsn(25, length);
                mv.visitMethodInsn(183, "java/lang/reflect/UndeclaredThrowableException", "<init>", "(Ljava/lang/Throwable;)V", false);
                mv.visitInsn(191);
            }
        }
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void pushMethodParameterArray(MethodVisitor mv, Class<?>[] parameterTypes) {
        this.createArrayDefinition(mv, parameterTypes.length, Object.class);
        int index = 1;
        for (int i = 0; i < parameterTypes.length; ++i) {
            mv.visitInsn(89);
            Class<?> parameterType = parameterTypes[i];
            this.pushIntOntoStack(mv, i);
            if (parameterType.isPrimitive()) {
                String wrapperType = this.getWrapperType(parameterType);
                mv.visitVarInsn(this.getVarInsn(parameterType), index);
                mv.visitMethodInsn(184, wrapperType, "valueOf", "(" + Type.getDescriptor(parameterType) + ")L" + wrapperType + ";", false);
                mv.visitInsn(83);
                if (Long.TYPE.equals(parameterType) || Double.TYPE.equals(parameterType)) {
                    index += 2;
                    continue;
                }
                ++index;
                continue;
            }
            mv.visitVarInsn(25, index);
            mv.visitInsn(83);
            ++index;
        }
    }

    private int getVarInsn(Class<?> type) {
        if (Integer.TYPE.equals(type)) {
            return 21;
        }
        if (Boolean.TYPE.equals(type)) {
            return 21;
        }
        if (Character.TYPE.equals(type)) {
            return 21;
        }
        if (Byte.TYPE.equals(type)) {
            return 21;
        }
        if (Short.TYPE.equals(type)) {
            return 21;
        }
        if (Float.TYPE.equals(type)) {
            return 23;
        }
        if (Long.TYPE.equals(type)) {
            return 22;
        }
        if (Double.TYPE.equals(type)) {
            return 24;
        }
        throw new IllegalStateException("Type: " + type.getCanonicalName() + " is not a primitive type");
    }

    private void pushIntOntoStack(MethodVisitor mv, int i) {
        if (i == 0) {
            mv.visitInsn(3);
        } else if (i == 1) {
            mv.visitInsn(4);
        } else if (i == 2) {
            mv.visitInsn(5);
        } else if (i == 3) {
            mv.visitInsn(6);
        } else if (i == 4) {
            mv.visitInsn(7);
        } else if (i == 5) {
            mv.visitInsn(8);
        } else if (i > 5 && i <= 255) {
            mv.visitIntInsn(16, i);
        } else {
            mv.visitIntInsn(17, i);
        }
    }

    private void createArrayDefinition(MethodVisitor mv, int size, Class<?> type) {
        if (size < 0) {
            throw new IllegalStateException("Array size cannot be less than zero");
        }
        this.pushIntOntoStack(mv, size);
        mv.visitTypeInsn(189, type.getCanonicalName().replace('.', '/'));
    }

    private <T> String getSignedClassProxyName(Class<T> classToProxy) {
        return "org.talend.generated.proxy.signed." + classToProxy.getName();
    }

    private String fixPreservedPackages(String name) {
        String proxyClassName = name;
        proxyClassName = this.fixPreservedPackage(proxyClassName, "java.");
        proxyClassName = this.fixPreservedPackage(proxyClassName, "javax.");
        proxyClassName = this.fixPreservedPackage(proxyClassName, "sun.misc.");
        return proxyClassName;
    }

    private String fixPreservedPackage(String className, String forbiddenPackagePrefix) {
        String fixedClassName = className;
        if (className.startsWith(forbiddenPackagePrefix)) {
            fixedClassName = "org.talend.generated.proxy.custom." + className.substring(forbiddenPackagePrefix.length());
        }
        return fixedClassName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int findJavaVersion(Class<?> from) {
        String resource = from.getName().replace('.', '/') + ".class";
        try (InputStream stream = from.getClassLoader().getResourceAsStream(resource);){
            if (stream == null) {
                int n = this.javaVersion;
                return n;
            }
            ClassReader reader = new ClassReader(stream);
            VersionVisitor visitor = new VersionVisitor();
            reader.accept((ClassVisitor)visitor, 7);
            if (visitor.version == 0) return this.javaVersion;
            int n = visitor.version;
            return n;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.javaVersion;
    }

    public boolean hasInterceptors(Class<?> type) {
        return Stream.concat(Stream.of(type.getAnnotations()), Stream.of(type.getMethods()).flatMap(m -> Stream.of(m.getAnnotations()))).anyMatch(this::isInterceptor);
    }

    private boolean isInterceptor(Annotation a) {
        return a.annotationType().isAnnotationPresent(Intercepts.class);
    }

    public boolean isSerializable(Class<?> type) {
        if (Serializable.class.isAssignableFrom(type)) {
            return true;
        }
        try {
            type.getMethod("writeReplace", new Class[0]);
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    public Class<?> generateProxy(ClassLoader loader, Class<?> classToProxy, String plugin, String key) {
        Method[] interceptedMethods;
        boolean hasInterceptors;
        ClassWriter cw = new ClassWriter(2);
        String proxyClassName = this.fixPreservedPackages((classToProxy.getSigners() != null ? this.getSignedClassProxyName(classToProxy) : classToProxy.getName()) + "$$TalendServiceProxy");
        String classFileName = proxyClassName.replace('.', '/');
        String[] interfaceNames = new String[]{Type.getInternalName(Serializable.class)};
        String superClassName = Type.getInternalName(classToProxy);
        cw.visit(this.findJavaVersion(classToProxy), 4129, classFileName, null, superClassName, interfaceNames);
        cw.visitSource(classFileName + ".java", null);
        if (!Serializable.class.isAssignableFrom(classToProxy)) {
            try {
                classToProxy.getMethod("writeReplace", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                this.createSerialisation(cw, plugin, key);
            }
        }
        if (hasInterceptors = this.hasInterceptors(classToProxy)) {
            cw.visitField(2, FIELD_INTERCEPTOR_HANDLER, Type.getDescriptor(InterceptorHandler.class), null, null).visitEnd();
            cw.visitField(10, FIELD_INTERCEPTED_METHODS, Type.getDescriptor(Method[].class), null, null).visitEnd();
        }
        this.createConstructor(cw, classToProxy, superClassName, classFileName, Stream.of(classToProxy.getDeclaredConstructors()).filter(c -> {
            int modifiers = c.getModifiers();
            return Modifier.isPublic(modifiers) || Modifier.isProtected(modifiers);
        }).sorted((o1, o2) -> {
            int mod1 = o1.getModifiers();
            int mod2 = o2.getModifiers();
            if (Modifier.isProtected(mod1) && !Modifier.isPublic(mod2)) {
                return 1;
            }
            if (Modifier.isProtected(mod2) && !Modifier.isPublic(mod1)) {
                return -1;
            }
            return o1.getParameterCount() - o2.getParameterCount();
        }).findFirst().orElseThrow(() -> new IllegalArgumentException(classToProxy + " has no default constructor, put at least a protected one")), hasInterceptors);
        if (hasInterceptors) {
            Collection globalInterceptors = Stream.of(classToProxy.getAnnotations()).filter(this::isInterceptor).collect(Collectors.toList());
            AtomicInteger methodIndex = new AtomicInteger();
            interceptedMethods = (Method[])Stream.of(classToProxy.getMethods()).filter(m -> !"<init>".equals(m.getName()) && (!globalInterceptors.isEmpty() || Stream.of(m.getAnnotations()).anyMatch(this::isInterceptor))).peek(method -> this.delegateMethod(cw, (Method)method, classFileName, methodIndex.getAndIncrement())).toArray(Method[]::new);
        } else {
            interceptedMethods = null;
        }
        Class objectClass = Unsafes.defineAndLoadClass(loader, proxyClassName, cw.toByteArray());
        if (hasInterceptors) {
            try {
                Field interceptedMethodsField = objectClass.getDeclaredField(FIELD_INTERCEPTED_METHODS);
                interceptedMethodsField.setAccessible(true);
                interceptedMethodsField.set(null, interceptedMethods);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return objectClass;
    }

    public void initialize(Object proxy, InterceptorHandler handler) {
        try {
            Field invocationHandlerField = proxy.getClass().getDeclaredField(FIELD_INTERCEPTOR_HANDLER);
            invocationHandlerField.setAccessible(true);
            invocationHandlerField.set(proxy, handler);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
    }

    public InterceptorHandlerFacade getHandler(Object instance) {
        try {
            Field invocationHandlerField = instance.getClass().getDeclaredField(FIELD_INTERCEPTOR_HANDLER);
            if (!invocationHandlerField.isAccessible()) {
                invocationHandlerField.setAccessible(true);
            }
            return (InterceptorHandlerFacade)InterceptorHandlerFacade.class.cast(invocationHandlerField.get(instance));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
    }

    private String getWrapperType(Class<?> type) {
        if (Integer.TYPE.equals(type)) {
            return Integer.class.getCanonicalName().replace('.', '/');
        }
        if (Boolean.TYPE.equals(type)) {
            return Boolean.class.getCanonicalName().replace('.', '/');
        }
        if (Character.TYPE.equals(type)) {
            return Character.class.getCanonicalName().replace('.', '/');
        }
        if (Byte.TYPE.equals(type)) {
            return Byte.class.getCanonicalName().replace('.', '/');
        }
        if (Short.TYPE.equals(type)) {
            return Short.class.getCanonicalName().replace('.', '/');
        }
        if (Float.TYPE.equals(type)) {
            return Float.class.getCanonicalName().replace('.', '/');
        }
        if (Long.TYPE.equals(type)) {
            return Long.class.getCanonicalName().replace('.', '/');
        }
        if (Double.TYPE.equals(type)) {
            return Double.class.getCanonicalName().replace('.', '/');
        }
        if (Void.TYPE.equals(type)) {
            return Void.class.getCanonicalName().replace('.', '/');
        }
        throw new IllegalStateException("Type: " + type.getCanonicalName() + " is not a primitive type");
    }

    private int getReturnInsn(Class<?> type) {
        if (type.isPrimitive()) {
            if (Void.TYPE.equals(type)) {
                return 177;
            }
            if (Integer.TYPE.equals(type)) {
                return 172;
            }
            if (Boolean.TYPE.equals(type)) {
                return 172;
            }
            if (Character.TYPE.equals(type)) {
                return 172;
            }
            if (Byte.TYPE.equals(type)) {
                return 172;
            }
            if (Short.TYPE.equals(type)) {
                return 172;
            }
            if (Float.TYPE.equals(type)) {
                return 174;
            }
            if (Long.TYPE.equals(type)) {
                return 173;
            }
            if (Double.TYPE.equals(type)) {
                return 175;
            }
        }
        return 176;
    }

    private String getCastType(Class<?> returnType) {
        if (returnType.isPrimitive()) {
            return this.getWrapperType(returnType);
        }
        return Type.getInternalName(returnType);
    }

    private String getPrimitiveMethod(Class<?> type) {
        if (Integer.TYPE.equals(type)) {
            return "intValue";
        }
        if (Boolean.TYPE.equals(type)) {
            return "booleanValue";
        }
        if (Character.TYPE.equals(type)) {
            return "charValue";
        }
        if (Byte.TYPE.equals(type)) {
            return "byteValue";
        }
        if (Short.TYPE.equals(type)) {
            return "shortValue";
        }
        if (Float.TYPE.equals(type)) {
            return "floatValue";
        }
        if (Long.TYPE.equals(type)) {
            return "longValue";
        }
        if (Double.TYPE.equals(type)) {
            return "doubleValue";
        }
        throw new IllegalStateException("Type: " + type.getCanonicalName() + " is not a primitive type");
    }

    Object writeReplace() throws ObjectStreamException {
        return new Replacer();
    }

    private static class VersionVisitor
    extends EmptyVisitor {
        private int version;

        private VersionVisitor() {
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
            this.version = version;
        }
    }

    private static class Replacer
    implements Serializable {
        Object readResolve() throws ObjectStreamException {
            return SINGLETON;
        }
    }
}

