/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.service;

import java.io.InputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.stream.Stream;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.runtime.record.json.PojoJsonbProvider;
import org.talend.sdk.component.runtime.serialization.SerializableService;

public class GenericOrPojoJsonb
implements Jsonb,
PojoJsonbProvider,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(GenericOrPojoJsonb.class);
    private final String plugin;
    private final Jsonb jsonb;
    private final Jsonb pojoMapper;

    public Jsonb get() {
        return this.pojoMapper;
    }

    public void close() {
        Stream.of(this.jsonb, this.pojoMapper).filter(Objects::nonNull).forEach(it -> {
            try {
                it.close();
            }
            catch (Exception e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
        });
    }

    public <T> T fromJson(String str, Class<T> type) throws JsonbException {
        return (T)this.jsonb.fromJson(str, type);
    }

    public <T> T fromJson(String str, Type runtimeType) throws JsonbException {
        return (T)this.jsonb.fromJson(str, runtimeType);
    }

    public <T> T fromJson(Reader reader, Class<T> type) throws JsonbException {
        return (T)this.jsonb.fromJson(reader, type);
    }

    public <T> T fromJson(Reader reader, Type runtimeType) throws JsonbException {
        return (T)this.jsonb.fromJson(reader, runtimeType);
    }

    public <T> T fromJson(InputStream stream, Class<T> type) throws JsonbException {
        return (T)this.jsonb.fromJson(stream, type);
    }

    public <T> T fromJson(InputStream stream, Type runtimeType) throws JsonbException {
        return (T)this.jsonb.fromJson(stream, runtimeType);
    }

    public String toJson(Object object) throws JsonbException {
        return this.jsonb.toJson(object);
    }

    public String toJson(Object object, Type runtimeType) throws JsonbException {
        return this.jsonb.toJson(object, runtimeType);
    }

    public void toJson(Object object, Writer writer) throws JsonbException {
        this.jsonb.toJson(object, writer);
    }

    public void toJson(Object object, Type runtimeType, Writer writer) throws JsonbException {
        this.jsonb.toJson(object, runtimeType, writer);
    }

    public void toJson(Object object, OutputStream stream) throws JsonbException {
        this.jsonb.toJson(object, stream);
    }

    public void toJson(Object object, Type runtimeType, OutputStream stream) throws JsonbException {
        this.jsonb.toJson(object, runtimeType, stream);
    }

    Object writeReplace() throws ObjectStreamException {
        return new SerializableService(this.plugin, Jsonb.class.getName());
    }

    public GenericOrPojoJsonb(String plugin, Jsonb jsonb, Jsonb pojoMapper) {
        this.plugin = plugin;
        this.jsonb = jsonb;
        this.pojoMapper = pojoMapper;
    }

    public Jsonb getPojoMapper() {
        return this.pojoMapper;
    }
}

