/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.extension;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.talend.sdk.component.api.component.DatabaseMapping;
import org.talend.sdk.component.api.input.Emitter;
import org.talend.sdk.component.api.input.PartitionMapper;
import org.talend.sdk.component.api.processor.Processor;
import org.talend.sdk.component.api.service.schema.FixedSchema;
import org.talend.sdk.component.api.standalone.DriverRunner;
import org.talend.sdk.component.spi.component.ComponentMetadataEnricher;

public class ComponentSchemaEnricher
implements ComponentMetadataEnricher {
    public static final String SCHEMA_MAPPING = "tcomp::ui::schema::mapping";
    public static final String SCHEMA_MAPPER = "tcomp::ui::schema::mapper";
    public static final String FIXED_SCHEMA_META_PREFIX = "tcomp::ui::schema::fixed";
    public static final String FIXED_SCHEMA_FLOWS_META_PREFIX = "tcomp::ui::schema::flows::fixed";
    private static final Set<Class<? extends Annotation>> SUPPORTED_ANNOTATIONS = new HashSet<Class>(Arrays.asList(PartitionMapper.class, Emitter.class, Processor.class, DriverRunner.class));

    public Map<String, String> onComponent(Type type, Annotation[] annotations) {
        if (Stream.of(annotations).map(Annotation::annotationType).noneMatch(SUPPORTED_ANNOTATIONS::contains)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> metadata = new HashMap<String, String>();
        Optional<DatabaseMapping> mappings = Arrays.stream(annotations).filter(a -> a.annotationType().equals(DatabaseMapping.class)).findFirst().map(DatabaseMapping.class::cast);
        if (mappings.isPresent()) {
            DatabaseMapping mapping = mappings.get();
            metadata.put(SCHEMA_MAPPING, mapping.value());
            if ("custom".equals(mapping.value())) {
                metadata.put(SCHEMA_MAPPER, mapping.mapping());
            }
        }
        Optional<FixedSchema> fixed = Arrays.stream(annotations).filter(a -> a.annotationType().equals(FixedSchema.class)).findFirst().map(FixedSchema.class::cast);
        if (!fixed.isPresent()) {
            return metadata;
        }
        FixedSchema fixedSchema = fixed.get();
        metadata.put(FIXED_SCHEMA_META_PREFIX, fixedSchema.value());
        if (fixedSchema.flows().length > 0) {
            metadata.put(FIXED_SCHEMA_FLOWS_META_PREFIX, String.join((CharSequence)",", fixedSchema.flows()));
        } else {
            metadata.put(FIXED_SCHEMA_FLOWS_META_PREFIX, "__default__");
        }
        return metadata;
    }
}

