/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.reflect;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.api.component.Metadatas;
import org.talend.sdk.component.api.input.Emitter;
import org.talend.sdk.component.api.input.PartitionMapper;
import org.talend.sdk.component.api.meta.Documentation;
import org.talend.sdk.component.spi.component.ComponentMetadataEnricher;

public class ComponentMetadataService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ComponentMetadataService.class);
    private List<ComponentMetadataEnricher> enrichers = StreamSupport.stream(ServiceLoader.load(ComponentMetadataEnricher.class).spliterator(), false).collect(Collectors.toList());
    private static final String DOCUMENTATION_KEY = "documentation::value";
    public static final String MAPPER_INFINITE = "mapper::infinite";
    public static final String MAPPER_OPTIONAL_ROW = "mapper::optionalRow";

    public Map<String, String> getMetadata(Class<?> clazz) {
        HashMap<String, String> metas = new HashMap<String, String>();
        Optional.ofNullable(clazz.getAnnotation(Documentation.class)).ifPresent(d -> metas.put(DOCUMENTATION_KEY, d.value()));
        Optional.ofNullable(clazz.getAnnotation(Metadatas.class)).ifPresent(m -> Arrays.stream(m.value()).forEach(meta -> metas.put(meta.key(), meta.value())));
        Optional.ofNullable(clazz.getAnnotation(PartitionMapper.class)).ifPresent(pm -> {
            metas.put(MAPPER_INFINITE, Boolean.toString(pm.infinite()));
            metas.put(MAPPER_OPTIONAL_ROW, Boolean.toString(pm.optionalRow()));
        });
        Optional.ofNullable(clazz.getAnnotation(Emitter.class)).ifPresent(e -> {
            metas.put(MAPPER_INFINITE, "false");
            metas.put(MAPPER_OPTIONAL_ROW, Boolean.toString(e.optionalRow()));
        });
        this.enrichers.stream().sorted(Comparator.comparing(ComponentMetadataEnricher::order)).forEach(enricher -> enricher.onComponent((Type)clazz, clazz.getAnnotations()).forEach((k, v) -> {
            if (metas.containsKey(k)) {
                log.warn("SPI {} (order: {}) overrides metadata {}.", new Object[]{enricher.getClass().getName(), enricher.order(), k});
            }
            metas.put((String)k, (String)v);
        }));
        return metas;
    }
}

