/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.testing.spark.junit5.internal;

import java.io.File;
import java.lang.annotation.Annotation;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;
import org.talend.sdk.component.junit.base.junit5.JUnit5InjectionSupport;
import org.talend.sdk.component.junit.base.junit5.TemporaryFolder;
import org.talend.sdk.component.junit.base.junit5.internal.TemporaryFolderExtension;
import org.talend.sdk.component.runtime.testing.spark.internal.BaseSpark;
import org.talend.sdk.component.runtime.testing.spark.internal.SparkVersions;
import org.talend.sdk.component.runtime.testing.spark.junit5.SparkInject;
import org.talend.sdk.component.runtime.testing.spark.junit5.WithSpark;

public class SparkExtension
extends BaseSpark<SparkExtension>
implements BeforeAllCallback,
AfterAllCallback,
JUnit5InjectionSupport {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{SparkExtension.class.getName()});
    private final TemporaryFolderExtension temporaryFolderExtension = new TemporaryFolderExtension();
    private File root;

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        this.temporaryFolderExtension.beforeAll(extensionContext);
        this.root = ((TemporaryFolder)TemporaryFolder.class.cast(this.temporaryFolderExtension.findInstance(extensionContext, TemporaryFolder.class))).getRoot();
        ExtensionContext.Store store = extensionContext.getStore(NAMESPACE);
        store.put((Object)BaseSpark.class.getName(), (Object)this);
        AnnotationUtils.findAnnotation((Optional)extensionContext.getElement(), WithSpark.class).ifPresent(ws -> {
            this.withSlaves(ws.slaves());
            this.withHadoopBase(ws.hadoopBase());
            this.withHadoopVersion(ws.hadoopVersion());
            this.withInstallWinUtils(ws.installWinUtils());
            this.withScalaVersion(Optional.of(ws.scalaVersion()).filter(it -> !"auto".equals(it)).orElse(SparkVersions.SPARK_SCALA_VERSION.getValue()));
            this.withSparkVersion(Optional.of(ws.sparkVersion()).filter(it -> !"auto".equals(it)).orElse(SparkVersions.SPARK_VERSION.getValue()));
        });
        BaseSpark.Instances instances = this.start();
        if (instances.getException() != null) {
            instances.close();
            if (Exception.class.isInstance(instances.getException())) {
                throw (Exception)Exception.class.cast(instances.getException());
            }
            if (Error.class.isInstance(instances.getException())) {
                throw (Error)Error.class.cast(instances.getException());
            }
            throw new IllegalStateException(instances.getException());
        }
        store.put(AutoCloseable.class, (Object)instances);
    }

    public void afterAll(ExtensionContext extensionContext) throws Exception {
        try {
            Optional.ofNullable(extensionContext.getStore(NAMESPACE).get(AutoCloseable.class)).map(AutoCloseable.class::cast).ifPresent(c -> {
                try {
                    c.close();
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            });
        }
        finally {
            this.temporaryFolderExtension.afterAll(extensionContext);
        }
    }

    public Class<? extends Annotation> injectionMarker() {
        return SparkInject.class;
    }

    @Override
    protected void fail(String message) {
        Assertions.fail((String)message);
    }

    @Override
    protected void assertTrue(String message, boolean value) {
        Assertions.assertTrue((boolean)value, (String)message);
    }

    @Override
    protected File getRoot() {
        return this.root;
    }
}

