/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.server.api;

import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.enums.ParameterIn;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.parameters.RequestBody;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.talend.sdk.component.server.front.model.ComponentDetailList;
import org.talend.sdk.component.server.front.model.ComponentIndices;
import org.talend.sdk.component.server.front.model.Dependencies;
import org.talend.sdk.component.server.front.model.error.ErrorPayload;

@Path(value="component")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Tag(name="Component", description="Endpoints related to component metadata access.")
public interface ComponentResource {
    @GET
    @Path(value="dependencies")
    @Operation(description="Returns a list of dependencies for the given components. IMPORTANT: don't forget to add the component itself since it will not be part of the dependencies.Then you can use /dependency/{id} to download the binary.")
    @APIResponse(responseCode="200", description="The list of dependencies per component.", content={@Content(mediaType="application/json")})
    public Dependencies getDependencies(@QueryParam(value="identifier") @Parameter(name="identifier", description="The identifier id to request. Repeat this parameter to request more than one element.", in=ParameterIn.QUERY) String[] var1);

    @GET
    @Path(value="dependency/{id}")
    @Produces(value={"application/octet-stream"})
    @Operation(description="Return a binary of the dependency represented by `id`. It can be maven coordinates for dependencies or a component id.")
    @APIResponses(value={@APIResponse(responseCode="200", description="The dependency binary (jar).", content={@Content(mediaType="application/octet-stream")}), @APIResponse(responseCode="404", description="If the plugin is missing, payload will be an ErrorPayload with the code PLUGIN_MISSING.", content={@Content(mediaType="application/json", schema=@Schema(type=SchemaType.OBJECT, implementation=ErrorPayload.class))})})
    public StreamingOutput getDependency(@PathParam(value="id") @Parameter(name="id", description="Dependency identifier for component/configurationType or maven coordinate.  \nExample: `/api/v1/component/dependency/org.apache.commons:commons-lang3:jar:3.12.0`.", in=ParameterIn.PATH) String var1);

    @GET
    @Path(value="index")
    @Operation(operationId="getComponentIndex", description="Returns the list of available components.")
    @APIResponse(responseCode="200", description="The index of available components.", content={@Content(mediaType="application/octet-stream")})
    public ComponentIndices getIndex(@QueryParam(value="language") @DefaultValue(value="en") @Parameter(name="language", description="Response language in i18n format.", in=ParameterIn.QUERY, schema=@Schema(type=SchemaType.STRING, defaultValue="en")) String var1, @QueryParam(value="includeIconContent") @DefaultValue(value="false") @Parameter(name="includeIconContent", description="Should the icon binary format be included in the payload.  Default is `false`.", in=ParameterIn.QUERY, schema=@Schema(type=SchemaType.STRING, defaultValue="en")) boolean var2, @QueryParam(value="q") @Parameter(name="q", description="Query in simple query language to filter components. It provides access to the component `plugin`, `name`, `id` and `metadata` of the first configuration property. Ex: `(id = AYETAE658349453) AND (metadata[configurationtype::type] = dataset) AND (plugin = jdbc-component) AND (name = input)`.", in=ParameterIn.QUERY, schema=@Schema(type=SchemaType.STRING)) String var3, @QueryParam(value="theme") @Parameter(name="theme", description="Theme selector.") String var4);

    @GET
    @Path(value="icon/family/{id}")
    @Produces(value={"application/json", "application/octet-stream"})
    @Operation(description="Returns the icon for a family.")
    @APIResponses(value={@APIResponse(responseCode="200", description="Returns a particular family icon in raw bytes.", content={@Content(mediaType="application/octet-stream")}), @APIResponse(responseCode="404", description="The family or icon is not found.", content={@Content(mediaType="application/json", schema=@Schema(type=SchemaType.OBJECT, implementation=ErrorPayload.class))})})
    public Response familyIcon(@PathParam(value="id") @Parameter(name="id", description="Family identifier.", in=ParameterIn.PATH) String var1, @QueryParam(value="theme") @Parameter(name="theme", description="Theme selector.") String var2);

    @GET
    @Path(value="icon/{id}")
    @Produces(value={"application/json", "application/octet-stream"})
    @Operation(description="Returns a particular component icon in raw bytes.")
    @APIResponses(value={@APIResponse(responseCode="200", description="The component icon in binary form.", content={@Content(mediaType="application/octet-stream")}), @APIResponse(responseCode="404", description="The family or icon is not found.", content={@Content(mediaType="application/json")})})
    public Response icon(@PathParam(value="id") @Parameter(name="id", description="Component icon identifier.", in=ParameterIn.PATH) String var1, @QueryParam(value="theme") @Parameter(name="theme", description="Theme selector.") String var2);

    @GET
    @Path(value="icon/custom/{familyId}/{iconKey}")
    @Produces(value={"application/json", "application/octet-stream"})
    @Operation(description="Returns a particular key icon in raw bytes.")
    @APIResponses(value={@APIResponse(responseCode="200", description="The icon in binary form.", content={@Content(mediaType="application/octet-stream")}), @APIResponse(responseCode="404", description="The family or icon is not found.", content={@Content(mediaType="application/json")})})
    public Response icon(@PathParam(value="familyId") @Parameter(name="familyId", description="family identifier.", in=ParameterIn.PATH) String var1, @PathParam(value="iconKey") @Parameter(name="iconKey", description="icon key.", in=ParameterIn.PATH) String var2, @QueryParam(value="theme") @Parameter(name="theme", description="Theme selector.") String var3);

    @POST
    @Path(value="migrate/{id}/{configurationVersion}")
    @Operation(operationId="migrateComponent", description="Allows to migrate a component configuration without calling any component execution.")
    @APIResponses(value={@APIResponse(responseCode="200", description="New configuration for that component (or the same if no migration was needed).", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="404", description="The component is not found.", content={@Content(mediaType="application/json", schema=@Schema(type=SchemaType.OBJECT, implementation=ErrorPayload.class))})})
    public Map<String, String> migrate(@PathParam(value="id") @Parameter(name="id", description="Component identifier.", in=ParameterIn.PATH) String var1, @PathParam(value="configurationVersion") @Parameter(name="configurationVersion", description="Configuration version sent, corresponding to the body content.", in=ParameterIn.PATH) int var2, @RequestBody(description="Actual configuration in key/value json form.", required=true, content={@Content(mediaType="application/json", schema=@Schema(type=SchemaType.OBJECT))}) Map<String, String> var3);

    @GET
    @Path(value="details")
    @Operation(operationId="getComponentDetail", description="Returns the set of metadata about one or multiples components identified by their 'id'.")
    @APIResponses(value={@APIResponse(responseCode="200", description="List of details for the requested components.", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="400", description="Some identifiers were not valid.", content={@Content(mediaType="application/json", schema=@Schema(type=SchemaType.OBJECT, implementation=SampleErrorForBulk.class))})})
    public ComponentDetailList getDetail(@QueryParam(value="language") @DefaultValue(value="en") @Parameter(name="language", description="Response language in i18n format.", in=ParameterIn.QUERY, schema=@Schema(type=SchemaType.STRING, defaultValue="en")) String var1, @QueryParam(value="identifiers") @Parameter(name="identifiers", description="The identifier id to request. Repeat this parameter to request more than one element.", in=ParameterIn.QUERY) String[] var2);

    public static class SampleErrorForBulk {
        private ErrorPayload error1;
        private ErrorPayload error2;
    }
}

